/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import yesman.epicfight.network.server.SPDatapackSync;

public class SPDatapackSyncSkill
extends SPDatapackSync {
    private final List<String> learnedSkills = Lists.newArrayList();

    public SPDatapackSyncSkill() {
        this(0, SPDatapackSync.Type.WEAPON);
    }

    public SPDatapackSyncSkill(int count, SPDatapackSync.Type type) {
        super(count, type);
    }

    public void addLearnedSkill(List<String> newArrayList) {
        this.learnedSkills.addAll(this.learnedSkills);
    }

    public List<String> getLearnedSkills() {
        return this.learnedSkills;
    }

    public static SPDatapackSyncSkill fromBytes(FriendlyByteBuf buf) {
        SPDatapackSyncSkill msg = new SPDatapackSyncSkill(buf.readInt(), SPDatapackSync.Type.values()[buf.readInt()]);
        for (int i = 0; i < msg.count; ++i) {
            msg.tags[i] = buf.m_130260_();
        }
        int learnedSkillCount = buf.readInt();
        for (int i = 0; i < learnedSkillCount; ++i) {
            String skillName = buf.m_130277_();
            msg.learnedSkills.add(skillName);
        }
        return msg;
    }

    public static void toBytes(SPDatapackSyncSkill msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.count);
        buf.writeInt(msg.type.ordinal());
        for (CompoundTag tag : msg.tags) {
            buf.m_130079_(tag);
        }
        buf.writeInt(msg.learnedSkills.size());
        for (String skill : msg.learnedSkills) {
            buf.m_130070_(skill);
        }
    }
}

