/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import java.lang.constant.Constable;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

public class SPChangeGamerule {
    private final SynchronizedGameRules gamerule;
    private final int gameruleId;
    private final Object object;

    public SPChangeGamerule() {
        this.gamerule = null;
        this.gameruleId = -1;
        this.object = 0;
    }

    public SPChangeGamerule(SynchronizedGameRules gamerule, Object object) {
        this.gamerule = gamerule;
        this.gameruleId = gamerule.ordinal();
        this.object = object;
    }

    public static SPChangeGamerule fromBytes(FriendlyByteBuf buf) {
        int id = buf.readInt();
        SynchronizedGameRules gamerule = SynchronizedGameRules.values()[id];
        Constable obj = null;
        switch (gamerule.valueType) {
            case INTEGER: {
                obj = buf.readInt();
                break;
            }
            case BOOLEAN: {
                obj = Boolean.valueOf(buf.readBoolean());
            }
        }
        return new SPChangeGamerule(gamerule, obj);
    }

    public static void toBytes(SPChangeGamerule msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.gameruleId);
        switch (msg.gamerule.valueType) {
            case INTEGER: {
                buf.writeInt(((Integer)msg.object).intValue());
                break;
            }
            case BOOLEAN: {
                buf.writeBoolean(((Boolean)msg.object).booleanValue());
            }
        }
    }

    public static void handle(SPChangeGamerule msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            switch (msg.gamerule.valueType) {
                case INTEGER: {
                    ((GameRules.IntegerValue)Minecraft.m_91087_().f_91073_.m_46469_().m_46170_(msg.gamerule.key)).m_46314_(msg.object.toString());
                    break;
                }
                case BOOLEAN: {
                    ((GameRules.BooleanValue)Minecraft.m_91087_().f_91073_.m_46469_().m_46170_(msg.gamerule.key)).m_46246_(((Boolean)msg.object).booleanValue(), null);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum SynchronizedGameRules {
        HAS_FALL_ANIMATION(ValueType.BOOLEAN, EpicFightGamerules.HAS_FALL_ANIMATION),
        WEIGHT_PENALTY(ValueType.INTEGER, EpicFightGamerules.WEIGHT_PENALTY),
        DIABLE_ENTITY_UI(ValueType.BOOLEAN, EpicFightGamerules.DISABLE_ENTITY_UI),
        CAN_SWITCH_COMBAT(ValueType.BOOLEAN, EpicFightGamerules.CAN_SWITCH_COMBAT),
        STIFF_COMBO_ATTACKS(ValueType.BOOLEAN, EpicFightGamerules.STIFF_COMBO_ATTACKS);

        ValueType valueType;
        GameRules.Key<?> key;

        private SynchronizedGameRules(ValueType valueType, GameRules.Key<?> key) {
            this.valueType = valueType;
            this.key = key;
        }

        static enum ValueType {
            INTEGER,
            BOOLEAN;

        }
    }
}

