/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.client;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPModifyPlayerData;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class CPRotateEntityModelYRot {
    private final float modelYRot;

    public CPRotateEntityModelYRot() {
        this.modelYRot = 0.0f;
    }

    public CPRotateEntityModelYRot(float degree) {
        this.modelYRot = degree;
    }

    public static CPRotateEntityModelYRot fromBytes(FriendlyByteBuf buf) {
        return new CPRotateEntityModelYRot(buf.readFloat());
    }

    public static void toBytes(CPRotateEntityModelYRot msg, FriendlyByteBuf buf) {
        buf.writeFloat(msg.modelYRot);
    }

    public static void handle(CPRotateEntityModelYRot msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerPatch entitypatch;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (entitypatch = EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class)) != null) {
                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPModifyPlayerData(player.m_19879_(), msg.modelYRot), (Entity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

