/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.mixin;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity {
    @Inject(at={@At(value="TAIL")}, method={"blockUsingShield(Lnet/minecraft/world/entity/LivingEntity;)V"}, cancellable=true)
    private void epicfight_blockUsingShield(LivingEntity p_21200_, CallbackInfo info) {
        LivingEntity self = (LivingEntity)this;
        LivingEntityPatch opponentEntitypatch = EpicFightCapabilities.getEntityPatch((Entity)p_21200_, LivingEntityPatch.class);
        LivingEntityPatch selfEntitypatch = EpicFightCapabilities.getEntityPatch((Entity)self, LivingEntityPatch.class);
        if (opponentEntitypatch != null) {
            opponentEntitypatch.setLastAttackResult(AttackResult.blocked(0.0f));
            if (selfEntitypatch != null && opponentEntitypatch.getEpicFightDamageSource() != null) {
                opponentEntitypatch.onAttackBlocked(opponentEntitypatch.getEpicFightDamageSource(), selfEntitypatch);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"hurt"}, cancellable=true)
    private void epicfight_hurt(DamageSource damagesource, float amount, CallbackInfoReturnable<Boolean> info) {
        LivingEntity self = (LivingEntity)this;
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(damagesource.m_7639_(), LivingEntityPatch.class);
        if (entitypatch != null && ((Boolean)info.getReturnValue()).booleanValue()) {
            entitypatch.setLastAttackEntity((Entity)self);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"push(Lnet/minecraft/world/entity/Entity;)V"}, cancellable=true)
    private void epicfight_push(Entity p_20293_, CallbackInfo info) {
        LivingEntity self = (LivingEntity)this;
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)self, LivingEntityPatch.class);
        if (entitypatch != null && !entitypatch.canPush(p_20293_)) {
            info.cancel();
        }
    }
}

