/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.main;

import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.ServerAnimator;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.model.ItemSkins;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.data.reloader.ItemCapabilityReloadListener;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.screen.IngameConfigurationScreen;
import yesman.epicfight.client.renderer.patched.item.EpicFightItemProperties;
import yesman.epicfight.compat.AzureLibArmorCompat;
import yesman.epicfight.compat.AzureLibCompat;
import yesman.epicfight.compat.GeckolibCompat;
import yesman.epicfight.compat.ICompatModule;
import yesman.epicfight.config.ConfigManager;
import yesman.epicfight.config.EpicFightOptions;
import yesman.epicfight.data.conditions.EpicFightConditions;
import yesman.epicfight.data.loot.EpicFightLootTables;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightDataSerializers;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.server.commands.PlayerModeCommand;
import yesman.epicfight.server.commands.PlayerSkillCommand;
import yesman.epicfight.server.commands.arguments.EpicFightCommandArgumentTypes;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.capabilities.item.WeaponTypeReloadListener;
import yesman.epicfight.world.capabilities.provider.EntityPatchProvider;
import yesman.epicfight.world.capabilities.provider.ItemCapabilityProvider;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.effect.EpicFightPotions;
import yesman.epicfight.world.entity.EpicFightEntities;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.gamerule.EpicFightGamerules;
import yesman.epicfight.world.item.EpicFightCreativeTabs;
import yesman.epicfight.world.item.EpicFightItems;
import yesman.epicfight.world.level.block.EpicFightBlocks;
import yesman.epicfight.world.level.block.entity.EpicFightBlockEntities;

@Mod(value="epicfight")
public class EpicFightMod {
    public static final String MODID = "epicfight";
    public static final String CONFIG_FILE_PATH = "epicfight.toml";
    public static final Logger LOGGER = LogManager.getLogger((String)"epicfight");
    public static EpicFightOptions CLIENT_CONFIGS;
    private static EpicFightMod instance;
    public final AnimationManager animationManager = new AnimationManager();
    private Function<LivingEntityPatch<?>, Animator> animatorProvider;

    public static EpicFightMod getInstance() {
        return instance;
    }

    public EpicFightMod() {
        instance = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigManager.CLIENT_CONFIG);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::newRegistry);
        bus.addListener(this::constructMod);
        bus.addListener(this::doClientStuff);
        bus.addListener(this::doCommonStuff);
        bus.addListener(this::doServerStuff);
        bus.addListener(this::registerClientReloadListnerEvent);
        bus.addListener(EpicFightAttributes::registerNewMobs);
        bus.addListener(EpicFightAttributes::modifyExistingMobs);
        bus.addListener(EpicFightCapabilities::registerCapabilities);
        bus.addListener(EpicFightEntities::onSpawnPlacementRegister);
        LivingMotion.ENUM_MANAGER.registerEnumCls(MODID, LivingMotions.class);
        SkillCategory.ENUM_MANAGER.registerEnumCls(MODID, SkillCategories.class);
        SkillSlot.ENUM_MANAGER.registerEnumCls(MODID, SkillSlots.class);
        Style.ENUM_MANAGER.registerEnumCls(MODID, CapabilityItem.Styles.class);
        WeaponCategory.ENUM_MANAGER.registerEnumCls(MODID, CapabilityItem.WeaponCategories.class);
        EpicFightMobEffects.EFFECTS.register(bus);
        EpicFightPotions.POTIONS.register(bus);
        EpicFightAttributes.ATTRIBUTES.register(bus);
        EpicFightCreativeTabs.TABS.register(bus);
        EpicFightItems.ITEMS.register(bus);
        EpicFightParticles.PARTICLES.register(bus);
        EpicFightEntities.ENTITIES.register(bus);
        EpicFightBlocks.BLOCKS.register(bus);
        EpicFightBlockEntities.BLOCK_ENTITIES.register(bus);
        EpicFightLootTables.LOOT_MODIFIERS.register(bus);
        EpicFightSounds.SOUNDS.register(bus);
        EpicFightDataSerializers.ENTITY_DATA_SERIALIZER.register(bus);
        EpicFightConditions.CONDITIONS.register(bus);
        SkillDataKeys.DATA_KEYS.register(bus);
        EpicFightCommandArgumentTypes.COMMAND_ARGUMENT_TYPES.register(bus);
        EpicFightSkills.registerSkills();
        MinecraftForge.EVENT_BUS.addListener(this::command);
        MinecraftForge.EVENT_BUS.addListener(this::reloadListnerEvent);
        ConfigManager.loadConfig(ConfigManager.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("epicfight-client.toml").toString());
        ConfigManager.loadConfig(ConfigManager.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve(CONFIG_FILE_PATH).toString());
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(IngameConfigurationScreen::new));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (ModList.get().isLoaded("geckolib")) {
                ICompatModule.loadCompatModuleClient(GeckolibCompat.class);
            }
            if (ModList.get().isLoaded("azurelib")) {
                ICompatModule.loadCompatModule(AzureLibCompat.class);
            }
            if (ModList.get().isLoaded("azurelibarmor")) {
                ICompatModule.loadCompatModule(AzureLibArmorCompat.class);
            }
        });
    }

    private void newRegistry(NewRegistryEvent event) {
        RegistryBuilder registryBuilder = RegistryBuilder.of((String)"epicfightanimation");
        registryBuilder.addCallback((Object)AnimationManager.getCallBack());
        Supplier animationRegistry = event.create(registryBuilder);
        this.animationManager.onRegistryCreated(animationRegistry);
    }

    private void command(RegisterCommandsEvent event) {
        PlayerModeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PlayerSkillCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private void constructMod(FMLConstructModEvent event) {
        LivingMotion.ENUM_MANAGER.loadEnum();
        SkillCategory.ENUM_MANAGER.loadEnum();
        SkillSlot.ENUM_MANAGER.loadEnum();
        Style.ENUM_MANAGER.loadEnum();
        WeaponCategory.ENUM_MANAGER.loadEnum();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        CLIENT_CONFIGS = new EpicFightOptions();
        new ClientEngine();
        this.animatorProvider = ClientAnimator::getAnimator;
        EntityPatchProvider.registerEntityPatchesClient();
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        Armatures.build(resourceManager);
        EpicFightItemProperties.registerItemProperties();
    }

    private void doServerStuff(FMLDedicatedServerSetupEvent event) {
        Armatures.build(null);
        this.animationManager.loadAnimationsOnServer();
        this.animatorProvider = ServerAnimator::getAnimator;
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        event.enqueueWork(EpicFightCommandArgumentTypes::registerArgumentTypes);
        event.enqueueWork(EpicFightPotions::addRecipes);
        event.enqueueWork(EpicFightNetworkManager::registerPackets);
        event.enqueueWork(ItemCapabilityProvider::registerWeaponTypesByClass);
        event.enqueueWork(EntityPatchProvider::registerEntityPatches);
        event.enqueueWork(EpicFightGamerules::registerRules);
        event.enqueueWork(WeaponTypeReloadListener::registerDefaultWeaponTypes);
        event.enqueueWork(EpicFightMobEffects::addOffhandModifier);
    }

    private void registerClientReloadListnerEvent(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)Meshes.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)Armatures.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)this.animationManager);
        event.registerReloadListener((PreparableReloadListener)ItemSkins.INSTANCE);
    }

    private void reloadListnerEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SkillManager());
        event.addListener((PreparableReloadListener)new WeaponTypeReloadListener());
        event.addListener((PreparableReloadListener)new ItemCapabilityReloadListener());
        event.addListener((PreparableReloadListener)new MobPatchReloadListener());
    }

    public static Animator getAnimator(LivingEntityPatch<?> entitypatch) {
        return EpicFightMod.getInstance().animatorProvider.apply(entitypatch);
    }

    public static boolean isPhysicalClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }
}

