/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.conditions.itemstack;

import com.google.common.collect.ImmutableMap;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;
import yesman.epicfight.data.conditions.itemstack.ItemStackCondition;

public class TagValueCondition
extends ItemStackCondition {
    private String key;
    private String value;

    public TagValueCondition(CompoundTag tag) {
        super(tag);
    }

    @Override
    public void read(CompoundTag tag) {
        this.key = tag.m_128461_("key");
        this.value = tag.m_128423_("value").m_7916_();
        if (this.key == null) {
            throw new IllegalArgumentException("No key provided!");
        }
        if (this.value == null) {
            throw new IllegalArgumentException("No value provided!");
        }
    }

    @Override
    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("key", this.key);
        tag.m_128359_("value", this.value);
        return tag;
    }

    @Override
    public boolean predicate(ItemStack itemstack) {
        String[] keys = this.key.split("[.]");
        List<CompoundTag> visitTags = List.of(itemstack.m_41783_());
        for (int i = 0; i < keys.length; ++i) {
            visitTags = TagValueCondition.visitTags(keys[i], visitTags);
        }
        for (Tag tag : visitTags) {
            if (!tag.m_7916_().equals(this.value)) continue;
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Set<Map.Entry<String, Object>> getAcceptingParameters() {
        return ImmutableMap.of((Object)"key", (Object)"", (Object)"value", (Object)"").entrySet();
    }

    private static List<Tag> visitTags(String key, List<Tag> compoundTag) {
        Pattern pattern = Pattern.compile("\\[[0-9]*\\]", 8);
        Matcher matcher = pattern.matcher(key);
        ArrayList childs = Lists.newArrayList();
        if (matcher.find()) {
            String sIndex = matcher.group().replaceAll("[\\[\\]]", "");
            String arrayKey = matcher.replaceAll("");
            if (StringUtil.isNullOrEmpty((String)sIndex)) {
                for (Tag tag : compoundTag) {
                    CompoundTag compTag;
                    if (!(tag instanceof CompoundTag) || !(compTag = (CompoundTag)tag).m_128441_(arrayKey)) continue;
                    ListTag listTag = (ListTag)compTag.m_128423_(arrayKey);
                    for (Tag listTagElement : listTag) {
                        childs.add(listTagElement);
                    }
                }
            } else {
                int index = Integer.valueOf(sIndex);
                for (Tag tag : compoundTag) {
                    CompoundTag compTag;
                    if (!(tag instanceof CompoundTag) || !(compTag = (CompoundTag)tag).m_128441_(arrayKey)) continue;
                    ListTag listTag = (ListTag)compTag.m_128423_(arrayKey);
                    childs.add(listTag.get(index));
                }
            }
        } else {
            for (Tag tag : compoundTag) {
                CompoundTag compTag;
                if (!(tag instanceof CompoundTag) || !(compTag = (CompoundTag)tag).m_128441_(key)) continue;
                childs.add(compTag.m_128423_(key));
            }
        }
        return childs;
    }
}

