/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.forgeevent.PrepareModelEvent;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public abstract class PatchedLivingEntityRenderer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends EntityModel<E>, AM extends AnimatedMesh>
extends PatchedEntityRenderer<E, T, LivingEntityRenderer<E, M>, AM> {
    protected static Method isBodyVisible = ObfuscationReflectionHelper.findMethod(LivingEntityRenderer.class, (String)"m_5933_", (Class[])new Class[]{LivingEntity.class});
    protected static Method getRenderType = ObfuscationReflectionHelper.findMethod(LivingEntityRenderer.class, (String)"m_7225_", (Class[])new Class[]{LivingEntity.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
    protected Map<Class<?>, PatchedLayer<E, T, M, ? extends RenderLayer<E, M>, AM>> patchedLayers = Maps.newHashMap();

    @Override
    public void render(E entityIn, T entitypatch, LivingEntityRenderer<E, M> renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        super.render(entityIn, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks);
        Minecraft mc = Minecraft.m_91087_();
        boolean isVisible = this.isVisible(renderer, entityIn);
        boolean isVisibleToPlayer = !isVisible && !entityIn.m_20177_((Player)mc.f_91074_);
        boolean isGlowing = mc.m_91314_(entityIn);
        RenderType renderType = this.getRenderType(entityIn, entitypatch, renderer, isVisible, isVisibleToPlayer, isGlowing);
        Armature armature = ((LivingEntityPatch)entitypatch).getArmature();
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, entityIn, entitypatch, partialTicks);
        OpenMatrix4f[] poseMatrices = this.getPoseMatrices(entitypatch, armature, partialTicks);
        if (renderType != null) {
            this.prepareVanillaModel(entityIn, renderer.m_7200_(), renderer, partialTicks);
            Object mesh = this.getMesh(entitypatch);
            this.prepareModel(mesh, entityIn, entitypatch);
            PrepareModelEvent prepareModelEvent = new PrepareModelEvent(this, (AnimatedMesh)mesh, (LivingEntityPatch<?>)entitypatch, buffer, poseStack, packedLight, partialTicks);
            if (!MinecraftForge.EVENT_BUS.post((Event)prepareModelEvent)) {
                VertexConsumer builder = buffer.m_6299_(renderType);
                ((AnimatedMesh)mesh).drawModelWithPose(poseStack, builder, packedLight, 1.0f, 1.0f, 1.0f, isVisibleToPlayer ? 0.15f : 1.0f, this.getOverlayCoord(entityIn, entitypatch, partialTicks), armature, poseMatrices);
            }
        }
        if (!entityIn.m_5833_()) {
            this.renderLayer(renderer, entitypatch, entityIn, poseMatrices, buffer, poseStack, packedLight, partialTicks);
        }
        if (renderType != null && Minecraft.m_91087_().m_91290_().m_114377_()) {
            for (Layer layer : ((LivingEntityPatch)entitypatch).getClientAnimator().getAllLayers()) {
                AnimationPlayer animPlayer = layer.animationPlayer;
                float playTime = animPlayer.getPrevElapsedTime() + (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()) * partialTicks;
                animPlayer.getAnimation().renderDebugging(poseStack, buffer, (LivingEntityPatch<?>)entitypatch, playTime, partialTicks);
            }
        }
        poseStack.m_85849_();
    }

    public float getVanillaRendererBob(E entity, LivingEntityRenderer<E, M> renderer, float partialTicks) {
        return (float)((LivingEntity)entity).f_19797_ + partialTicks;
    }

    protected void prepareVanillaModel(E entityIn, M model, LivingEntityRenderer<E, M> renderer, float partialTicks) {
        boolean shouldSit;
        ((EntityModel)model).f_102609_ = shouldSit = entityIn.m_20159_() && entityIn.m_20202_() != null && entityIn.m_20202_().shouldRiderSit();
        ((EntityModel)model).f_102610_ = entityIn.m_6162_();
        float f = Mth.m_14189_((float)partialTicks, (float)((LivingEntity)entityIn).f_20884_, (float)((LivingEntity)entityIn).f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)((LivingEntity)entityIn).f_20886_, (float)((LivingEntity)entityIn).f_20885_);
        float f2 = f1 - f;
        if (shouldSit && entityIn.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.m_20202_();
            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_((float)partialTicks, (float)((LivingEntity)entityIn).f_19860_, (float)entityIn.m_146909_());
        if (LivingEntityRenderer.m_194453_(entityIn)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        float f7 = this.getVanillaRendererBob(entityIn, renderer, partialTicks);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.m_6084_()) {
            f8 = ((LivingEntity)entityIn).f_267362_.m_267711_(partialTicks);
            f5 = ((LivingEntity)entityIn).f_267362_.m_267756_() - ((LivingEntity)entityIn).f_267362_.m_267731_() * (1.0f - partialTicks);
            if (entityIn.m_6162_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        model.m_6839_(entityIn, f5, f8, partialTicks);
        model.m_6973_(entityIn, f5, f8, f7, f2, f6);
    }

    protected void prepareModel(AM mesh, E entity, T entitypatch) {
        ((Mesh)mesh).initialize();
    }

    protected void renderLayer(LivingEntityRenderer<E, M> renderer, T entitypatch, E entityIn, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLightIn, float partialTicks) {
        ArrayList layers = Lists.newArrayList();
        renderer.f_115291_.forEach(layers::add);
        Iterator iter = layers.iterator();
        float f = MathUtils.lerpBetween(((LivingEntity)entityIn).f_20884_, ((LivingEntity)entityIn).f_20883_, partialTicks);
        float f1 = MathUtils.lerpBetween(((LivingEntity)entityIn).f_20886_, ((LivingEntity)entityIn).f_20885_, partialTicks);
        float f2 = f1 - f;
        float f7 = entityIn.m_5686_(partialTicks);
        float bob = this.getVanillaRendererBob(entityIn, renderer, partialTicks);
        while (iter.hasNext()) {
            RenderLayer layer2 = (RenderLayer)iter.next();
            Class<?> rendererClass = layer2.getClass();
            if (rendererClass.isAnonymousClass()) {
                rendererClass = rendererClass.getSuperclass();
            }
            this.patchedLayers.computeIfPresent(rendererClass, (key, val) -> {
                val.renderLayer(0, entitypatch, entityIn, layer2, poseStack, buffer, packedLightIn, poses, bob, f2, f7, partialTicks);
                iter.remove();
                return val;
            });
        }
        int rootJointId = this.getRootJointIndex();
        OpenMatrix4f modelMatrix = new OpenMatrix4f().mulFront(poses[rootJointId]);
        OpenMatrix4f transpose = OpenMatrix4f.transpose(modelMatrix, null);
        poseStack.m_85836_();
        MathUtils.translateStack(poseStack, modelMatrix);
        MathUtils.rotateStack(poseStack, transpose);
        poseStack.m_85837_(0.0, this.getLayerCorrection(), 0.0);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        layers.forEach(layer -> layer.m_6494_(poseStack, buffer, packedLightIn, (Entity)entityIn, entityIn.f_267362_.m_267756_(), entityIn.f_267362_.m_267731_(), partialTicks, bob, f2, f7));
        poseStack.m_85849_();
    }

    public RenderType getRenderType(E entityIn, T entitypatch, LivingEntityRenderer<E, M> renderer, boolean isVisible, boolean isVisibleToPlayer, boolean isGlowing) {
        try {
            RenderType renderType = (RenderType)getRenderType.invoke(renderer, entityIn, isVisible, isVisibleToPlayer, isGlowing);
            if (renderType != null) {
                renderType = EpicFightRenderTypes.triangles(renderType);
            }
            return renderType;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            EpicFightMod.LOGGER.error("Reflection Exception");
            e.printStackTrace();
            return null;
        }
    }

    protected boolean isVisible(LivingEntityRenderer<E, M> renderer, E entityIn) {
        try {
            return (Boolean)isBodyVisible.invoke(renderer, entityIn);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            EpicFightMod.LOGGER.error("Reflection Exception");
            e.printStackTrace();
            return true;
        }
    }

    protected int getOverlayCoord(E entity, T entitypatch, float partialTicks) {
        return OverlayTexture.m_118093_((int)0, (int)OverlayTexture.m_118096_((((LivingEntity)entity).f_20916_ > 5 ? 1 : 0) != 0));
    }

    @Override
    public void mulPoseStack(PoseStack poseStack, Armature armature, E entityIn, T entitypatch, float partialTicks) {
        super.mulPoseStack(poseStack, armature, entityIn, entitypatch, partialTicks);
        if (entityIn.m_6047_()) {
            poseStack.m_85837_(0.0, 0.15, 0.0);
        }
    }

    public void addPatchedLayer(Class<?> originalLayerClass, PatchedLayer<E, T, M, ? extends RenderLayer<E, M>, AM> patchedLayer) {
        this.patchedLayers.put(originalLayerClass, patchedLayer);
    }

    protected int getRootJointIndex() {
        return 0;
    }

    protected double getLayerCorrection() {
        return 1.15;
    }
}

