/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EpicFightRenderTypes
extends RenderType {
    private static final Map<RenderType, RenderType> renderTypeCache = Maps.newHashMap();
    private static final Function<ResourceLocation, RenderType> ENTITY_INDICATOR = Util.m_143827_(textureLocation -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173102_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false, false)).m_110685_(f_110134_).m_110671_(f_110153_).m_110677_(f_110155_).m_110691_(true);
        return EpicFightRenderTypes.m_173215_((String)"epicfight:entity_indicator", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final RenderType DEBUG_COLLIDER = EpicFightRenderTypes.m_173215_((String)"epicfight:debug_collider", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINE_STRIP, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
    private static final RenderType DEBUG_QUADS = EpicFightRenderTypes.m_173215_((String)"epicfight:debug_quad", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110669_(f_110119_).m_110685_(f_110134_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));

    public static RenderType triangles(RenderType renderType) {
        return renderTypeCache.computeIfAbsent(renderType, key -> {
            RenderType.CompositeRenderType trianglesRenderType = null;
            if (renderType instanceof RenderType.CompositeRenderType) {
                RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
                trianglesRenderType = new RenderType.CompositeRenderType(renderType.f_110133_, renderType.f_110389_, VertexFormat.Mode.TRIANGLES, renderType.m_110507_(), renderType.m_110405_(), renderType.f_110393_, compositeRenderType.f_110511_);
            }
            return trianglesRenderType;
        });
    }

    private EpicFightRenderTypes(String name, VertexFormat format, VertexFormat.Mode drawingMode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setup, Runnable clean) {
        super(name, format, drawingMode, bufferSize, affectsCrumbling, sortOnUpload, setup, clean);
    }

    private static VertexConsumer getTriangleBuffer(MultiBufferSource bufferSource, RenderType renderType) {
        RenderType triangleRenderType = EpicFightRenderTypes.triangles(renderType);
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource cast = (MultiBufferSource.BufferSource)bufferSource;
            if (cast.f_109905_.containsKey(renderType)) {
                cast.f_109905_.computeIfAbsent(triangleRenderType, key -> new BufferBuilder(renderType.m_110507_()));
                return cast.m_6299_(triangleRenderType);
            }
            return cast.m_6299_(triangleRenderType);
        }
        return bufferSource.m_6299_(triangleRenderType);
    }

    public static VertexConsumer getArmorFoilBufferTriangles(MultiBufferSource bufferSource, RenderType renderType, boolean isEntity, boolean hasEffect) {
        return hasEffect ? VertexMultiConsumer.m_86168_((VertexConsumer)EpicFightRenderTypes.getTriangleBuffer(bufferSource, isEntity ? RenderType.m_110481_() : RenderType.m_110484_()), (VertexConsumer)EpicFightRenderTypes.getTriangleBuffer(bufferSource, renderType)) : EpicFightRenderTypes.getTriangleBuffer(bufferSource, renderType);
    }

    public static RenderType entityIndicator(ResourceLocation locationIn) {
        return ENTITY_INDICATOR.apply(locationIn);
    }

    public static RenderType debugCollider() {
        return DEBUG_COLLIDER;
    }

    public static RenderType m_269166_() {
        return DEBUG_QUADS;
    }
}

