/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.skill.SkillContainer;

public class SlotSelectScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("epicfight", "textures/gui/screen/slot_select.png");
    private final SkillBookScreen parent;
    private final List<SkillContainer> containers;

    public SlotSelectScreen(Set<SkillContainer> containers, SkillBookScreen parent) {
        super((Component)Component.m_237119_());
        this.parent = parent;
        this.containers = new ArrayList<SkillContainer>(containers);
        Collections.sort(this.containers, (c1, c2) -> {
            if (c1.getSlotId() > c2.getSlotId()) {
                return 1;
            }
            if (c1.getSlotId() < c2.getSlotId()) {
                return -1;
            }
            return 0;
        });
    }

    protected void m_7856_() {
        this.parent.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        int k = this.f_96543_ / 2 - 80;
        int l = this.f_96544_ / 2 - 45;
        for (SkillContainer container : this.containers) {
            String slotName = container.getSlot().toString().toLowerCase(Locale.ROOT);
            String skillName = container.getSkill() == null ? "Empty" : Component.m_237115_((String)container.getSkill().getTranslationKey()).getString();
            SlotButton slotbutton = new SlotButton(k, l, 167, 17, (Component)Component.m_237113_((String)(slotName + ": " + skillName)), button -> {
                this.parent.learnSkill(container);
                this.m_7379_();
            });
            l += 22;
            this.m_142416_((GuiEventListener)slotbutton);
        }
    }

    public void m_7379_() {
        if (this.parent != null) {
            this.f_96541_.m_91152_((Screen)this.parent);
        } else {
            super.m_7379_();
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int posX = (this.f_96543_ - 184) / 2;
        int posY = (this.f_96544_ - 150) / 2;
        this.parent.render(guiGraphics, mouseX, mouseY, partialTicks, true);
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 50.0f);
        RenderSystem.setShader(GameRenderer::m_172820_);
        guiGraphics.m_280218_(BACKGROUND, posX, posY, 0, 0, 191, 154);
        MutableComponent component = Component.m_237115_((String)"gui.epicfight.select_slot_tooltip");
        int lineHeight = 0;
        for (FormattedCharSequence s : this.f_96547_.m_92923_((FormattedText)component, 250)) {
            guiGraphics.m_280649_(this.f_96547_, s, this.f_96543_ / 2 - 84, this.f_96544_ / 2 - 66 + lineHeight, 0x303030, false);
            lineHeight += 10;
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    class SlotButton
    extends Button {
        public SlotButton(int x, int y, int width, int height, Component title, Button.OnPress pressedAction) {
            super(x, y, width, height, title, pressedAction, Button.f_252438_);
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
            int y = this.f_93622_ || !this.f_93623_ ? 171 : 154;
            guiGraphics.m_280218_(BACKGROUND, this.m_252754_(), this.m_252907_(), 0, y, this.f_93618_, this.f_93619_);
            guiGraphics.m_280614_(SlotSelectScreen.this.f_96547_, this.m_6035_(), this.m_252754_() + 3, this.m_252907_() + 3, -1, false);
        }
    }
}

