/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistry;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.screen.SelectFromRegistryScreen;

@OnlyIn(value=Dist.CLIENT)
public class SelectFromRegistryScreen<T>
extends Screen {
    private final RegistryList registryList;
    private final Screen parentScreen;
    private final Consumer<T> selectCallback;
    private final Consumer<T> onSelect;

    public SelectFromRegistryScreen(Screen parentScreen, IForgeRegistry<T> registry, Consumer<T> selectCallback) {
        this(parentScreen, registry, select -> {}, selectCallback);
    }

    public SelectFromRegistryScreen(Screen parentScreen, IForgeRegistry<T> registry, Consumer<T> onSelect, Consumer<T> selectCallback) {
        super((Component)Component.m_237110_((String)"gui.epicfight.select", (Object[])new Object[]{ParseUtil.makeFirstLetterToUpper(registry.getRegistryName().m_135815_())}));
        this.registryList = new RegistryList(parentScreen.getMinecraft(), this.f_96543_, this.f_96544_, 36, this.f_96544_ - 16, 21, registry);
        this.parentScreen = parentScreen;
        this.selectCallback = selectCallback;
        this.onSelect = onSelect;
    }

    protected void m_7856_() {
        this.registryList.m_93437_(this.f_96543_, this.f_96544_, 36, this.f_96544_ - 32);
        EditBox editBox = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2, 12, this.f_96543_ / 2 - 12, 16, (Component)Component.m_237113_((String)"epicfight:"));
        editBox.m_94151_(this.registryList::applyFilter);
        this.m_142416_((GuiEventListener)this.registryList);
        this.m_142416_((GuiEventListener)editBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_286989_, button -> {
            this.selectCallback.accept(((RegistryList.RegistryEntry)this.registryList.m_93511_()).item);
            this.f_96541_.m_91152_(this.parentScreen);
        }).m_252794_(this.f_96543_ / 2 - 162, this.f_96544_ - 28).m_253046_(160, 21).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.f_96541_.m_91152_(this.parentScreen)).m_252794_(this.f_96543_ / 2 + 2, this.f_96544_ - 28).m_253046_(160, 21).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280039_(guiGraphics);
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, 20, 16, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    @OnlyIn(value=Dist.CLIENT)
    class RegistryList
    extends ObjectSelectionList<yesman.epicfight.client.gui.screen.SelectFromRegistryScreen$RegistryList.RegistryEntry> {
        private final IForgeRegistry<T> registry;

        public RegistryList(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight, IForgeRegistry<T> registry) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.registry = registry;
            for (Map.Entry entry : registry.getEntries()) {
                this.m_7085_((AbstractSelectionList.Entry)new RegistryEntry(entry.getValue(), ((ResourceKey)entry.getKey()).m_135782_().toString()));
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public void setSelected(@Nullable RegistryEntry selEntry) {
            SelectFromRegistryScreen.this.onSelect.accept(selEntry.item);
            super.m_6987_((AbstractSelectionList.Entry)selEntry);
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        protected int m_5756_() {
            return this.f_93392_ - 6;
        }

        public void applyFilter(String keyward) {
            this.m_93410_(0.0);
            this.m_6702_().clear();
            this.registry.getEntries().stream().filter(entry -> StringUtil.m_14408_((String)keyward) ? true : ((ResourceKey)entry.getKey()).toString().contains(keyward)).map(entry -> new RegistryEntry(entry.getValue(), ((ResourceKey)entry.getKey()).m_135782_().toString())).forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
        }

        @OnlyIn(value=Dist.CLIENT)
        class RegistryEntry
        extends ObjectSelectionList.Entry<yesman.epicfight.client.gui.screen.SelectFromRegistryScreen$RegistryList.RegistryEntry> {
            private final T item;
            private final String name;

            public RegistryEntry(T item, String name) {
                this.item = item;
                this.name = name;
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                guiGraphics.m_280056_(((SelectFromRegistryScreen)SelectFromRegistryScreen.this).f_96541_.f_91062_, this.name, left + 25, top + 5, 0xFFFFFF, false);
            }

            public Component m_142172_() {
                return Component.m_237115_((String)"narrator.select");
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (RegistryList.this.m_93511_() == this) {
                        SelectFromRegistryScreen.this.selectCallback.accept(this.item);
                        SelectFromRegistryScreen.this.f_96541_.m_91152_(SelectFromRegistryScreen.this.parentScreen);
                        return true;
                    }
                    RegistryList.this.setSelected(this);
                    return true;
                }
                return false;
            }
        }
    }
}

