/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.component;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface ResizableComponent
extends GuiEventListener,
NarratableEntry {
    default public void resize(ScreenRectangle screenRectangle) {
        if (this.getHorizontalSizingOption() != null) {
            this.getHorizontalSizingOption().resizeFunction.resize(this, screenRectangle, this.getX1(), this.getX2());
        }
        if (this.getVerticalSizingOption() != null) {
            this.getVerticalSizingOption().resizeFunction.resize(this, screenRectangle, this.getY1(), this.getY2());
        }
    }

    default public void relocateX(int x) {
        this.m_252865_(x);
    }

    default public void relocateY(int y) {
        this.m_253211_(y);
    }

    public int getX1();

    public int getX2();

    public int getY1();

    public int getY2();

    public HorizontalSizing getHorizontalSizingOption();

    public VerticalSizing getVerticalSizingOption();

    public void m_88315_(GuiGraphics var1, int var2, int var3, float var4);

    public int m_252754_();

    public int m_252907_();

    public int m_5711_();

    public int m_93694_();

    public void m_252865_(int var1);

    public void m_253211_(int var1);

    public void m_93674_(int var1);

    public void setHeight(int var1);

    public static enum HorizontalSizing {
        LEFT_WIDTH((component, screenRectangle, v1, v2) -> {
            component.m_252865_(v1);
            component.m_93674_(v2);
        }),
        LEFT_RIGHT((component, screenRectangle, v1, v2) -> {
            int end = screenRectangle.m_274445_() - v2;
            int width = Math.max(end - v1, 0);
            component.m_252865_(v1);
            component.m_93674_(width);
        }),
        WIDTH_RIGHT((component, screenRectangle, v1, v2) -> {
            int end = screenRectangle.m_274445_() - v2;
            int start = Math.max(end - v1, 0);
            component.m_252865_(start);
            component.m_93674_(v1);
        });

        ResizeFunction resizeFunction;

        private HorizontalSizing(ResizeFunction resizeFunction) {
            this.resizeFunction = resizeFunction;
        }
    }

    @FunctionalInterface
    public static interface ResizeFunction {
        public void resize(ResizableComponent var1, ScreenRectangle var2, int var3, int var4);
    }

    public static enum VerticalSizing {
        TOP_HEIGHT((component, screenRectangle, v1, v2) -> {
            component.m_253211_(v1);
            component.setHeight(v2);
        }),
        TOP_BOTTOM((component, screenRectangle, v1, v2) -> {
            int end = screenRectangle.m_274349_() - v2;
            int height = Math.max(end - v1, 0);
            component.m_253211_(v1);
            component.setHeight(height);
        }),
        HEIGHT_BOTTOM((component, screenRectangle, v1, v2) -> {
            int end = screenRectangle.m_274349_() - v2;
            int start = Math.max(end - v1, 0);
            component.m_253211_(start);
            component.setHeight(v1);
        });

        ResizeFunction resizeFunction;

        private VerticalSizing(ResizeFunction resizeFunction) {
            this.resizeFunction = resizeFunction;
        }
    }
}

