/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.component;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.compress.utils.Lists;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.component.ComboBox;
import yesman.epicfight.client.gui.component.PopupBox;
import yesman.epicfight.client.gui.component.ResizableButton;
import yesman.epicfight.client.gui.component.ResizableComponent;

@OnlyIn(value=Dist.CLIENT)
public class Grid
extends ObjectSelectionList<Row>
implements ResizableComponent {
    private final Screen owner;
    private final Map<String, Column<?>> columns = Maps.newHashMap();
    private final List<ResizableButton> rowEditButtons = Lists.newArrayList();
    private final boolean transparentBackground;
    private AbstractWidget editingWidget;
    private Column<?> editingColumn;
    private int rowpostition;
    private final int xParam1;
    private final int yParam1;
    private final int xParam2;
    private final int yParam2;
    private final ResizableComponent.HorizontalSizing horizontalSizingOption;
    private final ResizableComponent.VerticalSizing verticalSizingOption;

    public Grid(GridBuilder gb) {
        super(gb.minecraft, gb.x2, gb.y2, gb.y1, gb.y1 + gb.y2, gb.rowHeight);
        this.owner = gb.owner;
        this.transparentBackground = gb.transparentBackground;
        this.horizontalSizingOption = gb.horizontalSizing;
        this.verticalSizingOption = gb.verticalSizing;
        this.xParam1 = gb.x1;
        this.yParam1 = gb.y1;
        this.xParam2 = gb.x2;
        this.yParam2 = gb.y2;
        this.resize(gb.minecraft.f_91080_.m_264198_());
        gb.columns.entrySet().stream().map(entry -> {
            ((Column)entry.getValue()).size = (int)((float)((Column)entry.getValue()).size * ((float)this.f_93388_ / (float)gb.sizeTotal));
            return Pair.of((Object)((String)entry.getKey()), (Object)((Column)entry.getValue()));
        }).forEach(pair -> this.columns.put((String)pair.getFirst(), (Column)pair.getSecond()));
        this.m_93507_(gb.x1);
        this.m_93496_(false);
        if (gb.rowEditable) {
            int x1 = this.f_93392_ - 12;
            int x2 = 12;
            int xCorrect1 = 12;
            int xCorrect2 = 0;
            if (gb.buttonHorizontalSizing == ResizableComponent.HorizontalSizing.WIDTH_RIGHT) {
                x1 = 12;
                x2 = this.owner.f_96543_ - this.f_93392_;
                xCorrect1 = 0;
                xCorrect2 = 12;
            }
            this.rowEditButtons.add(ResizableButton.builder((Component)Component.m_237113_((String)"+"), button -> gb.onAddPress.accept(this, button)).pos(x1 - xCorrect1, this.f_93390_ - 12).size(x2 - xCorrect2, 12).horizontalSizing(gb.buttonHorizontalSizing).build());
            this.rowEditButtons.add(ResizableButton.builder((Component)Component.m_237113_((String)"x"), button -> gb.onRemovePress.accept(this, button)).pos(x1, this.f_93390_ - 12).size(x2, 12).horizontalSizing(gb.buttonHorizontalSizing).build());
        }
    }

    public int addRow() {
        return this.addRow(this.m_6702_().size());
    }

    public int addRow(int rowposition) {
        this.editingColumn = null;
        this.editingWidget = null;
        Row row = new Row();
        this.m_6702_().add(rowposition, row);
        for (Map.Entry<String, Column<?>> entry : this.columns.entrySet()) {
            row.setValue(entry.getKey(), entry.getValue().defaultVal);
        }
        return rowposition;
    }

    public int addRowWithDefaultValues(Object ... defaultValues) {
        return this.addRow(this.m_6702_().size(), defaultValues);
    }

    public int addRow(int rowposition, Object ... defaultValues) {
        this.editingColumn = null;
        this.editingWidget = null;
        Row row = new Row();
        for (Map.Entry<String, Column<?>> entry : this.columns.entrySet()) {
            row.setValue(entry.getKey(), entry.getValue().defaultVal);
        }
        for (int i = 0; i < defaultValues.length; i += 2) {
            row.setValue((String)defaultValues[i], defaultValues[i + 1]);
        }
        this.m_6702_().add(rowposition, row);
        return rowposition;
    }

    public int removeRow() {
        return this.removeRow(this.rowpostition);
    }

    public int removeRow(int row) {
        if (row < 0) {
            return -1;
        }
        if (this.m_6702_().size() == 0) {
            return -1;
        }
        if (this.rowpostition == row) {
            this.editingColumn = null;
            this.editingWidget = null;
        }
        this.m_6702_().remove(row);
        this.rowpostition = Math.min(row, this.m_6702_().size() - 1);
        return this.rowpostition;
    }

    public void setSelected(int rowposition) {
        this.setSelected((Row)((Object)this.m_6702_().get(rowposition)));
    }

    public void setSelected(@Nullable Row row) {
        super.m_6987_((AbstractSelectionList.Entry)row);
        this.rowpostition = this.m_6702_().indexOf((Object)row);
    }

    public <T> T getValue(int rowposition, String columnName) {
        return ((Row)((Object)this.m_6702_().get(rowposition))).getValue(columnName);
    }

    public <T> void setValue(int rowposition, String columnName, T value) {
        Row row = (Row)((Object)this.m_6702_().get(rowposition));
        row.setValue(columnName, value);
    }

    public void setGridFocus(int rowposition, String columnName) {
        this.setSelected(rowposition);
        int startX = 0;
        this.editingColumn = null;
        for (Map.Entry<String, Column<?>> entry : this.columns.entrySet()) {
            if (entry.getKey() == columnName) {
                this.editingColumn = entry.getValue();
                break;
            }
            startX += entry.getValue().size;
        }
        if (this.editingColumn == null) {
            this.editingWidget = null;
        } else if (this.editingColumn.editable) {
            this.editingWidget = this.editingColumn.createEditWidget(this.owner, this.owner.getMinecraft().f_91062_, this.f_93393_ + startX + 2, this.m_7610_(rowposition) - 2, this.f_93387_ - 3, (Row)this.m_93511_(), columnName, ((Row)this.m_93511_()).getValue(columnName));
            this.editingWidget.m_93692_(true);
        }
    }

    public List<ResizableButton> getRowEditButtons() {
        return this.rowEditButtons;
    }

    private void relocateButtons() {
        int x = this.f_93392_ - 24;
        int y = this.f_93390_ - 14;
        for (AbstractWidget abstractWidget : this.rowEditButtons) {
            abstractWidget.m_252865_(x);
            abstractWidget.m_253211_(y);
            x += 12;
        }
    }

    @Override
    public void resize(ScreenRectangle screenRectangle) {
        if (this.getHorizontalSizingOption() != null) {
            this.getHorizontalSizingOption().resizeFunction.resize(this, screenRectangle, this.getX1(), this.getX2());
        }
        if (this.getVerticalSizingOption() != null) {
            this.getVerticalSizingOption().resizeFunction.resize(this, screenRectangle, this.getY1(), this.getY2());
        }
        this.getRowEditButtons().forEach(button -> button.resize(screenRectangle));
    }

    public void m_93437_(int width, int height, int y0, int y1) {
        this.f_93388_ = width;
        this.f_93389_ = height;
        this.f_93390_ = y0;
        this.f_93391_ = y1;
        this.f_93393_ = 0;
        this.f_93392_ = width;
        this.relocateButtons();
    }

    public void m_93507_(int x) {
        this.f_93393_ = x;
        this.f_93392_ = x + this.f_93388_;
        this.relocateButtons();
    }

    public int m_5747_() {
        return this.f_93393_ + this.f_93388_ / 2 - this.m_5759_() / 2 + 2;
    }

    public int m_93520_() {
        return this.m_5747_() + this.m_5759_();
    }

    protected int m_7610_(int p_93512_) {
        return this.f_93390_ - (int)this.m_93517_() + p_93512_ * this.f_93387_ + this.f_93395_;
    }

    protected int m_93485_(int p_93486_) {
        return this.m_7610_(p_93486_) + this.f_93387_;
    }

    public void m_93692_(boolean focused) {
        if (!focused) {
            this.editingColumn = null;
            this.editingWidget = null;
        }
    }

    public boolean m_93696_() {
        return this.owner.m_7222_() == this;
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.rowEditButtons.forEach(button -> button.m_88315_(guiGraphics, mouseX, mouseY, partialTicks));
        int color = this.m_93696_() ? -1 : -6250336;
        guiGraphics.m_280509_(this.f_93393_, this.f_93390_, this.f_93392_, this.f_93391_, color);
        this.m_239227_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.editingWidget != null) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            this.editingWidget.m_253211_(this.m_7610_(this.rowpostition) + 2);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    protected void m_239227_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int rowLeft = this.m_5747_() - 1;
        int rowWidth = this.m_5759_();
        int itemHeight = this.f_93387_;
        int itemCount = this.m_5773_();
        int rowBottom = this.f_93390_;
        for (int rowIndex = 0; rowIndex < itemCount; ++rowIndex) {
            int rowTop = this.m_7610_(rowIndex);
            rowBottom = this.m_7610_(rowIndex) + this.f_93387_;
            if (rowBottom < this.f_93390_ || rowTop > this.f_93391_) continue;
            this.m_238964_(guiGraphics, mouseX, mouseY, partialTicks, rowIndex, rowLeft, rowTop, rowWidth, itemHeight);
        }
        if (rowBottom < this.f_93391_) {
            if (this.transparentBackground) {
                guiGraphics.m_280246_(0.12f, 0.12f, 0.12f, 1.0f);
                guiGraphics.m_280163_(Screen.f_279548_, rowLeft, rowBottom + 1, (float)(rowLeft + rowWidth - 2), (float)(this.f_93391_ - 1), rowWidth - 2, this.f_93391_ - rowBottom - 2, 32, 32);
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                guiGraphics.m_280509_(rowLeft, rowBottom + 1, rowLeft + rowWidth - 2, this.f_93391_ - 1, -16777216);
            }
        }
    }

    protected void m_238964_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, int rowPosition, int rowLeft, int rowTop, int rowRight, int itemHeight) {
        Row row = (Row)this.m_93500_(rowPosition);
        if (this.m_7987_(rowPosition)) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            this.m_240140_(guiGraphics, rowTop, rowRight, itemHeight, 0, 0);
            row.m_6311_(guiGraphics, rowPosition, rowTop, rowLeft, rowRight, itemHeight, mouseX, mouseY, false, partialTicks);
            guiGraphics.m_280168_().m_85849_();
        } else {
            row.m_6311_(guiGraphics, rowPosition, rowTop, rowLeft, rowRight, itemHeight, mouseX, mouseY, false, partialTicks);
        }
    }

    protected void m_240140_(GuiGraphics guiGraphics, int rowTop, int rowRight, int itemHeight, int color, int color2) {
        guiGraphics.m_280509_(this.f_93393_, rowTop, this.f_93392_, rowTop + itemHeight + 1, -1);
    }

    public boolean m_5953_(double x, double y) {
        double y0 = this.rowEditButtons.size() > 0 ? (double)(this.f_93390_ - 12) : (double)this.f_93390_;
        return y >= y0 && y <= (double)this.f_93391_ && x >= (double)this.f_93393_ && x <= (double)this.f_93392_;
    }

    public boolean m_6375_(double x, double y, int button) {
        for (Button button2 : this.rowEditButtons) {
            if (!button2.m_6375_(x, y, button)) continue;
            return true;
        }
        if (!this.m_5953_(x, y)) {
            return false;
        }
        if (this.editingWidget != null && this.editingWidget.m_6375_(x, y, button)) {
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6050_(double x, double y, double button) {
        if (this.m_93696_() && this.m_93518_() > 0) {
            this.m_93410_(this.m_93517_() - button * (double)this.f_93387_ / 2.0);
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keycode, int p_100876_, int p_100877_) {
        if (this.editingWidget != null) {
            return this.editingWidget.m_7933_(keycode, p_100876_, p_100877_);
        }
        return super.m_7933_(keycode, p_100876_, p_100877_);
    }

    public boolean m_5534_(char c, int i) {
        if (this.editingWidget != null) {
            return this.editingWidget.m_5534_(c, i);
        }
        return super.m_5534_(c, i);
    }

    public void tick() {
        AbstractWidget abstractWidget = this.editingWidget;
        if (abstractWidget instanceof EditBox) {
            EditBox editBox = (EditBox)abstractWidget;
            editBox.m_94120_();
        }
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    protected int m_5756_() {
        return this.f_93392_ - 6;
    }

    public static GridBuilder builder(Screen owner) {
        return new GridBuilder(owner);
    }

    @Override
    public void relocateX(int x) {
        this.f_93393_ = x;
        this.f_93392_ = x + this.f_93388_;
        this.relocateButtons();
    }

    @Override
    public void relocateY(int y) {
        this.f_93390_ = y;
        this.f_93391_ = y + this.f_93389_;
        this.relocateButtons();
    }

    @Override
    public void m_252865_(int x) {
        this.f_93393_ = x;
        this.f_93392_ = this.f_93393_ + this.f_93388_;
        this.relocateButtons();
    }

    @Override
    public void m_253211_(int y) {
        this.f_93390_ = y;
        this.f_93391_ = this.f_93390_ + this.f_93389_;
        this.relocateButtons();
    }

    @Override
    public void m_93674_(int width) {
        this.f_93392_ = this.f_93393_ + width;
        this.f_93388_ = width;
        this.relocateButtons();
    }

    @Override
    public void setHeight(int height) {
        this.f_93391_ = this.f_93390_ + height;
        this.f_93389_ = height;
        this.relocateButtons();
    }

    @Override
    public int m_252754_() {
        return this.f_93393_;
    }

    @Override
    public int m_252907_() {
        return this.f_93390_;
    }

    @Override
    public int getX1() {
        return this.xParam1;
    }

    @Override
    public int getX2() {
        return this.xParam2;
    }

    @Override
    public int getY1() {
        return this.yParam1;
    }

    @Override
    public int getY2() {
        return this.yParam2;
    }

    @Override
    public ResizableComponent.HorizontalSizing getHorizontalSizingOption() {
        return this.horizontalSizingOption;
    }

    @Override
    public ResizableComponent.VerticalSizing getVerticalSizingOption() {
        return this.verticalSizingOption;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GridBuilder {
        private final Minecraft minecraft;
        private final Screen owner;
        private final Map<String, Column<?>> columns = Maps.newLinkedHashMap();
        private int x1;
        private int y1;
        private int x2;
        private int y2;
        private int rowHeight;
        private int sizeTotal;
        private boolean rowEditable;
        private boolean transparentBackground;
        private BiConsumer<Grid, Button> onAddPress;
        private BiConsumer<Grid, Button> onRemovePress;
        private ResizableComponent.HorizontalSizing horizontalSizing = ResizableComponent.HorizontalSizing.LEFT_WIDTH;
        private ResizableComponent.VerticalSizing verticalSizing = null;
        private ResizableComponent.HorizontalSizing buttonHorizontalSizing = ResizableComponent.HorizontalSizing.LEFT_WIDTH;

        private GridBuilder(Screen owner) {
            this.owner = owner;
            this.minecraft = owner.getMinecraft();
        }

        public GridBuilder addEditboxColumn(String name, String defaultValue, boolean editable, int size) {
            this.columns.put(name, new EditBoxColumn(defaultValue, editable, size));
            this.sizeTotal += size;
            return this;
        }

        public <T> GridBuilder addComboColumn(String name, Function<T, String> toVisualText, T defaultValue, T[] enums, boolean editable, int size) {
            this.columns.put(name, new ComboColumn<T>(toVisualText, defaultValue, Arrays.asList(enums), editable, size));
            this.sizeTotal += size;
            return this;
        }

        public <T> GridBuilder addPopupColumn(String name, Function<T, String> toVisualText, T defaultValue, IForgeRegistry<T> registry, boolean editable, int size) {
            this.columns.put(name, new RegistryPopupColumn<T>(toVisualText, defaultValue, registry, editable, size));
            this.sizeTotal += size;
            return this;
        }

        public GridBuilder xy1(int x1, int y1) {
            this.x1 = x1;
            this.y1 = y1;
            return this;
        }

        public GridBuilder xy2(int x2, int y2) {
            this.x2 = x2;
            this.y2 = y2;
            return this;
        }

        public GridBuilder rowHeight(int rowHeight) {
            this.rowHeight = rowHeight;
            return this;
        }

        public GridBuilder transparentBackground(boolean transparentBackground) {
            this.transparentBackground = transparentBackground;
            return this;
        }

        public GridBuilder rowEditable(boolean rowEditable) {
            this.rowEditable = rowEditable;
            return this;
        }

        public GridBuilder onAddPress(BiConsumer<Grid, Button> onAddPress) {
            this.onAddPress = onAddPress;
            return this;
        }

        public GridBuilder onRemovePress(BiConsumer<Grid, Button> OnRemovePress) {
            this.onRemovePress = OnRemovePress;
            return this;
        }

        public GridBuilder horizontalSizing(ResizableComponent.HorizontalSizing horizontalSizing) {
            this.horizontalSizing = horizontalSizing;
            return this;
        }

        public GridBuilder verticalSizing(ResizableComponent.VerticalSizing verticalSizing) {
            this.verticalSizing = verticalSizing;
            return this;
        }

        public GridBuilder buttonHorizontalSizing(ResizableComponent.HorizontalSizing buttonHorizontalSizing) {
            this.buttonHorizontalSizing = buttonHorizontalSizing;
            return this;
        }

        public Grid build() {
            return new Grid(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static abstract class Column<T> {
        final Function<T, String> toVisualText;
        final T defaultVal;
        final boolean editable;
        int size;

        protected Column(Function<T, String> toVisualText, T defaultVal, boolean editable, int size) {
            this.toVisualText = toVisualText;
            this.defaultVal = defaultVal;
            this.size = size;
            this.editable = editable;
        }

        public String toVisualText(Object object) {
            return this.toVisualText.apply(object);
        }

        public abstract AbstractWidget createEditWidget(Screen var1, Font var2, int var3, int var4, int var5, Row var6, String var7, T var8);
    }

    @OnlyIn(value=Dist.CLIENT)
    class Row
    extends ObjectSelectionList.Entry<Row> {
        private Map<String, Object> values = Maps.newLinkedHashMap();

        private Row() {
            for (String columnName : Grid.this.columns.keySet()) {
                this.values.put(columnName, null);
            }
        }

        public <T> T getValue(String columnName) {
            return (T)this.values.get(columnName);
        }

        public <T> void setValue(String columnName, T value) {
            if (!Grid.this.columns.containsKey(columnName)) {
                throw new IllegalArgumentException("There's no column named " + columnName + " in Grid");
            }
            this.values.put(columnName, value);
        }

        public Component m_142172_() {
            return Component.m_237115_((String)"narrator.select");
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            int startX = Grid.this.f_93393_;
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                Column<?> column = Grid.this.columns.get(entry.getKey());
                if (Grid.this.transparentBackground) {
                    guiGraphics.m_280246_(0.12f, 0.12f, 0.12f, 1.0f);
                    guiGraphics.m_280163_(Screen.f_279548_, startX + 1, top + 1, (float)(startX + column.size - 1), (float)(top + height), column.size - 2, height - 1, 32, 32);
                    guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                } else {
                    guiGraphics.m_280509_(startX + 1, top + 1, startX + column.size - 1, top + height, -16777216);
                }
                startX += column.size;
                String displayText = column.toVisualText(entry.getValue());
                String correctedString = ((Grid)Grid.this).f_93386_.f_91062_.m_92834_(displayText, column.size - 1);
                guiGraphics.m_280056_(((Grid)Grid.this).f_93386_.f_91062_, correctedString, left + 2, top + Grid.this.f_93387_ / 2 - 4, 0xFFFFFF, false);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                int rowposition = Grid.this.m_6702_().indexOf((Object)this);
                if (Grid.this.m_93511_() == this) {
                    if (Grid.this.editingColumn == null) {
                        Grid.this.setGridFocus(rowposition, this.getColumn(mouseX));
                    } else {
                        Grid.this.setGridFocus(rowposition, null);
                    }
                } else {
                    Grid.this.setGridFocus(rowposition, this.getColumn(mouseX));
                }
                Grid.this.setSelected(this);
                return true;
            }
            return false;
        }

        public String getColumn(double mouseX) {
            double x = 0.0;
            for (Map.Entry<String, Column<?>> entry : Grid.this.columns.entrySet()) {
                if (!(mouseX < (x += (double)entry.getValue().size))) continue;
                return entry.getKey();
            }
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class RegistryPopupColumn<T>
    extends Column<T> {
        final IForgeRegistry<T> registry;

        protected RegistryPopupColumn(Function<T, String> toVisualText, T defaultVal, IForgeRegistry<T> registry, boolean editable, int size) {
            super(toVisualText, defaultVal, editable, size);
            this.registry = registry;
        }

        @Override
        public AbstractWidget createEditWidget(Screen owner, Font font, int x, int y, int height, Row row, String colName, T value) {
            return new PopupBox<T>(owner, font, x, y, this.size - 4, height, null, null, (Component)Component.m_237113_((String)"grid.popupEdit"), this.registry);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ComboColumn<T>
    extends Column<T> {
        final List<T> enums;

        protected ComboColumn(Function<T, String> toVisualText, T defaultVal, List<T> enums, boolean editable, int size) {
            super(toVisualText, defaultVal, editable, size);
            this.enums = enums;
        }

        @Override
        public AbstractWidget createEditWidget(Screen owner, Font font, int x, int y, int height, Row row, String colName, T value) {
            return new ComboBox<Object>(owner, font, x, y, this.size - 4, height, null, null, 8, (Component)Component.m_237113_((String)"grid.comboEdit"), this.enums, e -> ParseUtil.makeFirstLetterToUpper(e.toString()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class EditBoxColumn
    extends Column<String> {
        protected EditBoxColumn(String defaultVal, boolean editable, int size) {
            super(string -> string, defaultVal, editable, size);
        }

        @Override
        public AbstractWidget createEditWidget(Screen owner, Font font, int x, int y, int height, Row row, String colName, String value) {
            EditBox editbox = new EditBox(font, x, y, this.size - 4, height, (Component)Component.m_237113_((String)"grid.editbox"));
            editbox.m_94144_(value);
            editbox.m_94151_(string -> row.setValue(colName, string));
            return editbox;
        }
    }
}

