/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.component;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.component.ComboBox;
import yesman.epicfight.client.gui.component.ResizableComponent;

@OnlyIn(value=Dist.CLIENT)
public class ComboBox<T>
extends AbstractWidget
implements ResizableComponent {
    private final ComboItemList comboItemList;
    private final Font font;
    private final int rows;
    private boolean listOpened;
    private final int x1;
    private final int x2;
    private final int y1;
    private final int y2;
    private final ResizableComponent.HorizontalSizing horizontalSizingOption;
    private final ResizableComponent.VerticalSizing verticalSizingOption;

    public ComboBox(Screen parent, Font font, int x1, int x2, int y1, int y2, ResizableComponent.HorizontalSizing horizontal, ResizableComponent.VerticalSizing vertical, int maxRows, Component title, List<T> items, Function<T, String> displayStringMapper) {
        super(x1, x2, y1, y2, title);
        this.font = font;
        this.rows = maxRows;
        this.comboItemList = new ComboItemList(parent.getMinecraft(), maxRows, 15);
        for (T item : items) {
            this.comboItemList.addEntry(item, displayStringMapper.apply(item));
        }
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.horizontalSizingOption = horizontal;
        this.verticalSizingOption = vertical;
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.f_93623_ && this.f_93624_) {
            boolean flag;
            if (this.listOpened && this.comboItemList.m_6375_(x, y, button)) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                this.listOpened = false;
                return true;
            }
            if (this.m_7972_(button) && (flag = this.m_93680_(x, y))) {
                this.m_5716_(x, y);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean m_6050_(double x, double y, double amount) {
        if (this.listOpened) {
            return this.comboItemList.m_6050_(x, y, amount);
        }
        return false;
    }

    protected boolean m_93680_(double x, double y) {
        return this.f_93623_ && this.f_93624_ && x >= (double)this.m_252754_() && y >= (double)this.m_252907_() && x < (double)(this.m_252754_() + this.f_93618_) && y < (double)(this.m_252907_() + this.f_93619_);
    }

    public boolean m_5953_(double x, double y) {
        return this.f_93623_ && this.f_93624_ && x >= (double)this.m_252754_() && y >= (double)this.m_252907_() && x < (double)(this.m_252754_() + this.f_93618_) && y < (double)(this.m_252907_() + this.f_93619_ * (this.rows + 1));
    }

    @Override
    public void m_252865_(int x) {
        super.m_252865_(x);
        this.relocateComboList();
    }

    @Override
    public void m_253211_(int y) {
        super.m_253211_(y);
        this.relocateComboList();
    }

    private void relocateComboList() {
        this.comboItemList.m_93437_(this.f_93618_, this.f_93619_ * this.rows, this.m_252907_() + this.f_93619_ + 1, this.m_252907_() + this.f_93619_ * this.rows + 1);
        this.comboItemList.m_93507_(this.m_252754_());
    }

    public void m_5716_(double x, double y) {
        if (this.arrowClicked(x, y)) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.listOpened = !this.listOpened;
        } else if (this.listOpened) {
            this.listOpened = false;
            this.m_7435_(Minecraft.m_91087_().m_91106_());
        }
    }

    private boolean arrowClicked(double x, double y) {
        int openPressed = this.m_252754_() + this.f_93618_ - 14;
        return this.f_93623_ && this.f_93624_ && x >= (double)openPressed && y >= (double)this.m_252907_() && x < (double)(this.m_252754_() + this.f_93618_) && y < (double)(this.m_252907_() + this.f_93619_);
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int outlineColor = this.m_93696_() ? -1 : -6250336;
        guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, outlineColor);
        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -16777216);
        String correctedString = this.font.m_92834_(this.comboItemList.m_93511_() == null ? "" : ((ComboItemList.ComboItemEntry)this.comboItemList.m_93511_()).displayName, this.f_93618_ - 10);
        MutableComponent mutableComponent = Component.m_237113_((String)correctedString);
        int n = this.m_252754_() + 4;
        int n2 = this.m_252907_() + this.f_93619_ / 2;
        Objects.requireNonNull(this.font);
        guiGraphics.m_280614_(this.font, (Component)mutableComponent, n, n2 - 9 / 2 + 1, 0xFFFFFF, false);
        MutableComponent mutableComponent2 = Component.m_237113_((String)"\u25bc");
        int n3 = this.m_252754_() + this.f_93618_ - 8;
        int n4 = this.m_252907_() + this.f_93619_ / 2;
        Objects.requireNonNull(this.font);
        guiGraphics.m_280614_(this.font, (Component)mutableComponent2, n3, n4 - 9 / 2 + 1, 0xFFFFFF, false);
        if (this.listOpened) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            this.comboItemList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    protected MutableComponent m_5646_() {
        Component component = this.m_6035_();
        return Component.m_237110_((String)"gui.epicfight.narrate.comboBox", (Object[])new Object[]{component});
    }

    protected void m_168797_(NarrationElementOutput narrationElementInput) {
        narrationElementInput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }

    @Override
    public int getX1() {
        return this.x1;
    }

    @Override
    public int getX2() {
        return this.x2;
    }

    @Override
    public int getY1() {
        return this.y1;
    }

    @Override
    public int getY2() {
        return this.y2;
    }

    @Override
    public ResizableComponent.HorizontalSizing getHorizontalSizingOption() {
        return this.horizontalSizingOption;
    }

    @Override
    public ResizableComponent.VerticalSizing getVerticalSizingOption() {
        return this.verticalSizingOption;
    }

    @OnlyIn(value=Dist.CLIENT)
    class ComboItemList
    extends ObjectSelectionList<yesman.epicfight.client.gui.component.ComboBox$ComboItemList.ComboItemEntry> {
        public ComboItemList(Minecraft minecraft, int maxRows, int itemHeight) {
            super(minecraft, ComboBox.this.f_93618_, ComboBox.this.f_93619_, 0, itemHeight * maxRows, itemHeight);
            this.m_93496_(false);
            this.m_93473_(false, 0);
            this.m_93488_(false);
        }

        public void addEntry(T item, String displayName) {
            this.m_7085_((AbstractSelectionList.Entry)new ComboItemEntry(item, displayName));
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            guiGraphics.m_280509_(this.f_93393_ - 1, this.f_93390_ - 1, this.f_93392_ + 1, this.f_93391_ + 1, -1);
            guiGraphics.m_280509_(this.f_93393_, this.f_93390_, this.f_93392_, this.f_93391_, -16777216);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        protected int m_5756_() {
            return this.f_93392_ - 6;
        }

        @OnlyIn(value=Dist.CLIENT)
        class ComboItemEntry
        extends ObjectSelectionList.Entry<yesman.epicfight.client.gui.component.ComboBox$ComboItemList.ComboItemEntry> {
            private final T item;
            private final String displayName;

            protected ComboItemEntry(T item, String displayName) {
                this.item = item;
                this.displayName = displayName;
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    ComboItemList.this.m_6987_((AbstractSelectionList.Entry)this);
                    return true;
                }
                return false;
            }

            public Component m_142172_() {
                return Component.m_237119_();
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                guiGraphics.m_280056_(ComboBox.this.font, this.displayName, left + 2, top + 1, 0xFFFFFF, false);
            }

            public T getItem() {
                return this.item;
            }
        }
    }
}

