/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import yesman.epicfight.client.gui.EntityIndicator;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.effect.VisibleMobEffect;

@OnlyIn(value=Dist.CLIENT)
public class HealthBarIndicator
extends EntityIndicator {
    @Override
    public boolean shouldDraw(LivingEntity entityIn, @Nullable LivingEntityPatch<?> entitypatch, LocalPlayerPatch playerpatch) {
        ClientConfig.HealthBarShowOptions option = EpicFightMod.CLIENT_CONFIGS.healthBarShowOption.getValue();
        Minecraft mc = Minecraft.m_91087_();
        if (option == ClientConfig.HealthBarShowOptions.NONE) {
            return false;
        }
        if (!entityIn.m_6072_() || entityIn.m_20145_() || entityIn == ((LocalPlayer)playerpatch.getOriginal()).m_20202_()) {
            return false;
        }
        if (entityIn.m_20280_(mc.m_91288_()) >= 400.0) {
            return false;
        }
        if (entityIn instanceof Player) {
            Player playerIn = (Player)entityIn;
            if (playerIn == playerpatch.getOriginal() && playerpatch.getMaxStunShield() <= 0.0f) {
                return false;
            }
            if (playerIn.m_7500_() || playerIn.m_5833_()) {
                return false;
            }
        }
        if (option == ClientConfig.HealthBarShowOptions.TARGET) {
            return playerpatch.getTarget() == entityIn;
        }
        return !(entityIn.m_21220_().isEmpty() && entityIn.m_21223_() >= entityIn.m_21233_() || entityIn.f_20919_ >= 19);
    }

    @Override
    public void drawIndicator(LivingEntity entityIn, @Nullable LivingEntityPatch<?> entitypatch, LocalPlayerPatch playerpatch, PoseStack matStackIn, MultiBufferSource bufferIn, float partialTicks) {
        Matrix4f mvMatrix = super.getMVMatrix(matStackIn, entityIn, 0.0f, entityIn.m_20206_() + 0.25f, 0.0f, true, partialTicks);
        Collection activeEffects = entityIn.m_21220_();
        if (!activeEffects.isEmpty() && !entityIn.m_7306_(playerpatch.getOriginal())) {
            Iterator iter = activeEffects.iterator();
            int acives = activeEffects.size();
            int row = acives > 1 ? 1 : 0;
            int column = (acives - 1) / 2;
            float startX = -0.8f + -0.3f * (float)row;
            float startY = -0.15f + 0.15f * (float)column;
            block0: for (int i = 0; i <= column; ++i) {
                for (int j = 0; j <= row; ++j) {
                    ResourceLocation rl;
                    MobEffectInstance effectInstance = (MobEffectInstance)iter.next();
                    MobEffect effect = effectInstance.m_19544_();
                    if (effect instanceof VisibleMobEffect) {
                        VisibleMobEffect visibleMobEffect = (VisibleMobEffect)effect;
                        rl = visibleMobEffect.getIcon(effectInstance);
                    } else {
                        rl = new ResourceLocation(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect).m_135827_(), "textures/mob_effect/" + ForgeRegistries.MOB_EFFECTS.getKey((Object)effect).m_135815_() + ".png");
                    }
                    Minecraft.m_91087_().m_91097_().m_174784_(rl);
                    float x = startX + 0.3f * (float)j;
                    float y = startY + -0.3f * (float)i;
                    VertexConsumer vertexBuilder1 = bufferIn.m_6299_(EpicFightRenderTypes.entityIndicator(rl));
                    this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder1, x, y, x + 0.3f, y + 0.3f, 0.0f, 0.0f, 256.0f, 256.0f);
                    if (!iter.hasNext()) continue block0;
                }
            }
        }
        VertexConsumer vertexBuilder = bufferIn.m_6299_(EpicFightRenderTypes.entityIndicator(BATTLE_ICON));
        float ratio = Mth.m_14036_((float)(entityIn.m_21223_() / entityIn.m_21233_()), (float)0.0f, (float)1.0f);
        float healthRatio = -0.5f + ratio;
        int textureRatio = (int)(62.0f * ratio);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, -0.5f, -0.05f, healthRatio, 0.05f, 1.0f, 15.0f, textureRatio, 20.0f);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, healthRatio, -0.05f, 0.5f, 0.05f, textureRatio, 10.0f, 62.0f, 15.0f);
        float absorption = entityIn.m_6103_();
        if ((double)absorption > 0.0) {
            float absorptionRatio = Mth.m_14036_((float)(absorption / entityIn.m_21233_()), (float)0.0f, (float)1.0f);
            int absTexRatio = (int)(62.0f * absorptionRatio);
            this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, -0.5f, -0.05f, absorptionRatio - 0.5f, 0.05f, 1.0f, 20.0f, absTexRatio, 25.0f);
        }
        if (entitypatch != null) {
            this.renderStunShield(entitypatch, mvMatrix, vertexBuilder);
        }
    }

    private void renderStunShield(LivingEntityPatch<?> entitypatch, Matrix4f mvMatrix, VertexConsumer vertexBuilder) {
        if (entitypatch.getStunShield() == 0.0f) {
            return;
        }
        float ratio = Mth.m_14036_((float)(entitypatch.getStunShield() / entitypatch.getMaxStunShield()), (float)0.0f, (float)1.0f);
        float barRatio = -0.5f + ratio;
        int textureRatio = (int)(62.0f * ratio);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, -0.5f, -0.1f, barRatio, -0.05f, 1.0f, 5.0f, textureRatio, 10.0f);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, barRatio, -0.1f, 0.5f, -0.05f, textureRatio, 0.0f, 63.0f, 5.0f);
    }
}

