/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.HealthBarIndicator;
import yesman.epicfight.client.gui.ModIngameGui;
import yesman.epicfight.client.gui.TargetIndicator;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityIndicator
extends ModIngameGui {
    public static final List<EntityIndicator> ENTITY_INDICATOR_RENDERERS = Lists.newArrayList();
    public static final ResourceLocation BATTLE_ICON = new ResourceLocation("epicfight", "textures/gui/battle_icons.png");

    public static void init() {
        new TargetIndicator();
        new HealthBarIndicator();
    }

    public void drawTexturedModalRect2DPlane(Matrix4f matrix, VertexConsumer vertexBuilder, float minX, float minY, float maxX, float maxY, float minTexU, float minTexV, float maxTexU, float maxTexV) {
        this.drawTexturedModalRect3DPlane(matrix, vertexBuilder, minX, minY, this.getBlitOffset(), maxX, maxY, this.getBlitOffset(), minTexU, minTexV, maxTexU, maxTexV);
    }

    public void drawTexturedModalRect3DPlane(Matrix4f matrix, VertexConsumer vertexBuilder, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float minTexU, float minTexV, float maxTexU, float maxTexV) {
        float cor = 0.00390625f;
        vertexBuilder.m_252986_(matrix, minX, minY, maxZ).m_7421_(minTexU * cor, maxTexV * cor).m_5752_();
        vertexBuilder.m_252986_(matrix, maxX, minY, maxZ).m_7421_(maxTexU * cor, maxTexV * cor).m_5752_();
        vertexBuilder.m_252986_(matrix, maxX, maxY, minZ).m_7421_(maxTexU * cor, minTexV * cor).m_5752_();
        vertexBuilder.m_252986_(matrix, minX, maxY, minZ).m_7421_(minTexU * cor, minTexV * cor).m_5752_();
    }

    public EntityIndicator() {
        ENTITY_INDICATOR_RENDERERS.add(this);
    }

    public final Matrix4f getMVMatrix(PoseStack poseStack, LivingEntity entity, float x, float y, float z, boolean lockRotation, float partialTicks) {
        float posX = (float)Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
        float posY = (float)Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_());
        float posZ = (float)Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
        poseStack.m_85836_();
        poseStack.m_252880_(-posX, -posY, -posZ);
        poseStack.m_252781_(QuaternionUtils.YP.rotationDegrees(180.0f));
        float screenX = posX + x;
        float screenY = posY + y;
        float screenZ = posZ + z;
        OpenMatrix4f viewMatrix = OpenMatrix4f.importFromMojangMatrix(poseStack.m_85850_().m_252922_());
        OpenMatrix4f finalMatrix = new OpenMatrix4f();
        finalMatrix.translate(new Vec3f(-screenX, screenY, -screenZ));
        poseStack.m_85849_();
        if (lockRotation) {
            finalMatrix.m00 = viewMatrix.m00;
            finalMatrix.m01 = viewMatrix.m10;
            finalMatrix.m02 = viewMatrix.m20;
            finalMatrix.m10 = viewMatrix.m01;
            finalMatrix.m11 = viewMatrix.m11;
            finalMatrix.m12 = viewMatrix.m21;
            finalMatrix.m20 = viewMatrix.m02;
            finalMatrix.m21 = viewMatrix.m12;
            finalMatrix.m22 = viewMatrix.m22;
        }
        finalMatrix.mulFront(viewMatrix);
        return OpenMatrix4f.exportToMojangMatrix(finalMatrix);
    }

    public abstract void drawIndicator(LivingEntity var1, @Nullable LivingEntityPatch<?> var2, LocalPlayerPatch var3, PoseStack var4, MultiBufferSource var5, float var6);

    public abstract boolean shouldDraw(LivingEntity var1, @Nullable LivingEntityPatch<?> var2, LocalPlayerPatch var3);
}

