/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.forgeevent;

import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.VertexIndicator;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.gameasset.Armatures;

public abstract class ModelBuildEvent<T>
extends Event
implements IModBusEvent {
    protected final ResourceManager resourceManager;

    public ModelBuildEvent(ResourceManager resourceManager, Map<ResourceLocation, T> registerMap) {
        this.resourceManager = resourceManager;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MeshBuild
    extends ModelBuildEvent<Mesh<?>> {
        public MeshBuild(ResourceManager resourceManager, Map<ResourceLocation, Mesh<?>> registerMap) {
            super(resourceManager, registerMap);
        }

        public <M extends Mesh.RawMesh> M getRaw(String modid, String path, Meshes.MeshContructor<VertexIndicator, M> constructor) {
            ResourceLocation rl = new ResourceLocation(modid, "animmodels/" + path + ".json");
            return Meshes.getOrCreateRawMesh(this.resourceManager, rl, constructor);
        }

        public <M extends AnimatedMesh> M getAnimated(String modid, String path, Meshes.MeshContructor<VertexIndicator.AnimatedVertexIndicator, M> constructor) {
            ResourceLocation rl = new ResourceLocation(modid, "animmodels/" + path + ".json");
            return Meshes.getOrCreateAnimatedMesh(this.resourceManager, rl, constructor);
        }
    }

    public static class ArmatureBuild
    extends ModelBuildEvent<Armature> {
        public ArmatureBuild(ResourceManager resourceManager, Map<ResourceLocation, Armature> registerMap) {
            super(resourceManager, registerMap);
        }

        public <T extends Armature> T get(String modid, String path, Armatures.ArmatureContructor<T> constructor) {
            ResourceLocation rl = new ResourceLocation(modid, "animmodels/" + path + ".json");
            return Armatures.getOrCreateArmature(this.resourceManager, rl, constructor);
        }
    }
}

