/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.data.reloader;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.data.reloader.EpicFightPredicates;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.network.server.SPDatapackSync;
import yesman.epicfight.world.capabilities.entitypatch.CustomHumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.CustomMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.capabilities.provider.EntityPatchProvider;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class MobPatchReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<EntityType<?>, CompoundTag> TAGMAP = Maps.newHashMap();
    private static final Map<EntityType<?>, AbstractMobPatchProvider> MOB_PATCH_PROVIDERS = Maps.newHashMap();

    public MobPatchReloadListener() {
        super(GSON, "epicfight_mobpatch");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation rl = entry.getKey();
            String pathString = rl.m_135815_();
            ResourceLocation registryName = new ResourceLocation(rl.m_135827_(), pathString);
            if (!ForgeRegistries.ENTITY_TYPES.containsKey(registryName)) {
                EpicFightMod.LOGGER.warn("[Custom Entity] Entity named " + registryName + " does not exist");
                continue;
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(registryName);
            CompoundTag tag = null;
            try {
                tag = TagParser.m_129359_((String)entry.getValue().toString());
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            MOB_PATCH_PROVIDERS.put(entityType, MobPatchReloadListener.deserialize(entityType, tag, false));
            EntityPatchProvider.putCustomEntityPatch(entityType, entity -> () -> MOB_PATCH_PROVIDERS.get(entity.m_6095_()).get((Entity)entity));
            TAGMAP.put(entityType, MobPatchReloadListener.filterClientData(tag));
            if (!EpicFightMod.isPhysicalClient()) continue;
            ClientEngine.getInstance().renderEngine.registerCustomEntityRenderer(entityType, tag.m_128441_("preset") ? tag.m_128461_("preset") : tag.m_128461_("renderer"));
        }
    }

    public static AbstractMobPatchProvider deserialize(EntityType<?> entityType, CompoundTag tag, boolean clientSide) {
        AbstractMobPatchProvider provider = null;
        int i = 0;
        boolean hasBranch = tag.m_128441_(String.format("branch_%d", i));
        if (hasBranch) {
            provider = new BranchProvider();
            provider.defaultProvider = MobPatchReloadListener.deserializeMobPatchProvider(entityType, tag, clientSide);
        } else {
            provider = MobPatchReloadListener.deserializeMobPatchProvider(entityType, tag, clientSide);
        }
        while (hasBranch) {
            CompoundTag branchTag = tag.m_128469_(String.format("branch_%d", i));
            provider.providers.add((Pair<EpicFightPredicates<Entity>, AbstractMobPatchProvider>)Pair.of(MobPatchReloadListener.deserializePredicate(branchTag.m_128469_("condition")), (Object)MobPatchReloadListener.deserialize(entityType, branchTag, clientSide)));
            hasBranch = tag.m_128441_(String.format("branch_%d", ++i));
        }
        return provider;
    }

    public static EpicFightPredicates<Entity> deserializePredicate(CompoundTag tag) {
        String predicateType = tag.m_128461_("predicate");
        EpicFightPredicates.HasTag predicate = null;
        ArrayList loggerNote = Lists.newArrayList();
        if ("has_tags".equals(predicateType)) {
            if (!tag.m_128425_("tags", 9)) {
                loggerNote.add(new String[]{"has_tags", "tags", "string list"});
            }
            predicate = new EpicFightPredicates.HasTag(tag.m_128437_("tags", 8));
        }
        for (String[] formatArgs : loggerNote) {
            EpicFightMod.LOGGER.info(String.format("[Custom Entity Error] can't find a proper argument for %s. [name: %s, type: %s]", formatArgs));
        }
        if (predicate == null) {
            throw new IllegalArgumentException("[Custom Entity Error] No predicate type: " + predicateType);
        }
        return predicate;
    }

    public static AbstractMobPatchProvider deserializeMobPatchProvider(EntityType<?> entityType, CompoundTag tag, boolean clientSide) {
        boolean disabled;
        boolean bl = disabled = tag.m_128441_("disabled") && tag.m_128471_("disabled");
        if (disabled) {
            return new NullPatchProvider();
        }
        if (tag.m_128441_("preset")) {
            String presetName = tag.m_128461_("preset");
            Function<Entity, Supplier<EntityPatch<?>>> preset = EntityPatchProvider.get(presetName);
            EntityType presetEntityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(presetName));
            Armatures.registerEntityTypeArmature(entityType, Armatures.getRegistry(presetEntityType));
            MobPatchPresetProvider provider = new MobPatchPresetProvider(preset);
            return provider;
        }
        boolean humanoid = tag.m_128471_("isHumanoid");
        CustomMobPatchProvider provider = humanoid ? new CustomHumanoidMobPatchProvider() : new CustomMobPatchProvider();
        provider.attributeValues = MobPatchReloadListener.deserializeAttributes(tag.m_128469_("attributes"));
        ResourceLocation modelLocation = new ResourceLocation(tag.m_128461_("model"));
        ResourceLocation armatureLocation = new ResourceLocation(tag.m_128461_("armature"));
        modelLocation = new ResourceLocation(modelLocation.m_135827_(), "animmodels/" + modelLocation.m_135815_() + ".json");
        armatureLocation = new ResourceLocation(armatureLocation.m_135827_(), "animmodels/" + armatureLocation.m_135815_() + ".json");
        if (EpicFightMod.isPhysicalClient()) {
            Minecraft mc = Minecraft.m_91087_();
            Meshes.getOrCreateAnimatedMesh(mc.m_91098_(), modelLocation, humanoid ? AnimatedMesh::new : HumanoidMesh::new);
            Armature armature = Armatures.getOrCreateArmature(mc.m_91098_(), armatureLocation, humanoid ? Armature::new : HumanoidArmature::new);
            Armatures.registerEntityTypeArmature(entityType, armature);
        } else {
            Armature armature = Armatures.getOrCreateArmature(null, armatureLocation, humanoid ? Armature::new : HumanoidArmature::new);
            Armatures.registerEntityTypeArmature(entityType, armature);
        }
        provider.defaultAnimations = MobPatchReloadListener.deserializeDefaultAnimations(tag.m_128469_("default_livingmotions"));
        provider.faction = Faction.valueOf(tag.m_128461_("faction").toUpperCase(Locale.ROOT));
        float f = provider.scale = tag.m_128469_("attributes").m_128441_("scale") ? (float)tag.m_128469_("attributes").m_128459_("scale") : 1.0f;
        if (!clientSide) {
            provider.stunAnimations = MobPatchReloadListener.deserializeStunAnimations(tag.m_128469_("stun_animations"));
            provider.chasingSpeed = tag.m_128469_("attributes").m_128459_("chasing_speed");
            if (humanoid) {
                CustomMobPatchProvider humanoidProvider = provider;
                humanoidProvider.humanoidCombatBehaviors = MobPatchReloadListener.deserializeHumanoidCombatBehaviors(tag.m_128437_("combat_behavior", 10));
                humanoidProvider.humanoidWeaponMotions = MobPatchReloadListener.deserializeHumanoidWeaponMotions(tag.m_128437_("humanoid_weapon_motions", 10));
            } else {
                provider.combatBehaviorsBuilder = MobPatchReloadListener.deserializeCombatBehaviorsBuilder(tag.m_128437_("combat_behavior", 10));
            }
        }
        return provider;
    }

    public static Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> deserializeHumanoidCombatBehaviors(ListTag tag) {
        HashMap combatBehaviorsMapBuilder = Maps.newHashMap();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag combatBehavior = tag.m_128728_(i);
            ListTag categories = combatBehavior.m_128437_("weapon_categories", 8);
            Style style = Style.ENUM_MANAGER.get(combatBehavior.m_128461_("style"));
            CombatBehaviors.Builder builder = MobPatchReloadListener.deserializeCombatBehaviorsBuilder(combatBehavior.m_128437_("behavior_series", 10));
            for (int j = 0; j < categories.size(); ++j) {
                WeaponCategory category = WeaponCategory.ENUM_MANAGER.get(categories.m_128778_(j));
                combatBehaviorsMapBuilder.computeIfAbsent(category, key -> Maps.newHashMap());
                ((Map)combatBehaviorsMapBuilder.get(category)).put(style, builder);
            }
        }
        return combatBehaviorsMapBuilder;
    }

    public static List<Pair<LivingMotion, StaticAnimation>> deserializeDefaultAnimations(CompoundTag defaultLivingmotions) {
        ArrayList defaultAnimations = Lists.newArrayList();
        for (String key : defaultLivingmotions.m_128431_()) {
            String animation = defaultLivingmotions.m_128461_(key);
            defaultAnimations.add(Pair.of((Object)LivingMotion.ENUM_MANAGER.get(key), (Object)EpicFightMod.getInstance().animationManager.findAnimationByPath(animation)));
        }
        return defaultAnimations;
    }

    public static Map<StunType, StaticAnimation> deserializeStunAnimations(CompoundTag tag) {
        HashMap stunAnimations = Maps.newHashMap();
        for (StunType stunType : StunType.values()) {
            String lowerCaseName = tag.m_128461_(stunType.name().toLowerCase(Locale.ROOT));
            if (StringUtil.isNullOrEmpty((String)lowerCaseName)) continue;
            stunAnimations.put(stunType, EpicFightMod.getInstance().animationManager.findAnimationByPath(lowerCaseName));
        }
        return stunAnimations;
    }

    public static Map<Attribute, Double> deserializeAttributes(CompoundTag tag) {
        HashMap attributes = Maps.newHashMap();
        attributes.put((Attribute)EpicFightAttributes.IMPACT.get(), tag.m_128425_("impact", 6) ? tag.m_128459_("impact") : 0.5);
        attributes.put((Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), tag.m_128425_("armor_negation", 6) ? tag.m_128459_("armor_negation") : 0.0);
        attributes.put((Attribute)EpicFightAttributes.MAX_STRIKES.get(), Double.valueOf(tag.m_128425_("max_strikes", 3) ? tag.m_128451_("max_strikes") : 1));
        if (tag.m_128425_("attack_damage", 6)) {
            attributes.put(Attributes.f_22281_, tag.m_128459_("attack_damage"));
        }
        return attributes;
    }

    public static Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>> deserializeHumanoidWeaponMotions(ListTag tag) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < tag.size(); ++i) {
            ImmutableSet.Builder motions = ImmutableSet.builder();
            CompoundTag weaponMotionTag = tag.m_128728_(i);
            Style style = Style.ENUM_MANAGER.get(weaponMotionTag.m_128461_("style"));
            CompoundTag motionsTag = weaponMotionTag.m_128469_("livingmotions");
            for (String key : motionsTag.m_128431_()) {
                motions.add((Object)Pair.of((Object)LivingMotion.ENUM_MANAGER.get(key), (Object)EpicFightMod.getInstance().animationManager.findAnimationByPath(motionsTag.m_128461_(key))));
            }
            Tag weponTypeTag = weaponMotionTag.m_128423_("weapon_categories");
            if (weponTypeTag instanceof StringTag) {
                WeaponCategory weaponCategory = WeaponCategory.ENUM_MANAGER.get(weponTypeTag.m_7916_());
                if (!map.containsKey(weaponCategory)) {
                    map.put(weaponCategory, Maps.newHashMap());
                }
                ((Map)map.get(weaponCategory)).put(style, motions.build());
                continue;
            }
            if (!(weponTypeTag instanceof ListTag)) continue;
            ListTag weponTypesTag = (ListTag)weponTypeTag;
            for (int j = 0; j < weponTypesTag.size(); ++j) {
                WeaponCategory weaponCategory = WeaponCategory.ENUM_MANAGER.get(weponTypesTag.m_128778_(j));
                if (!map.containsKey(weaponCategory)) {
                    map.put(weaponCategory, Maps.newHashMap());
                }
                ((Map)map.get(weaponCategory)).put(style, motions.build());
            }
        }
        return map;
    }

    public static <T extends MobPatch<?>> CombatBehaviors.Builder<T> deserializeCombatBehaviorsBuilder(ListTag tag) {
        CombatBehaviors.Builder builder = CombatBehaviors.builder();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag behaviorSeries = tag.m_128728_(i);
            float weight = (float)behaviorSeries.m_128459_("weight");
            int cooldown = behaviorSeries.m_128441_("cooldown") ? behaviorSeries.m_128451_("cooldown") : 0;
            boolean canBeInterrupted = behaviorSeries.m_128441_("canBeInterrupted") && behaviorSeries.m_128471_("canBeInterrupted");
            boolean looping = behaviorSeries.m_128441_("looping") && behaviorSeries.m_128471_("looping");
            ListTag behaviorList = behaviorSeries.m_128437_("behaviors", 10);
            CombatBehaviors.BehaviorSeries.Builder behaviorSeriesBuilder = CombatBehaviors.BehaviorSeries.builder();
            behaviorSeriesBuilder.weight(weight).cooldown(cooldown).canBeInterrupted(canBeInterrupted).looping(looping);
            for (int j = 0; j < behaviorList.size(); ++j) {
                CombatBehaviors.Behavior.Builder<T> behaviorBuilder = CombatBehaviors.Behavior.builder();
                CompoundTag behavior = behaviorList.m_128728_(j);
                StaticAnimation animation = EpicFightMod.getInstance().animationManager.findAnimationByPath(behavior.m_128461_("animation"));
                ListTag conditionList = behavior.m_128437_("conditions", 10);
                behaviorBuilder.animationBehavior(animation);
                for (int k = 0; k < conditionList.size(); ++k) {
                    CompoundTag condition = conditionList.m_128728_(k);
                    CombatBehaviors.BehaviorPredicate<T> predicate = MobPatchReloadListener.deserializeBehaviorPredicate(condition.m_128461_("predicate"), condition);
                    behaviorBuilder.predicate(predicate);
                }
                behaviorSeriesBuilder.nextBehavior(behaviorBuilder);
            }
            builder.newBehaviorSeries(behaviorSeriesBuilder);
        }
        return builder;
    }

    public static <T extends MobPatch<?>> CombatBehaviors.BehaviorPredicate<T> deserializeBehaviorPredicate(String type, CompoundTag args) {
        CombatBehaviors.BehaviorPredicate predicate = null;
        ArrayList loggerNote = Lists.newArrayList();
        switch (type) {
            case "random_chance": {
                if (!args.m_128425_("chance", 6)) {
                    loggerNote.add(new String[]{"random_chance", "chance", "double", "0.0"});
                }
                predicate = new CombatBehaviors.RandomChance((float)args.m_128459_("chance"));
                break;
            }
            case "within_eye_height": {
                predicate = new CombatBehaviors.TargetWithinEyeHeight();
                break;
            }
            case "within_distance": {
                if (!args.m_128425_("min", 6)) {
                    loggerNote.add(new String[]{"within_distance", "min", "double", "0.0"});
                }
                if (!args.m_128425_("max", 6)) {
                    loggerNote.add(new String[]{"within_distance", "max", "double", "0.0"});
                }
                predicate = new CombatBehaviors.TargetWithinDistance(args.m_128459_("min"), args.m_128459_("max"));
                break;
            }
            case "within_angle": {
                if (!args.m_128425_("min", 6)) {
                    loggerNote.add(new String[]{"within_angle", "within_distance", "min", "double", "0.0F"});
                }
                if (!args.m_128425_("max", 6)) {
                    loggerNote.add(new String[]{"within_angle", "max", "double", "0.0F"});
                }
                predicate = new CombatBehaviors.TargetWithinAngle(args.m_128459_("min"), args.m_128459_("max"));
                break;
            }
            case "within_angle_horizontal": {
                if (!args.m_128425_("min", 6)) {
                    loggerNote.add(new String[]{"within_angle_horizontal", "min", "double", "0.0F"});
                }
                if (!args.m_128425_("max", 6)) {
                    loggerNote.add(new String[]{"within_angle_horizontal", "max", "double", "0.0F"});
                }
                predicate = new CombatBehaviors.TargetWithinAngle.Horizontal(args.m_128459_("min"), args.m_128459_("max"));
                break;
            }
            case "health": {
                if (!args.m_128425_("health", 6)) {
                    loggerNote.add(new String[]{"health", "health", "double", "0.0F"});
                }
                if (!args.m_128425_("comparator", 8)) {
                    loggerNote.add(new String[]{"health", "comparator", "string", ""});
                }
                predicate = new CombatBehaviors.Health((float)args.m_128459_("health"), CombatBehaviors.Health.Comparator.valueOf(args.m_128461_("comparator").toUpperCase(Locale.ROOT)));
            }
        }
        for (String[] formatArgs : loggerNote) {
            EpicFightMod.LOGGER.info(String.format("[Custom Entity Error] can't find a proper argument for %s. [name: %s, type: %s, default: %s]", formatArgs));
        }
        if (predicate == null) {
            throw new IllegalArgumentException("[Custom Entity Error] No predicate type: " + type);
        }
        return predicate;
    }

    public static CompoundTag filterClientData(CompoundTag tag) {
        CompoundTag clientTag = new CompoundTag();
        int i = 0;
        boolean hasBranch = tag.m_128441_(String.format("branch_%d", i));
        while (hasBranch) {
            CompoundTag branchTag = tag.m_128469_(String.format("branch_%d", i));
            CompoundTag copiedTag = new CompoundTag();
            MobPatchReloadListener.extractBranch(copiedTag, branchTag);
            clientTag.m_128365_(String.format("branch_%d", i), (Tag)copiedTag);
            hasBranch = tag.m_128441_(String.format("branch_%d", ++i));
        }
        MobPatchReloadListener.extractBranch(clientTag, tag);
        return clientTag;
    }

    public static CompoundTag extractBranch(CompoundTag extract, CompoundTag original) {
        if (original.m_128441_("disabled") && original.m_128471_("disabled")) {
            extract.m_128365_("disabled", original.m_128423_("disabled"));
        } else if (original.m_128441_("preset")) {
            extract.m_128365_("preset", original.m_128423_("preset"));
        } else {
            extract.m_128365_("model", original.m_128423_("model"));
            extract.m_128365_("armature", original.m_128423_("armature"));
            extract.m_128379_("isHumanoid", original.m_128441_("isHumanoid") ? original.m_128471_("isHumanoid") : false);
            extract.m_128365_("renderer", original.m_128423_("renderer"));
            extract.m_128365_("faction", original.m_128423_("faction"));
            extract.m_128365_("default_livingmotions", original.m_128423_("default_livingmotions"));
            extract.m_128365_("attributes", original.m_128423_("attributes"));
        }
        return extract;
    }

    public static Stream<CompoundTag> getDataStream() {
        Stream<CompoundTag> tagStream = TAGMAP.entrySet().stream().map(entry -> {
            ((CompoundTag)entry.getValue()).m_128359_("id", ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)entry.getKey())).toString());
            return (CompoundTag)entry.getValue();
        });
        return tagStream;
    }

    public static int getTagCount() {
        return TAGMAP.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processServerPacket(SPDatapackSync packet) {
        for (CompoundTag tag : packet.getTags()) {
            boolean disabled = false;
            if (tag.m_128441_("disabled")) {
                disabled = tag.m_128471_("disabled");
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(tag.m_128461_("id")));
            MOB_PATCH_PROVIDERS.put(entityType, MobPatchReloadListener.deserialize(entityType, tag, true));
            EntityPatchProvider.putCustomEntityPatch(entityType, entity -> () -> MOB_PATCH_PROVIDERS.get(entity.m_6095_()).get((Entity)entity));
            if (disabled) continue;
            if (tag.m_128441_("preset")) {
                Armatures.registerEntityTypeArmature(entityType, tag.m_128461_("preset"));
            } else {
                Minecraft mc = Minecraft.m_91087_();
                ResourceLocation armatureLocation = new ResourceLocation(tag.m_128461_("armature"));
                armatureLocation = new ResourceLocation(armatureLocation.m_135827_(), "animmodels/" + armatureLocation.m_135815_() + ".json");
                boolean humanoid = tag.m_128471_("isHumanoid");
                Armature armature = Armatures.getOrCreateArmature(mc.m_91098_(), armatureLocation, humanoid ? Armature::new : HumanoidArmature::new);
                Armatures.registerEntityTypeArmature(entityType, armature);
            }
            ClientEngine.getInstance().renderEngine.registerCustomEntityRenderer(entityType, tag.m_128441_("preset") ? tag.m_128461_("preset") : tag.m_128461_("renderer"));
        }
    }

    public static abstract class AbstractMobPatchProvider {
        public abstract EntityPatch<?> get(Entity var1);
    }

    public static class BranchProvider
    extends AbstractMobPatchProvider {
        protected List<Pair<EpicFightPredicates<Entity>, AbstractMobPatchProvider>> providers = Lists.newArrayList();
        protected AbstractMobPatchProvider defaultProvider;

        @Override
        public EntityPatch<?> get(Entity entity) {
            for (Pair<EpicFightPredicates<Entity>, AbstractMobPatchProvider> provider : this.providers) {
                if (!((EpicFightPredicates)provider.getFirst()).test(entity)) continue;
                return ((AbstractMobPatchProvider)provider.getSecond()).get(entity);
            }
            return this.defaultProvider.get(entity);
        }
    }

    public static class NullPatchProvider
    extends AbstractMobPatchProvider {
        @Override
        public EntityPatch<?> get(Entity entity) {
            return null;
        }
    }

    public static class MobPatchPresetProvider
    extends AbstractMobPatchProvider {
        protected final Function<Entity, Supplier<EntityPatch<?>>> presetProvider;

        public MobPatchPresetProvider(Function<Entity, Supplier<EntityPatch<?>>> presetProvider) {
            this.presetProvider = presetProvider;
        }

        @Override
        public EntityPatch<?> get(Entity entity) {
            return this.presetProvider.apply(entity).get();
        }
    }

    public static class CustomHumanoidMobPatchProvider
    extends CustomMobPatchProvider {
        protected Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> humanoidCombatBehaviors;
        protected Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>> humanoidWeaponMotions;

        @Override
        public EntityPatch<?> get(Entity entity) {
            return new CustomHumanoidMobPatch(this.faction, this);
        }

        public Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>> getHumanoidWeaponMotions() {
            return this.humanoidWeaponMotions;
        }

        public Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> getHumanoidCombatBehaviors() {
            return this.humanoidCombatBehaviors;
        }
    }

    public static class CustomMobPatchProvider
    extends AbstractMobPatchProvider {
        protected CombatBehaviors.Builder<?> combatBehaviorsBuilder;
        protected List<Pair<LivingMotion, StaticAnimation>> defaultAnimations;
        protected Map<StunType, StaticAnimation> stunAnimations;
        protected Map<Attribute, Double> attributeValues;
        protected Faction faction;
        protected double chasingSpeed;
        protected float scale;

        @Override
        public EntityPatch<?> get(Entity entity) {
            return new CustomMobPatch(this.faction, this);
        }

        public CombatBehaviors.Builder<?> getCombatBehaviorsBuilder() {
            return this.combatBehaviorsBuilder;
        }

        public List<Pair<LivingMotion, StaticAnimation>> getDefaultAnimations() {
            return this.defaultAnimations;
        }

        public Map<StunType, StaticAnimation> getStunAnimations() {
            return this.stunAnimations;
        }

        public Map<Attribute, Double> getAttributeValues() {
            return this.attributeValues;
        }

        public double getChasingSpeed() {
            return this.chasingSpeed;
        }

        public float getScale() {
            return this.scale;
        }
    }
}

