/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.data.reloader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.MultiOBBCollider;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.data.conditions.EpicFightConditions;
import yesman.epicfight.data.conditions.itemstack.ItemStackCondition;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.server.SPDatapackSync;
import yesman.epicfight.world.capabilities.item.ArmorCapability;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.TagBasedSeparativeCapability;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.capabilities.item.WeaponTypeReloadListener;
import yesman.epicfight.world.capabilities.provider.ItemCapabilityProvider;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class ItemCapabilityReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<Item, CompoundTag> CAPABILITY_ARMOR_DATA_MAP = Maps.newHashMap();
    private static final Map<Item, CompoundTag> CAPABILITY_WEAPON_DATA_MAP = Maps.newHashMap();
    private static boolean armorReceived = false;
    private static boolean weaponReceived = false;
    private static boolean weaponTypeReceived = false;

    public ItemCapabilityReloadListener() {
        super(GSON, "capabilities");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation rl = entry.getKey();
            String path = rl.m_135815_();
            if (!path.contains("/")) continue;
            String[] str = path.split("/", 2);
            ResourceLocation registryName = new ResourceLocation(rl.m_135827_(), str[1]);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
            if (item == null) {
                EpicFightMod.LOGGER.warn("Tried to add a capability for item " + registryName + ", but it doesn't exist!");
                return;
            }
            CompoundTag nbt = null;
            try {
                nbt = TagParser.m_129359_((String)entry.getValue().toString());
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            try {
                CapabilityItem capability;
                if (str[0].equals("armors")) {
                    capability = ItemCapabilityReloadListener.deserializeArmor(item, nbt);
                    ItemCapabilityProvider.put(item, capability);
                    CAPABILITY_ARMOR_DATA_MAP.put(item, nbt);
                    continue;
                }
                if (!str[0].equals("weapons")) continue;
                capability = ItemCapabilityReloadListener.deserializeWeapon(item, nbt);
                ItemCapabilityProvider.put(item, capability);
                CAPABILITY_WEAPON_DATA_MAP.put(item, nbt);
            }
            catch (Exception e) {
                EpicFightMod.LOGGER.warn("Error while deserializing datapack for " + registryName);
                e.printStackTrace();
            }
        }
        ItemCapabilityProvider.addDefaultItems();
    }

    public static CapabilityItem deserializeArmor(Item item, CompoundTag tag) {
        ArmorCapability.Builder builder = ArmorCapability.builder();
        if (tag.m_128441_("attributes")) {
            CompoundTag attributes = tag.m_128469_("attributes");
            builder.weight(attributes.m_128459_("weight")).stunArmor(attributes.m_128459_("stun_armor"));
        }
        builder.item(item);
        return builder.build();
    }

    public static CapabilityItem deserializeWeapon(Item item, CompoundTag tag) {
        CapabilityItem capability;
        if (tag.m_128441_("variations")) {
            CapabilityItem.Builder innerDefaultCapabilityBuilder;
            ListTag jsonArray = tag.m_128437_("variations", 10);
            ArrayList list = Lists.newArrayList();
            CapabilityItem.Builder builder = innerDefaultCapabilityBuilder = tag.m_128441_("type") ? WeaponTypeReloadListener.get(tag.m_128461_("type")).apply(item) : CapabilityItem.builder();
            if (tag.m_128441_("attributes")) {
                Iterator attributes = tag.m_128469_("attributes");
                for (String key : attributes.m_128431_()) {
                    Map<Attribute, AttributeModifier> attributeEntry = ItemCapabilityReloadListener.deserializeAttributes(attributes.m_128469_(key));
                    for (Map.Entry<Attribute, AttributeModifier> attribute : attributeEntry.entrySet()) {
                        innerDefaultCapabilityBuilder.addStyleAttibutes(Style.ENUM_MANAGER.get(key), (Pair<Attribute, AttributeModifier>)Pair.of((Object)attribute.getKey(), (Object)attribute.getValue()));
                    }
                }
            }
            for (Tag jsonElement : jsonArray) {
                CompoundTag innerTag = (CompoundTag)jsonElement;
                Function conditionProvider = EpicFightConditions.getConditionOrThrow(new ResourceLocation(innerTag.m_128461_("condition")));
                ItemStackCondition condition = (ItemStackCondition)Condition.ConditionBuilder.builder(conditionProvider).setTag(innerTag.m_128469_("predicate")).build();
                list.add(Pair.of((Object)condition, (Object)ItemCapabilityReloadListener.deserializeWeapon(item, innerTag)));
            }
            capability = new TagBasedSeparativeCapability(list, innerDefaultCapabilityBuilder.build());
        } else {
            CapabilityItem.Builder builder;
            CapabilityItem.Builder builder2 = builder = tag.m_128441_("type") ? WeaponTypeReloadListener.get(tag.m_128461_("type")).apply(item) : CapabilityItem.builder();
            if (tag.m_128441_("attributes")) {
                CompoundTag attributes = tag.m_128469_("attributes");
                for (String key : attributes.m_128431_()) {
                    Map<Attribute, AttributeModifier> attributeEntry = ItemCapabilityReloadListener.deserializeAttributes(attributes.m_128469_(key));
                    for (Map.Entry<Attribute, AttributeModifier> attribute : attributeEntry.entrySet()) {
                        builder.addStyleAttibutes(Style.ENUM_MANAGER.get(key), (Pair<Attribute, AttributeModifier>)Pair.of((Object)attribute.getKey(), (Object)attribute.getValue()));
                    }
                }
            }
            if (tag.m_128441_("collider") && builder instanceof WeaponCapability.Builder) {
                WeaponCapability.Builder weaponCapBuilder = (WeaponCapability.Builder)builder;
                CompoundTag colliderTag = tag.m_128469_("collider");
                Collider collider = ItemCapabilityReloadListener.deserializeCollider(colliderTag);
                weaponCapBuilder.collider(collider);
            }
            capability = builder.build();
        }
        return capability;
    }

    private static Map<Attribute, AttributeModifier> deserializeAttributes(CompoundTag tag) {
        HashMap modifierMap = Maps.newHashMap();
        if (tag.m_128441_("armor_negation")) {
            modifierMap.put((Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), EpicFightAttributes.getArmorNegationModifier(tag.m_128459_("armor_negation")));
        }
        if (tag.m_128441_("impact")) {
            modifierMap.put((Attribute)EpicFightAttributes.IMPACT.get(), EpicFightAttributes.getImpactModifier(tag.m_128459_("impact")));
        }
        if (tag.m_128441_("max_strikes")) {
            modifierMap.put((Attribute)EpicFightAttributes.MAX_STRIKES.get(), EpicFightAttributes.getMaxStrikesModifier(tag.m_128451_("max_strikes")));
        }
        if (tag.m_128441_("damage_bonus")) {
            modifierMap.put(Attributes.f_22281_, EpicFightAttributes.getDamageBonusModifier(tag.m_128459_("damage_bonus")));
        }
        if (tag.m_128441_("speed_bonus")) {
            modifierMap.put(Attributes.f_22283_, EpicFightAttributes.getSpeedBonusModifier(tag.m_128459_("speed_bonus")));
        }
        return modifierMap;
    }

    public static Collider deserializeCollider(CompoundTag tag) {
        int number = tag.m_128451_("number");
        if (number < 1) {
            throw new IllegalArgumentException("Datapack deserialization error: the number of colliders must bigger than 0!");
        }
        ListTag sizeVector = tag.m_128437_("size", 6);
        ListTag centerVector = tag.m_128437_("center", 6);
        double sizeX = sizeVector.m_128772_(0);
        double sizeY = sizeVector.m_128772_(1);
        double sizeZ = sizeVector.m_128772_(2);
        double centerX = centerVector.m_128772_(0);
        double centerY = centerVector.m_128772_(1);
        double centerZ = centerVector.m_128772_(2);
        if (sizeX < 0.0 || sizeY < 0.0 || sizeZ < 0.0) {
            throw new IllegalArgumentException("Datapack deserialization error: the size of the collider must be non-negative value!");
        }
        if (number == 1) {
            return new OBBCollider(sizeX, sizeY, sizeZ, centerX, centerY, centerZ);
        }
        return new MultiOBBCollider(number, sizeX, sizeY, sizeZ, centerX, centerY, centerZ);
    }

    public static Stream<CompoundTag> getArmorDataStream() {
        Stream<CompoundTag> tagStream = CAPABILITY_ARMOR_DATA_MAP.entrySet().stream().map(entry -> {
            ((CompoundTag)entry.getValue()).m_128405_("id", Item.m_41393_((Item)((Item)entry.getKey())));
            return (CompoundTag)entry.getValue();
        });
        return tagStream;
    }

    public static Stream<CompoundTag> getWeaponDataStream() {
        Stream<CompoundTag> tagStream = CAPABILITY_WEAPON_DATA_MAP.entrySet().stream().map(entry -> {
            ((CompoundTag)entry.getValue()).m_128405_("id", Item.m_41393_((Item)((Item)entry.getKey())));
            return (CompoundTag)entry.getValue();
        });
        return tagStream;
    }

    public static int armorCount() {
        return CAPABILITY_ARMOR_DATA_MAP.size();
    }

    public static int weaponCount() {
        return CAPABILITY_WEAPON_DATA_MAP.size();
    }

    public static void weaponTypeProcessedCheck() {
        weaponTypeReceived = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void reset() {
        armorReceived = false;
        weaponReceived = false;
        weaponTypeReceived = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processServerPacket(SPDatapackSync packet) {
        switch (packet.getType()) {
            case ARMOR: {
                for (CompoundTag tag2 : packet.getTags()) {
                    Item item2 = Item.m_41445_((int)tag2.m_128451_("id"));
                    CAPABILITY_ARMOR_DATA_MAP.put(item2, tag2);
                }
                armorReceived = true;
                break;
            }
            case WEAPON: {
                for (CompoundTag tag3 : packet.getTags()) {
                    Item item3 = Item.m_41445_((int)tag3.m_128451_("id"));
                    CAPABILITY_WEAPON_DATA_MAP.put(item3, tag3);
                }
                weaponReceived = true;
                break;
            }
        }
        if (weaponTypeReceived && armorReceived && weaponReceived) {
            CAPABILITY_ARMOR_DATA_MAP.forEach((item, tag) -> {
                try {
                    CapabilityItem itemCap = ItemCapabilityReloadListener.deserializeWeapon(item, tag);
                    ItemCapabilityProvider.put(item, itemCap);
                }
                catch (Exception e) {
                    EpicFightMod.LOGGER.warn("Can't read item capability for " + item);
                    e.printStackTrace();
                }
            });
            CAPABILITY_WEAPON_DATA_MAP.forEach((item, tag) -> {
                try {
                    CapabilityItem itemCap = ItemCapabilityReloadListener.deserializeWeapon(item, tag);
                    ItemCapabilityProvider.put(item, itemCap);
                }
                catch (Exception e) {
                    EpicFightMod.LOGGER.warn("Can't read item capability for " + item);
                    e.printStackTrace();
                }
            });
            ItemCapabilityProvider.addDefaultItems();
        }
    }
}

