/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;

public class OBBCollider
extends Collider {
    protected final Vec3[] modelVertex;
    protected final Vec3[] modelNormal;
    protected Vec3[] rotatedVertex;
    protected Vec3[] rotatedNormal;
    protected Vec3f scale;

    public OBBCollider(double posX, double posY, double posZ, double center_x, double center_y, double center_z) {
        this(OBBCollider.getInitialAABB(posX, posY, posZ, center_x, center_y, center_z), posX, posY, posZ, center_x, center_y, center_z);
    }

    protected OBBCollider(AABB outerAABB, double posX, double posY, double posZ, double center_x, double center_y, double center_z) {
        super(new Vec3(center_x, center_y, center_z), outerAABB);
        this.modelVertex = new Vec3[4];
        this.modelNormal = new Vec3[3];
        this.rotatedVertex = new Vec3[4];
        this.rotatedNormal = new Vec3[3];
        this.modelVertex[0] = new Vec3(posX, posY, -posZ);
        this.modelVertex[1] = new Vec3(posX, posY, posZ);
        this.modelVertex[2] = new Vec3(-posX, posY, posZ);
        this.modelVertex[3] = new Vec3(-posX, posY, -posZ);
        this.modelNormal[0] = new Vec3(1.0, 0.0, 0.0);
        this.modelNormal[1] = new Vec3(0.0, 1.0, 0.0);
        this.modelNormal[2] = new Vec3(0.0, 0.0, -1.0);
        this.rotatedVertex[0] = new Vec3(0.0, 0.0, 0.0);
        this.rotatedVertex[1] = new Vec3(0.0, 0.0, 0.0);
        this.rotatedVertex[2] = new Vec3(0.0, 0.0, 0.0);
        this.rotatedVertex[3] = new Vec3(0.0, 0.0, 0.0);
        this.rotatedNormal[0] = new Vec3(0.0, 0.0, 0.0);
        this.rotatedNormal[1] = new Vec3(0.0, 0.0, 0.0);
        this.rotatedNormal[2] = new Vec3(0.0, 0.0, 0.0);
    }

    static AABB getInitialAABB(double posX, double posY, double posZ, double center_x, double center_y, double center_z) {
        double xLength = Math.abs(posX) + Math.abs(center_x);
        double yLength = Math.abs(posY) + Math.abs(center_y);
        double zLength = Math.abs(posZ) + Math.abs(center_z);
        double maxLength = Math.max(xLength, Math.max(yLength, zLength));
        return new AABB(maxLength, maxLength, maxLength, -maxLength, -maxLength, -maxLength);
    }

    public OBBCollider(AABB entityCallAABB, double pos1_x, double pos1_y, double pos1_z, double pos2_x, double pos2_y, double pos2_z, double norm1_x, double norm1_y, double norm1_z, double norm2_x, double norm2_y, double norm2_z, double center_x, double center_y, double center_z) {
        super(new Vec3(center_x, center_y, center_z), entityCallAABB);
        this.modelVertex = new Vec3[2];
        this.modelNormal = new Vec3[2];
        this.rotatedVertex = new Vec3[2];
        this.rotatedNormal = new Vec3[2];
        this.modelVertex[0] = new Vec3(pos1_x, pos1_y, pos1_z);
        this.modelVertex[1] = new Vec3(pos2_x, pos2_y, pos2_z);
        this.modelNormal[0] = new Vec3(norm1_x, norm1_y, norm1_z);
        this.modelNormal[1] = new Vec3(norm2_x, norm2_y, norm2_z);
        this.rotatedVertex[0] = new Vec3(0.0, 0.0, 0.0);
        this.rotatedVertex[1] = new Vec3(0.0, 0.0, 0.0);
        this.rotatedNormal[0] = new Vec3(0.0, 0.0, 0.0);
        this.rotatedNormal[1] = new Vec3(0.0, 0.0, 0.0);
    }

    public OBBCollider(AABB aabbCopy) {
        super(null, null);
        this.modelVertex = null;
        this.modelNormal = null;
        double xSize = (aabbCopy.f_82291_ - aabbCopy.f_82288_) / 2.0;
        double ySize = (aabbCopy.f_82292_ - aabbCopy.f_82289_) / 2.0;
        double zSize = (aabbCopy.f_82293_ - aabbCopy.f_82290_) / 2.0;
        this.worldCenter = new Vec3(-((double)((float)aabbCopy.f_82288_) + xSize), (double)((float)aabbCopy.f_82289_) + ySize, -((double)((float)aabbCopy.f_82290_) + zSize));
        this.rotatedVertex = new Vec3[4];
        this.rotatedNormal = new Vec3[3];
        this.rotatedVertex[0] = new Vec3(-xSize, ySize, -zSize);
        this.rotatedVertex[1] = new Vec3(-xSize, ySize, zSize);
        this.rotatedVertex[2] = new Vec3(xSize, ySize, zSize);
        this.rotatedVertex[3] = new Vec3(xSize, ySize, -zSize);
        this.rotatedNormal[0] = new Vec3(1.0, 0.0, 0.0);
        this.rotatedNormal[1] = new Vec3(0.0, 1.0, 0.0);
        this.rotatedNormal[2] = new Vec3(0.0, 0.0, 1.0);
    }

    @Override
    public void transform(OpenMatrix4f modelMatrix) {
        int i;
        OpenMatrix4f noTranslation = modelMatrix.removeTranslation();
        for (i = 0; i < this.modelVertex.length; ++i) {
            this.rotatedVertex[i] = OpenMatrix4f.transform(noTranslation, this.modelVertex[i]);
        }
        for (i = 0; i < this.modelNormal.length; ++i) {
            this.rotatedNormal[i] = OpenMatrix4f.transform(noTranslation, this.modelNormal[i]);
        }
        this.scale = noTranslation.toScaleVector();
        super.transform(modelMatrix);
    }

    @Override
    protected AABB getHitboxAABB() {
        return this.outerAABB.m_82377_((this.outerAABB.f_82291_ - this.outerAABB.f_82288_) * (double)this.scale.x, (this.outerAABB.f_82292_ - this.outerAABB.f_82289_) * (double)this.scale.y, (this.outerAABB.f_82293_ - this.outerAABB.f_82290_) * (double)this.scale.z).m_82386_(-this.worldCenter.f_82479_, this.worldCenter.f_82480_, -this.worldCenter.f_82481_);
    }

    public boolean isCollide(OBBCollider opponent) {
        Vec3 toOpponent = opponent.worldCenter.m_82546_(this.worldCenter);
        for (Vec3 seperateAxis : this.rotatedNormal) {
            if (OBBCollider.collisionDetection(seperateAxis, toOpponent, this, opponent)) continue;
            return false;
        }
        for (Vec3 seperateAxis : opponent.rotatedNormal) {
            if (OBBCollider.collisionDetection(seperateAxis, toOpponent, this, opponent)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCollide(Entity entity) {
        OBBCollider obb = new OBBCollider(entity.m_20191_());
        return this.isCollide(obb);
    }

    @Override
    public OBBCollider deepCopy() {
        Vec3 xyzVec = this.modelVertex[1];
        return new OBBCollider(xyzVec.f_82479_, xyzVec.f_82480_, xyzVec.f_82481_, this.modelCenter.f_82479_, this.modelCenter.f_82480_, this.modelCenter.f_82481_);
    }

    private static boolean collisionDetection(Vec3 seperateAxis, Vec3 toOpponent, OBBCollider box1, OBBCollider box2) {
        double dot;
        Vec3 temp;
        Vec3 maxProj1 = null;
        Vec3 maxProj2 = null;
        double maxDot1 = -1.0;
        double maxDot2 = -1.0;
        Vec3 distance = seperateAxis.m_82526_(toOpponent) > 0.0 ? toOpponent : toOpponent.m_82490_(-1.0);
        for (Vec3 vertexVector : box1.rotatedVertex) {
            temp = seperateAxis.m_82526_(vertexVector) > 0.0 ? vertexVector : vertexVector.m_82490_(-1.0);
            dot = seperateAxis.m_82526_(temp);
            if (!(dot > maxDot1)) continue;
            maxDot1 = dot;
            maxProj1 = temp;
        }
        for (Vec3 vertexVector : box2.rotatedVertex) {
            temp = seperateAxis.m_82526_(vertexVector) > 0.0 ? vertexVector : vertexVector.m_82490_(-1.0);
            dot = seperateAxis.m_82526_(temp);
            if (!(dot > maxDot2)) continue;
            maxDot2 = dot;
            maxProj2 = temp;
        }
        return !(MathUtils.projectVector(distance, seperateAxis).m_82553_() > MathUtils.projectVector(maxProj1, seperateAxis).m_82553_() + MathUtils.projectVector(maxProj2, seperateAxis).m_82553_());
    }

    @Override
    public String toString() {
        return super.toString() + " worldCenter : " + this.worldCenter + " direction : " + this.rotatedVertex[0];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInternal(PoseStack matrixStackIn, MultiBufferSource buffer, OpenMatrix4f pose, boolean red) {
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_173247_());
        OpenMatrix4f transpose = new OpenMatrix4f();
        OpenMatrix4f.transpose(pose, transpose);
        matrixStackIn.m_85836_();
        MathUtils.translateStack(matrixStackIn, pose);
        MathUtils.rotateStack(matrixStackIn, transpose);
        Matrix4f matrix = matrixStackIn.m_85850_().m_252922_();
        Vec3 vec = this.modelVertex[1];
        float maxX = (float)(this.modelCenter.f_82479_ + vec.f_82479_);
        float maxY = (float)(this.modelCenter.f_82480_ + vec.f_82480_);
        float maxZ = (float)(this.modelCenter.f_82481_ + vec.f_82481_);
        float minX = (float)(this.modelCenter.f_82479_ - vec.f_82479_);
        float minY = (float)(this.modelCenter.f_82480_ - vec.f_82480_);
        float minZ = (float)(this.modelCenter.f_82481_ - vec.f_82481_);
        float color = red ? 0.0f : 1.0f;
        vertexBuilder.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, maxX, maxY, minZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, minX, maxY, minZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, minX, maxY, maxZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, maxX, minY, maxZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, maxX, minY, minZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, maxX, maxY, minZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, maxX, minY, minZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, minX, minY, minZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, minX, maxY, minZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, minX, minY, minZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, minX, minY, maxZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, minX, maxY, maxZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, minX, minY, maxZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, maxX, minY, maxZ).m_85950_(1.0f, color, color, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        matrixStackIn.m_85849_();
    }
}

