/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import yesman.epicfight.api.client.model.ModelPart;
import yesman.epicfight.api.client.model.VertexIndicator;
import yesman.epicfight.main.EpicFightMod;

@OnlyIn(value=Dist.CLIENT)
public abstract class Mesh<T extends VertexIndicator> {
    final float[] positions;
    final float[] uvs;
    final float[] normals;
    final int totalVertices;
    final Map<String, ModelPart<T>> parts;
    final RenderProperties renderProperties;

    public Mesh(Map<String, float[]> arrayMap, Mesh<T> parent, RenderProperties renderProperties, Map<String, ModelPart<T>> parts) {
        this.positions = parent == null ? arrayMap.get("positions") : parent.positions;
        this.normals = parent == null ? arrayMap.get("normals") : parent.normals;
        this.uvs = parent == null ? arrayMap.get("uvs") : parent.uvs;
        this.parts = parent == null ? parts : parent.parts;
        this.renderProperties = renderProperties;
        int totalV = 0;
        for (ModelPart<T> meshpart : parts.values()) {
            totalV += meshpart.getVertices().size();
        }
        this.totalVertices = totalV;
    }

    protected abstract ModelPart<T> getOrLogException(Map<String, ModelPart<T>> var1, String var2);

    public boolean hasPart(String part) {
        return this.parts.containsKey(part);
    }

    public ModelPart<T> getPart(String part) {
        return this.parts.get(part);
    }

    public Collection<ModelPart<T>> getAllParts() {
        return this.parts.values();
    }

    public RenderProperties getRenderProperty() {
        return this.renderProperties;
    }

    public void initialize() {
        this.parts.values().forEach(part -> {
            part.hidden = false;
        });
    }

    public void drawRawModel(PoseStack poseStack, VertexConsumer builder, int packedLightIn, float r, float g, float b, float a, int overlayCoord) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        for (ModelPart<T> part : this.parts.values()) {
            if (part.hidden) continue;
            for (VertexIndicator vi : part.getVertices()) {
                int pos = vi.position * 3;
                int norm = vi.normal * 3;
                int uv = vi.uv * 2;
                Vector4f posVec = new Vector4f(this.positions[pos], this.positions[pos + 1], this.positions[pos + 2], 1.0f);
                Vector3f normVec = new Vector3f(this.normals[norm], this.normals[norm + 1], this.normals[norm + 2]);
                posVec.mul((Matrix4fc)matrix4f);
                normVec.mul((Matrix3fc)matrix3f);
                builder.m_5954_(posVec.x(), posVec.y(), posVec.z(), r, g, b, a, this.uvs[uv], this.uvs[uv + 1], overlayCoord, packedLightIn, normVec.x(), normVec.y(), normVec.z());
            }
        }
    }

    public void drawRawModelNormal(PoseStack poseStack, VertexConsumer builder, int packedLightIn, float r, float g, float b, float a, int overlayCoord) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        for (ModelPart<T> part : this.parts.values()) {
            if (part.hidden) continue;
            for (VertexIndicator vi : part.getVertices()) {
                int pos = vi.position * 3;
                int uv = vi.uv * 2;
                Vector4f posVec = new Vector4f(this.positions[pos], this.positions[pos + 1], this.positions[pos + 2], 1.0f);
                posVec.mul((Matrix4fc)matrix4f);
                builder.m_5483_((double)posVec.x(), (double)posVec.y(), (double)posVec.z()).m_85950_(r, g, b, a).m_7421_(this.uvs[uv], this.uvs[uv + 1]).m_85969_(packedLightIn).m_5752_();
            }
        }
    }

    public static class RenderProperties {
        protected String customTexturePath;
        protected boolean isTransparent;

        public String getCustomTexturePath() {
            return this.customTexturePath;
        }

        public boolean isTransparent() {
            return this.isTransparent;
        }

        public RenderProperties customTexturePath(String path) {
            this.customTexturePath = path;
            return this;
        }

        public RenderProperties transparency(boolean isTransparent) {
            this.isTransparent = isTransparent;
            return this;
        }

        public static RenderProperties create() {
            return new RenderProperties();
        }
    }

    public static class RawMesh
    extends Mesh<VertexIndicator> {
        public static final ModelPart<VertexIndicator> EMPTY = new ModelPart(null, null);

        public RawMesh(Map<String, float[]> arrayMap, Mesh<VertexIndicator> parent, RenderProperties properties, Map<String, ModelPart<VertexIndicator>> parts) {
            super(arrayMap, parent, properties, parts);
        }

        @Override
        protected ModelPart<VertexIndicator> getOrLogException(Map<String, ModelPart<VertexIndicator>> parts, String name) {
            if (!parts.containsKey(name)) {
                EpicFightMod.LOGGER.debug("Can not find the mesh part named " + name + " in " + this.getClass().getCanonicalName());
                return EMPTY;
            }
            return parts.get(name);
        }
    }
}

