/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.ModelPart;
import yesman.epicfight.api.client.model.VertexIndicator;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.api.utils.math.Vec4f;
import yesman.epicfight.main.EpicFightMod;

@OnlyIn(value=Dist.CLIENT)
public class AnimatedMesh
extends Mesh<VertexIndicator.AnimatedVertexIndicator> {
    public static final ModelPart<VertexIndicator.AnimatedVertexIndicator> EMPTY = new ModelPart(null, null);
    final float[] weights;

    public AnimatedMesh(Map<String, float[]> arrayMap, AnimatedMesh parent, Mesh.RenderProperties properties, Map<String, ModelPart<VertexIndicator.AnimatedVertexIndicator>> parts) {
        super(arrayMap, parent, properties, parts);
        this.weights = parent == null ? arrayMap.get("weights") : parent.weights;
    }

    @Override
    protected ModelPart<VertexIndicator.AnimatedVertexIndicator> getOrLogException(Map<String, ModelPart<VertexIndicator.AnimatedVertexIndicator>> parts, String name) {
        if (!parts.containsKey(name)) {
            EpicFightMod.LOGGER.debug("Cannot find the mesh part named " + name + " in " + this.getClass().getCanonicalName());
            return EMPTY;
        }
        return parts.get(name);
    }

    public void drawModelWithPose(PoseStack poseStack, VertexConsumer builder, int packedLightIn, float r, float g, float b, float a, int overlayCoord, Armature armature, OpenMatrix4f[] poses) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        OpenMatrix4f[] posesNoTranslation = new OpenMatrix4f[poses.length];
        for (int i = 0; i < poses.length; ++i) {
            posesNoTranslation[i] = OpenMatrix4f.mul(poses[i], armature.searchJointById(i).getToOrigin(), null).removeTranslation();
        }
        for (ModelPart part : this.parts.values()) {
            if (part.hidden) continue;
            for (VertexIndicator.AnimatedVertexIndicator vi : part.getVertices()) {
                int pos = vi.position * 3;
                int norm = vi.normal * 3;
                int uv = vi.uv * 2;
                Vec4f position = new Vec4f(this.positions[pos], this.positions[pos + 1], this.positions[pos + 2], 1.0f);
                Vec4f normal = new Vec4f(this.normals[norm], this.normals[norm + 1], this.normals[norm + 2], 1.0f);
                Vec4f totalPos = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
                Vec4f totalNorm = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
                for (int i = 0; i < vi.joint.size(); ++i) {
                    int jointIndex = vi.joint.get(i);
                    int weightIndex = vi.weight.get(i);
                    float weight = this.weights[weightIndex];
                    Vec4f.add(OpenMatrix4f.transform(OpenMatrix4f.mul(poses[jointIndex], armature.searchJointById(jointIndex).getToOrigin(), null), position, null).scale(weight), totalPos, totalPos);
                    Vec4f.add(OpenMatrix4f.transform(posesNoTranslation[jointIndex], normal, null).scale(weight), totalNorm, totalNorm);
                }
                Vector4f posVec = new Vector4f(totalPos.x, totalPos.y, totalPos.z, 1.0f);
                Vector3f normVec = totalNorm.toMojangVector();
                posVec.mul((Matrix4fc)matrix4f);
                normVec.mul((Matrix3fc)matrix3f);
                builder.m_5954_(posVec.x(), posVec.y(), posVec.z(), r, g, b, a, this.uvs[uv], this.uvs[uv + 1], overlayCoord, packedLightIn, normVec.x(), normVec.y(), normVec.z());
            }
        }
    }

    public void drawWithPoseNoTexture(PoseStack poseStack, VertexConsumer builder, int packedLightIn, float r, float g, float b, float a, int overlayCoord, OpenMatrix4f[] poses) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        OpenMatrix4f[] posesNoTranslation = new OpenMatrix4f[poses.length];
        for (int i = 0; i < poses.length; ++i) {
            posesNoTranslation[i] = poses[i].removeTranslation();
        }
        for (ModelPart part : this.parts.values()) {
            if (part.hidden) continue;
            for (VertexIndicator.AnimatedVertexIndicator vi : part.getVertices()) {
                int pos = vi.position * 3;
                int norm = vi.normal * 3;
                Vec4f position = new Vec4f(this.positions[pos], this.positions[pos + 1], this.positions[pos + 2], 1.0f);
                Vec4f normal = new Vec4f(this.normals[norm], this.normals[norm + 1], this.normals[norm + 2], 1.0f);
                Vec4f totalPos = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
                Vec4f totalNorm = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
                for (int i = 0; i < vi.joint.size(); ++i) {
                    int jointIndex = vi.joint.get(i);
                    int weightIndex = vi.weight.get(i);
                    float weight = this.weights[weightIndex];
                    Vec4f.add(OpenMatrix4f.transform(poses[jointIndex], position, null).scale(weight), totalPos, totalPos);
                    Vec4f.add(OpenMatrix4f.transform(posesNoTranslation[jointIndex], normal, null).scale(weight), totalNorm, totalNorm);
                }
                Vector4f posVec = new Vector4f(totalPos.x, totalPos.y, totalPos.z, 1.0f);
                Vector3f normVec = new Vector3f(totalNorm.x, totalNorm.y, totalNorm.z);
                posVec.mul((Matrix4fc)matrix4f);
                normVec.mul((Matrix3fc)matrix3f);
                builder.m_5483_((double)posVec.x(), (double)posVec.y(), (double)posVec.z());
                builder.m_85950_(r, g, b, a);
                builder.m_85969_(packedLightIn);
                builder.m_5752_();
            }
        }
    }

    public JsonObject toJsonObject() {
        int k;
        int i;
        JsonObject root = new JsonObject();
        JsonObject vertices = new JsonObject();
        float[] positions = (float[])this.positions.clone();
        float[] normals = (float[])this.normals.clone();
        OpenMatrix4f toBlenderCoord = OpenMatrix4f.createRotatorDeg(90.0f, Vec3f.X_AXIS);
        for (i = 0; i < positions.length / 3; ++i) {
            k = i * 3;
            Vec4f posVector = new Vec4f(positions[k], positions[k + 1], positions[k + 2], 1.0f);
            OpenMatrix4f.transform(toBlenderCoord, posVector, posVector);
            positions[k] = posVector.x;
            positions[k + 1] = posVector.y;
            positions[k + 2] = posVector.z;
        }
        for (i = 0; i < normals.length / 3; ++i) {
            k = i * 3;
            Vec4f normVector = new Vec4f(normals[k], normals[k + 1], normals[k + 2], 1.0f);
            OpenMatrix4f.transform(toBlenderCoord, normVector, normVector);
            normals[k] = normVector.x;
            normals[k + 1] = normVector.y;
            normals[k + 2] = normVector.z;
        }
        int[] indices = new int[this.totalVertices * 3];
        int[] vcounts = new int[positions.length / 3];
        ArrayList vIndexList = Lists.newArrayList();
        HashMap positionMap = Maps.newHashMap();
        int i2 = 0;
        for (ModelPart part : this.parts.values()) {
            for (VertexIndicator.AnimatedVertexIndicator vertexIndicator : part.getVertices()) {
                indices[i2 * 3] = vertexIndicator.position;
                indices[i2 * 3 + 1] = vertexIndicator.uv;
                indices[i2 * 3 + 2] = vertexIndicator.normal;
                vcounts[vertexIndicator.position] = vertexIndicator.joint.size();
                positionMap.put(vertexIndicator.position, vertexIndicator);
                ++i2;
            }
        }
        for (i2 = 0; i2 < vcounts.length; ++i2) {
            for (int j2 = 0; j2 < vcounts[i2]; ++j2) {
                VertexIndicator.AnimatedVertexIndicator vi = (VertexIndicator.AnimatedVertexIndicator)positionMap.get(i2);
                vIndexList.add(vi.joint.get(j2));
                vIndexList.add(vi.weight.get(j2));
            }
        }
        int[] vIndices = vIndexList.stream().mapToInt(j -> j).toArray();
        vertices.add("positions", (JsonElement)AnimatedMesh.arrayToJsonObject(positions, 3));
        vertices.add("uvs", (JsonElement)AnimatedMesh.arrayToJsonObject(this.uvs, 2));
        vertices.add("normals", (JsonElement)AnimatedMesh.arrayToJsonObject(normals, 3));
        vertices.add("indices", (JsonElement)AnimatedMesh.arrayToJsonObject(indices, 3));
        vertices.add("vcounts", (JsonElement)AnimatedMesh.arrayToJsonObject(vcounts, 1));
        vertices.add("weights", (JsonElement)AnimatedMesh.arrayToJsonObject(this.weights, 1));
        vertices.add("vindices", (JsonElement)AnimatedMesh.arrayToJsonObject(vIndices, 1));
        root.add("vertices", (JsonElement)vertices);
        if (this.renderProperties != null) {
            JsonObject renderProperties = new JsonObject();
            renderProperties.addProperty("texture_path", this.renderProperties.getCustomTexturePath());
            renderProperties.addProperty("transparent", Boolean.valueOf(this.renderProperties.isTransparent()));
            root.add("render_properties", (JsonElement)renderProperties);
        }
        return root;
    }

    public static JsonObject arrayToJsonObject(float[] array, int stride) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("stride", (Number)stride);
        jsonObject.addProperty("count", (Number)(array.length / stride));
        JsonArray jsonArray = new JsonArray();
        for (float element : array) {
            jsonArray.add((Number)Float.valueOf(element));
        }
        jsonObject.add("array", (JsonElement)jsonArray);
        return jsonObject;
    }

    public static JsonObject arrayToJsonObject(int[] array, int stride) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("stride", (Number)stride);
        jsonObject.addProperty("count", (Number)(array.length / stride));
        JsonArray jsonArray = new JsonArray();
        for (int element : array) {
            jsonArray.add((Number)element);
        }
        jsonObject.add("array", (JsonElement)jsonArray);
        return jsonObject;
    }
}

