/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.procedural;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.procedural.IKInfo;
import yesman.epicfight.api.animation.types.procedural.ProceduralAnimation;
import yesman.epicfight.api.animation.types.procedural.TipPointAnimation;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.RenderingTool;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;

public class EnderDragonAttackAnimation
extends AttackAnimation
implements ProceduralAnimation {
    private final IKInfo[] ikInfos;
    private Map<String, TransformSheet> tipPointTransform;

    public EnderDragonAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, Collider collider, Joint colliderJoint, String path, Armature armature, IKInfo[] ikInfos) {
        super(convertTime, antic, preDelay, contact, recovery, collider, colliderJoint, path, armature);
        this.ikInfos = ikInfos;
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.RAW_COORD);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, null);
    }

    @Override
    public void loadAnimation(ResourceManager resourceManager) {
        EnderDragonAttackAnimation.loadBothSide(resourceManager, this);
        this.tipPointTransform = Maps.newHashMap();
        this.setIKInfo(this.ikInfos, this.getTransfroms(), this.tipPointTransform, this.getArmature(), false, true);
        this.onLoaded();
    }

    @Override
    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        Pose pose = super.getPoseByTime(entitypatch, time, partialTicks);
        if (entitypatch instanceof EnderDragonPatch) {
            EnderDragonPatch enderdragonpatch = (EnderDragonPatch)entitypatch;
            float x = (float)((LivingEntity)entitypatch.getOriginal()).m_20185_();
            float y = (float)((LivingEntity)entitypatch.getOriginal()).m_20186_();
            float z = (float)((LivingEntity)entitypatch.getOriginal()).m_20189_();
            float xo = (float)((LivingEntity)entitypatch.getOriginal()).f_19854_;
            float yo = (float)((LivingEntity)entitypatch.getOriginal()).f_19855_;
            float zo = (float)((LivingEntity)entitypatch.getOriginal()).f_19856_;
            OpenMatrix4f toModelPos = OpenMatrix4f.mul(OpenMatrix4f.translate(new Vec3f(xo + (x - xo) * partialTicks, yo + (y - yo) * partialTicks, zo + (z - zo) * partialTicks), new OpenMatrix4f(), null), entitypatch.getModelMatrix(partialTicks), null).invert();
            this.correctRootRotation(pose.getJointTransformData().get("Root"), enderdragonpatch, partialTicks);
            for (IKInfo ikInfo : this.ikInfos) {
                TipPointAnimation tipAnim = enderdragonpatch.getTipPointAnimation(ikInfo.endJoint.getName());
                JointTransform jt = tipAnim.getTipTransform(partialTicks);
                Vec3f jointModelpos = OpenMatrix4f.transform3v(toModelPos, jt.translation(), null);
                this.applyFabrikToJoint(jointModelpos.multiply(-1.0f, 1.0f, -1.0f), pose, entitypatch.getArmature(), ikInfo.startJoint, ikInfo.endJoint, jt.rotation());
            }
        }
        return pose;
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        MoveCoordFunctions.MoveCoordSetter actionAnimCoordSetter = this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN).orElse((self, entitypatch$2, transformSheet) -> transformSheet.readFrom(self.getTransfroms().get("Root")));
        actionAnimCoordSetter.set(this, entitypatch, entitypatch.getArmature().getActionAnimationCoord());
        if (entitypatch instanceof EnderDragonPatch) {
            EnderDragonPatch enderdragonpatch = (EnderDragonPatch)entitypatch;
            Vec3 entitypos = ((EnderDragon)enderdragonpatch.getOriginal()).m_20182_();
            OpenMatrix4f toWorld = OpenMatrix4f.mul(OpenMatrix4f.createTranslation((float)entitypos.f_82479_, (float)entitypos.f_82480_, (float)entitypos.f_82481_), enderdragonpatch.getModelMatrix(1.0f), null);
            enderdragonpatch.resetTipAnimations();
            for (IKInfo ikInfo : this.ikInfos) {
                TransformSheet tipAnim = this.getFirstPart(this.tipPointTransform.get(ikInfo.endJoint.getName()));
                Keyframe[] keyframes = tipAnim.getKeyframes();
                JointTransform firstposeTransform = keyframes[0].transform();
                firstposeTransform.translation().multiply(-1.0f, 1.0f, -1.0f);
                if (!ikInfo.clipAnimation || ikInfo.touchingGround[0]) {
                    Vec3f rayResultPosition = this.getRayCastedTipPosition(firstposeTransform.translation().add(0.0f, 2.5f, 0.0f), toWorld, enderdragonpatch, 8.0f, ikInfo.rayLeastHeight);
                    firstposeTransform.translation().set(rayResultPosition);
                } else {
                    firstposeTransform.translation().set(OpenMatrix4f.transform3v(toWorld, firstposeTransform.translation(), null));
                }
                for (Keyframe keyframe : keyframes) {
                    keyframe.transform().translation().set(firstposeTransform.translation());
                }
                enderdragonpatch.addTipPointAnimation(ikInfo.endJoint.getName(), firstposeTransform.translation(), tipAnim, ikInfo);
            }
        }
        if (entitypatch.isLogicalClient()) {
            entitypatch.getClientAnimator().resetMotion();
            entitypatch.getClientAnimator().resetCompositeMotion();
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (entitypatch instanceof EnderDragonPatch) {
            EnderDragonPatch enderdragonpatch = (EnderDragonPatch)entitypatch;
            Vec3 entitypos = ((EnderDragon)enderdragonpatch.getOriginal()).m_20182_();
            OpenMatrix4f toWorld = OpenMatrix4f.mul(OpenMatrix4f.createTranslation((float)entitypos.f_82479_, (float)entitypos.f_82480_, (float)entitypos.f_82481_), enderdragonpatch.getModelMatrix(1.0f), null);
            float elapsedTime = ((Animator)entitypatch.getAnimator()).getPlayerFor(this).getElapsedTime();
            for (IKInfo ikInfo : this.ikInfos) {
                Vec3f finalTargetpos;
                if (!ikInfo.clipAnimation) continue;
                Keyframe[] keyframes = this.getTransfroms().get(ikInfo.endJoint.getName()).getKeyframes();
                float startTime = keyframes[ikInfo.startFrame].time();
                float endTime = keyframes[ikInfo.endFrame - 1].time();
                if (!(startTime <= elapsedTime) || !(elapsedTime < endTime)) continue;
                TipPointAnimation tipAnim = enderdragonpatch.getTipPointAnimation(ikInfo.endJoint.getName());
                Vec3f clipStart = ikInfo.endpos.copy().add(0.0f, 2.5f, 0.0f).multiply(-1.0f, 1.0f, -1.0f);
                Vec3f vec3f = finalTargetpos = !ikInfo.clipAnimation || ikInfo.touchingGround[ikInfo.touchingGround.length - 1] ? this.getRayCastedTipPosition(clipStart, toWorld, enderdragonpatch, 8.0f, ikInfo.rayLeastHeight) : OpenMatrix4f.transform3v(toWorld, ikInfo.endpos.multiply(-1.0f, 1.0f, -1.0f), null);
                if (tipAnim.isOnWorking()) {
                    tipAnim.newTargetPosition(finalTargetpos);
                    continue;
                }
                this.startPartAnimation(ikInfo, tipAnim, this.clipAnimation(this.tipPointTransform.get(ikInfo.endJoint.getName()), ikInfo), finalTargetpos);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderDebugging(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, float playTime, float partialTicks) {
        super.renderDebugging(poseStack, buffer, entitypatch, playTime, partialTicks);
        if (entitypatch instanceof EnderDragonPatch) {
            EnderDragonPatch enderdragonpatch = (EnderDragonPatch)entitypatch;
            OpenMatrix4f modelmat = enderdragonpatch.getModelMatrix(partialTicks);
            LivingEntity originalEntity = (LivingEntity)entitypatch.getOriginal();
            Vec3 entitypos = originalEntity.m_20182_();
            float x = (float)entitypos.f_82479_;
            float y = (float)entitypos.f_82480_;
            float z = (float)entitypos.f_82481_;
            float xo = (float)originalEntity.f_19854_;
            float yo = (float)originalEntity.f_19855_;
            float zo = (float)originalEntity.f_19856_;
            OpenMatrix4f toModelPos = OpenMatrix4f.mul(OpenMatrix4f.createTranslation(xo + (x - xo) * partialTicks, yo + (y - yo) * partialTicks, zo + (z - zo) * partialTicks), modelmat, null).invert();
            for (IKInfo ikInfo : this.ikInfos) {
                VertexConsumer vertexBuilder = buffer.m_6299_(EpicFightRenderTypes.m_269166_());
                Vec3f worldtargetpos = enderdragonpatch.getTipPointAnimation(ikInfo.endJoint.getName()).getTargetPosition();
                Vec3f modeltargetpos = OpenMatrix4f.transform3v(toModelPos, worldtargetpos, null).multiply(-1.0f, 1.0f, -1.0f);
                RenderingTool.drawQuad(poseStack, vertexBuilder, modeltargetpos, 0.5f, 1.0f, 0.0f, 0.0f);
                Vec3f jointWorldPos = enderdragonpatch.getTipPointAnimation(ikInfo.endJoint.getName()).getTipPosition(partialTicks);
                Vec3f jointModelpos = OpenMatrix4f.transform3v(toModelPos, jointWorldPos, null).multiply(-1.0f, 1.0f, -1.0f);
                RenderingTool.drawQuad(poseStack, vertexBuilder, jointModelpos, 0.4f, 0.0f, 0.0f, 1.0f);
                Pose pose = new Pose();
                for (String jointName : this.jointTransforms.keySet()) {
                    pose.putJointData(jointName, ((TransformSheet)this.jointTransforms.get(jointName)).getInterpolatedTransform(playTime));
                }
            }
        }
    }
}

