/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.property;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.TimePairList;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.ExtraDamageInstance;
import yesman.epicfight.world.damagesource.StunType;

public abstract class AnimationProperty<T> {

    public static class AttackPhaseProperty<T>
    extends AnimationProperty<T> {
        public static final AttackPhaseProperty<ValueModifier> MAX_STRIKES_MODIFIER = new AttackPhaseProperty();
        public static final AttackPhaseProperty<ValueModifier> DAMAGE_MODIFIER = new AttackPhaseProperty();
        public static final AttackPhaseProperty<Set<ExtraDamageInstance>> EXTRA_DAMAGE = new AttackPhaseProperty();
        public static final AttackPhaseProperty<ValueModifier> ARMOR_NEGATION_MODIFIER = new AttackPhaseProperty();
        public static final AttackPhaseProperty<ValueModifier> IMPACT_MODIFIER = new AttackPhaseProperty();
        public static final AttackPhaseProperty<StunType> STUN_TYPE = new AttackPhaseProperty();
        public static final AttackPhaseProperty<SoundEvent> SWING_SOUND = new AttackPhaseProperty();
        public static final AttackPhaseProperty<SoundEvent> HIT_SOUND = new AttackPhaseProperty();
        public static final AttackPhaseProperty<RegistryObject<HitParticleType>> PARTICLE = new AttackPhaseProperty();
        public static final AttackPhaseProperty<HitEntityList.Priority> HIT_PRIORITY = new AttackPhaseProperty();
        public static final AttackPhaseProperty<Set<TagKey<DamageType>>> SOURCE_TAG = new AttackPhaseProperty();
        public static final AttackPhaseProperty<Function<LivingEntityPatch<?>, Vec3>> SOURCE_LOCATION_PROVIDER = new AttackPhaseProperty();
    }

    @FunctionalInterface
    public static interface PlaybackTimeModifier {
        public float modify(DynamicAnimation var1, LivingEntityPatch<?> var2, float var3, float var4);
    }

    @FunctionalInterface
    public static interface PoseModifier {
        public void modify(DynamicAnimation var1, Pose var2, LivingEntityPatch<?> var3, float var4, float var5);
    }

    @FunctionalInterface
    public static interface Registerer<T> {
        public void register(Map<AnimationProperty<T>, Object> var1, AnimationProperty<T> var2, T var3);
    }

    public static class AttackAnimationProperty<T>
    extends AnimationProperty<T> {
        public static final AttackAnimationProperty<Boolean> FIXED_MOVE_DISTANCE = new AttackAnimationProperty();
        public static final AttackAnimationProperty<Float> ATTACK_SPEED_FACTOR = new AttackAnimationProperty();
        public static final AttackAnimationProperty<Float> BASIS_ATTACK_SPEED = new AttackAnimationProperty();
        public static final AttackAnimationProperty<Integer> EXTRA_COLLIDERS = new AttackAnimationProperty();
    }

    public static class ActionAnimationProperty<T>
    extends AnimationProperty<T> {
        public static final ActionAnimationProperty<Boolean> STOP_MOVEMENT = new ActionAnimationProperty();
        public static final ActionAnimationProperty<Boolean> MOVE_VERTICAL = new ActionAnimationProperty();
        public static final ActionAnimationProperty<TimePairList> NO_GRAVITY_TIME = new ActionAnimationProperty();
        public static final ActionAnimationProperty<TransformSheet> COORD = new ActionAnimationProperty();
        public static final ActionAnimationProperty<Boolean> MOVE_ON_LINK = new ActionAnimationProperty();
        public static final ActionAnimationProperty<TimePairList> MOVE_TIME = new ActionAnimationProperty();
        public static final ActionAnimationProperty<MoveCoordFunctions.MoveCoordSetter> COORD_SET_BEGIN = new ActionAnimationProperty();
        public static final ActionAnimationProperty<MoveCoordFunctions.MoveCoordSetter> COORD_SET_TICK = new ActionAnimationProperty();
        public static final ActionAnimationProperty<MoveCoordFunctions.MoveCoordGetter> COORD_GET = new ActionAnimationProperty();
        public static final ActionAnimationProperty<Boolean> AFFECT_SPEED = new ActionAnimationProperty();
        public static final ActionAnimationProperty<Boolean> CANCELABLE_MOVE = new ActionAnimationProperty();
        public static final ActionAnimationProperty<Boolean> IS_DEATH_ANIMATION = new ActionAnimationProperty();
        public static final ActionAnimationProperty<TimePairList> COORD_UPDATE_TIME = new ActionAnimationProperty();
        public static final ActionAnimationProperty<Boolean> RESET_PLAYER_COMBO_COUNTER = new ActionAnimationProperty();
    }

    public static class StaticAnimationProperty<T>
    extends AnimationProperty<T> {
        public static final StaticAnimationProperty<AnimationEvent[]> EVENTS = new StaticAnimationProperty();
        public static final StaticAnimationProperty<AnimationEvent.TimeStampedEvent[]> TIME_STAMPED_EVENTS = new StaticAnimationProperty();
        public static final StaticAnimationProperty<AnimationEvent.TimePeriodEvent[]> TIME_PERIOD_EVENTS = new StaticAnimationProperty();
        public static final StaticAnimationProperty<AnimationEvent[]> ON_BEGIN_EVENTS = new StaticAnimationProperty();
        public static final StaticAnimationProperty<AnimationEvent[]> ON_END_EVENTS = new StaticAnimationProperty();
        public static final StaticAnimationProperty<PlaybackTimeModifier> PLAY_SPEED_MODIFIER = new StaticAnimationProperty();
        public static final StaticAnimationProperty<PlaybackTimeModifier> ELAPSED_TIME_MODIFIER = new StaticAnimationProperty();
        public static final StaticAnimationProperty<PoseModifier> POSE_MODIFIER = new StaticAnimationProperty();
    }
}

