/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class SkyblockChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<SkyblockChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(gen -> gen.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(NoiseBasedChunkGenerator::m_224341_)).apply((Applicative)instance, instance.stable(SkyblockChunkGenerator::new)));

    public static void submitRegistration(BiConsumer<Codec<? extends ChunkGenerator>, ResourceLocation> consumer) {
        consumer.accept(CODEC, ResourceLocationHelper.prefix("skyblock"));
    }

    public static boolean isWorldSkyblock(Level world) {
        ServerChunkCache chunkCache;
        ChunkSource chunkSource = world.m_7726_();
        return chunkSource instanceof ServerChunkCache && (chunkCache = (ServerChunkCache)chunkSource).m_8481_() instanceof SkyblockChunkGenerator;
    }

    private SkyblockChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        super(biomeSource, settings);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public int m_214096_(int x, int z, Heightmap.Types heightmapTypes, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        return levelHeightAccessor.m_141937_();
    }

    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        return new NoiseColumn(levelHeightAccessor.m_141937_(), new BlockState[0]);
    }

    public void m_224261_(ChunkAccess chunkAccess, WorldGenerationContext context, RandomState randomState, StructureManager structureManager, BiomeManager biomeManager, Registry<Biome> biomes, Blender blender) {
    }

    public void m_213679_(WorldGenRegion worldGenRegion, long seed, RandomState randomState, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public void m_6929_(WorldGenRegion region) {
    }

    public void m_213609_(WorldGenLevel level, ChunkAccess chunkAccess, StructureManager structureManager) {
    }
}

