/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.mixin.MushroomCowAccessor;

public class PollidisiacBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 6;
    private static final int MANA_COST = 12;

    public PollidisiacBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.POLLIDISIAC, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.m_58904_().f_46443_ && this.getMana() >= 12) {
            AABB pickupBounds = new AABB(this.m_58899_()).m_82400_(6.0);
            List items = this.m_58904_().m_6443_(ItemEntity.class, pickupBounds, itemEntity -> DelayHelper.canInteractWith(this, itemEntity));
            if (items.isEmpty()) {
                return;
            }
            AABB bounds = new AABB(this.getEffectivePos()).m_82400_(6.0);
            List animals = this.m_58904_().m_6443_(Animal.class, bounds, Predicate.not(AgeableMob::m_6162_));
            Collections.shuffle(animals);
            for (Animal animal : animals) {
                if (!animal.m_27593_()) {
                    for (ItemEntity item : items) {
                        if (!animal.m_6898_(item.m_32055_())) continue;
                        this.consumeFoodItem(item);
                        animal.m_27601_(1200);
                        this.m_58904_().m_7605_((Entity)animal, (byte)18);
                        break;
                    }
                    if (this.getMana() < 12) break;
                }
                if (!PollidisiacBlockEntity.isBrownMooshroomWithoutEffect(animal)) continue;
                for (ItemEntity item : items) {
                    SuspiciousEffectHolder effect;
                    ItemStack stack = item.m_32055_();
                    if (!stack.m_204117_(ItemTags.f_13145_) || (effect = SuspiciousEffectHolder.m_257980_((ItemLike)stack.m_41720_())) == null) continue;
                    this.consumeFoodItem(item);
                    MushroomCowAccessor cowAccessor = (MushroomCowAccessor)animal;
                    cowAccessor.setEffect(effect.m_53521_());
                    cowAccessor.setEffectDuration(effect.m_53522_());
                    animal.m_5496_(SoundEvents.f_12072_, 2.0f, 1.0f);
                    break;
                }
                if (this.getMana() >= 12) continue;
                break;
            }
        }
    }

    private void consumeFoodItem(ItemEntity itemEntity) {
        EntityHelper.shrinkItem(itemEntity);
        this.addMana(-12);
    }

    private static boolean isBrownMooshroomWithoutEffect(Animal animal) {
        MushroomCow mushroomCow;
        if (animal instanceof MushroomCow && (mushroomCow = (MushroomCow)animal).m_28554_() == MushroomCow.MushroomType.BROWN) {
            MushroomCowAccessor cowAccessor = (MushroomCowAccessor)animal;
            return cowAccessor.getEffect() == null;
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 6);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return this.m_58899_().equals((Object)this.getEffectivePos()) ? null : RadiusDescriptor.Rectangle.square(this.m_58899_(), 6);
    }

    @Override
    public int getMaxMana() {
        return 120;
    }

    @Override
    public int getColor() {
        return 13584665;
    }
}

