/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.block_entity.FloatingFlowerBlockEntityRenderer;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;

public class SpecialFlowerBlockEntityRenderer<T extends SpecialFlowerBlockEntity>
implements BlockEntityRenderer<T> {
    public SpecialFlowerBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(SpecialFlowerBlockEntity tile, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        boolean hasBindingAttempt;
        Entity entity;
        if (tile.isFloating()) {
            FloatingFlowerBlockEntityRenderer.renderFloatingIsland(tile, partialTicks, ms, buffers, overlay);
        }
        if (!((entity = Minecraft.m_91087_().f_91075_) instanceof LivingEntity)) {
            return;
        }
        LivingEntity view = (LivingEntity)entity;
        if (!ManaseerMonocleItem.hasMonocle(view)) {
            return;
        }
        BlockPos pos = null;
        HitResult ray = Minecraft.m_91087_().f_91077_;
        if (ray != null && ray.m_6662_() == HitResult.Type.BLOCK) {
            pos = ((BlockHitResult)ray).m_82425_();
        }
        if ((hasBindingAttempt = SpecialFlowerBlockEntityRenderer.hasBindingAttempt(view, tile.m_58899_())) || tile.m_58899_().equals((Object)pos)) {
            SpecialFlowerBlockEntity flower = tile;
            ms.m_85836_();
            if (hasBindingAttempt) {
                ms.m_85837_(0.0, 0.005, 0.0);
            }
            SpecialFlowerBlockEntityRenderer.renderRadius(tile, ms, buffers, flower.getRadius());
            ms.m_85837_(0.0, 0.002, 0.0);
            SpecialFlowerBlockEntityRenderer.renderRadius(tile, ms, buffers, flower.getSecondaryRadius());
            ms.m_85849_();
        }
    }

    public static void renderRadius(BlockEntity tile, PoseStack ms, MultiBufferSource buffers, @Nullable RadiusDescriptor descriptor) {
        if (descriptor != null) {
            ms.m_85836_();
            ms.m_252880_((float)(-tile.m_58899_().m_123341_()), (float)(-tile.m_58899_().m_123342_()), (float)(-tile.m_58899_().m_123343_()));
            if (descriptor instanceof RadiusDescriptor.Circle) {
                RadiusDescriptor.Circle circle = (RadiusDescriptor.Circle)descriptor;
                SpecialFlowerBlockEntityRenderer.renderCircle(ms, buffers, circle.subtileCoords(), circle.radius());
            } else if (descriptor instanceof RadiusDescriptor.Rectangle) {
                RadiusDescriptor.Rectangle rectangle = (RadiusDescriptor.Rectangle)descriptor;
                SpecialFlowerBlockEntityRenderer.renderRectangle(ms, buffers, rectangle.aabb(), true, null, (byte)32);
            }
            ms.m_85849_();
        }
    }

    public static boolean hasBindingAttempt(LivingEntity view, BlockPos tilePos) {
        ItemStack stackHeld = PlayerHelper.getFirstHeldItemClass(view, WandOfTheForestItem.class);
        if (!stackHeld.m_41619_() && WandOfTheForestItem.getBindMode(stackHeld)) {
            return WandOfTheForestItem.getBindingAttempt(stackHeld).filter(arg_0 -> ((BlockPos)tilePos).equals(arg_0)).isPresent();
        }
        return false;
    }

    private static void renderCircle(PoseStack ms, MultiBufferSource buffers, BlockPos center, double radius) {
        ms.m_85836_();
        double x = (double)center.m_123341_() + 0.5;
        double y = center.m_123342_();
        double z = (double)center.m_123343_() + 0.5;
        ms.m_85837_(x, y, z);
        int color = Mth.m_14169_((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int alpha = 32;
        float f = 0.0625f;
        int totalAngles = 360;
        int drawAngles = 360;
        int step = totalAngles / drawAngles;
        radius -= (double)f;
        VertexConsumer buffer = buffers.m_6299_(RenderHelper.CIRCLE);
        Matrix4f mat = ms.m_85850_().m_252922_();
        Runnable centerFunc = () -> buffer.m_252986_(mat, 0.0f, f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
        ArrayList<Runnable> vertexFuncs = new ArrayList<Runnable>();
        for (int i = 0; i < totalAngles + 1; i += step) {
            double rad = (double)(totalAngles - i) * Math.PI / 180.0;
            float xp = (float)(Math.cos(rad) * radius);
            float zp = (float)(Math.sin(rad) * radius);
            vertexFuncs.add(() -> buffer.m_252986_(mat, xp, f, zp).m_6122_(r, g, b, alpha).m_5752_());
        }
        RenderHelper.triangleFan(centerFunc, vertexFuncs);
        radius += (double)f;
        float f1 = f + f / 4.0f;
        int alpha2 = 64;
        centerFunc = () -> buffer.m_252986_(mat, 0.0f, f1, 0.0f).m_6122_(r, g, b, alpha2).m_5752_();
        vertexFuncs.clear();
        for (int i = 0; i < totalAngles + 1; i += step) {
            double rad = (double)(totalAngles - i) * Math.PI / 180.0;
            float xp = (float)(Math.cos(rad) * radius);
            float zp = (float)(Math.sin(rad) * radius);
            vertexFuncs.add(() -> buffer.m_252986_(mat, xp, f1, zp).m_6122_(r, g, b, alpha2).m_5752_());
        }
        RenderHelper.triangleFan(centerFunc, vertexFuncs);
        ms.m_85849_();
    }

    public static void renderRectangle(PoseStack ms, MultiBufferSource buffers, AABB aabb, boolean inner, @Nullable Integer color, byte alpha) {
        ms.m_85836_();
        ms.m_85837_(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_);
        if (color == null) {
            color = Mth.m_14169_((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float f = 0.0625f;
        float x = (float)(aabb.f_82291_ - aabb.f_82288_ - (double)f);
        float z = (float)(aabb.f_82293_ - aabb.f_82290_ - (double)f);
        VertexConsumer buffer = buffers.m_6299_(RenderHelper.RECTANGLE);
        Matrix4f mat = ms.m_85850_().m_252922_();
        buffer.m_252986_(mat, x, f, f).m_6122_(r, g, b, (int)alpha).m_5752_();
        buffer.m_252986_(mat, f, f, f).m_6122_(r, g, b, (int)alpha).m_5752_();
        buffer.m_252986_(mat, f, f, z).m_6122_(r, g, b, (int)alpha).m_5752_();
        buffer.m_252986_(mat, x, f, z).m_6122_(r, g, b, (int)alpha).m_5752_();
        if (inner) {
            float f1 = f + f / 4.0f;
            alpha = (byte)(alpha * 2);
            buffer.m_252986_(mat, x += f, f1, 0.0f).m_6122_(r, g, b, (int)alpha).m_5752_();
            buffer.m_252986_(mat, 0.0f, f1, 0.0f).m_6122_(r, g, b, (int)alpha).m_5752_();
            buffer.m_252986_(mat, 0.0f, f1, z += f).m_6122_(r, g, b, (int)alpha).m_5752_();
            buffer.m_252986_(mat, x, f1, z).m_6122_(r, g, b, (int)alpha).m_5752_();
        }
        ms.m_85849_();
    }
}

