/*
 * Decompiled with CFR 0.152.
 */
package optifine;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import optifine.AccessFixer;
import optifine.HashUtils;
import optifine.IOptiFineResourceLocator;
import optifine.IResourceProvider;
import optifine.Patcher;
import optifine.Utils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class OptiFineTransformer
implements ITransformer<ClassNode>,
IResourceProvider,
IOptiFineResourceLocator {
    private static final Logger LOGGER = LogManager.getLogger();
    private ZipFile ofZipFile;
    private Map<String, String> patchMap = null;
    private Pattern[] patterns = null;
    public static final String PREFIX_SRG = "srg/";
    public static final String SUFFIX_CLASS = ".class";
    public static final String PREFIX_PATCH_SRG = "patch/srg/";
    public static final String SUFFIX_CLASS_XDELTA = ".class.xdelta";
    public static final String PREFIX_OPTIFINE = "optifine/";
    private final boolean hasTargetPreClass;

    public OptiFineTransformer(ZipFile ofZipFile, IEnvironment env2) {
        this.ofZipFile = ofZipFile;
        this.hasTargetPreClass = OptiFineTransformer.hasTargetPreClass(env2);
        if (this.hasTargetPreClass) {
            LOGGER.info("Target.PRE_CLASS is available");
        } else {
            LOGGER.info("Target.PRE_CLASS is not available");
        }
        try {
            this.patchMap = Patcher.getConfigurationMap(ofZipFile);
            this.patterns = Patcher.getConfigurationPatterns(this.patchMap);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public TransformerVoteResult castVote(ITransformerVotingContext context) {
        return TransformerVoteResult.YES;
    }

    public Set<ITransformer.Target> targets() {
        HashSet<ITransformer.Target> set = new HashSet<ITransformer.Target>();
        Object[] names = this.getResourceNames(PREFIX_SRG, SUFFIX_CLASS);
        Object[] namesPatch = this.getResourceNames(PREFIX_PATCH_SRG, SUFFIX_CLASS_XDELTA);
        names = (String[])Utils.addObjectsToArray(names, namesPatch);
        int i2 = 0;
        while (i2 < names.length) {
            Object name = names[i2];
            name = Utils.removePrefix((String)name, new String[]{PREFIX_SRG, PREFIX_PATCH_SRG});
            if (!((String)(name = Utils.removeSuffix((String)name, new String[]{SUFFIX_CLASS, SUFFIX_CLASS_XDELTA}))).startsWith("net/optifine/")) {
                ITransformer.Target itt = this.getTargetClass((String)name);
                set.add(itt);
            }
            ++i2;
        }
        LOGGER.info("Targets: " + set.size());
        return set;
    }

    private ITransformer.Target getTargetClass(String name) {
        if (this.hasTargetPreClass) {
            return this.getTargetPreClass(name);
        }
        return ITransformer.Target.targetClass((String)name);
    }

    private ITransformer.Target getTargetPreClass(String name) {
        return ITransformer.Target.targetPreClass((String)name);
    }

    private static boolean hasTargetPreClass(IEnvironment env2) {
        Optional mlVer = env2.getProperty((TypesafeMap.Key)IEnvironment.Keys.MLSPEC_VERSION.get());
        if (!mlVer.isPresent()) {
            return false;
        }
        String[] parts = Utils.tokenize((String)mlVer.get(), ".");
        if (parts.length <= 0) {
            return false;
        }
        String majorStr = parts[0];
        int major = Utils.parseInt(majorStr, -1);
        return major >= 7;
    }

    public ClassNode transform(ClassNode input, ITransformerVotingContext context) {
        ByteArrayInputStream in2;
        ClassNode classNodeNew;
        ClassNode classNode = input;
        String className = context.getClassName();
        String classNameZip = className.replace('.', '/');
        byte[] bytes = this.getOptiFineResource(PREFIX_SRG + classNameZip + SUFFIX_CLASS);
        if (bytes != null && (classNodeNew = this.loadClass(in2 = new ByteArrayInputStream(bytes))) != null) {
            this.debugClass(classNodeNew);
            AccessFixer.fixMemberAccess(classNode, classNodeNew);
            classNode = classNodeNew;
        }
        return classNode;
    }

    private void debugClass(ClassNode classNode) {
    }

    private ClassNode loadClass(InputStream in2) {
        try {
            ClassReader cr = new ClassReader(in2);
            ClassNode cn = new ClassNode(393216);
            cr.accept((ClassVisitor)cn, 0);
            return cn;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private String[] getResourceNames(String prefix, String suffix) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<? extends ZipEntry> entries = this.ofZipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = zipEntry.getName();
            if (!name.startsWith(prefix) || !name.endsWith(suffix)) continue;
            list.add(name);
        }
        String[] names = list.toArray(new String[list.size()]);
        return names;
    }

    private byte[] getOptiFineResource(String name) {
        InputStream in2;
        block3: {
            try {
                in2 = this.getOptiFineResourceStream(name);
                if (in2 != null) break block3;
                return null;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return null;
            }
        }
        byte[] bytes = Utils.readAll(in2);
        in2.close();
        return bytes;
    }

    @Override
    public synchronized InputStream getOptiFineResourceStream(String name) {
        InputStream in2 = this.getOptiFineResourceStreamZip(name = Utils.removePrefix(name, "/"));
        if (in2 != null) {
            return in2;
        }
        in2 = this.getOptiFineResourceStreamPatched(name);
        if (in2 != null) {
            return in2;
        }
        return null;
    }

    @Override
    public InputStream getResourceStream(String path) {
        path = Utils.removePrefix(path, "/");
        return ClassLoader.getSystemClassLoader().getResourceAsStream(path);
    }

    public synchronized InputStream getOptiFineResourceStreamZip(String name) {
        if (this.ofZipFile == null) {
            return null;
        }
        ZipEntry ze = this.ofZipFile.getEntry(name = Utils.removePrefix(name, "/"));
        if (ze == null) {
            return null;
        }
        try {
            InputStream in2 = this.ofZipFile.getInputStream(ze);
            return in2;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public synchronized byte[] getOptiFineResourceZip(String name) {
        InputStream in2 = this.getOptiFineResourceStreamZip(name);
        if (in2 == null) {
            return null;
        }
        try {
            byte[] bytes = Utils.readAll(in2);
            return bytes;
        }
        catch (IOException e2) {
            return null;
        }
    }

    public synchronized InputStream getOptiFineResourceStreamPatched(String name) {
        byte[] bytes = this.getOptiFineResourcePatched(name);
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public synchronized byte[] getOptiFineResourcePatched(String name) {
        if (this.patterns == null || this.patchMap == null) {
            return null;
        }
        String patchName = "patch/" + (name = Utils.removePrefix(name, "/")) + ".xdelta";
        byte[] bytes = this.getOptiFineResourceZip(patchName);
        if (bytes == null) {
            return null;
        }
        try {
            byte[] md5Mod;
            String md5ModStr;
            String md5Str;
            byte[] bytesPatched = Patcher.applyPatch(name, bytes, this.patterns, this.patchMap, this);
            String fullMd5Name = "patch/" + name + ".md5";
            byte[] bytesMd5 = this.getOptiFineResourceZip(fullMd5Name);
            if (bytesMd5 != null && !(md5Str = new String(bytesMd5, "ASCII")).equals(md5ModStr = HashUtils.toHexString(md5Mod = HashUtils.getHashMd5(bytesPatched)))) {
                throw new IOException("MD5 not matching, name: " + name + ", saved: " + md5Str + ", patched: " + md5ModStr);
            }
            return bytesPatched;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }
}

