/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.optifine.Config;
import net.optifine.util.GpuMemory;
import net.optifine.util.MathUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TimedEvent;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

/*
 * Exception performing whole class analysis ignored.
 */
public class DebugUtils {
    private static FloatBuffer floatBuffer16 = BufferUtils.createFloatBuffer((int)16);
    private static float[] floatArray16 = new float[16];

    public static String getGlModelView() {
        floatBuffer16.clear();
        GL11.glGetFloatv((int)2982, (FloatBuffer)floatBuffer16);
        floatBuffer16.get(floatArray16);
        float[] floatArray16T = DebugUtils.transposeMat4((float[])floatArray16);
        return DebugUtils.getMatrix4((float[])floatArray16T);
    }

    public static String getGlProjection() {
        floatBuffer16.clear();
        GL11.glGetFloatv((int)2983, (FloatBuffer)floatBuffer16);
        floatBuffer16.get(floatArray16);
        float[] floatArray16T = DebugUtils.transposeMat4((float[])floatArray16);
        return DebugUtils.getMatrix4((float[])floatArray16T);
    }

    private static float[] transposeMat4(float[] arr) {
        float[] arrT = new float[16];
        for (int x2 = 0; x2 < 4; ++x2) {
            for (int y2 = 0; y2 < 4; ++y2) {
                arrT[x2 * 4 + y2] = arr[y2 * 4 + x2];
            }
        }
        return arrT;
    }

    public static String getMatrix4(Matrix4f mat) {
        MathUtils.write((Matrix4f)mat, (float[])floatArray16);
        return DebugUtils.getMatrix4((float[])floatArray16);
    }

    private static String getMatrix4(float[] fs) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < fs.length; ++i2) {
            String str = String.format("%.2f", Float.valueOf(fs[i2]));
            if (i2 > 0) {
                if (i2 % 4 == 0) {
                    sb.append("\n");
                } else {
                    sb.append(", ");
                }
            }
            str = StrUtils.fillLeft((String)str, (int)5, (char)' ');
            sb.append(str);
        }
        return sb.toString();
    }

    public static void debugVboMemory(fmp.c[] renderChunks) {
        if (!TimedEvent.isActive((String)"DbgVbos", (long)3000L)) {
            return;
        }
        int sum = 0;
        int countChunks = 0;
        int countVbos = 0;
        int countLayers = 0;
        for (int i2 = 0; i2 < renderChunks.length; ++i2) {
            fmp.c renderChunk = renderChunks[i2];
            int sumPre = sum;
            for (fkf rt : fmp.BLOCK_RENDER_LAYERS) {
                eim vb = renderChunk.a(rt);
                if (vb.getIndexCount() > 0) {
                    sum += vb.getIndexCount() * vb.d().b();
                    ++countVbos;
                }
                if (!renderChunk.d().isLayerUsed(rt)) continue;
                ++countLayers;
            }
            if (sum <= sumPre) continue;
            ++countChunks;
        }
        Config.dbg((String)("VRAM: " + sum / 0x100000 + " MB, vbos: " + countVbos + ", layers: " + countLayers + ", chunks: " + countChunks));
        Config.dbg((String)("VBOs: " + GpuMemory.getBufferAllocated() / 0x100000L + " MB"));
    }

    public static void debugTextures() {
        Config.dbg((String)" *** TEXTURES ***");
        fuw textureManager = enn.N().X();
        long sum = 0L;
        Collection locations = textureManager.getTextureLocations();
        ArrayList list = new ArrayList(locations);
        Collections.sort(list);
        for (acq loc : list) {
            fug texture = textureManager.b(loc);
            long size = GpuMemory.getTextureSize((fug)texture);
            if (Config.isShaders()) {
                size *= 3L;
            }
            Config.dbg((String)(loc + " = " + size));
            sum += size;
        }
        Config.dbg((String)("All: " + sum));
    }
}

