/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

public class CacheLocal {
    private int maxX = 18;
    private int maxY = 128;
    private int maxZ = 18;
    private int offsetX = 0;
    private int offsetY = 0;
    private int offsetZ = 0;
    private int[][][] cache = null;
    private int[] lastZs = null;
    private int lastDz = 0;

    public CacheLocal(int maxX, int maxY, int maxZ) {
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.cache = new int[maxX][maxY][maxZ];
        this.resetCache();
    }

    public void resetCache() {
        for (int x2 = 0; x2 < this.maxX; ++x2) {
            int[][] ys = this.cache[x2];
            for (int y2 = 0; y2 < this.maxY; ++y2) {
                int[] zs = ys[y2];
                for (int z2 = 0; z2 < this.maxZ; ++z2) {
                    zs[z2] = -1;
                }
            }
        }
    }

    public void setOffset(int x2, int y2, int z2) {
        this.offsetX = x2;
        this.offsetY = y2;
        this.offsetZ = z2;
        this.resetCache();
    }

    public int get(int x2, int y2, int z2) {
        try {
            this.lastZs = this.cache[x2 - this.offsetX][y2 - this.offsetY];
            this.lastDz = z2 - this.offsetZ;
            return this.lastZs[this.lastDz];
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            e2.printStackTrace();
            return -1;
        }
    }

    public void setLast(int val) {
        try {
            this.lastZs[this.lastDz] = val;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

