/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.optifine.shaders.DrawBuffers;
import net.optifine.shaders.FixedFramebuffer;
import net.optifine.shaders.FlipTextures;
import net.optifine.shaders.GlState;
import net.optifine.shaders.SMCLog;
import net.optifine.shaders.Shaders;
import net.optifine.util.ArrayUtils;
import net.optifine.util.CompoundIntKey;
import net.optifine.util.CompoundKey;
import net.optifine.util.DynamicDimension;
import org.joml.Vector4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class ShadersFramebuffer {
    private String name;
    private int width;
    private int height;
    private int usedColorBuffers;
    private int usedDepthBuffers;
    private int maxDrawBuffers;
    private boolean[] depthFilterNearest;
    private boolean[] depthFilterHardware;
    private boolean[] colorFilterNearest;
    private DynamicDimension[] colorBufferSizes;
    private int[] buffersFormat;
    private int[] colorTextureUnits;
    private int[] depthTextureUnits;
    private int[] colorImageUnits;
    private int glFramebuffer;
    private FlipTextures colorTexturesFlip;
    private IntBuffer depthTextures;
    private final DrawBuffers drawBuffers;
    private DrawBuffers activeDrawBuffers;
    private int[] drawColorTextures;
    private int[] drawColorTexturesMap;
    private boolean[] dirtyColorTextures;
    private Map<CompoundKey, FixedFramebuffer> fixedFramebuffers = new HashMap();

    public ShadersFramebuffer(String name, int width, int height, int usedColorBuffers, int usedDepthBuffers, int maxDrawBuffers, boolean[] depthFilterNearest, boolean[] depthFilterHardware, boolean[] colorFilterNearest, DynamicDimension[] colorBufferSizes, int[] buffersFormat, int[] colorTextureUnits, int[] depthTextureUnits, int[] colorImageUnits, DrawBuffers drawBuffers) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.usedColorBuffers = usedColorBuffers;
        this.usedDepthBuffers = usedDepthBuffers;
        this.maxDrawBuffers = maxDrawBuffers;
        this.depthFilterNearest = depthFilterNearest;
        this.depthFilterHardware = depthFilterHardware;
        this.colorFilterNearest = colorFilterNearest;
        this.colorBufferSizes = colorBufferSizes;
        this.buffersFormat = buffersFormat;
        this.colorTextureUnits = colorTextureUnits;
        this.depthTextureUnits = depthTextureUnits;
        this.colorImageUnits = colorImageUnits;
        this.drawBuffers = drawBuffers;
    }

    public void setup() {
        int status;
        Dimension dim2;
        int filter;
        int i2;
        if (this.exists()) {
            this.delete();
        }
        this.colorTexturesFlip = new FlipTextures(this.name + "ColorTexturesFlip", this.usedColorBuffers);
        this.depthTextures = BufferUtils.createIntBuffer((int)this.usedDepthBuffers);
        this.drawColorTextures = new int[this.usedColorBuffers];
        this.drawColorTexturesMap = new int[this.usedColorBuffers];
        this.dirtyColorTextures = new boolean[this.maxDrawBuffers];
        Arrays.fill(this.drawColorTextures, 0);
        Arrays.fill(this.drawColorTexturesMap, -1);
        Arrays.fill(this.dirtyColorTextures, false);
        for (i2 = 0; i2 < this.drawBuffers.limit(); ++i2) {
            this.drawBuffers.put(i2, 36064 + i2);
        }
        this.glFramebuffer = GL30.glGenFramebuffers();
        this.bindFramebuffer();
        GL30.glDrawBuffers((int)0);
        GL30.glReadBuffer((int)0);
        GL30.glGenTextures((IntBuffer)this.depthTextures.clear().limit(this.usedDepthBuffers));
        this.colorTexturesFlip.clear().limit(this.usedColorBuffers).genTextures();
        this.depthTextures.position(0);
        this.colorTexturesFlip.position(0);
        for (i2 = 0; i2 < this.usedDepthBuffers; ++i2) {
            GlStateManager._bindTexture((int)this.depthTextures.get(i2));
            GL30.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL30.glTexParameteri((int)3553, (int)10243, (int)33071);
            filter = this.depthFilterNearest[i2] ? 9728 : 9729;
            GL30.glTexParameteri((int)3553, (int)10241, (int)filter);
            GL30.glTexParameteri((int)3553, (int)10240, (int)filter);
            if (this.depthFilterHardware[i2]) {
                GL30.glTexParameteri((int)3553, (int)34892, (int)34894);
            }
            GL30.glTexImage2D((int)3553, (int)0, (int)6402, (int)this.width, (int)this.height, (int)0, (int)6402, (int)5126, (FloatBuffer)null);
        }
        this.setFramebufferTexture2D(36160, 36096, 3553, this.depthTextures.get(0), 0);
        Shaders.checkGLError((String)("FBS " + this.name + " depth"));
        for (i2 = 0; i2 < this.usedColorBuffers; ++i2) {
            GlStateManager._bindTexture((int)this.colorTexturesFlip.getA(i2));
            GL30.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL30.glTexParameteri((int)3553, (int)10243, (int)33071);
            filter = this.colorFilterNearest[i2] ? 9728 : 9729;
            GL30.glTexParameteri((int)3553, (int)10241, (int)filter);
            GL30.glTexParameteri((int)3553, (int)10240, (int)filter);
            dim2 = this.colorBufferSizes[i2] != null ? this.colorBufferSizes[i2].getDimension(this.width, this.height) : new Dimension(this.width, this.height);
            GL30.glTexImage2D((int)3553, (int)0, (int)this.buffersFormat[i2], (int)dim2.width, (int)dim2.height, (int)0, (int)Shaders.getPixelFormat((int)this.buffersFormat[i2]), (int)33639, (ByteBuffer)null);
            this.setFramebufferTexture2D(36160, 36064 + i2, 3553, this.colorTexturesFlip.getA(i2), 0);
            Shaders.checkGLError((String)("FBS " + this.name + " colorA"));
        }
        for (i2 = 0; i2 < this.usedColorBuffers; ++i2) {
            GlStateManager._bindTexture((int)this.colorTexturesFlip.getB(i2));
            GL30.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL30.glTexParameteri((int)3553, (int)10243, (int)33071);
            filter = this.colorFilterNearest[i2] ? 9728 : 9729;
            GL30.glTexParameteri((int)3553, (int)10241, (int)filter);
            GL30.glTexParameteri((int)3553, (int)10240, (int)filter);
            dim2 = this.colorBufferSizes[i2] != null ? this.colorBufferSizes[i2].getDimension(this.width, this.height) : new Dimension(this.width, this.height);
            GL30.glTexImage2D((int)3553, (int)0, (int)this.buffersFormat[i2], (int)dim2.width, (int)dim2.height, (int)0, (int)Shaders.getPixelFormat((int)this.buffersFormat[i2]), (int)33639, (ByteBuffer)null);
            Shaders.checkGLError((String)("FBS " + this.name + " colorB"));
        }
        GlStateManager._bindTexture((int)0);
        if (this.usedColorBuffers > 0) {
            this.setDrawBuffers(this.drawBuffers);
            GL30.glReadBuffer((int)0);
        }
        if ((status = GL30.glCheckFramebufferStatus((int)36160)) != 36053) {
            Shaders.printChatAndLogError((String)("[Shaders] Error creating framebuffer: " + this.name + ", status: " + status));
            return;
        }
        SMCLog.info((String)("Framebuffer created: " + this.name));
    }

    public void delete() {
        if (this.glFramebuffer != 0) {
            GL30.glDeleteFramebuffers((int)this.glFramebuffer);
            this.glFramebuffer = 0;
        }
        if (this.colorTexturesFlip != null) {
            this.colorTexturesFlip.deleteTextures();
            this.colorTexturesFlip = null;
        }
        if (this.depthTextures != null) {
            GlStateManager.deleteTextures((IntBuffer)this.depthTextures);
            this.depthTextures = null;
        }
        this.drawBuffers.position(0).fill(0);
        for (FixedFramebuffer ff : this.fixedFramebuffers.values()) {
            ff.delete();
        }
        this.fixedFramebuffers.clear();
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getGlFramebuffer() {
        return this.glFramebuffer;
    }

    public boolean exists() {
        return this.glFramebuffer != 0;
    }

    public void bindFramebuffer() {
        GlState.bindFramebuffer((ShadersFramebuffer)this);
    }

    public void setColorTextures(boolean main) {
        for (int i2 = 0; i2 < this.usedColorBuffers; ++i2) {
            this.setFramebufferTexture2D(36160, 36064 + i2, 3553, this.colorTexturesFlip.get(main, i2), 0);
        }
    }

    public void setDepthTexture() {
        this.setFramebufferTexture2D(36160, 36096, 3553, this.depthTextures.get(0), 0);
    }

    public void setColorBuffersFiltering(int minFilter, int magFilter) {
        GlStateManager._activeTexture((int)33984);
        for (int i2 = 0; i2 < this.usedColorBuffers; ++i2) {
            GlStateManager._bindTexture((int)this.colorTexturesFlip.getA(i2));
            GL11.glTexParameteri((int)3553, (int)10241, (int)minFilter);
            GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
            GlStateManager._bindTexture((int)this.colorTexturesFlip.getB(i2));
            GL11.glTexParameteri((int)3553, (int)10241, (int)minFilter);
            GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
        }
        GlStateManager._bindTexture((int)0);
    }

    public void setFramebufferTexture2D(int target, int attachment, int texTarget, int texture, int level) {
        int colorIndex = attachment - 36064;
        if (this.isColorBufferIndex(colorIndex)) {
            if (this.colorBufferSizes[colorIndex] != null) {
                if (this.isColorExtendedIndex(colorIndex)) {
                    return;
                }
                texture = 0;
            }
            this.drawColorTextures[colorIndex] = texture;
            if (colorIndex >= this.maxDrawBuffers) {
                int indexMapped = this.drawColorTexturesMap[colorIndex];
                if (!this.isDrawBufferIndex(indexMapped)) {
                    return;
                }
                attachment = 36064 + indexMapped;
            }
        }
        this.bindFramebuffer();
        GL30.glFramebufferTexture2D((int)target, (int)attachment, (int)texTarget, (int)texture, (int)level);
    }

    public boolean isColorBufferIndex(int index) {
        return index >= 0 && index < this.usedColorBuffers;
    }

    public boolean isColorExtendedIndex(int index) {
        return index >= this.maxDrawBuffers && index < this.usedColorBuffers;
    }

    public boolean isDrawBufferIndex(int index) {
        return index >= 0 && index < this.maxDrawBuffers;
    }

    private void setDrawColorTexturesMap(int[] newColorTexturesMap) {
        int i2;
        this.bindFramebuffer();
        for (i2 = 0; i2 < this.maxDrawBuffers; ++i2) {
            if (!this.dirtyColorTextures[i2]) continue;
            int texture = this.drawColorTextures[i2];
            GL30.glFramebufferTexture2D((int)36160, (int)(36064 + i2), (int)3553, (int)texture, (int)0);
            this.dirtyColorTextures[i2] = false;
        }
        this.drawColorTexturesMap = newColorTexturesMap;
        for (i2 = this.maxDrawBuffers; i2 < this.drawColorTexturesMap.length; ++i2) {
            int ai = this.drawColorTexturesMap[i2];
            if (ai < 0) continue;
            int texture = this.drawColorTextures[i2];
            GL30.glFramebufferTexture2D((int)36160, (int)(36064 + ai), (int)3553, (int)texture, (int)0);
            this.dirtyColorTextures[ai] = true;
        }
    }

    public void setDrawBuffers(DrawBuffers drawBuffersIn) {
        if (drawBuffersIn == null) {
            drawBuffersIn = Shaders.drawBuffersNone;
        }
        this.setDrawColorTexturesMap(drawBuffersIn.getAttachmentMappings());
        this.activeDrawBuffers = drawBuffersIn;
        this.bindFramebuffer();
        GL30.glDrawBuffers((IntBuffer)drawBuffersIn.getGlDrawBuffers());
        Shaders.checkGLError((String)"setDrawBuffers");
    }

    public void setDrawBuffers() {
        this.setDrawBuffers(this.drawBuffers);
    }

    public DrawBuffers getDrawBuffers() {
        return this.activeDrawBuffers;
    }

    public void bindDepthTextures(int[] depthTextureImageUnits) {
        for (int i2 = 0; i2 < this.usedDepthBuffers; ++i2) {
            GlStateManager._activeTexture((int)(33984 + depthTextureImageUnits[i2]));
            GlStateManager._bindTexture((int)this.depthTextures.get(i2));
        }
        GlStateManager._activeTexture((int)33984);
    }

    public void bindColorTextures(int startColorBuffer) {
        for (int i2 = startColorBuffer; i2 < this.usedColorBuffers; ++i2) {
            GlStateManager._activeTexture((int)(33984 + this.colorTextureUnits[i2]));
            GlStateManager._bindTexture((int)this.colorTexturesFlip.getA(i2));
            this.bindColorImage(i2, true);
        }
    }

    public void bindColorImages(boolean main) {
        if (this.colorImageUnits == null) {
            return;
        }
        for (int i2 = 0; i2 < this.usedColorBuffers; ++i2) {
            this.bindColorImage(i2, main);
        }
    }

    public void bindColorImage(int index, boolean main) {
        if (this.colorImageUnits == null) {
            return;
        }
        if (index >= 0 && index < this.colorImageUnits.length) {
            int imageFormat = Shaders.getImageFormat((int)this.buffersFormat[index]);
            GlStateManager.bindImageTexture((int)this.colorImageUnits[index], (int)this.colorTexturesFlip.get(main, index), (int)0, (boolean)false, (int)0, (int)35002, (int)imageFormat);
        }
        GlStateManager._activeTexture((int)33984);
    }

    public void generateDepthMipmaps(boolean[] depthMipmapEnabled) {
        for (int i2 = 0; i2 < this.usedDepthBuffers; ++i2) {
            if (!depthMipmapEnabled[i2]) continue;
            GlStateManager._activeTexture((int)(33984 + this.depthTextureUnits[i2]));
            GlStateManager._bindTexture((int)this.depthTextures.get(i2));
            GL30.glGenerateMipmap((int)3553);
            GL30.glTexParameteri((int)3553, (int)10241, (int)(this.depthFilterNearest[i2] ? 9984 : 9987));
        }
        GlStateManager._activeTexture((int)33984);
    }

    public void generateColorMipmaps(boolean main, boolean[] colorMipmapEnabled) {
        for (int i2 = 0; i2 < this.usedColorBuffers; ++i2) {
            if (!colorMipmapEnabled[i2]) continue;
            GlStateManager._activeTexture((int)(33984 + this.colorTextureUnits[i2]));
            GlStateManager._bindTexture((int)this.colorTexturesFlip.get(main, i2));
            GL30.glGenerateMipmap((int)3553);
            GL30.glTexParameteri((int)3553, (int)10241, (int)(this.colorFilterNearest[i2] ? 9984 : 9987));
        }
        GlStateManager._activeTexture((int)33984);
    }

    public void genCompositeMipmap(int compositeMipmapSetting) {
        if (Shaders.hasGlGenMipmap) {
            for (int i2 = 0; i2 < this.usedColorBuffers; ++i2) {
                if ((compositeMipmapSetting & 1 << i2) == 0) continue;
                GlStateManager._activeTexture((int)(33984 + this.colorTextureUnits[i2]));
                GL30.glTexParameteri((int)3553, (int)10241, (int)9987);
                GL30.glGenerateMipmap((int)3553);
            }
            GlStateManager._activeTexture((int)33984);
        }
    }

    public void flipColorTextures(boolean[] toggleColorTextures) {
        for (int i2 = 0; i2 < this.colorTexturesFlip.limit(); ++i2) {
            if (!toggleColorTextures[i2]) continue;
            this.flipColorTexture(i2);
        }
    }

    public void flipColorTexture(int index) {
        this.colorTexturesFlip.flip(index);
        GlStateManager._activeTexture((int)(33984 + this.colorTextureUnits[index]));
        GlStateManager._bindTexture((int)this.colorTexturesFlip.getA(index));
        this.bindColorImage(index, true);
        this.setFramebufferTexture2D(36160, 36064 + index, 3553, this.colorTexturesFlip.getB(index), 0);
        GlStateManager._activeTexture((int)33984);
    }

    public void clearColorBuffers(boolean[] buffersClear, Vector4f[] clearColors) {
        for (int i2 = 0; i2 < this.usedColorBuffers; ++i2) {
            if (!buffersClear[i2]) continue;
            Vector4f col = clearColors[i2];
            if (col != null) {
                GL30.glClearColor((float)col.x(), (float)col.y(), (float)col.z(), (float)col.w());
            }
            if (this.colorBufferSizes[i2] != null) {
                if (this.colorTexturesFlip.isChanged(i2)) {
                    this.clearColorBufferFixedSize(i2, false);
                }
                this.clearColorBufferFixedSize(i2, true);
                continue;
            }
            if (this.colorTexturesFlip.isChanged(i2)) {
                this.setFramebufferTexture2D(36160, 36064 + i2, 3553, this.colorTexturesFlip.getB(i2), 0);
                this.setDrawBuffers(Shaders.drawBuffersColorAtt[i2]);
                GL30.glClear((int)16384);
                this.setFramebufferTexture2D(36160, 36064 + i2, 3553, this.colorTexturesFlip.getA(i2), 0);
            }
            this.setDrawBuffers(Shaders.drawBuffersColorAtt[i2]);
            GL30.glClear((int)16384);
        }
    }

    private void clearColorBufferFixedSize(int i2, boolean main) {
        Dimension dim2 = this.colorBufferSizes[i2].getDimension(this.width, this.height);
        if (dim2 == null) {
            return;
        }
        FixedFramebuffer ff = this.getFixedFramebuffer(dim2.width, dim2.height, Shaders.drawBuffersColorAtt[i2], main);
        ff.bindFramebuffer();
        GL30.glClear((int)16384);
    }

    public void clearDepthBuffer(Vector4f col) {
        this.setFramebufferTexture2D(36160, 36096, 3553, this.depthTextures.get(0), 0);
        GL30.glClearColor((float)col.x(), (float)col.y(), (float)col.z(), (float)col.w());
        GL30.glClear((int)256);
    }

    public String toString() {
        return this.name + ", width: " + this.width + ", height: " + this.height + ", usedColorBuffers: " + this.usedColorBuffers + ", usedDepthBuffers: " + this.usedDepthBuffers + ", maxDrawBuffers: " + this.maxDrawBuffers;
    }

    public FixedFramebuffer getFixedFramebuffer(int width, int height, DrawBuffers dbs, boolean main) {
        IntBuffer glDbs = dbs.getGlDrawBuffers();
        int dbsLen = dbs.limit();
        int[] glTexs = new int[dbsLen];
        int[] glAtts = new int[dbsLen];
        for (int i2 = 0; i2 < glTexs.length; ++i2) {
            int att = dbs.get(i2);
            int ix2 = att - 36064;
            if (!this.isColorBufferIndex(ix2)) continue;
            glTexs[i2] = this.colorTexturesFlip.get(main, ix2);
            glAtts[i2] = glDbs.get(i2);
        }
        CompoundKey key = new CompoundKey((Object)new CompoundIntKey(glTexs), (Object)new CompoundIntKey(glAtts));
        FixedFramebuffer ff = (FixedFramebuffer)this.fixedFramebuffers.get(key);
        if (ff == null) {
            String fixedName = this.name + ", [" + ArrayUtils.arrayToString((int[])glTexs) + "], [" + ArrayUtils.arrayToString((int[])glAtts) + "]";
            ff = new FixedFramebuffer(fixedName, width, height, glTexs, glAtts, this.depthFilterNearest[0], this.depthFilterHardware[0]);
            ff.setup();
            this.fixedFramebuffers.put(key, ff);
        }
        return ff;
    }
}

