/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.optifine.Config;
import net.optifine.CustomBlockLayers;
import net.optifine.CustomColors;
import net.optifine.GlErrors;
import net.optifine.Lang;
import net.optifine.config.ConnectedParser;
import net.optifine.expr.IExpressionBool;
import net.optifine.render.GLConst;
import net.optifine.render.GlAlphaState;
import net.optifine.render.GlBlendState;
import net.optifine.render.RenderTypes;
import net.optifine.render.RenderUtils;
import net.optifine.shaders.BlockAliases;
import net.optifine.shaders.ComputeProgram;
import net.optifine.shaders.CustomTexture;
import net.optifine.shaders.CustomTextureLocation;
import net.optifine.shaders.CustomTextureRaw;
import net.optifine.shaders.DefaultShaders;
import net.optifine.shaders.DrawBuffers;
import net.optifine.shaders.EntityAliases;
import net.optifine.shaders.FixedFramebuffer;
import net.optifine.shaders.GlState;
import net.optifine.shaders.HFNoiseTexture;
import net.optifine.shaders.ICustomTexture;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.ItemAliases;
import net.optifine.shaders.MultiTexID;
import net.optifine.shaders.Program;
import net.optifine.shaders.ProgramStack;
import net.optifine.shaders.ProgramStage;
import net.optifine.shaders.ProgramUtils;
import net.optifine.shaders.Programs;
import net.optifine.shaders.RenderStage;
import net.optifine.shaders.SMCLog;
import net.optifine.shaders.SMath;
import net.optifine.shaders.ShaderPackDefault;
import net.optifine.shaders.ShaderPackFolder;
import net.optifine.shaders.ShaderPackNone;
import net.optifine.shaders.ShaderPackZip;
import net.optifine.shaders.ShaderUtils;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersFramebuffer;
import net.optifine.shaders.ShadersRender;
import net.optifine.shaders.ShadersTex;
import net.optifine.shaders.SimpleShaderTexture;
import net.optifine.shaders.config.EnumShaderOption;
import net.optifine.shaders.config.MacroProcessor;
import net.optifine.shaders.config.MacroState;
import net.optifine.shaders.config.PropertyDefaultFastFancyOff;
import net.optifine.shaders.config.PropertyDefaultTrueFalse;
import net.optifine.shaders.config.RenderScale;
import net.optifine.shaders.config.ScreenShaderOptions;
import net.optifine.shaders.config.ShaderLine;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.config.ShaderOptionProfile;
import net.optifine.shaders.config.ShaderOptionRest;
import net.optifine.shaders.config.ShaderPackParser;
import net.optifine.shaders.config.ShaderParser;
import net.optifine.shaders.config.ShaderProfile;
import net.optifine.shaders.config.ShaderType;
import net.optifine.shaders.uniform.CustomUniforms;
import net.optifine.shaders.uniform.ShaderUniform1f;
import net.optifine.shaders.uniform.ShaderUniform1i;
import net.optifine.shaders.uniform.ShaderUniform2i;
import net.optifine.shaders.uniform.ShaderUniform3f;
import net.optifine.shaders.uniform.ShaderUniform4f;
import net.optifine.shaders.uniform.ShaderUniform4i;
import net.optifine.shaders.uniform.ShaderUniformM3;
import net.optifine.shaders.uniform.ShaderUniformM4;
import net.optifine.shaders.uniform.ShaderUniforms;
import net.optifine.shaders.uniform.Smoother;
import net.optifine.texture.InternalFormat;
import net.optifine.texture.PixelFormat;
import net.optifine.texture.PixelType;
import net.optifine.texture.TextureType;
import net.optifine.util.ArrayUtils;
import net.optifine.util.DynamicDimension;
import net.optifine.util.EntityUtils;
import net.optifine.util.LineBuffer;
import net.optifine.util.MathUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.StrUtils;
import net.optifine.util.TimedEvent;
import net.optifine.util.WorldUtils;
import org.apache.commons.io.IOUtils;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.ARBGeometryShader4;
import org.lwjgl.opengl.EXTGeometryShader4;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class Shaders {
    static enn mc;
    static fjq entityRenderer;
    public static boolean isInitializedOnce;
    public static boolean isShaderPackInitialized;
    public static GLCapabilities capabilities;
    public static String glVersionString;
    public static String glVendorString;
    public static String glRendererString;
    public static boolean hasGlGenMipmap;
    public static int countResetDisplayLists;
    private static int renderDisplayWidth;
    private static int renderDisplayHeight;
    public static int renderWidth;
    public static int renderHeight;
    public static boolean isRenderingWorld;
    public static boolean isRenderingSky;
    public static boolean isCompositeRendered;
    public static boolean isRenderingDfb;
    public static boolean isShadowPass;
    public static boolean isSleeping;
    private static boolean isRenderingFirstPersonHand;
    private static boolean isHandRenderedMain;
    private static boolean isHandRenderedOff;
    private static boolean skipRenderHandMain;
    private static boolean skipRenderHandOff;
    public static boolean renderItemKeepDepthMask;
    public static boolean itemToRenderMainTranslucent;
    public static boolean itemToRenderOffTranslucent;
    static float[] sunPosition;
    static float[] moonPosition;
    static float[] shadowLightPosition;
    static float[] upPosition;
    static float[] shadowLightPositionVector;
    static float[] upPosModelView;
    static float[] sunPosModelView;
    static float[] moonPosModelView;
    private static float[] tempMat;
    static Vector4f clearColor;
    static float skyColorR;
    static float skyColorG;
    static float skyColorB;
    static long worldTime;
    static long lastWorldTime;
    static long diffWorldTime;
    static float celestialAngle;
    static float sunAngle;
    static float shadowAngle;
    static int moonPhase;
    static long systemTime;
    static long lastSystemTime;
    static long diffSystemTime;
    static int frameCounter;
    static float frameTime;
    static float frameTimeCounter;
    static int systemTimeInt32;
    public static ena pointOfView;
    public static boolean pointOfViewChanged;
    static float rainStrength;
    static float wetness;
    public static float wetnessHalfLife;
    public static float drynessHalfLife;
    public static float eyeBrightnessHalflife;
    static boolean usewetness;
    static int isEyeInWater;
    static int eyeBrightness;
    static float eyeBrightnessFadeX;
    static float eyeBrightnessFadeY;
    static float eyePosY;
    static float centerDepth;
    static float centerDepthSmooth;
    static float centerDepthSmoothHalflife;
    static boolean centerDepthSmoothEnabled;
    static int superSamplingLevel;
    static float nightVision;
    static float blindness;
    static boolean lightmapEnabled;
    static boolean fogEnabled;
    static boolean fogAllowed;
    static RenderStage renderStage;
    static int bossBattle;
    static float darknessFactor;
    static float darknessLightFactor;
    private static int baseAttribId;
    public static int entityAttrib;
    public static int midTexCoordAttrib;
    public static int tangentAttrib;
    public static int velocityAttrib;
    public static int midBlockAttrib;
    public static boolean useEntityAttrib;
    public static boolean useMidTexCoordAttrib;
    public static boolean useTangentAttrib;
    public static boolean useVelocityAttrib;
    public static boolean useMidBlockAttrib;
    public static boolean progUseEntityAttrib;
    public static boolean progUseMidTexCoordAttrib;
    public static boolean progUseTangentAttrib;
    public static boolean progUseVelocityAttrib;
    public static boolean progUseMidBlockAttrib;
    private static boolean progArbGeometryShader4;
    private static boolean progExtGeometryShader4;
    private static int progMaxVerticesOut;
    private static boolean hasGeometryShaders;
    public static boolean hasShadowGeometryShaders;
    public static boolean hasShadowInstancing;
    public static int atlasSizeX;
    public static int atlasSizeY;
    private static ShaderUniforms shaderUniforms;
    public static ShaderUniform4f uniform_entityColor;
    public static ShaderUniform1i uniform_entityId;
    public static ShaderUniform1i uniform_blockEntityId;
    public static ShaderUniform1i uniform_gtexture;
    public static ShaderUniform1i uniform_lightmap;
    public static ShaderUniform1i uniform_normals;
    public static ShaderUniform1i uniform_specular;
    public static ShaderUniform1i uniform_shadow;
    public static ShaderUniform1i uniform_watershadow;
    public static ShaderUniform1i uniform_shadowtex0;
    public static ShaderUniform1i uniform_shadowtex1;
    public static ShaderUniform1i uniform_depthtex0;
    public static ShaderUniform1i uniform_depthtex1;
    public static ShaderUniform1i uniform_shadowcolor;
    public static ShaderUniform1i uniform_shadowcolor0;
    public static ShaderUniform1i uniform_shadowcolor1;
    public static ShaderUniform1i uniform_noisetex;
    public static ShaderUniform1i uniform_gcolor;
    public static ShaderUniform1i uniform_gdepth;
    public static ShaderUniform1i uniform_gnormal;
    public static ShaderUniform1i uniform_composite;
    public static ShaderUniform1i uniform_gaux1;
    public static ShaderUniform1i uniform_gaux2;
    public static ShaderUniform1i uniform_gaux3;
    public static ShaderUniform1i uniform_gaux4;
    public static ShaderUniform1i uniform_colortex0;
    public static ShaderUniform1i uniform_colortex1;
    public static ShaderUniform1i uniform_colortex2;
    public static ShaderUniform1i uniform_colortex3;
    public static ShaderUniform1i uniform_colortex4;
    public static ShaderUniform1i uniform_colortex5;
    public static ShaderUniform1i uniform_colortex6;
    public static ShaderUniform1i uniform_colortex7;
    public static ShaderUniform1i uniform_gdepthtex;
    public static ShaderUniform1i uniform_depthtex2;
    public static ShaderUniform1i uniform_colortex8;
    public static ShaderUniform1i uniform_colortex9;
    public static ShaderUniform1i uniform_colortex10;
    public static ShaderUniform1i uniform_colortex11;
    public static ShaderUniform1i uniform_colortex12;
    public static ShaderUniform1i uniform_colortex13;
    public static ShaderUniform1i uniform_colortex14;
    public static ShaderUniform1i uniform_colortex15;
    public static ShaderUniform1i uniform_colorimg0;
    public static ShaderUniform1i uniform_colorimg1;
    public static ShaderUniform1i uniform_colorimg2;
    public static ShaderUniform1i uniform_colorimg3;
    public static ShaderUniform1i uniform_colorimg4;
    public static ShaderUniform1i uniform_colorimg5;
    public static ShaderUniform1i uniform_shadowcolorimg0;
    public static ShaderUniform1i uniform_shadowcolorimg1;
    public static ShaderUniform1i uniform_tex;
    public static ShaderUniform1i uniform_heldItemId;
    public static ShaderUniform1i uniform_heldBlockLightValue;
    public static ShaderUniform1i uniform_heldItemId2;
    public static ShaderUniform1i uniform_heldBlockLightValue2;
    public static ShaderUniform1i uniform_fogMode;
    public static ShaderUniform1f uniform_fogDensity;
    public static ShaderUniform1f uniform_fogStart;
    public static ShaderUniform1f uniform_fogEnd;
    public static ShaderUniform1i uniform_fogShape;
    public static ShaderUniform3f uniform_fogColor;
    public static ShaderUniform3f uniform_skyColor;
    public static ShaderUniform1i uniform_worldTime;
    public static ShaderUniform1i uniform_worldDay;
    public static ShaderUniform1i uniform_moonPhase;
    public static ShaderUniform1i uniform_frameCounter;
    public static ShaderUniform1f uniform_frameTime;
    public static ShaderUniform1f uniform_frameTimeCounter;
    public static ShaderUniform1f uniform_sunAngle;
    public static ShaderUniform1f uniform_shadowAngle;
    public static ShaderUniform1f uniform_rainStrength;
    public static ShaderUniform1f uniform_aspectRatio;
    public static ShaderUniform1f uniform_viewWidth;
    public static ShaderUniform1f uniform_viewHeight;
    public static ShaderUniform1f uniform_near;
    public static ShaderUniform1f uniform_far;
    public static ShaderUniform3f uniform_sunPosition;
    public static ShaderUniform3f uniform_moonPosition;
    public static ShaderUniform3f uniform_shadowLightPosition;
    public static ShaderUniform3f uniform_upPosition;
    public static ShaderUniform3f uniform_previousCameraPosition;
    public static ShaderUniform3f uniform_cameraPosition;
    public static ShaderUniformM4 uniform_gbufferModelView;
    public static ShaderUniformM4 uniform_gbufferModelViewInverse;
    public static ShaderUniformM4 uniform_gbufferPreviousProjection;
    public static ShaderUniformM4 uniform_gbufferProjection;
    public static ShaderUniformM4 uniform_gbufferProjectionInverse;
    public static ShaderUniformM4 uniform_gbufferPreviousModelView;
    public static ShaderUniformM4 uniform_shadowProjection;
    public static ShaderUniformM4 uniform_shadowProjectionInverse;
    public static ShaderUniformM4 uniform_shadowModelView;
    public static ShaderUniformM4 uniform_shadowModelViewInverse;
    public static ShaderUniform1f uniform_wetness;
    public static ShaderUniform1f uniform_eyeAltitude;
    public static ShaderUniform2i uniform_eyeBrightness;
    public static ShaderUniform2i uniform_eyeBrightnessSmooth;
    public static ShaderUniform2i uniform_terrainTextureSize;
    public static ShaderUniform1i uniform_terrainIconSize;
    public static ShaderUniform1i uniform_isEyeInWater;
    public static ShaderUniform1f uniform_nightVision;
    public static ShaderUniform1f uniform_blindness;
    public static ShaderUniform1f uniform_screenBrightness;
    public static ShaderUniform1i uniform_hideGUI;
    public static ShaderUniform1f uniform_centerDepthSmooth;
    public static ShaderUniform2i uniform_atlasSize;
    public static ShaderUniform4f uniform_spriteBounds;
    public static ShaderUniform4i uniform_blendFunc;
    public static ShaderUniform1i uniform_instanceId;
    public static ShaderUniform1f uniform_playerMood;
    public static ShaderUniform1i uniform_renderStage;
    public static ShaderUniform1i uniform_bossBattle;
    public static ShaderUniformM4 uniform_modelViewMatrix;
    public static ShaderUniformM4 uniform_modelViewMatrixInverse;
    public static ShaderUniformM4 uniform_projectionMatrix;
    public static ShaderUniformM4 uniform_projectionMatrixInverse;
    public static ShaderUniformM4 uniform_textureMatrix;
    public static ShaderUniformM3 uniform_normalMatrix;
    public static ShaderUniform3f uniform_chunkOffset;
    public static ShaderUniform4f uniform_colorModulator;
    public static ShaderUniform1f uniform_alphaTestRef;
    public static ShaderUniform1f uniform_darknessFactor;
    public static ShaderUniform1f uniform_darknessLightFactor;
    static double previousCameraPositionX;
    static double previousCameraPositionY;
    static double previousCameraPositionZ;
    static double cameraPositionX;
    static double cameraPositionY;
    static double cameraPositionZ;
    static int cameraOffsetX;
    static int cameraOffsetZ;
    public static boolean hasShadowMap;
    public static boolean needResizeShadow;
    static int shadowMapWidth;
    static int shadowMapHeight;
    static int spShadowMapWidth;
    static int spShadowMapHeight;
    static float shadowMapFOV;
    static float shadowMapHalfPlane;
    static boolean shadowMapIsOrtho;
    static float shadowDistanceRenderMul;
    public static boolean shouldSkipDefaultShadow;
    static boolean waterShadowEnabled;
    public static final int MaxDrawBuffers = 8;
    public static final int MaxColorBuffers = 16;
    public static final int MaxDepthBuffers = 3;
    public static final int MaxShadowColorBuffers = 2;
    public static final int MaxShadowDepthBuffers = 2;
    static int usedColorBuffers;
    static int usedDepthBuffers;
    static int usedShadowColorBuffers;
    static int usedShadowDepthBuffers;
    static int usedColorAttachs;
    static int usedDrawBuffers;
    static boolean bindImageTextures;
    static ShadersFramebuffer dfb;
    static ShadersFramebuffer sfb;
    private static int[] gbuffersFormat;
    public static boolean[] gbuffersClear;
    public static Vector4f[] gbuffersClearColor;
    private static final Vector4f CLEAR_COLOR_0;
    private static final Vector4f CLEAR_COLOR_1;
    private static int[] shadowBuffersFormat;
    public static boolean[] shadowBuffersClear;
    public static Vector4f[] shadowBuffersClearColor;
    private static Programs programs;
    public static final Program ProgramNone;
    public static final Program ProgramShadow;
    public static final Program ProgramShadowSolid;
    public static final Program ProgramShadowCutout;
    public static final Program[] ProgramsShadowcomp;
    public static final Program[] ProgramsPrepare;
    public static final Program ProgramBasic;
    public static final Program ProgramLine;
    public static final Program ProgramTextured;
    public static final Program ProgramTexturedLit;
    public static final Program ProgramSkyBasic;
    public static final Program ProgramSkyTextured;
    public static final Program ProgramClouds;
    public static final Program ProgramTerrain;
    public static final Program ProgramTerrainSolid;
    public static final Program ProgramTerrainCutoutMip;
    public static final Program ProgramTerrainCutout;
    public static final Program ProgramDamagedBlock;
    public static final Program ProgramBlock;
    public static final Program ProgramBeaconBeam;
    public static final Program ProgramItem;
    public static final Program ProgramEntities;
    public static final Program ProgramEntitiesGlowing;
    public static final Program ProgramArmorGlint;
    public static final Program ProgramSpiderEyes;
    public static final Program ProgramHand;
    public static final Program ProgramWeather;
    public static final Program ProgramDeferredPre;
    public static final Program[] ProgramsDeferred;
    public static final Program ProgramDeferred;
    public static final Program ProgramWater;
    public static final Program ProgramHandWater;
    public static final Program ProgramCompositePre;
    public static final Program[] ProgramsComposite;
    public static final Program ProgramComposite;
    public static final Program ProgramFinal;
    public static final int ProgramCount;
    public static final Program[] ProgramsAll;
    public static Program activeProgram;
    public static int activeProgramID;
    private static ProgramStack programStack;
    private static boolean hasDeferredPrograms;
    public static boolean hasShadowcompPrograms;
    public static boolean hasPreparePrograms;
    public static Properties loadedShaders;
    public static Properties shadersConfig;
    public static fug defaultTexture;
    public static boolean[] shadowHardwareFilteringEnabled;
    public static boolean[] shadowMipmapEnabled;
    public static boolean[] shadowFilterNearest;
    public static boolean[] shadowColorMipmapEnabled;
    public static boolean[] shadowColorFilterNearest;
    public static boolean configTweakBlockDamage;
    public static boolean configCloudShadow;
    public static float configHandDepthMul;
    public static float configRenderResMul;
    public static float configShadowResMul;
    public static int configTexMinFilB;
    public static int configTexMinFilN;
    public static int configTexMinFilS;
    public static int configTexMagFilB;
    public static int configTexMagFilN;
    public static int configTexMagFilS;
    public static boolean configShadowClipFrustrum;
    public static boolean configNormalMap;
    public static boolean configSpecularMap;
    public static PropertyDefaultTrueFalse configOldLighting;
    public static PropertyDefaultTrueFalse configOldHandLight;
    public static int configAntialiasingLevel;
    public static final int texMinFilRange = 3;
    public static final int texMagFilRange = 2;
    public static final String[] texMinFilDesc;
    public static final String[] texMagFilDesc;
    public static final int[] texMinFilValue;
    public static final int[] texMagFilValue;
    private static IShaderPack shaderPack;
    public static boolean shaderPackLoaded;
    public static String currentShaderName;
    public static final String SHADER_PACK_NAME_NONE = "OFF";
    public static final String SHADER_PACK_NAME_DEFAULT = "(internal)";
    public static final String SHADER_PACKS_DIR_NAME = "shaderpacks";
    public static final String OPTIONS_FILE_NAME = "optionsshaders.txt";
    public static final File shaderPacksDir;
    static File configFile;
    private static ShaderOption[] shaderPackOptions;
    private static Set<String> shaderPackOptionSliders;
    static ShaderProfile[] shaderPackProfiles;
    static Map<String, ScreenShaderOptions> shaderPackGuiScreens;
    static Map<String, IExpressionBool> shaderPackProgramConditions;
    public static final String PATH_SHADERS_PROPERTIES = "/shaders/shaders.properties";
    public static PropertyDefaultFastFancyOff shaderPackClouds;
    public static PropertyDefaultTrueFalse shaderPackOldLighting;
    public static PropertyDefaultTrueFalse shaderPackOldHandLight;
    public static PropertyDefaultTrueFalse shaderPackDynamicHandLight;
    public static PropertyDefaultTrueFalse shaderPackShadowTerrain;
    public static PropertyDefaultTrueFalse shaderPackShadowTranslucent;
    public static PropertyDefaultTrueFalse shaderPackShadowEntities;
    public static PropertyDefaultTrueFalse shaderPackShadowBlockEntities;
    public static PropertyDefaultTrueFalse shaderPackUnderwaterOverlay;
    public static PropertyDefaultTrueFalse shaderPackSun;
    public static PropertyDefaultTrueFalse shaderPackMoon;
    public static PropertyDefaultTrueFalse shaderPackVignette;
    public static PropertyDefaultTrueFalse shaderPackBackFaceSolid;
    public static PropertyDefaultTrueFalse shaderPackBackFaceCutout;
    public static PropertyDefaultTrueFalse shaderPackBackFaceCutoutMipped;
    public static PropertyDefaultTrueFalse shaderPackBackFaceTranslucent;
    public static PropertyDefaultTrueFalse shaderPackRainDepth;
    public static PropertyDefaultTrueFalse shaderPackBeaconBeamDepth;
    public static PropertyDefaultTrueFalse shaderPackSeparateAo;
    public static PropertyDefaultTrueFalse shaderPackFrustumCulling;
    public static PropertyDefaultTrueFalse shaderPackShadowCulling;
    public static PropertyDefaultTrueFalse shaderPackParticlesBeforeDeferred;
    private static Map<String, String> shaderPackResources;
    private static few currentWorld;
    private static List<Integer> shaderPackDimensions;
    private static ICustomTexture[] customTexturesGbuffers;
    private static ICustomTexture[] customTexturesComposite;
    private static ICustomTexture[] customTexturesDeferred;
    private static ICustomTexture[] customTexturesShadowcomp;
    private static ICustomTexture[] customTexturesPrepare;
    private static String noiseTexturePath;
    private static DynamicDimension[] colorBufferSizes;
    private static CustomUniforms customUniforms;
    public static final boolean saveFinalShaders;
    public static float blockLightLevel05;
    public static float blockLightLevel06;
    public static float blockLightLevel08;
    public static float aoLevel;
    public static float sunPathRotation;
    public static float shadowAngleInterval;
    public static int fogMode;
    public static int fogShape;
    public static float fogDensity;
    public static float fogStart;
    public static float fogEnd;
    public static float fogColorR;
    public static float fogColorG;
    public static float fogColorB;
    public static float shadowIntervalSize;
    public static int terrainIconSize;
    public static int[] terrainTextureSize;
    private static ICustomTexture noiseTexture;
    private static boolean noiseTextureEnabled;
    private static int noiseTextureResolution;
    static final int[] colorTextureImageUnit;
    static final int[] depthTextureImageUnit;
    static final int[] shadowColorTextureImageUnit;
    static final int[] shadowDepthTextureImageUnit;
    static final int[] colorImageUnit;
    static final int[] shadowColorImageUnit;
    private static final int bigBufferSize;
    private static final ByteBuffer bigBuffer;
    static final float[] faProjection;
    static final float[] faProjectionInverse;
    static final float[] faModelView;
    static final float[] faModelViewInverse;
    static final float[] faShadowProjection;
    static final float[] faShadowProjectionInverse;
    static final float[] faShadowModelView;
    static final float[] faShadowModelViewInverse;
    static final FloatBuffer projection;
    static final FloatBuffer projectionInverse;
    static final FloatBuffer modelView;
    static final FloatBuffer modelViewInverse;
    static final FloatBuffer shadowProjection;
    static final FloatBuffer shadowProjectionInverse;
    static final FloatBuffer shadowModelView;
    static final FloatBuffer shadowModelViewInverse;
    static final Matrix4f lastModelView;
    static final Matrix4f lastProjection;
    static final FloatBuffer previousProjection;
    static final FloatBuffer previousModelView;
    static final FloatBuffer tempMatrixDirectBuffer;
    static final FloatBuffer tempDirectFloatBuffer;
    static final DrawBuffers dfbDrawBuffers;
    static final DrawBuffers sfbDrawBuffers;
    static final DrawBuffers drawBuffersNone;
    static final DrawBuffers[] drawBuffersColorAtt;
    static boolean glDebugGroups;
    static boolean glDebugGroupProgram;
    public static final Matrix4f MATRIX_IDENTITY;
    static Map<cpn, Integer> mapBlockToEntityData;
    private static final String[] formatNames;
    private static final int[] formatIds;
    private static final Pattern patternLoadEntityDataMap;
    public static int[] entityData;
    public static int entityDataIndex;

    private Shaders() {
    }

    private static ByteBuffer nextByteBuffer(int size) {
        ByteBuffer buffer = bigBuffer;
        int pos = buffer.limit();
        buffer.position(pos).limit(pos + size);
        return buffer.slice();
    }

    public static IntBuffer nextIntBuffer(int size) {
        ByteBuffer buffer = bigBuffer;
        int pos = buffer.limit();
        buffer.position(pos).limit(pos + size * 4);
        return buffer.asIntBuffer();
    }

    private static FloatBuffer nextFloatBuffer(int size) {
        ByteBuffer buffer = bigBuffer;
        int pos = buffer.limit();
        buffer.position(pos).limit(pos + size * 4);
        return buffer.asFloatBuffer();
    }

    private static IntBuffer[] nextIntBufferArray(int count, int size) {
        IntBuffer[] aib = new IntBuffer[count];
        for (int i2 = 0; i2 < count; ++i2) {
            aib[i2] = Shaders.nextIntBuffer((int)size);
        }
        return aib;
    }

    private static DrawBuffers[] makeDrawBuffersColorSingle(int count) {
        DrawBuffers[] dbs = new DrawBuffers[count];
        for (int i2 = 0; i2 < dbs.length; ++i2) {
            DrawBuffers db = new DrawBuffers("single" + i2, 16, 8);
            db.put(36064 + i2);
            db.position(0);
            db.limit(1);
            dbs[i2] = db;
        }
        return dbs;
    }

    public static void loadConfig() {
        SMCLog.info((String)"Load shaders configuration.");
        try {
            if (!shaderPacksDir.exists()) {
                shaderPacksDir.mkdir();
            }
        }
        catch (Exception e2) {
            SMCLog.severe((String)("Failed to open the shaderpacks directory: " + shaderPacksDir));
        }
        shadersConfig = new PropertiesOrdered();
        shadersConfig.setProperty(EnumShaderOption.SHADER_PACK.getPropertyKey(), "");
        if (configFile.exists()) {
            try {
                FileReader reader = new FileReader(configFile);
                shadersConfig.load(reader);
                reader.close();
            }
            catch (Exception reader) {
                // empty catch block
            }
        }
        if (!configFile.exists()) {
            try {
                Shaders.storeConfig();
            }
            catch (Exception reader) {
                // empty catch block
            }
        }
        EnumShaderOption[] ops = EnumShaderOption.values();
        for (int i2 = 0; i2 < ops.length; ++i2) {
            EnumShaderOption op = ops[i2];
            String key = op.getPropertyKey();
            String def = op.getValueDefault();
            String val = shadersConfig.getProperty(key, def);
            Shaders.setEnumShaderOption((EnumShaderOption)op, (String)val);
        }
        Shaders.loadShaderPack();
    }

    private static void setEnumShaderOption(EnumShaderOption eso2, String str) {
        if (str == null) {
            str = eso2.getValueDefault();
        }
        switch (1.$SwitchMap$net$optifine$shaders$config$EnumShaderOption[eso2.ordinal()]) {
            case 1: {
                configAntialiasingLevel = Config.parseInt((String)str, (int)0);
                break;
            }
            case 2: {
                configNormalMap = Config.parseBoolean((String)str, (boolean)true);
                break;
            }
            case 3: {
                configSpecularMap = Config.parseBoolean((String)str, (boolean)true);
                break;
            }
            case 4: {
                configRenderResMul = Config.parseFloat((String)str, (float)1.0f);
                break;
            }
            case 5: {
                configShadowResMul = Config.parseFloat((String)str, (float)1.0f);
                break;
            }
            case 6: {
                configHandDepthMul = Config.parseFloat((String)str, (float)0.125f);
                break;
            }
            case 7: {
                configCloudShadow = Config.parseBoolean((String)str, (boolean)true);
                break;
            }
            case 8: {
                configOldHandLight.setPropertyValue(str);
                break;
            }
            case 9: {
                configOldLighting.setPropertyValue(str);
                break;
            }
            case 10: {
                currentShaderName = str;
                break;
            }
            case 11: {
                configTweakBlockDamage = Config.parseBoolean((String)str, (boolean)true);
                break;
            }
            case 12: {
                configShadowClipFrustrum = Config.parseBoolean((String)str, (boolean)true);
                break;
            }
            case 13: {
                configTexMinFilB = Config.parseInt((String)str, (int)0);
                break;
            }
            case 14: {
                configTexMinFilN = Config.parseInt((String)str, (int)0);
                break;
            }
            case 15: {
                configTexMinFilS = Config.parseInt((String)str, (int)0);
                break;
            }
            case 16: {
                configTexMagFilB = Config.parseInt((String)str, (int)0);
                break;
            }
            case 17: {
                configTexMagFilB = Config.parseInt((String)str, (int)0);
                break;
            }
            case 18: {
                configTexMagFilB = Config.parseInt((String)str, (int)0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown option: " + eso2);
            }
        }
    }

    public static void storeConfig() {
        SMCLog.info((String)"Save shaders configuration.");
        if (shadersConfig == null) {
            shadersConfig = new PropertiesOrdered();
        }
        EnumShaderOption[] ops = EnumShaderOption.values();
        for (int i2 = 0; i2 < ops.length; ++i2) {
            EnumShaderOption op = ops[i2];
            String key = op.getPropertyKey();
            String val = Shaders.getEnumShaderOption((EnumShaderOption)op);
            shadersConfig.setProperty(key, val);
        }
        try {
            FileWriter writer = new FileWriter(configFile);
            shadersConfig.store(writer, null);
            writer.close();
        }
        catch (Exception ex) {
            SMCLog.severe((String)("Error saving configuration: " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    public static String getEnumShaderOption(EnumShaderOption eso2) {
        switch (1.$SwitchMap$net$optifine$shaders$config$EnumShaderOption[eso2.ordinal()]) {
            case 1: {
                return Integer.toString(configAntialiasingLevel);
            }
            case 2: {
                return Boolean.toString(configNormalMap);
            }
            case 3: {
                return Boolean.toString(configSpecularMap);
            }
            case 4: {
                return Float.toString(configRenderResMul);
            }
            case 5: {
                return Float.toString(configShadowResMul);
            }
            case 6: {
                return Float.toString(configHandDepthMul);
            }
            case 7: {
                return Boolean.toString(configCloudShadow);
            }
            case 8: {
                return configOldHandLight.getPropertyValue();
            }
            case 9: {
                return configOldLighting.getPropertyValue();
            }
            case 10: {
                return currentShaderName;
            }
            case 11: {
                return Boolean.toString(configTweakBlockDamage);
            }
            case 12: {
                return Boolean.toString(configShadowClipFrustrum);
            }
            case 13: {
                return Integer.toString(configTexMinFilB);
            }
            case 14: {
                return Integer.toString(configTexMinFilN);
            }
            case 15: {
                return Integer.toString(configTexMinFilS);
            }
            case 16: {
                return Integer.toString(configTexMagFilB);
            }
            case 17: {
                return Integer.toString(configTexMagFilB);
            }
            case 18: {
                return Integer.toString(configTexMagFilB);
            }
        }
        throw new IllegalArgumentException("Unknown option: " + eso2);
    }

    public static void setShaderPack(String par1name) {
        currentShaderName = par1name;
        shadersConfig.setProperty(EnumShaderOption.SHADER_PACK.getPropertyKey(), par1name);
        Shaders.loadShaderPack();
    }

    public static void loadShaderPack() {
        boolean oldLightingChanged;
        boolean shaderPackLoadedPrev = shaderPackLoaded;
        boolean oldLightingPrev = Shaders.isOldLighting();
        if (Shaders.mc.f != null) {
            Shaders.mc.f.pauseChunkUpdates();
        }
        shaderPackLoaded = false;
        if (shaderPack != null) {
            shaderPack.close();
            shaderPack = null;
            shaderPackResources.clear();
            shaderPackDimensions.clear();
            shaderPackOptions = null;
            shaderPackOptionSliders = null;
            shaderPackProfiles = null;
            shaderPackGuiScreens = null;
            shaderPackProgramConditions.clear();
            shaderPackClouds.resetValue();
            shaderPackOldHandLight.resetValue();
            shaderPackDynamicHandLight.resetValue();
            shaderPackOldLighting.resetValue();
            Shaders.resetCustomTextures();
            noiseTexturePath = null;
        }
        boolean shadersBlocked = false;
        if (Config.isAntialiasing()) {
            SMCLog.info((String)("Shaders can not be loaded, Antialiasing is enabled: " + Config.getAntialiasingLevel() + "x"));
            shadersBlocked = true;
        }
        if (Config.isGraphicsFabulous()) {
            SMCLog.info((String)"Shaders can not be loaded, Fabulous Graphics is enabled.");
            shadersBlocked = true;
        }
        String packName = shadersConfig.getProperty(EnumShaderOption.SHADER_PACK.getPropertyKey(), "(internal)");
        if (!shadersBlocked) {
            shaderPack = Shaders.getShaderPack((String)packName);
            boolean bl = shaderPackLoaded = shaderPack != null;
        }
        if (shaderPackLoaded) {
            SMCLog.info((String)("Loaded shaderpack: " + Shaders.getShaderPackName()));
        } else {
            SMCLog.info((String)"No shaderpack loaded.");
            shaderPack = new ShaderPackNone();
        }
        if (saveFinalShaders) {
            Shaders.clearDirectory((File)new File(shaderPacksDir, "debug"));
        }
        Shaders.loadShaderPackResources();
        Shaders.loadShaderPackDimensions();
        shaderPackOptions = Shaders.loadShaderPackOptions();
        Shaders.loadShaderPackFixedProperties();
        Shaders.loadShaderPackDynamicProperties();
        boolean formatChanged = shaderPackLoaded != shaderPackLoadedPrev;
        boolean bl = oldLightingChanged = Shaders.isOldLighting() != oldLightingPrev;
        if (formatChanged || oldLightingChanged) {
            eih.updateVertexFormats();
            Shaders.updateBlockLightLevel();
        }
        if (mc.Y() != null) {
            CustomBlockLayers.update();
        }
        if (Shaders.mc.f != null) {
            Shaders.mc.f.resumeChunkUpdates();
        }
        if ((formatChanged || oldLightingChanged) && mc.Y() != null) {
            mc.O();
        }
    }

    public static IShaderPack getShaderPack(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).isEmpty() || name.equals("OFF")) {
            return null;
        }
        if (name.equals("(internal)")) {
            return new ShaderPackDefault();
        }
        try {
            File packFile = new File(shaderPacksDir, name);
            if (packFile.isDirectory()) {
                return new ShaderPackFolder(name, packFile);
            }
            if (packFile.isFile() && name.toLowerCase().endsWith(".zip")) {
                return new ShaderPackZip(name, packFile);
            }
            return null;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static IShaderPack getShaderPack() {
        return shaderPack;
    }

    private static void loadShaderPackDimensions() {
        shaderPackDimensions.clear();
        for (int i2 = -128; i2 <= 128; ++i2) {
            String worldDir = "/shaders/world" + i2;
            if (!shaderPack.hasDirectory(worldDir)) continue;
            shaderPackDimensions.add(i2);
        }
        if (shaderPackDimensions.size() > 0) {
            Object[] ids = shaderPackDimensions.toArray(new Integer[shaderPackDimensions.size()]);
            Config.dbg((String)("[Shaders] Worlds: " + Config.arrayToString((Object[])ids)));
        }
    }

    private static void loadShaderPackFixedProperties() {
        shaderPackOldLighting.resetValue();
        shaderPackSeparateAo.resetValue();
        if (shaderPack == null) {
            return;
        }
        String path = "/shaders/shaders.properties";
        try {
            InputStream in2 = shaderPack.getResourceAsStream(path);
            if (in2 == null) {
                return;
            }
            in2 = MacroProcessor.process((InputStream)in2, (String)path, (boolean)false);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in2);
            in2.close();
            shaderPackOldLighting.loadFrom((Properties)props);
            shaderPackSeparateAo.loadFrom((Properties)props);
            shaderPackOptionSliders = ShaderPackParser.parseOptionSliders((Properties)props, (ShaderOption[])shaderPackOptions);
            shaderPackProfiles = ShaderPackParser.parseProfiles((Properties)props, (ShaderOption[])shaderPackOptions);
            shaderPackGuiScreens = ShaderPackParser.parseGuiScreens((Properties)props, (ShaderProfile[])shaderPackProfiles, (ShaderOption[])shaderPackOptions);
        }
        catch (IOException e2) {
            Config.warn((String)("[Shaders] Error reading: " + path));
        }
    }

    private static void loadShaderPackDynamicProperties() {
        shaderPackClouds.resetValue();
        shaderPackOldHandLight.resetValue();
        shaderPackDynamicHandLight.resetValue();
        shaderPackShadowTerrain.resetValue();
        shaderPackShadowTranslucent.resetValue();
        shaderPackShadowEntities.resetValue();
        shaderPackShadowBlockEntities.resetValue();
        shaderPackUnderwaterOverlay.resetValue();
        shaderPackSun.resetValue();
        shaderPackMoon.resetValue();
        shaderPackVignette.resetValue();
        shaderPackBackFaceSolid.resetValue();
        shaderPackBackFaceCutout.resetValue();
        shaderPackBackFaceCutoutMipped.resetValue();
        shaderPackBackFaceTranslucent.resetValue();
        shaderPackRainDepth.resetValue();
        shaderPackBeaconBeamDepth.resetValue();
        shaderPackFrustumCulling.resetValue();
        shaderPackShadowCulling.resetValue();
        shaderPackParticlesBeforeDeferred.resetValue();
        BlockAliases.reset();
        ItemAliases.reset();
        EntityAliases.reset();
        customUniforms = null;
        for (int i2 = 0; i2 < ProgramsAll.length; ++i2) {
            Program p2 = ProgramsAll[i2];
            p2.resetProperties();
        }
        Arrays.fill(colorBufferSizes, null);
        if (shaderPack == null) {
            return;
        }
        BlockAliases.update((IShaderPack)shaderPack);
        ItemAliases.update((IShaderPack)shaderPack);
        EntityAliases.update((IShaderPack)shaderPack);
        String path = "/shaders/shaders.properties";
        try {
            InputStream in2 = shaderPack.getResourceAsStream(path);
            if (in2 == null) {
                return;
            }
            in2 = MacroProcessor.process((InputStream)in2, (String)path, (boolean)true);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in2);
            in2.close();
            shaderPackClouds.loadFrom((Properties)props);
            shaderPackOldHandLight.loadFrom((Properties)props);
            shaderPackDynamicHandLight.loadFrom((Properties)props);
            shaderPackShadowTerrain.loadFrom((Properties)props);
            shaderPackShadowTranslucent.loadFrom((Properties)props);
            shaderPackShadowEntities.loadFrom((Properties)props);
            shaderPackShadowBlockEntities.loadFrom((Properties)props);
            shaderPackUnderwaterOverlay.loadFrom((Properties)props);
            shaderPackSun.loadFrom((Properties)props);
            shaderPackVignette.loadFrom((Properties)props);
            shaderPackMoon.loadFrom((Properties)props);
            shaderPackBackFaceSolid.loadFrom((Properties)props);
            shaderPackBackFaceCutout.loadFrom((Properties)props);
            shaderPackBackFaceCutoutMipped.loadFrom((Properties)props);
            shaderPackBackFaceTranslucent.loadFrom((Properties)props);
            shaderPackRainDepth.loadFrom((Properties)props);
            shaderPackBeaconBeamDepth.loadFrom((Properties)props);
            shaderPackFrustumCulling.loadFrom((Properties)props);
            shaderPackShadowCulling.loadFrom((Properties)props);
            shaderPackParticlesBeforeDeferred.loadFrom((Properties)props);
            shaderPackProgramConditions = ShaderPackParser.parseProgramConditions((Properties)props, (ShaderOption[])shaderPackOptions);
            customTexturesGbuffers = Shaders.loadCustomTextures((Properties)props, (ProgramStage)ProgramStage.GBUFFERS);
            customTexturesComposite = Shaders.loadCustomTextures((Properties)props, (ProgramStage)ProgramStage.COMPOSITE);
            customTexturesDeferred = Shaders.loadCustomTextures((Properties)props, (ProgramStage)ProgramStage.DEFERRED);
            customTexturesShadowcomp = Shaders.loadCustomTextures((Properties)props, (ProgramStage)ProgramStage.SHADOWCOMP);
            customTexturesPrepare = Shaders.loadCustomTextures((Properties)props, (ProgramStage)ProgramStage.PREPARE);
            noiseTexturePath = props.getProperty("texture.noise");
            if (noiseTexturePath != null) {
                noiseTextureEnabled = true;
            }
            customUniforms = ShaderPackParser.parseCustomUniforms((Properties)props);
            ShaderPackParser.parseAlphaStates((Properties)props);
            ShaderPackParser.parseBlendStates((Properties)props);
            ShaderPackParser.parseRenderScales((Properties)props);
            ShaderPackParser.parseBuffersFlip((Properties)props);
            colorBufferSizes = ShaderPackParser.parseBufferSizes((Properties)props, (int)16);
        }
        catch (IOException e2) {
            Config.warn((String)("[Shaders] Error reading: " + path));
        }
    }

    private static ICustomTexture[] loadCustomTextures(Properties props, ProgramStage stage) {
        String PREFIX_TEXTURE = "texture." + stage.getName() + ".";
        Set<Object> keys = props.keySet();
        ArrayList<ICustomTexture> list = new ArrayList<ICustomTexture>();
        for (String string : keys) {
            if (!string.startsWith(PREFIX_TEXTURE)) continue;
            String name = StrUtils.removePrefix((String)string, (String)PREFIX_TEXTURE);
            name = StrUtils.removeSuffix((String)name, (String[])new String[]{".0", ".1", ".2", ".3", ".4", ".5", ".6", ".7", ".8", ".9"});
            String path = props.getProperty(string).trim();
            int index = Shaders.getTextureIndex((ProgramStage)stage, (String)name);
            if (index < 0) {
                SMCLog.warning((String)("Invalid texture name: " + string));
                continue;
            }
            ICustomTexture ct = Shaders.loadCustomTexture((int)index, (String)path);
            if (ct == null) continue;
            SMCLog.info((String)("Custom texture: " + string + " = " + path));
            list.add(ct);
        }
        if (list.size() <= 0) {
            return null;
        }
        ICustomTexture[] cts = list.toArray(new ICustomTexture[list.size()]);
        return cts;
    }

    private static ICustomTexture loadCustomTexture(int textureUnit, String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.trim()).indexOf(58) >= 0) {
            return Shaders.loadCustomTextureLocation((int)textureUnit, (String)path);
        }
        if (path.indexOf(32) >= 0) {
            return Shaders.loadCustomTextureRaw((int)textureUnit, (String)path);
        }
        return Shaders.loadCustomTextureShaders((int)textureUnit, (String)path);
    }

    private static ICustomTexture loadCustomTextureLocation(int textureUnit, String path) {
        String pathFull = path.trim();
        int variant = 0;
        if (pathFull.startsWith("minecraft:textures/")) {
            if ((pathFull = StrUtils.addSuffixCheck((String)pathFull, (String)".png")).endsWith("_n.png")) {
                pathFull = StrUtils.replaceSuffix((String)pathFull, (String)"_n.png", (String)".png");
                variant = 1;
            } else if (pathFull.endsWith("_s.png")) {
                pathFull = StrUtils.replaceSuffix((String)pathFull, (String)"_s.png", (String)".png");
                variant = 2;
            }
        }
        if (pathFull.startsWith("minecraft:dynamic/lightmap_")) {
            pathFull = pathFull.replace("lightmap", "light_map");
        }
        acq loc = new acq(pathFull);
        CustomTextureLocation ctv = new CustomTextureLocation(textureUnit, loc, variant);
        return ctv;
    }

    private static void reloadCustomTexturesLocation(ICustomTexture[] cts) {
        if (cts == null) {
            return;
        }
        for (int i2 = 0; i2 < cts.length; ++i2) {
            ICustomTexture ct = cts[i2];
            if (!(ct instanceof CustomTextureLocation)) continue;
            CustomTextureLocation ctl2 = (CustomTextureLocation)ct;
            ctl2.reloadTexture();
        }
    }

    private static ICustomTexture loadCustomTextureRaw(int textureUnit, String line) {
        ConnectedParser cp = new ConnectedParser("Shaders");
        String[] parts = Config.tokenize((String)line, (String)" ");
        ArrayDeque<String> params = new ArrayDeque<String>(Arrays.asList(parts));
        String path = (String)params.poll();
        TextureType type = (TextureType)cp.parseEnum((String)params.poll(), (Enum[])TextureType.values(), "texture type");
        if (type == null) {
            SMCLog.warning((String)("Invalid raw texture type: " + line));
            return null;
        }
        InternalFormat internalFormat = (InternalFormat)cp.parseEnum((String)params.poll(), (Enum[])InternalFormat.values(), "internal format");
        if (internalFormat == null) {
            SMCLog.warning((String)("Invalid raw texture internal format: " + line));
            return null;
        }
        int width = 0;
        int height = 0;
        int depth = 0;
        switch (1.$SwitchMap$net$optifine$texture$TextureType[type.ordinal()]) {
            case 1: {
                width = cp.parseInt((String)params.poll(), -1);
                break;
            }
            case 2: {
                width = cp.parseInt((String)params.poll(), -1);
                height = cp.parseInt((String)params.poll(), -1);
                break;
            }
            case 3: {
                width = cp.parseInt((String)params.poll(), -1);
                height = cp.parseInt((String)params.poll(), -1);
                depth = cp.parseInt((String)params.poll(), -1);
                break;
            }
            case 4: {
                width = cp.parseInt((String)params.poll(), -1);
                height = cp.parseInt((String)params.poll(), -1);
                break;
            }
            default: {
                SMCLog.warning((String)("Invalid raw texture type: " + type));
                return null;
            }
        }
        if (width < 0 || height < 0 || depth < 0) {
            SMCLog.warning((String)("Invalid raw texture size: " + line));
            return null;
        }
        PixelFormat pixelFormat = (PixelFormat)cp.parseEnum((String)params.poll(), (Enum[])PixelFormat.values(), "pixel format");
        if (pixelFormat == null) {
            SMCLog.warning((String)("Invalid raw texture pixel format: " + line));
            return null;
        }
        PixelType pixelType = (PixelType)cp.parseEnum((String)params.poll(), (Enum[])PixelType.values(), "pixel type");
        if (pixelType == null) {
            SMCLog.warning((String)("Invalid raw texture pixel type: " + line));
            return null;
        }
        if (!params.isEmpty()) {
            SMCLog.warning((String)("Invalid raw texture, too many parameters: " + line));
            return null;
        }
        return Shaders.loadCustomTextureRaw((int)textureUnit, (String)line, (String)path, (TextureType)type, (InternalFormat)internalFormat, (int)width, (int)height, (int)depth, (PixelFormat)pixelFormat, (PixelType)pixelType);
    }

    private static ICustomTexture loadCustomTextureRaw(int textureUnit, String line, String path, TextureType type, InternalFormat internalFormat, int width, int height, int depth, PixelFormat pixelFormat, PixelType pixelType) {
        try {
            String pathFull = "shaders/" + StrUtils.removePrefix((String)path, (String)"/");
            InputStream in2 = shaderPack.getResourceAsStream(pathFull);
            if (in2 == null) {
                SMCLog.warning((String)("Raw texture not found: " + path));
                return null;
            }
            byte[] bytes = Config.readAll((InputStream)in2);
            IOUtils.closeQuietly((InputStream)in2);
            ByteBuffer bb = ehh.a((int)bytes.length);
            bb.put(bytes);
            bb.flip();
            fwn tms = SimpleShaderTexture.loadTextureMetadataSection((String)pathFull, (fwn)new fwn(true, true));
            CustomTextureRaw ctr = new CustomTextureRaw(type, internalFormat, width, height, depth, pixelFormat, pixelType, bb, textureUnit, tms.a(), tms.b());
            return ctr;
        }
        catch (IOException e2) {
            SMCLog.warning((String)("Error loading raw texture: " + path));
            SMCLog.warning((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
    }

    private static ICustomTexture loadCustomTextureShaders(int textureUnit, String path) {
        if (((String)(path = ((String)path).trim())).indexOf(46) < 0) {
            path = (String)path + ".png";
        }
        try {
            String pathFull = "shaders/" + StrUtils.removePrefix((String)path, (String)"/");
            InputStream in2 = shaderPack.getResourceAsStream(pathFull);
            if (in2 == null) {
                SMCLog.warning((String)("Texture not found: " + (String)path));
                return null;
            }
            IOUtils.closeQuietly((InputStream)in2);
            SimpleShaderTexture tex = new SimpleShaderTexture(pathFull);
            tex.a(mc.Y());
            CustomTexture ct = new CustomTexture(textureUnit, pathFull, (fug)tex);
            return ct;
        }
        catch (IOException e2) {
            SMCLog.warning((String)("Error loading texture: " + (String)path));
            SMCLog.warning((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
    }

    private static int getTextureIndex(ProgramStage stage, String name) {
        int colortexIndex;
        if (stage == ProgramStage.GBUFFERS) {
            colortexIndex = ShaderParser.getIndex((String)name, (String)"colortex", (int)4, (int)15);
            if (colortexIndex >= 0) {
                return colorTextureImageUnit[colortexIndex];
            }
            if (name.equals("texture")) {
                return 0;
            }
            if (name.equals("lightmap")) {
                return 1;
            }
            if (name.equals("normals")) {
                return 2;
            }
            if (name.equals("specular")) {
                return 3;
            }
            if (name.equals("shadowtex0") || name.equals("watershadow")) {
                return 4;
            }
            if (name.equals("shadow")) {
                return waterShadowEnabled ? 5 : 4;
            }
            if (name.equals("shadowtex1")) {
                return 5;
            }
            if (name.equals("depthtex0")) {
                return 6;
            }
            if (name.equals("gaux1")) {
                return 7;
            }
            if (name.equals("gaux2")) {
                return 8;
            }
            if (name.equals("gaux3")) {
                return 9;
            }
            if (name.equals("gaux4")) {
                return 10;
            }
            if (name.equals("depthtex1")) {
                return 12;
            }
            if (name.equals("shadowcolor0") || name.equals("shadowcolor")) {
                return 13;
            }
            if (name.equals("shadowcolor1")) {
                return 14;
            }
            if (name.equals("noisetex")) {
                return 15;
            }
        }
        if (stage.isAnyComposite()) {
            colortexIndex = ShaderParser.getIndex((String)name, (String)"colortex", (int)0, (int)15);
            if (colortexIndex >= 0) {
                return colorTextureImageUnit[colortexIndex];
            }
            if (name.equals("colortex0")) {
                return 0;
            }
            if (name.equals("gdepth")) {
                return 1;
            }
            if (name.equals("gnormal")) {
                return 2;
            }
            if (name.equals("composite")) {
                return 3;
            }
            if (name.equals("shadowtex0") || name.equals("watershadow")) {
                return 4;
            }
            if (name.equals("shadow")) {
                return waterShadowEnabled ? 5 : 4;
            }
            if (name.equals("shadowtex1")) {
                return 5;
            }
            if (name.equals("depthtex0") || name.equals("gdepthtex")) {
                return 6;
            }
            if (name.equals("gaux1")) {
                return 7;
            }
            if (name.equals("gaux2")) {
                return 8;
            }
            if (name.equals("gaux3")) {
                return 9;
            }
            if (name.equals("gaux4")) {
                return 10;
            }
            if (name.equals("depthtex1")) {
                return 11;
            }
            if (name.equals("depthtex2")) {
                return 12;
            }
            if (name.equals("shadowcolor0") || name.equals("shadowcolor")) {
                return 13;
            }
            if (name.equals("shadowcolor1")) {
                return 14;
            }
            if (name.equals("noisetex")) {
                return 15;
            }
        }
        return -1;
    }

    private static void bindCustomTextures(ICustomTexture[] cts) {
        if (cts == null) {
            return;
        }
        for (int i2 = 0; i2 < cts.length; ++i2) {
            ICustomTexture ct = cts[i2];
            GlStateManager._activeTexture((int)(33984 + ct.getTextureUnit()));
            int texId = ct.getTextureId();
            int target = ct.getTarget();
            if (target == 3553) {
                GlStateManager._bindTexture((int)texId);
                continue;
            }
            GL11.glBindTexture((int)target, (int)texId);
        }
        GlStateManager._activeTexture((int)33984);
    }

    private static void resetCustomTextures() {
        Shaders.deleteCustomTextures((ICustomTexture[])customTexturesGbuffers);
        Shaders.deleteCustomTextures((ICustomTexture[])customTexturesComposite);
        Shaders.deleteCustomTextures((ICustomTexture[])customTexturesDeferred);
        Shaders.deleteCustomTextures((ICustomTexture[])customTexturesShadowcomp);
        Shaders.deleteCustomTextures((ICustomTexture[])customTexturesPrepare);
        customTexturesGbuffers = null;
        customTexturesComposite = null;
        customTexturesDeferred = null;
        customTexturesShadowcomp = null;
        customTexturesPrepare = null;
    }

    private static void deleteCustomTextures(ICustomTexture[] cts) {
        if (cts == null) {
            return;
        }
        for (int i2 = 0; i2 < cts.length; ++i2) {
            ICustomTexture ct = cts[i2];
            ct.deleteTexture();
        }
    }

    public static ShaderOption[] getShaderPackOptions(String screenName) {
        Object[] ops = (ShaderOption[])shaderPackOptions.clone();
        if (shaderPackGuiScreens == null) {
            if (shaderPackProfiles != null) {
                ShaderOptionProfile optionProfile = new ShaderOptionProfile(shaderPackProfiles, (ShaderOption[])ops);
                ops = (ShaderOption[])Config.addObjectToArray((Object[])ops, (Object)optionProfile, (int)0);
            }
            ops = Shaders.getVisibleOptions((ShaderOption[])ops);
            return ops;
        }
        Object key = screenName != null ? "screen." + screenName : "screen";
        ScreenShaderOptions sso = (ScreenShaderOptions)shaderPackGuiScreens.get(key);
        if (sso == null) {
            return new ShaderOption[0];
        }
        ShaderOption[] sos = sso.getShaderOptions();
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        for (int i2 = 0; i2 < sos.length; ++i2) {
            ShaderOption so = sos[i2];
            if (so == null) {
                list.add(null);
                continue;
            }
            if (so instanceof ShaderOptionRest) {
                ShaderOption[] restOps = Shaders.getShaderOptionsRest((Map)shaderPackGuiScreens, (ShaderOption[])ops);
                list.addAll(Arrays.asList(restOps));
                continue;
            }
            list.add(so);
        }
        ShaderOption[] sosExp = list.toArray(new ShaderOption[list.size()]);
        return sosExp;
    }

    public static int getShaderPackColumns(String screenName, int def) {
        Object key;
        Object object = key = screenName != null ? "screen." + screenName : "screen";
        if (shaderPackGuiScreens == null) {
            return def;
        }
        ScreenShaderOptions sso = (ScreenShaderOptions)shaderPackGuiScreens.get(key);
        if (sso == null) {
            return def;
        }
        return sso.getColumns();
    }

    private static ShaderOption[] getShaderOptionsRest(Map<String, ScreenShaderOptions> mapScreens, ShaderOption[] ops) {
        HashSet<String> setNames = new HashSet<String>();
        Set<String> keys = mapScreens.keySet();
        for (String key : keys) {
            ScreenShaderOptions sso = mapScreens.get(key);
            ShaderOption[] sos = sso.getShaderOptions();
            for (int v2 = 0; v2 < sos.length; ++v2) {
                ShaderOption so = sos[v2];
                if (so == null) continue;
                setNames.add(so.getName());
            }
        }
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        for (int i2 = 0; i2 < ops.length; ++i2) {
            String name;
            ShaderOption so = ops[i2];
            if (!so.isVisible() || setNames.contains(name = so.getName())) continue;
            list.add(so);
        }
        ShaderOption[] sos = list.toArray(new ShaderOption[list.size()]);
        return sos;
    }

    public static ShaderOption getShaderOption(String name) {
        return ShaderUtils.getShaderOption((String)name, (ShaderOption[])shaderPackOptions);
    }

    public static ShaderOption[] getShaderPackOptions() {
        return shaderPackOptions;
    }

    public static boolean isShaderPackOptionSlider(String name) {
        if (shaderPackOptionSliders == null) {
            return false;
        }
        return shaderPackOptionSliders.contains(name);
    }

    private static ShaderOption[] getVisibleOptions(ShaderOption[] ops) {
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        for (int i2 = 0; i2 < ops.length; ++i2) {
            ShaderOption so = ops[i2];
            if (!so.isVisible()) continue;
            list.add(so);
        }
        ShaderOption[] sos = list.toArray(new ShaderOption[list.size()]);
        return sos;
    }

    public static void saveShaderPackOptions() {
        Shaders.saveShaderPackOptions((ShaderOption[])shaderPackOptions, (IShaderPack)shaderPack);
    }

    private static void saveShaderPackOptions(ShaderOption[] sos, IShaderPack sp) {
        PropertiesOrdered props = new PropertiesOrdered();
        if (shaderPackOptions != null) {
            for (int i2 = 0; i2 < sos.length; ++i2) {
                ShaderOption so = sos[i2];
                if (!so.isChanged() || !so.isEnabled()) continue;
                props.setProperty(so.getName(), so.getValue());
            }
        }
        try {
            Shaders.saveOptionProperties((IShaderPack)sp, (Properties)props);
        }
        catch (IOException e2) {
            Config.warn((String)("[Shaders] Error saving configuration for " + shaderPack.getName()));
            e2.printStackTrace();
        }
    }

    private static void saveOptionProperties(IShaderPack sp, Properties props) throws IOException {
        String path = "shaderpacks/" + sp.getName() + ".txt";
        File propFile = new File(enn.N().p, path);
        if (props.isEmpty()) {
            propFile.delete();
            return;
        }
        FileOutputStream fos2 = new FileOutputStream(propFile);
        props.store(fos2, null);
        fos2.flush();
        fos2.close();
    }

    private static ShaderOption[] loadShaderPackOptions() {
        try {
            String[] programNames = programs.getProgramNames();
            Properties props = Shaders.loadOptionProperties((IShaderPack)shaderPack);
            ShaderOption[] sos = ShaderPackParser.parseShaderPackOptions((IShaderPack)shaderPack, (String[])programNames, (List)shaderPackDimensions);
            for (int i2 = 0; i2 < sos.length; ++i2) {
                ShaderOption so = sos[i2];
                String val = props.getProperty(so.getName());
                if (val == null) continue;
                so.resetValue();
                if (so.setValue(val)) continue;
                Config.warn((String)("[Shaders] Invalid value, option: " + so.getName() + ", value: " + val));
            }
            return sos;
        }
        catch (IOException e2) {
            Config.warn((String)("[Shaders] Error reading configuration for " + shaderPack.getName()));
            e2.printStackTrace();
            return null;
        }
    }

    private static Properties loadOptionProperties(IShaderPack sp) throws IOException {
        PropertiesOrdered props = new PropertiesOrdered();
        String path = "shaderpacks/" + sp.getName() + ".txt";
        File propFile = new File(enn.N().p, path);
        if (!(propFile.exists() && propFile.isFile() && propFile.canRead())) {
            return props;
        }
        FileInputStream fis2 = new FileInputStream(propFile);
        props.load(fis2);
        fis2.close();
        return props;
    }

    public static ShaderOption[] getChangedOptions(ShaderOption[] ops) {
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        for (int i2 = 0; i2 < ops.length; ++i2) {
            ShaderOption op = ops[i2];
            if (!op.isEnabled() || !op.isChanged()) continue;
            list.add(op);
        }
        ShaderOption[] cops = list.toArray(new ShaderOption[list.size()]);
        return cops;
    }

    public static ArrayList listOfShaders() {
        ArrayList<String> listDir = new ArrayList<String>();
        ArrayList<String> listZip = new ArrayList<String>();
        try {
            if (!shaderPacksDir.exists()) {
                shaderPacksDir.mkdir();
            }
            File[] listOfFiles = shaderPacksDir.listFiles();
            for (int i2 = 0; i2 < listOfFiles.length; ++i2) {
                File file = listOfFiles[i2];
                String name = file.getName();
                if (file.isDirectory()) {
                    File subDir;
                    if (name.equals("debug") || !(subDir = new File(file, "shaders")).exists() || !subDir.isDirectory()) continue;
                    listDir.add(name);
                    continue;
                }
                if (!file.isFile() || !name.toLowerCase().endsWith(".zip")) continue;
                listZip.add(name);
            }
        }
        catch (Exception listOfFiles) {
            // empty catch block
        }
        Collections.sort(listDir, String.CASE_INSENSITIVE_ORDER);
        Collections.sort(listZip, String.CASE_INSENSITIVE_ORDER);
        ArrayList<String> list = new ArrayList<String>();
        list.add("OFF");
        list.add("(internal)");
        list.addAll(listDir);
        list.addAll(listZip);
        return list;
    }

    public static int checkFramebufferStatus(String location) {
        int status = GL43.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            SMCLog.severe((String)"FramebufferStatus 0x%04X at '%s'", (Object[])new Object[]{status, location});
        }
        return status;
    }

    public static int checkGLError(String location) {
        int errorCode = GlStateManager._getError();
        if (errorCode != 0 && GlErrors.isEnabled((int)errorCode)) {
            String errorText = Config.getGlErrorString((int)errorCode);
            String shadersInfo = Shaders.getErrorInfo((int)errorCode, (String)location);
            String messageLog = String.format("OpenGL error: %s (%s)%s, at: %s", errorCode, errorText, shadersInfo, location);
            SMCLog.severe((String)messageLog);
            if (Config.isShowGlErrors() && TimedEvent.isActive((String)"ShowGlErrorShaders", (long)10000L)) {
                String messageChat = fvz.a((String)"of.message.openglError", (Object[])new Object[]{errorCode, errorText});
                Shaders.printChat((String)messageChat);
            }
        }
        return errorCode;
    }

    private static String getErrorInfo(int errorCode, String location) {
        String programName;
        StringBuilder sb = new StringBuilder();
        if (errorCode == 1286) {
            int statusCode = GL43.glCheckFramebufferStatus((int)36160);
            String statusText = Shaders.getFramebufferStatusText((int)statusCode);
            String info = ", fbStatus: " + statusCode + " (" + statusText + ")";
            sb.append(info);
        }
        if ((programName = activeProgram.getName()).isEmpty()) {
            programName = "none";
        }
        sb.append(", program: " + programName);
        Program activeProgramReal = Shaders.getProgramById((int)activeProgramID);
        if (activeProgramReal != activeProgram) {
            String programRealName = activeProgramReal.getName();
            if (programRealName.isEmpty()) {
                programRealName = "none";
            }
            sb.append(" (" + programRealName + ")");
        }
        if (location.equals("setDrawBuffers")) {
            sb.append(", drawBuffers: " + ArrayUtils.arrayToString((Object[])activeProgram.getDrawBufSettings()));
        }
        return sb.toString();
    }

    private static Program getProgramById(int programID) {
        for (int i2 = 0; i2 < ProgramsAll.length; ++i2) {
            Program pi = ProgramsAll[i2];
            if (pi.getId() != programID) continue;
            return pi;
        }
        return ProgramNone;
    }

    private static String getFramebufferStatusText(int fbStatusCode) {
        switch (fbStatusCode) {
            case 36053: {
                return "Complete";
            }
            case 33305: {
                return "Undefined";
            }
            case 36054: {
                return "Incomplete attachment";
            }
            case 36055: {
                return "Incomplete missing attachment";
            }
            case 36059: {
                return "Incomplete draw buffer";
            }
            case 36060: {
                return "Incomplete read buffer";
            }
            case 36061: {
                return "Unsupported";
            }
            case 36182: {
                return "Incomplete multisample";
            }
            case 36264: {
                return "Incomplete layer targets";
            }
        }
        return "Unknown";
    }

    private static void printChat(String str) {
        Shaders.mc.l.d().a((sw)sw.b((String)str));
    }

    public static void printChatAndLogError(String str) {
        SMCLog.severe((String)str);
        Shaders.mc.l.d().a((sw)sw.b((String)str));
    }

    public static void printIntBuffer(String title, IntBuffer buf) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(title).append(" [pos ").append(buf.position()).append(" lim ").append(buf.limit()).append(" cap ").append(buf.capacity()).append(" :");
        int lim = buf.limit();
        for (int i2 = 0; i2 < lim; ++i2) {
            sb.append(" ").append(buf.get(i2));
        }
        sb.append("]");
        SMCLog.info((String)sb.toString());
    }

    public static void startup(enn mc) {
        Shaders.checkShadersModInstalled();
        Shaders.mc = mc;
        mc = enn.N();
        capabilities = GL.getCapabilities();
        glVersionString = GL11.glGetString((int)7938);
        glVendorString = GL11.glGetString((int)7936);
        glRendererString = GL11.glGetString((int)7937);
        SMCLog.info((String)("OpenGL Version: " + glVersionString));
        SMCLog.info((String)("Vendor:  " + glVendorString));
        SMCLog.info((String)("Renderer: " + glRendererString));
        SMCLog.info((String)("Capabilities: " + (Shaders.capabilities.OpenGL20 ? " 2.0 " : " - ") + (Shaders.capabilities.OpenGL21 ? " 2.1 " : " - ") + (Shaders.capabilities.OpenGL30 ? " 3.0 " : " - ") + (Shaders.capabilities.OpenGL32 ? " 3.2 " : " - ") + (Shaders.capabilities.OpenGL40 ? " 4.0 " : " - ")));
        SMCLog.info((String)("GL_MAX_DRAW_BUFFERS: " + GL43.glGetInteger((int)34852)));
        SMCLog.info((String)("GL_MAX_COLOR_ATTACHMENTS: " + GL43.glGetInteger((int)36063)));
        SMCLog.info((String)("GL_MAX_TEXTURE_IMAGE_UNITS: " + GL43.glGetInteger((int)34930)));
        hasGlGenMipmap = Shaders.capabilities.OpenGL30;
        boolean bl = glDebugGroups = Boolean.getBoolean("gl.debug.groups") && Shaders.capabilities.GL_KHR_debug;
        if (glDebugGroups) {
            SMCLog.info((String)"glDebugGroups: true");
        }
        Shaders.loadConfig();
    }

    public static void updateBlockLightLevel() {
        if (Shaders.isOldLighting()) {
            blockLightLevel05 = 0.5f;
            blockLightLevel06 = 0.6f;
            blockLightLevel08 = 0.8f;
        } else {
            blockLightLevel05 = 1.0f;
            blockLightLevel06 = 1.0f;
            blockLightLevel08 = 1.0f;
        }
    }

    public static boolean isOldHandLight() {
        if (!configOldHandLight.isDefault()) {
            return configOldHandLight.isTrue();
        }
        if (!shaderPackOldHandLight.isDefault()) {
            return shaderPackOldHandLight.isTrue();
        }
        return true;
    }

    public static boolean isDynamicHandLight() {
        if (!shaderPackDynamicHandLight.isDefault()) {
            return shaderPackDynamicHandLight.isTrue();
        }
        return true;
    }

    public static boolean isOldLighting() {
        if (!configOldLighting.isDefault()) {
            return configOldLighting.isTrue();
        }
        if (!shaderPackOldLighting.isDefault()) {
            return shaderPackOldLighting.isTrue();
        }
        return true;
    }

    public static boolean isRenderShadowTerrain() {
        return !shaderPackShadowTerrain.isFalse();
    }

    public static boolean isRenderShadowTranslucent() {
        return !shaderPackShadowTranslucent.isFalse();
    }

    public static boolean isRenderShadowEntities() {
        return !shaderPackShadowEntities.isFalse();
    }

    public static boolean isRenderShadowBlockEntities() {
        return !shaderPackShadowBlockEntities.isFalse();
    }

    public static boolean isUnderwaterOverlay() {
        return !shaderPackUnderwaterOverlay.isFalse();
    }

    public static boolean isSun() {
        return !shaderPackSun.isFalse();
    }

    public static boolean isMoon() {
        return !shaderPackMoon.isFalse();
    }

    public static boolean isVignette() {
        return !shaderPackVignette.isFalse();
    }

    public static boolean isRenderBackFace(fkf blockLayerIn) {
        if (blockLayerIn == RenderTypes.SOLID) {
            return shaderPackBackFaceSolid.isTrue();
        }
        if (blockLayerIn == RenderTypes.CUTOUT) {
            return shaderPackBackFaceCutout.isTrue();
        }
        if (blockLayerIn == RenderTypes.CUTOUT_MIPPED) {
            return shaderPackBackFaceCutoutMipped.isTrue();
        }
        if (blockLayerIn == RenderTypes.TRANSLUCENT) {
            return shaderPackBackFaceTranslucent.isTrue();
        }
        return false;
    }

    public static boolean isRainDepth() {
        return shaderPackRainDepth.isTrue();
    }

    public static boolean isBeaconBeamDepth() {
        return shaderPackBeaconBeamDepth.isTrue();
    }

    public static boolean isSeparateAo() {
        return shaderPackSeparateAo.isTrue();
    }

    public static boolean isFrustumCulling() {
        return !shaderPackFrustumCulling.isFalse();
    }

    public static boolean isShadowCulling() {
        if (!shaderPackShadowCulling.isDefault()) {
            return shaderPackShadowCulling.isTrue();
        }
        return !hasShadowGeometryShaders && !hasShadowInstancing;
    }

    public static boolean isParticlesBeforeDeferred() {
        return shaderPackParticlesBeforeDeferred.isTrue();
    }

    public static void init() {
        boolean firstInit;
        if (!isInitializedOnce) {
            isInitializedOnce = true;
            firstInit = true;
        } else {
            firstInit = false;
        }
        if (!isShaderPackInitialized) {
            int i2;
            int dimId;
            Shaders.checkGLError((String)"Shaders.init pre");
            if (Shaders.getShaderPackName() != null) {
                // empty if block
            }
            dfbDrawBuffers.position(0).limit(8);
            sfbDrawBuffers.position(0).limit(8);
            usedColorBuffers = 4;
            usedDepthBuffers = 1;
            usedShadowColorBuffers = 0;
            usedShadowDepthBuffers = 0;
            usedColorAttachs = 1;
            usedDrawBuffers = 1;
            bindImageTextures = false;
            Arrays.fill(gbuffersFormat, 6408);
            Arrays.fill(gbuffersClear, true);
            Arrays.fill(gbuffersClearColor, null);
            Arrays.fill(shadowBuffersFormat, 6408);
            Arrays.fill(shadowBuffersClear, true);
            Arrays.fill(shadowBuffersClearColor, null);
            Arrays.fill(shadowHardwareFilteringEnabled, false);
            Arrays.fill(shadowMipmapEnabled, false);
            Arrays.fill(shadowFilterNearest, false);
            Arrays.fill(shadowColorMipmapEnabled, false);
            Arrays.fill(shadowColorFilterNearest, false);
            centerDepthSmoothEnabled = false;
            noiseTextureEnabled = false;
            sunPathRotation = 0.0f;
            shadowIntervalSize = 2.0f;
            shadowMapWidth = 1024;
            shadowMapHeight = 1024;
            spShadowMapWidth = 1024;
            spShadowMapHeight = 1024;
            shadowMapFOV = 90.0f;
            shadowMapHalfPlane = 160.0f;
            shadowMapIsOrtho = true;
            shadowDistanceRenderMul = -1.0f;
            aoLevel = -1.0f;
            useEntityAttrib = false;
            useMidTexCoordAttrib = false;
            useTangentAttrib = false;
            useVelocityAttrib = false;
            waterShadowEnabled = false;
            hasGeometryShaders = false;
            hasShadowGeometryShaders = false;
            hasShadowInstancing = false;
            Shaders.updateBlockLightLevel();
            Smoother.resetValues();
            shaderUniforms.reset();
            if (customUniforms != null) {
                customUniforms.reset();
            }
            ShaderProfile activeProfile = ShaderUtils.detectProfile((ShaderProfile[])shaderPackProfiles, (ShaderOption[])shaderPackOptions, (boolean)false);
            Object worldPrefix = "";
            if (currentWorld != null && shaderPackDimensions.contains(dimId = WorldUtils.getDimensionId((acp)currentWorld.ac()))) {
                worldPrefix = "world" + dimId + "/";
            }
            Shaders.loadShaderPackDynamicProperties();
            int vaoPrev = GL43.glGetInteger((int)34229);
            int vaoTemp = GlStateManager._glGenVertexArrays();
            GlStateManager._glBindVertexArray((int)vaoTemp);
            for (int i3 = 0; i3 < ProgramsAll.length; ++i3) {
                Program p2 = ProgramsAll[i3];
                p2.resetId();
                p2.resetConfiguration();
                if (p2.getProgramStage() == ProgramStage.NONE) continue;
                String programName = p2.getName();
                String programPath = (String)worldPrefix + programName;
                boolean enabled = true;
                if (shaderPackProgramConditions.containsKey(programPath)) {
                    boolean bl = enabled = enabled && ((IExpressionBool)shaderPackProgramConditions.get(programPath)).eval();
                }
                if (activeProfile != null) {
                    boolean bl = enabled = enabled && !activeProfile.isProgramDisabled(programPath);
                }
                if (!enabled) {
                    SMCLog.info((String)("Program disabled: " + programPath));
                    programName = "<disabled>";
                    programPath = (String)worldPrefix + programName;
                }
                String programFullPath = "/shaders/" + programPath;
                String programFullPathVertex = programFullPath + ".vsh";
                String programFullPathGeometry = programFullPath + ".gsh";
                String programFullPathFragment = programFullPath + ".fsh";
                ComputeProgram[] cps = Shaders.setupComputePrograms((Program)p2, (String)"/shaders/", (String)programPath, (String)".csh");
                p2.setComputePrograms(cps);
                Shaders.setupProgram((Program)p2, (String)programFullPathVertex, (String)programFullPathGeometry, (String)programFullPathFragment);
                int pr = p2.getId();
                if (pr > 0) {
                    SMCLog.info((String)("Program loaded: " + programPath));
                }
                Shaders.initDrawBuffers((Program)p2);
                Shaders.initBlendStatesIndexed((Program)p2);
                Shaders.updateToggleBuffers((Program)p2);
                Shaders.updateProgramSize((Program)p2);
            }
            GlStateManager._glBindVertexArray((int)vaoPrev);
            GlStateManager._glDeleteVertexArrays((int)vaoTemp);
            hasDeferredPrograms = ProgramUtils.hasActive((Program[])ProgramsDeferred);
            hasShadowcompPrograms = ProgramUtils.hasActive((Program[])ProgramsShadowcomp);
            hasPreparePrograms = ProgramUtils.hasActive((Program[])ProgramsPrepare);
            usedColorAttachs = usedColorBuffers;
            if (usedShadowDepthBuffers > 0 || usedShadowColorBuffers > 0) {
                hasShadowMap = true;
                usedShadowDepthBuffers = Math.max(usedShadowDepthBuffers, 1);
            }
            shouldSkipDefaultShadow = hasShadowMap;
            SMCLog.info((String)("usedColorBuffers: " + usedColorBuffers));
            SMCLog.info((String)("usedDepthBuffers: " + usedDepthBuffers));
            SMCLog.info((String)("usedShadowColorBuffers: " + usedShadowColorBuffers));
            SMCLog.info((String)("usedShadowDepthBuffers: " + usedShadowDepthBuffers));
            SMCLog.info((String)("usedColorAttachs: " + usedColorAttachs));
            SMCLog.info((String)("usedDrawBuffers: " + usedDrawBuffers));
            SMCLog.info((String)("bindImageTextures: " + bindImageTextures));
            int maxDrawBuffers = GL43.glGetInteger((int)34852);
            if (usedDrawBuffers > maxDrawBuffers) {
                Shaders.printChatAndLogError((String)("[Shaders] Error: Not enough draw buffers, needed: " + usedDrawBuffers + ", available: " + maxDrawBuffers));
                usedDrawBuffers = maxDrawBuffers;
            }
            dfbDrawBuffers.position(0).limit(usedDrawBuffers);
            for (i2 = 0; i2 < usedDrawBuffers; ++i2) {
                dfbDrawBuffers.put(i2, 36064 + i2);
            }
            sfbDrawBuffers.position(0).limit(usedShadowColorBuffers);
            for (i2 = 0; i2 < usedShadowColorBuffers; ++i2) {
                sfbDrawBuffers.put(i2, 36064 + i2);
            }
            for (i2 = 0; i2 < ProgramsAll.length; ++i2) {
                Program pi;
                Program pn;
                for (pn = pi = ProgramsAll[i2]; pn.getId() == 0 && pn.getProgramBackup() != pn; pn = pn.getProgramBackup()) {
                }
                if (pn == pi || pi == ProgramShadow) continue;
                pi.copyFrom(pn);
            }
            Shaders.resize();
            Shaders.resizeShadow();
            if (noiseTextureEnabled) {
                Shaders.setupNoiseTexture();
            }
            if (defaultTexture == null) {
                defaultTexture = ShadersTex.createDefaultTexture();
            }
            eij matrixStack = new eij();
            matrixStack.a(a.d.rotationDegrees(-90.0f));
            Shaders.preCelestialRotate((eij)matrixStack);
            Shaders.postCelestialRotate((eij)matrixStack);
            isShaderPackInitialized = true;
            Shaders.loadEntityDataMap();
            Shaders.resetDisplayLists();
            if (!firstInit) {
                // empty if block
            }
            Shaders.checkGLError((String)"Shaders.init");
        }
    }

    private static void initDrawBuffers(Program p2) {
        String infoGlBuffers;
        int maxDrawBuffers = GL43.glGetInteger((int)34852);
        Arrays.fill(p2.getToggleColorTextures(), false);
        if (p2 == ProgramFinal) {
            p2.setDrawBuffers(null);
            return;
        }
        if (p2.getId() == 0) {
            if (p2 == ProgramShadow) {
                p2.setDrawBuffers(drawBuffersNone);
            } else {
                p2.setDrawBuffers(drawBuffersColorAtt[0]);
            }
            return;
        }
        String[] drawBufSettings = p2.getDrawBufSettings();
        if (drawBufSettings == null) {
            if (p2 != ProgramShadow && p2 != ProgramShadowSolid && p2 != ProgramShadowCutout) {
                p2.setDrawBuffers(dfbDrawBuffers);
                usedDrawBuffers = Math.min(usedColorBuffers, maxDrawBuffers);
                Arrays.fill(p2.getToggleColorTextures(), 0, usedColorBuffers, true);
            } else {
                p2.setDrawBuffers(sfbDrawBuffers);
            }
            return;
        }
        DrawBuffers drawBuffers = p2.getDrawBuffersCustom();
        int numDB = drawBufSettings.length;
        usedDrawBuffers = Math.max(usedDrawBuffers, numDB);
        numDB = Math.min(numDB, maxDrawBuffers);
        p2.setDrawBuffers(drawBuffers);
        drawBuffers.limit(numDB);
        for (int i2 = 0; i2 < numDB; ++i2) {
            int drawBuffer = Shaders.getDrawBuffer((Program)p2, (String)drawBufSettings[i2]);
            drawBuffers.put(i2, drawBuffer);
        }
        String infoBuffers = drawBuffers.getInfo(false);
        if (!Config.equals((Object)infoBuffers, (Object)(infoGlBuffers = drawBuffers.getInfo(true)))) {
            SMCLog.info((String)("Draw buffers: " + infoBuffers + " -> " + infoGlBuffers));
        }
    }

    private static void initBlendStatesIndexed(Program p2) {
        GlBlendState[] blendStatesColorIndexed = p2.getBlendStatesColorIndexed();
        if (blendStatesColorIndexed == null) {
            return;
        }
        for (int i2 = 0; i2 < blendStatesColorIndexed.length; ++i2) {
            GlBlendState blendState = blendStatesColorIndexed[i2];
            if (blendState == null) continue;
            String bufferName = Integer.toHexString(i2).toUpperCase();
            int colAtt = 36064 + i2;
            int drawBufferIndex = p2.getDrawBuffers().indexOf(colAtt);
            if (drawBufferIndex < 0) {
                SMCLog.warning((String)("Blend buffer not used in draw buffers: " + bufferName));
                continue;
            }
            p2.setBlendStateIndexed(drawBufferIndex, blendState);
            SMCLog.info((String)("Blend buffer: " + bufferName));
        }
    }

    private static int getDrawBuffer(Program p2, String str) {
        int drawBuffer = 0;
        int ca = Config.parseInt((String)str, (int)-1);
        if (p2 == ProgramShadow) {
            if (ca >= 0 && ca < 2) {
                drawBuffer = 36064 + ca;
                usedShadowColorBuffers = Math.max(usedShadowColorBuffers, ca + 1);
            }
            return drawBuffer;
        }
        if (ca >= 0 && ca < 16) {
            p2.getToggleColorTextures()[ca] = true;
            drawBuffer = 36064 + ca;
            usedColorAttachs = Math.max(usedColorAttachs, ca + 1);
            usedColorBuffers = Math.max(usedColorBuffers, ca + 1);
        }
        return drawBuffer;
    }

    private static void updateToggleBuffers(Program p2) {
        boolean[] toggleBuffers = p2.getToggleColorTextures();
        Boolean[] flipBuffers = p2.getBuffersFlip();
        for (int i2 = 0; i2 < flipBuffers.length; ++i2) {
            Boolean flip = flipBuffers[i2];
            if (flip == null) continue;
            toggleBuffers[i2] = flip;
        }
    }

    private static void updateProgramSize(Program p2) {
        if (!p2.getProgramStage().isMainComposite()) {
            return;
        }
        DynamicDimension drawSize = null;
        int countFixed = 0;
        int countMatching = 0;
        DrawBuffers db = p2.getDrawBuffers();
        if (db == null) {
            return;
        }
        for (int i2 = 0; i2 < db.limit(); ++i2) {
            DynamicDimension dim2;
            int att = db.get(i2);
            int ix2 = att - 36064;
            if (ix2 < 0 || ix2 >= colorBufferSizes.length || (dim2 = colorBufferSizes[ix2]) == null) continue;
            ++countFixed;
            if (drawSize == null) {
                drawSize = dim2;
            }
            if (!dim2.equals((Object)drawSize)) continue;
            ++countMatching;
        }
        if (countFixed == 0) {
            return;
        }
        if (countMatching != db.limit()) {
            SMCLog.severe((String)("Program " + p2.getName() + " draws to buffers with different sizes"));
            return;
        }
        p2.setDrawSize(drawSize);
    }

    public static void resetDisplayLists() {
        SMCLog.info((String)"Reset model renderers");
        ++countResetDisplayLists;
        SMCLog.info((String)"Reset world renderers");
        Shaders.mc.f.f();
    }

    private static void setupProgram(Program program, String vShaderPath, String gShaderPath, String fShaderPath) {
        Shaders.checkGLError((String)"pre setupProgram");
        progUseEntityAttrib = false;
        progUseMidTexCoordAttrib = false;
        progUseTangentAttrib = false;
        progUseVelocityAttrib = false;
        progUseMidBlockAttrib = false;
        int vShader = Shaders.createVertShader((Program)program, (String)vShaderPath);
        int gShader = Shaders.createGeomShader((Program)program, (String)gShaderPath);
        int fShader = Shaders.createFragShader((Program)program, (String)fShaderPath);
        if (vShader == 0 && gShader == 0 && fShader == 0) {
            return;
        }
        Config.sleep((long)1L);
        Shaders.checkGLError((String)"create");
        int programid = GL43.glCreateProgram();
        Shaders.checkGLError((String)"create");
        if (vShader != 0) {
            GL43.glAttachShader((int)programid, (int)vShader);
            Shaders.checkGLError((String)"attach");
            if (program.getProgramStage() == ProgramStage.SHADOW && program.getCountInstances() > 1) {
                hasShadowInstancing = true;
            }
        }
        if (gShader != 0) {
            GL43.glAttachShader((int)programid, (int)gShader);
            Shaders.checkGLError((String)"attach");
            if (progArbGeometryShader4) {
                ARBGeometryShader4.glProgramParameteriARB((int)programid, (int)36315, (int)4);
                ARBGeometryShader4.glProgramParameteriARB((int)programid, (int)36316, (int)5);
                ARBGeometryShader4.glProgramParameteriARB((int)programid, (int)36314, (int)progMaxVerticesOut);
                Shaders.checkGLError((String)"arbGeometryShader4");
            }
            if (progExtGeometryShader4) {
                EXTGeometryShader4.glProgramParameteriEXT((int)programid, (int)36315, (int)4);
                EXTGeometryShader4.glProgramParameteriEXT((int)programid, (int)36316, (int)5);
                EXTGeometryShader4.glProgramParameteriEXT((int)programid, (int)36314, (int)progMaxVerticesOut);
                Shaders.checkGLError((String)"extGeometryShader4");
            }
            hasGeometryShaders = true;
            if (program.getProgramStage() == ProgramStage.SHADOW) {
                hasShadowGeometryShaders = true;
            }
        }
        if (fShader != 0) {
            GL43.glAttachShader((int)programid, (int)fShader);
            Shaders.checkGLError((String)"attach");
            for (int i2 = 0; i2 < 8; ++i2) {
                GL43.glBindFragDataLocation((int)programid, (int)i2, (CharSequence)("outColor" + i2));
            }
            Shaders.checkGLError((String)"bindDataLocation");
        }
        eio vertexFormat = eih.ENTITY_VANILLA;
        ImmutableList attributeNames = vertexFormat.d();
        for (int i3 = 0; i3 < attributeNames.size(); ++i3) {
            String name = (String)attributeNames.get(i3);
            eip element = (eip)vertexFormat.getElementMapping().get((Object)name);
            int attributeIndex = element.getAttributeIndex(i3);
            if (attributeIndex < 0) continue;
            String nameOf = "va" + name;
            eia.a((int)programid, (int)attributeIndex, (CharSequence)nameOf);
        }
        if (progUseEntityAttrib) {
            GL43.glBindAttribLocation((int)programid, (int)entityAttrib, (CharSequence)"mc_Entity");
            Shaders.checkGLError((String)"mc_Entity");
        }
        if (progUseMidTexCoordAttrib) {
            GL43.glBindAttribLocation((int)programid, (int)midTexCoordAttrib, (CharSequence)"mc_midTexCoord");
            Shaders.checkGLError((String)"mc_midTexCoord");
        }
        if (progUseTangentAttrib) {
            GL43.glBindAttribLocation((int)programid, (int)tangentAttrib, (CharSequence)"at_tangent");
            Shaders.checkGLError((String)"at_tangent");
        }
        if (progUseVelocityAttrib) {
            GL43.glBindAttribLocation((int)programid, (int)velocityAttrib, (CharSequence)"at_velocity");
            Shaders.checkGLError((String)"at_velocity");
        }
        if (progUseMidBlockAttrib) {
            GL43.glBindAttribLocation((int)programid, (int)midBlockAttrib, (CharSequence)"at_midBlock");
            Shaders.checkGLError((String)"at_midBlock");
        }
        GL43.glLinkProgram((int)programid);
        if (GL43.glGetProgrami((int)programid, (int)35714) != 1) {
            SMCLog.severe((String)("Error linking program: " + programid + " (" + program.getName() + ")"));
        }
        Shaders.printProgramLogInfo((int)programid, (String)program.getName());
        if (vShader != 0) {
            GL43.glDetachShader((int)programid, (int)vShader);
            GL43.glDeleteShader((int)vShader);
        }
        if (gShader != 0) {
            GL43.glDetachShader((int)programid, (int)gShader);
            GL43.glDeleteShader((int)gShader);
        }
        if (fShader != 0) {
            GL43.glDetachShader((int)programid, (int)fShader);
            GL43.glDeleteShader((int)fShader);
        }
        program.setId(programid);
        program.setRef(programid);
        Shaders.useProgram((Program)program);
        GL43.glValidateProgram((int)programid);
        Shaders.useProgram((Program)ProgramNone);
        Shaders.printProgramLogInfo((int)programid, (String)program.getName());
        int valid = GL43.glGetProgrami((int)programid, (int)35715);
        if (valid != 1) {
            String Q = "\"";
            Shaders.printChatAndLogError((String)("[Shaders] Error: Invalid program " + Q + program.getName() + Q));
            GL43.glDeleteProgram((int)programid);
            programid = 0;
            program.resetId();
        }
    }

    private static eio getVertexFormat(Program program) {
        if (Shaders.isTerrain((Program)program)) {
            return eih.j;
        }
        if (program == ProgramSkyTextured) {
            return eih.q;
        }
        if (program == ProgramClouds) {
            return eih.v;
        }
        return eih.k;
    }

    public static boolean isTerrain(Program program) {
        if (program.getName().contains("terrain")) {
            return true;
        }
        if (program == ProgramWater) {
            return true;
        }
        return program.getProgramStage() == ProgramStage.SHADOW;
    }

    private static ComputeProgram[] setupComputePrograms(Program program, String prefixShaders, String programPath, String shaderExt) {
        if (program.getProgramStage() == ProgramStage.GBUFFERS) {
            return new ComputeProgram[0];
        }
        ArrayList<ComputeProgram> list = new ArrayList<ComputeProgram>();
        int count = 27;
        for (int i2 = 0; i2 < count; ++i2) {
            String suffix = i2 > 0 ? "_" + (char)(97 + i2 - 1) : "";
            String computePath = programPath + suffix;
            String computeShaderFullPath = prefixShaders + computePath + shaderExt;
            ComputeProgram cp = new ComputeProgram(program.getName(), program.getProgramStage());
            Shaders.setupComputeProgram((ComputeProgram)cp, (String)computeShaderFullPath);
            if (cp.getId() <= 0) continue;
            list.add(cp);
            SMCLog.info((String)("Compute program loaded: " + computePath));
        }
        ComputeProgram[] cps = list.toArray(new ComputeProgram[list.size()]);
        return cps;
    }

    private static void setupComputeProgram(ComputeProgram program, String cShaderPath) {
        Shaders.checkGLError((String)"pre setupProgram");
        int cShader = Shaders.createCompShader((ComputeProgram)program, (String)cShaderPath);
        Shaders.checkGLError((String)"create");
        if (cShader != 0) {
            int programid = GL43.glCreateProgram();
            Shaders.checkGLError((String)"create");
            if (cShader != 0) {
                GL43.glAttachShader((int)programid, (int)cShader);
                Shaders.checkGLError((String)"attach");
            }
            GL43.glLinkProgram((int)programid);
            if (GL43.glGetProgrami((int)programid, (int)35714) != 1) {
                SMCLog.severe((String)("Error linking program: " + programid + " (" + program.getName() + ")"));
            }
            Shaders.printProgramLogInfo((int)programid, (String)program.getName());
            if (cShader != 0) {
                GL43.glDetachShader((int)programid, (int)cShader);
                GL43.glDeleteShader((int)cShader);
            }
            program.setId(programid);
            program.setRef(programid);
            Shaders.useComputeProgram((ComputeProgram)program);
            GL43.glValidateProgram((int)programid);
            GlStateManager._glUseProgram((int)0);
            Shaders.printProgramLogInfo((int)programid, (String)program.getName());
            int valid = GL43.glGetProgrami((int)programid, (int)35715);
            if (valid != 1) {
                String Q = "\"";
                Shaders.printChatAndLogError((String)("[Shaders] Error: Invalid program " + Q + program.getName() + Q));
                GL43.glDeleteProgram((int)programid);
                programid = 0;
                program.resetId();
            }
        }
    }

    private static int createCompShader(ComputeProgram program, String filename) {
        InputStream is2 = shaderPack.getResourceAsStream(filename);
        if (is2 == null) {
            return 0;
        }
        int compShader = GL43.glCreateShader((int)37305);
        if (compShader == 0) {
            return 0;
        }
        ShaderOption[] activeOptions = Shaders.getChangedOptions((ShaderOption[])shaderPackOptions);
        ArrayList listFiles = new ArrayList();
        LineBuffer lines = new LineBuffer();
        if (is2 != null) {
            try {
                lines = ShaderPackParser.loadShader(null, (ShaderType)ShaderType.COMPUTE, (InputStream)is2, (String)filename, (IShaderPack)shaderPack, listFiles, (ShaderOption[])activeOptions);
                MacroState macroState = new MacroState();
                for (String line : lines) {
                    String name;
                    int bufferindex;
                    ShaderLine sl;
                    if (!macroState.processLine(line) || (sl = ShaderParser.parseLine((String)line, (ShaderType)ShaderType.COMPUTE)) == null) continue;
                    if (sl.isUniform()) {
                        String uniform = sl.getName();
                        int index = ShaderParser.getShadowDepthIndex((String)uniform);
                        if (index >= 0) {
                            usedShadowDepthBuffers = Math.max(usedShadowDepthBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getShadowColorIndex((String)uniform);
                        if (index >= 0) {
                            usedShadowColorBuffers = Math.max(usedShadowColorBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getShadowColorImageIndex((String)uniform);
                        if (index >= 0) {
                            usedShadowColorBuffers = Math.max(usedShadowColorBuffers, index + 1);
                            bindImageTextures = true;
                            continue;
                        }
                        index = ShaderParser.getDepthIndex((String)uniform);
                        if (index >= 0) {
                            usedDepthBuffers = Math.max(usedDepthBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getColorIndex((String)uniform);
                        if (index >= 0) {
                            usedColorBuffers = Math.max(usedColorBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getColorImageIndex((String)uniform);
                        if (index < 0) continue;
                        usedColorBuffers = Math.max(usedColorBuffers, index + 1);
                        bindImageTextures = true;
                        continue;
                    }
                    if (sl.isLayout("in")) {
                        hz localSize = ShaderParser.parseLocalSize((String)sl.getValue());
                        if (localSize != null) {
                            program.setLocalSize(localSize);
                            continue;
                        }
                        SMCLog.severe((String)("Invalid local size: " + line));
                        continue;
                    }
                    if (sl.isConstIVec3("workGroups")) {
                        hz workGroups = sl.getValueIVec3();
                        if (workGroups != null) {
                            program.setWorkGroups(workGroups);
                            continue;
                        }
                        SMCLog.severe((String)("Invalid workGroups: " + line));
                        continue;
                    }
                    if (sl.isConstVec2("workGroupsRender")) {
                        eeh workGroupsRender = sl.getValueVec2();
                        if (workGroupsRender != null) {
                            program.setWorkGroupsRender(workGroupsRender);
                            continue;
                        }
                        SMCLog.severe((String)("Invalid workGroupsRender: " + line));
                        continue;
                    }
                    if (!sl.isConstBoolSuffix("MipmapEnabled", true) || (bufferindex = Shaders.getBufferIndex((String)(name = StrUtils.removeSuffix((String)sl.getName(), (String)"MipmapEnabled")))) < 0) continue;
                    int compositeMipmapSetting = program.getCompositeMipmapSetting();
                    program.setCompositeMipmapSetting(compositeMipmapSetting |= 1 << bufferindex);
                    SMCLog.info((String)"%s mipmap enabled", (Object[])new Object[]{name});
                }
            }
            catch (Exception e2) {
                SMCLog.severe((String)("Couldn't read " + filename + "!"));
                e2.printStackTrace();
                GL43.glDeleteShader((int)compShader);
                return 0;
            }
        }
        String compCode = lines.toString();
        if (saveFinalShaders) {
            Shaders.saveShader((String)filename, (String)compCode);
        }
        if (program.getLocalSize() == null) {
            SMCLog.severe((String)("Missing local size: " + filename));
            GL43.glDeleteShader((int)compShader);
            return 0;
        }
        Shaders.shaderSource((int)compShader, (String)compCode);
        GL43.glCompileShader((int)compShader);
        if (GL43.glGetShaderi((int)compShader, (int)35713) != 1) {
            SMCLog.severe((String)("Error compiling compute shader: " + filename));
        }
        Shaders.printShaderLogInfo((int)compShader, (String)filename, listFiles);
        return compShader;
    }

    private static int createVertShader(Program program, String filename) {
        InputStream is2 = shaderPack.getResourceAsStream(filename);
        if (is2 == null) {
            is2 = DefaultShaders.getResourceAsStream((String)filename);
        }
        if (is2 == null) {
            return 0;
        }
        int vertShader = GL43.glCreateShader((int)35633);
        if (vertShader == 0) {
            return 0;
        }
        ShaderOption[] activeOptions = Shaders.getChangedOptions((ShaderOption[])shaderPackOptions);
        ArrayList listFiles = new ArrayList();
        LineBuffer lines = new LineBuffer();
        if (is2 != null) {
            try {
                lines = ShaderPackParser.loadShader((Program)program, (ShaderType)ShaderType.VERTEX, (InputStream)is2, (String)filename, (IShaderPack)shaderPack, listFiles, (ShaderOption[])activeOptions);
                MacroState macroState = new MacroState();
                for (String line : lines) {
                    ShaderLine sl;
                    if (!macroState.processLine(line) || (sl = ShaderParser.parseLine((String)line, (ShaderType)ShaderType.VERTEX)) == null) continue;
                    if (sl.isAttribute("mc_Entity")) {
                        useEntityAttrib = true;
                        progUseEntityAttrib = true;
                    } else if (sl.isAttribute("mc_midTexCoord")) {
                        useMidTexCoordAttrib = true;
                        progUseMidTexCoordAttrib = true;
                    } else if (sl.isAttribute("at_tangent")) {
                        useTangentAttrib = true;
                        progUseTangentAttrib = true;
                    } else if (sl.isAttribute("at_velocity")) {
                        useVelocityAttrib = true;
                        progUseVelocityAttrib = true;
                    } else if (sl.isAttribute("at_midBlock")) {
                        useMidBlockAttrib = true;
                        progUseMidBlockAttrib = true;
                    }
                    if (!sl.isConstInt("countInstances")) continue;
                    program.setCountInstances(sl.getValueInt());
                    SMCLog.info((String)("countInstances: " + program.getCountInstances()));
                }
            }
            catch (Exception e2) {
                SMCLog.severe((String)("Couldn't read " + filename + "!"));
                e2.printStackTrace();
                GL43.glDeleteShader((int)vertShader);
                return 0;
            }
        }
        String vertexCode = lines.toString();
        if (saveFinalShaders) {
            Shaders.saveShader((String)filename, (String)vertexCode);
        }
        Shaders.shaderSource((int)vertShader, (String)vertexCode);
        GL43.glCompileShader((int)vertShader);
        if (GL43.glGetShaderi((int)vertShader, (int)35713) != 1) {
            SMCLog.severe((String)("Error compiling vertex shader: " + filename));
        }
        Shaders.printShaderLogInfo((int)vertShader, (String)filename, listFiles);
        return vertShader;
    }

    private static int createGeomShader(Program program, String filename) {
        InputStream is2 = shaderPack.getResourceAsStream(filename);
        if (is2 == null) {
            return 0;
        }
        int geomShader = GL43.glCreateShader((int)36313);
        if (geomShader == 0) {
            return 0;
        }
        ShaderOption[] activeOptions = Shaders.getChangedOptions((ShaderOption[])shaderPackOptions);
        ArrayList listFiles = new ArrayList();
        progArbGeometryShader4 = false;
        progExtGeometryShader4 = false;
        progMaxVerticesOut = 3;
        LineBuffer lines = new LineBuffer();
        if (is2 != null) {
            try {
                lines = ShaderPackParser.loadShader((Program)program, (ShaderType)ShaderType.GEOMETRY, (InputStream)is2, (String)filename, (IShaderPack)shaderPack, listFiles, (ShaderOption[])activeOptions);
                MacroState macroState = new MacroState();
                for (String line : lines) {
                    String val;
                    ShaderLine sl;
                    if (!macroState.processLine(line) || (sl = ShaderParser.parseLine((String)line, (ShaderType)ShaderType.GEOMETRY)) == null) continue;
                    if (sl.isExtension("GL_ARB_geometry_shader4") && ((val = Config.normalize((String)sl.getValue())).equals("enable") || val.equals("require") || val.equals("warn"))) {
                        progArbGeometryShader4 = true;
                    }
                    if (sl.isExtension("GL_EXT_geometry_shader4") && ((val = Config.normalize((String)sl.getValue())).equals("enable") || val.equals("require") || val.equals("warn"))) {
                        progExtGeometryShader4 = true;
                    }
                    if (!sl.isConstInt("maxVerticesOut")) continue;
                    progMaxVerticesOut = sl.getValueInt();
                }
            }
            catch (Exception e2) {
                SMCLog.severe((String)("Couldn't read " + filename + "!"));
                e2.printStackTrace();
                GL43.glDeleteShader((int)geomShader);
                return 0;
            }
        }
        String geomCode = lines.toString();
        if (saveFinalShaders) {
            Shaders.saveShader((String)filename, (String)geomCode);
        }
        Shaders.shaderSource((int)geomShader, (String)geomCode);
        GL43.glCompileShader((int)geomShader);
        if (GL43.glGetShaderi((int)geomShader, (int)35713) != 1) {
            SMCLog.severe((String)("Error compiling geometry shader: " + filename));
        }
        Shaders.printShaderLogInfo((int)geomShader, (String)filename, listFiles);
        return geomShader;
    }

    private static int createFragShader(Program program, String filename) {
        InputStream is2 = shaderPack.getResourceAsStream(filename);
        if (is2 == null) {
            is2 = DefaultShaders.getResourceAsStream((String)filename);
        }
        if (is2 == null) {
            return 0;
        }
        int fragShader = GL43.glCreateShader((int)35632);
        if (fragShader == 0) {
            return 0;
        }
        ShaderOption[] activeOptions = Shaders.getChangedOptions((ShaderOption[])shaderPackOptions);
        ArrayList listFiles = new ArrayList();
        LineBuffer lines = new LineBuffer();
        if (is2 != null) {
            try {
                lines = ShaderPackParser.loadShader((Program)program, (ShaderType)ShaderType.FRAGMENT, (InputStream)is2, (String)filename, (IShaderPack)shaderPack, listFiles, (ShaderOption[])activeOptions);
                MacroState macroState = new MacroState();
                for (String line : lines) {
                    String val;
                    String name;
                    ShaderLine sl;
                    if (!macroState.processLine(line) || (sl = ShaderParser.parseLine((String)line, (ShaderType)ShaderType.FRAGMENT)) == null) continue;
                    if (sl.isUniform()) {
                        String uniform = sl.getName();
                        int index = ShaderParser.getShadowDepthIndex((String)uniform);
                        if (index >= 0) {
                            usedShadowDepthBuffers = Math.max(usedShadowDepthBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getShadowColorIndex((String)uniform);
                        if (index >= 0) {
                            usedShadowColorBuffers = Math.max(usedShadowColorBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getShadowColorImageIndex((String)uniform);
                        if (index >= 0) {
                            usedShadowColorBuffers = Math.max(usedShadowColorBuffers, index + 1);
                            bindImageTextures = true;
                            continue;
                        }
                        index = ShaderParser.getDepthIndex((String)uniform);
                        if (index >= 0) {
                            usedDepthBuffers = Math.max(usedDepthBuffers, index + 1);
                            continue;
                        }
                        if (uniform.equals("gdepth") && gbuffersFormat[1] == 6408) {
                            Shaders.gbuffersFormat[1] = 34836;
                            continue;
                        }
                        index = ShaderParser.getColorIndex((String)uniform);
                        if (index >= 0) {
                            usedColorBuffers = Math.max(usedColorBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getColorImageIndex((String)uniform);
                        if (index >= 0) {
                            usedColorBuffers = Math.max(usedColorBuffers, index + 1);
                            bindImageTextures = true;
                            continue;
                        }
                        if (!uniform.equals("centerDepthSmooth")) continue;
                        centerDepthSmoothEnabled = true;
                        continue;
                    }
                    if (sl.isConstInt("shadowMapResolution") || sl.isProperty("SHADOWRES")) {
                        spShadowMapWidth = spShadowMapHeight = sl.getValueInt();
                        shadowMapWidth = shadowMapHeight = Math.round((float)spShadowMapWidth * configShadowResMul);
                        SMCLog.info((String)("Shadow map resolution: " + spShadowMapWidth));
                        continue;
                    }
                    if (sl.isConstFloat("shadowMapFov") || sl.isProperty("SHADOWFOV")) {
                        shadowMapFOV = sl.getValueFloat();
                        shadowMapIsOrtho = false;
                        SMCLog.info((String)("Shadow map field of view: " + shadowMapFOV));
                        continue;
                    }
                    if (sl.isConstFloat("shadowDistance") || sl.isProperty("SHADOWHPL")) {
                        shadowMapHalfPlane = sl.getValueFloat();
                        shadowMapIsOrtho = true;
                        SMCLog.info((String)("Shadow map distance: " + shadowMapHalfPlane));
                        continue;
                    }
                    if (sl.isConstFloat("shadowDistanceRenderMul")) {
                        shadowDistanceRenderMul = sl.getValueFloat();
                        SMCLog.info((String)("Shadow distance render mul: " + shadowDistanceRenderMul));
                        continue;
                    }
                    if (sl.isConstFloat("shadowIntervalSize")) {
                        shadowIntervalSize = sl.getValueFloat();
                        SMCLog.info((String)("Shadow map interval size: " + shadowIntervalSize));
                        continue;
                    }
                    if (sl.isConstBool("generateShadowMipmap", true)) {
                        Arrays.fill(shadowMipmapEnabled, true);
                        SMCLog.info((String)"Generate shadow mipmap");
                        continue;
                    }
                    if (sl.isConstBool("generateShadowColorMipmap", true)) {
                        Arrays.fill(shadowColorMipmapEnabled, true);
                        SMCLog.info((String)"Generate shadow color mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowHardwareFiltering", true)) {
                        Arrays.fill(shadowHardwareFilteringEnabled, true);
                        SMCLog.info((String)"Hardware shadow filtering enabled.");
                        continue;
                    }
                    if (sl.isConstBool("shadowHardwareFiltering0", true)) {
                        Shaders.shadowHardwareFilteringEnabled[0] = true;
                        SMCLog.info((String)"shadowHardwareFiltering0");
                        continue;
                    }
                    if (sl.isConstBool("shadowHardwareFiltering1", true)) {
                        Shaders.shadowHardwareFilteringEnabled[1] = true;
                        SMCLog.info((String)"shadowHardwareFiltering1");
                        continue;
                    }
                    if (sl.isConstBool("shadowtex0Mipmap", "shadowtexMipmap", true)) {
                        Shaders.shadowMipmapEnabled[0] = true;
                        SMCLog.info((String)"shadowtex0Mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowtex1Mipmap", true)) {
                        Shaders.shadowMipmapEnabled[1] = true;
                        SMCLog.info((String)"shadowtex1Mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowcolor0Mipmap", "shadowColor0Mipmap", true)) {
                        Shaders.shadowColorMipmapEnabled[0] = true;
                        SMCLog.info((String)"shadowcolor0Mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowcolor1Mipmap", "shadowColor1Mipmap", true)) {
                        Shaders.shadowColorMipmapEnabled[1] = true;
                        SMCLog.info((String)"shadowcolor1Mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowtex0Nearest", "shadowtexNearest", "shadow0MinMagNearest", true)) {
                        Shaders.shadowFilterNearest[0] = true;
                        SMCLog.info((String)"shadowtex0Nearest");
                        continue;
                    }
                    if (sl.isConstBool("shadowtex1Nearest", "shadow1MinMagNearest", true)) {
                        Shaders.shadowFilterNearest[1] = true;
                        SMCLog.info((String)"shadowtex1Nearest");
                        continue;
                    }
                    if (sl.isConstBool("shadowcolor0Nearest", "shadowColor0Nearest", "shadowColor0MinMagNearest", true)) {
                        Shaders.shadowColorFilterNearest[0] = true;
                        SMCLog.info((String)"shadowcolor0Nearest");
                        continue;
                    }
                    if (sl.isConstBool("shadowcolor1Nearest", "shadowColor1Nearest", "shadowColor1MinMagNearest", true)) {
                        Shaders.shadowColorFilterNearest[1] = true;
                        SMCLog.info((String)"shadowcolor1Nearest");
                        continue;
                    }
                    if (sl.isConstFloat("wetnessHalflife") || sl.isProperty("WETNESSHL")) {
                        wetnessHalfLife = sl.getValueFloat();
                        SMCLog.info((String)("Wetness halflife: " + wetnessHalfLife));
                        continue;
                    }
                    if (sl.isConstFloat("drynessHalflife") || sl.isProperty("DRYNESSHL")) {
                        drynessHalfLife = sl.getValueFloat();
                        SMCLog.info((String)("Dryness halflife: " + drynessHalfLife));
                        continue;
                    }
                    if (sl.isConstFloat("eyeBrightnessHalflife")) {
                        eyeBrightnessHalflife = sl.getValueFloat();
                        SMCLog.info((String)("Eye brightness halflife: " + eyeBrightnessHalflife));
                        continue;
                    }
                    if (sl.isConstFloat("centerDepthHalflife")) {
                        centerDepthSmoothHalflife = sl.getValueFloat();
                        SMCLog.info((String)("Center depth halflife: " + centerDepthSmoothHalflife));
                        continue;
                    }
                    if (sl.isConstFloat("sunPathRotation")) {
                        sunPathRotation = sl.getValueFloat();
                        SMCLog.info((String)("Sun path rotation: " + sunPathRotation));
                        continue;
                    }
                    if (sl.isConstFloat("ambientOcclusionLevel")) {
                        aoLevel = Config.limit((float)sl.getValueFloat(), (float)0.0f, (float)1.0f);
                        SMCLog.info((String)("AO Level: " + aoLevel));
                        continue;
                    }
                    if (sl.isConstInt("superSamplingLevel")) {
                        int ssaa = sl.getValueInt();
                        if (ssaa > 1) {
                            SMCLog.info((String)("Super sampling level: " + ssaa + "x"));
                            superSamplingLevel = ssaa;
                            continue;
                        }
                        superSamplingLevel = 1;
                        continue;
                    }
                    if (sl.isConstInt("noiseTextureResolution")) {
                        noiseTextureResolution = sl.getValueInt();
                        noiseTextureEnabled = true;
                        SMCLog.info((String)"Noise texture enabled");
                        SMCLog.info((String)("Noise texture resolution: " + noiseTextureResolution));
                        continue;
                    }
                    if (sl.isConstIntSuffix("Format")) {
                        int shadowColorIndex;
                        name = StrUtils.removeSuffix((String)sl.getName(), (String)"Format");
                        String value = sl.getValue();
                        int format = Shaders.getTextureFormatFromString((String)value);
                        if (format == 0) continue;
                        int bufferindex = Shaders.getBufferIndex((String)name);
                        if (bufferindex >= 0) {
                            Shaders.gbuffersFormat[bufferindex] = format;
                            SMCLog.info((String)"%s format: %s", (Object[])new Object[]{name, value});
                        }
                        if ((shadowColorIndex = ShaderParser.getShadowColorIndex((String)name)) < 0) continue;
                        Shaders.shadowBuffersFormat[shadowColorIndex] = format;
                        SMCLog.info((String)"%s format: %s", (Object[])new Object[]{name, value});
                        continue;
                    }
                    if (sl.isConstBoolSuffix("Clear", false)) {
                        int shadowColorIndex;
                        if (!program.getProgramStage().isAnyComposite()) continue;
                        name = StrUtils.removeSuffix((String)sl.getName(), (String)"Clear");
                        int bufferindex = Shaders.getBufferIndex((String)name);
                        if (bufferindex >= 0) {
                            Shaders.gbuffersClear[bufferindex] = false;
                            SMCLog.info((String)"%s clear disabled", (Object[])new Object[]{name});
                        }
                        if ((shadowColorIndex = ShaderParser.getShadowColorIndex((String)name)) < 0) continue;
                        Shaders.shadowBuffersClear[shadowColorIndex] = false;
                        SMCLog.info((String)"%s clear disabled", (Object[])new Object[]{name});
                        continue;
                    }
                    if (sl.isConstVec4Suffix("ClearColor")) {
                        if (!program.getProgramStage().isAnyComposite()) continue;
                        name = StrUtils.removeSuffix((String)sl.getName(), (String)"ClearColor");
                        Vector4f col = sl.getValueVec4();
                        if (col != null) {
                            int shadowColorIndex;
                            int bufferindex = Shaders.getBufferIndex((String)name);
                            if (bufferindex >= 0) {
                                Shaders.gbuffersClearColor[bufferindex] = col;
                                SMCLog.info((String)"%s clear color: %s %s %s %s", (Object[])new Object[]{name, Float.valueOf(col.x()), Float.valueOf(col.y()), Float.valueOf(col.z()), Float.valueOf(col.w())});
                            }
                            if ((shadowColorIndex = ShaderParser.getShadowColorIndex((String)name)) < 0) continue;
                            Shaders.shadowBuffersClearColor[shadowColorIndex] = col;
                            SMCLog.info((String)"%s clear color: %s %s %s %s", (Object[])new Object[]{name, Float.valueOf(col.x()), Float.valueOf(col.y()), Float.valueOf(col.z()), Float.valueOf(col.w())});
                            continue;
                        }
                        SMCLog.warning((String)("Invalid color value: " + sl.getValue()));
                        continue;
                    }
                    if (sl.isProperty("GAUX4FORMAT", "RGBA32F")) {
                        Shaders.gbuffersFormat[7] = 34836;
                        SMCLog.info((String)"gaux4 format : RGB32AF");
                        continue;
                    }
                    if (sl.isProperty("GAUX4FORMAT", "RGB32F")) {
                        Shaders.gbuffersFormat[7] = 34837;
                        SMCLog.info((String)"gaux4 format : RGB32F");
                        continue;
                    }
                    if (sl.isProperty("GAUX4FORMAT", "RGB16")) {
                        Shaders.gbuffersFormat[7] = 32852;
                        SMCLog.info((String)"gaux4 format : RGB16");
                        continue;
                    }
                    if (sl.isConstBoolSuffix("MipmapEnabled", true)) {
                        int bufferindex;
                        if (!program.getProgramStage().isAnyComposite() || (bufferindex = Shaders.getBufferIndex((String)(name = StrUtils.removeSuffix((String)sl.getName(), (String)"MipmapEnabled")))) < 0) continue;
                        int compositeMipmapSetting = program.getCompositeMipmapSetting();
                        program.setCompositeMipmapSetting(compositeMipmapSetting |= 1 << bufferindex);
                        SMCLog.info((String)"%s mipmap enabled", (Object[])new Object[]{name});
                        continue;
                    }
                    if (sl.isProperty("DRAWBUFFERS")) {
                        val = sl.getValue();
                        String[] dbs = ShaderParser.parseDrawBuffers((String)val);
                        if (dbs != null) {
                            program.setDrawBufSettings(dbs);
                            continue;
                        }
                        SMCLog.warning((String)("Invalid draw buffers: " + val));
                        continue;
                    }
                    if (!sl.isProperty("RENDERTARGETS")) continue;
                    val = sl.getValue();
                    String[] dbs = ShaderParser.parseRenderTargets((String)val);
                    if (dbs != null) {
                        program.setDrawBufSettings(dbs);
                        continue;
                    }
                    SMCLog.warning((String)("Invalid render targets: " + val));
                }
            }
            catch (Exception e2) {
                SMCLog.severe((String)("Couldn't read " + filename + "!"));
                e2.printStackTrace();
                GL43.glDeleteShader((int)fragShader);
                return 0;
            }
        }
        String fragCode = lines.toString();
        if (saveFinalShaders) {
            Shaders.saveShader((String)filename, (String)fragCode);
        }
        Shaders.shaderSource((int)fragShader, (String)fragCode);
        GL43.glCompileShader((int)fragShader);
        if (GL43.glGetShaderi((int)fragShader, (int)35713) != 1) {
            SMCLog.severe((String)("Error compiling fragment shader: " + filename));
        }
        Shaders.printShaderLogInfo((int)fragShader, (String)filename, listFiles);
        return fragShader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shaderSource(int shader, String code) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer sourceBuffer = MemoryUtil.memUTF8((CharSequence)code, (boolean)true);
            PointerBuffer pointers = stack.mallocPointer(1);
            pointers.put(sourceBuffer);
            GL43.nglShaderSource((int)shader, (int)1, (long)pointers.address0(), (long)0L);
            APIUtil.apiArrayFree((long)pointers.address0(), (int)1);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void saveShader(String filename, String code) {
        try {
            File file = new File(shaderPacksDir, "debug/" + filename);
            file.getParentFile().mkdirs();
            Config.writeFile((File)file, (String)code);
        }
        catch (IOException e2) {
            Config.warn((String)("Error saving: " + filename));
            e2.printStackTrace();
        }
    }

    private static void clearDirectory(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = files[i2];
            if (file.isDirectory()) {
                Shaders.clearDirectory((File)file);
            }
            file.delete();
        }
    }

    private static boolean printProgramLogInfo(int obj, String name) {
        IntBuffer iVal = BufferUtils.createIntBuffer((int)1);
        GL43.glGetProgramiv((int)obj, (int)35716, (IntBuffer)iVal);
        int length = iVal.get();
        if (length > 1) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer((int)length);
            iVal.flip();
            GL43.glGetProgramInfoLog((int)obj, (IntBuffer)iVal, (ByteBuffer)infoLog);
            byte[] infoBytes = new byte[length];
            infoLog.get(infoBytes);
            if (infoBytes[length - 1] == 0) {
                infoBytes[length - 1] = 10;
            }
            String out = new String(infoBytes, StandardCharsets.US_ASCII);
            out = StrUtils.trim((String)out, (String)" \n\r\t");
            SMCLog.info((String)("Program info log: " + name + "\n" + out));
            return false;
        }
        return true;
    }

    private static boolean printShaderLogInfo(int shader, String name, List<String> listFiles) {
        IntBuffer iVal = BufferUtils.createIntBuffer((int)1);
        int length = GL43.glGetShaderi((int)shader, (int)35716);
        if (length > 1) {
            for (int i2 = 0; i2 < listFiles.size(); ++i2) {
                String path = listFiles.get(i2);
                SMCLog.info((String)("File: " + (i2 + 1) + " = " + path));
            }
            String log = GL43.glGetShaderInfoLog((int)shader, (int)length);
            log = StrUtils.trim((String)log, (String)" \n\r\t");
            SMCLog.info((String)("Shader info log: " + name + "\n" + log));
            return false;
        }
        return true;
    }

    public static void useProgram(Program program) {
        int programID;
        Shaders.checkGLError((String)"pre-useProgram");
        if (isShadowPass) {
            program = ProgramShadow;
        }
        if (activeProgram == program) {
            return;
        }
        Shaders.flushRenderBuffers();
        Shaders.updateAlphaBlend((Program)activeProgram, (Program)program);
        if (glDebugGroups && glDebugGroupProgram) {
            KHRDebug.glPopDebugGroup();
        }
        activeProgram = program;
        if (glDebugGroups) {
            KHRDebug.glPushDebugGroup((int)33354, (int)0, (CharSequence)activeProgram.getRealProgramName());
            glDebugGroupProgram = true;
        }
        activeProgramID = programID = program.getId();
        GlStateManager._glUseProgram((int)programID);
        if (Shaders.checkGLError((String)"useProgram") != 0) {
            program.setId(0);
            activeProgramID = programID = program.getId();
            GlStateManager._glUseProgram((int)programID);
        }
        shaderUniforms.setProgram(programID);
        if (customUniforms != null) {
            customUniforms.setProgram(programID);
        }
        if (programID == 0) {
            fki.useVanillaProgram();
            return;
        }
        DrawBuffers drawBuffers = program.getDrawBuffers();
        if (isRenderingDfb) {
            GlState.setDrawBuffers((DrawBuffers)drawBuffers);
        }
        Shaders.setProgramUniforms((ProgramStage)program.getProgramStage());
        Shaders.setImageUniforms();
        Shaders.checkGLError((String)"end useProgram");
    }

    private static void setProgramUniforms(ProgramStage programStage) {
        int blockLight2;
        switch (1.$SwitchMap$net$optifine$shaders$ProgramStage[programStage.ordinal()]) {
            case 1: {
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gtexture, (int)0);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_lightmap, (int)2);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_normals, (int)1);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_specular, (int)3);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadow, (int)(waterShadowEnabled ? 5 : 4));
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_watershadow, (int)4);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowtex0, (int)4);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowtex1, (int)5);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_depthtex0, (int)6);
                if (customTexturesGbuffers != null || hasDeferredPrograms) {
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gaux1, (int)7);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gaux2, (int)8);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gaux3, (int)9);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gaux4, (int)10);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex4, (int)7);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex5, (int)8);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex6, (int)9);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex7, (int)10);
                    if (usedColorBuffers > 8) {
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex8, (int)16);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex9, (int)17);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex10, (int)18);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex11, (int)19);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex12, (int)20);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex13, (int)21);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex14, (int)22);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex15, (int)23);
                    }
                }
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_depthtex1, (int)11);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowcolor, (int)13);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowcolor0, (int)13);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowcolor1, (int)14);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_noisetex, (int)15);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gcolor, (int)0);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gdepth, (int)1);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gnormal, (int)2);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_composite, (int)3);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gaux1, (int)7);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gaux2, (int)8);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gaux3, (int)9);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gaux4, (int)10);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex0, (int)0);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex1, (int)1);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex2, (int)2);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex3, (int)3);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex4, (int)7);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex5, (int)8);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex6, (int)9);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex7, (int)10);
                if (usedColorBuffers > 8) {
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex8, (int)16);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex9, (int)17);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex10, (int)18);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex11, (int)19);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex12, (int)20);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex13, (int)21);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex14, (int)22);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex15, (int)23);
                }
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadow, (int)(waterShadowEnabled ? 5 : 4));
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_watershadow, (int)4);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowtex0, (int)4);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowtex1, (int)5);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gdepthtex, (int)6);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_depthtex0, (int)6);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_depthtex1, (int)11);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_depthtex2, (int)12);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowcolor, (int)13);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowcolor0, (int)13);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowcolor1, (int)14);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_noisetex, (int)15);
                break;
            }
            case 6: {
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_tex, (int)0);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gtexture, (int)0);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_lightmap, (int)2);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_normals, (int)1);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_specular, (int)3);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadow, (int)(waterShadowEnabled ? 5 : 4));
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_watershadow, (int)4);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowtex0, (int)4);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowtex1, (int)5);
                if (customTexturesGbuffers != null) {
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gaux1, (int)7);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gaux2, (int)8);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gaux3, (int)9);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_gaux4, (int)10);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex4, (int)7);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex5, (int)8);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex6, (int)9);
                    Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex7, (int)10);
                    if (usedColorBuffers > 8) {
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex8, (int)16);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex9, (int)17);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex10, (int)18);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex11, (int)19);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex12, (int)20);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex13, (int)21);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex14, (int)22);
                        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_colortex15, (int)23);
                    }
                }
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowcolor, (int)13);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowcolor0, (int)13);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_shadowcolor1, (int)14);
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_noisetex, (int)15);
                break;
            }
        }
        cfz stack = Shaders.mc.t != null ? Shaders.mc.t.eO() : null;
        cfu item = stack != null ? stack.d() : null;
        int itemID = -1;
        cpn block = null;
        if (item != null) {
            itemID = jb.i.a((Object)item);
            if (item instanceof cds) {
                block = ((cds)item).e();
            }
            itemID = ItemAliases.getItemAliasId((int)itemID);
        }
        int blockLight = block != null ? block.n().h() : 0;
        cfz stack2 = Shaders.mc.t != null ? Shaders.mc.t.eP() : null;
        cfu item2 = stack2 != null ? stack2.d() : null;
        int itemID2 = -1;
        cpn block2 = null;
        if (item2 != null) {
            itemID2 = jb.i.a((Object)item2);
            if (item2 instanceof cds) {
                block2 = ((cds)item2).e();
            }
            itemID2 = ItemAliases.getItemAliasId((int)itemID2);
        }
        int n2 = blockLight2 = block2 != null ? block2.n().h() : 0;
        if (Shaders.isOldHandLight() && blockLight2 > blockLight) {
            itemID = itemID2;
            blockLight = blockLight2;
        }
        float playerMood = Shaders.mc.t != null ? Shaders.mc.t.o() : 0.0f;
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_heldItemId, (int)itemID);
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_heldBlockLightValue, (int)blockLight);
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_heldItemId2, (int)itemID2);
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_heldBlockLightValue2, (int)blockLight2);
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_fogMode, (int)(fogEnabled && fogAllowed ? fogMode : 0));
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_fogShape, (int)fogShape);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogDensity, (float)(fogEnabled && fogAllowed ? fogDensity : 0.0f));
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogStart, (float)(fogEnabled && fogAllowed ? fogStart : 1.7014117E38f));
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogEnd, (float)(fogEnabled && fogAllowed ? fogEnd : Float.MAX_VALUE));
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_fogColor, (float)fogColorR, (float)fogColorG, (float)fogColorB);
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_skyColor, (float)skyColorR, (float)skyColorG, (float)skyColorB);
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_worldTime, (int)((int)(worldTime % 24000L)));
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_worldDay, (int)((int)(worldTime / 24000L)));
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_moonPhase, (int)moonPhase);
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_frameCounter, (int)frameCounter);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_frameTime, (float)frameTime);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_frameTimeCounter, (float)frameTimeCounter);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_sunAngle, (float)sunAngle);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_shadowAngle, (float)shadowAngle);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_rainStrength, (float)rainStrength);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_aspectRatio, (float)((float)renderWidth / (float)renderHeight));
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_viewWidth, (float)renderWidth);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_viewHeight, (float)renderHeight);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_near, (float)0.05f);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_far, (float)((Integer)Shaders.mc.m.d().c() * 16));
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_sunPosition, (float)sunPosition[0], (float)sunPosition[1], (float)sunPosition[2]);
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_moonPosition, (float)moonPosition[0], (float)moonPosition[1], (float)moonPosition[2]);
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_shadowLightPosition, (float)shadowLightPosition[0], (float)shadowLightPosition[1], (float)shadowLightPosition[2]);
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_upPosition, (float)upPosition[0], (float)upPosition[1], (float)upPosition[2]);
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_previousCameraPosition, (float)((float)previousCameraPositionX), (float)((float)previousCameraPositionY), (float)((float)previousCameraPositionZ));
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_cameraPosition, (float)((float)cameraPositionX), (float)((float)cameraPositionY), (float)((float)cameraPositionZ));
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferModelView, (boolean)false, (FloatBuffer)modelView);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferModelViewInverse, (boolean)false, (FloatBuffer)modelViewInverse);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferPreviousProjection, (boolean)false, (FloatBuffer)previousProjection);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferProjection, (boolean)false, (FloatBuffer)projection);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferProjectionInverse, (boolean)false, (FloatBuffer)projectionInverse);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferPreviousModelView, (boolean)false, (FloatBuffer)previousModelView);
        if (hasShadowMap) {
            Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_shadowProjection, (boolean)false, (FloatBuffer)shadowProjection);
            Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_shadowProjectionInverse, (boolean)false, (FloatBuffer)shadowProjectionInverse);
            Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_shadowModelView, (boolean)false, (FloatBuffer)shadowModelView);
            Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_shadowModelViewInverse, (boolean)false, (FloatBuffer)shadowModelViewInverse);
        }
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_wetness, (float)wetness);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_eyeAltitude, (float)eyePosY);
        Shaders.setProgramUniform2i((ShaderUniform2i)uniform_eyeBrightness, (int)(eyeBrightness & 0xFFFF), (int)(eyeBrightness >> 16));
        Shaders.setProgramUniform2i((ShaderUniform2i)uniform_eyeBrightnessSmooth, (int)Math.round(eyeBrightnessFadeX), (int)Math.round(eyeBrightnessFadeY));
        Shaders.setProgramUniform2i((ShaderUniform2i)uniform_terrainTextureSize, (int)terrainTextureSize[0], (int)terrainTextureSize[1]);
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_terrainIconSize, (int)terrainIconSize);
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_isEyeInWater, (int)isEyeInWater);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_nightVision, (float)nightVision);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_blindness, (float)blindness);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_screenBrightness, (float)((float)((Double)Shaders.mc.m.ak().c()).doubleValue()));
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_hideGUI, (int)(Shaders.mc.m.Z ? 1 : 0));
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_centerDepthSmooth, (float)centerDepthSmooth);
        Shaders.setProgramUniform2i((ShaderUniform2i)uniform_atlasSize, (int)atlasSizeX, (int)atlasSizeY);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_playerMood, (float)playerMood);
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_renderStage, (int)renderStage.ordinal());
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_bossBattle, (int)bossBattle);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_darknessFactor, (float)darknessFactor);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_darknessLightFactor, (float)darknessLightFactor);
        GlStateManager.applyAlphaTest();
        if (customUniforms != null) {
            customUniforms.update();
        }
    }

    private static void setImageUniforms() {
        if (!bindImageTextures) {
            return;
        }
        uniform_colorimg0.setValue(colorImageUnit[0]);
        uniform_colorimg1.setValue(colorImageUnit[1]);
        uniform_colorimg2.setValue(colorImageUnit[2]);
        uniform_colorimg3.setValue(colorImageUnit[3]);
        uniform_colorimg4.setValue(colorImageUnit[4]);
        uniform_colorimg5.setValue(colorImageUnit[5]);
        uniform_shadowcolorimg0.setValue(shadowColorImageUnit[0]);
        uniform_shadowcolorimg1.setValue(shadowColorImageUnit[1]);
    }

    private static void updateAlphaBlend(Program programOld, Program programNew) {
        GlBlendState blendNew;
        GlAlphaState alphaNew;
        if (programOld.getAlphaState() != null) {
            GlStateManager.unlockAlpha();
        }
        if (programOld.getBlendState() != null) {
            GlStateManager.unlockBlend();
        }
        if (programOld.getBlendStatesIndexed() != null) {
            GlStateManager.applyCurrentBlend();
        }
        if ((alphaNew = programNew.getAlphaState()) != null) {
            GlStateManager.lockAlpha((GlAlphaState)alphaNew);
        }
        if ((blendNew = programNew.getBlendState()) != null) {
            GlStateManager.lockBlend((GlBlendState)blendNew);
        }
        if (programNew.getBlendStatesIndexed() != null) {
            GlStateManager.setBlendsIndexed((GlBlendState[])programNew.getBlendStatesIndexed());
        }
    }

    private static void setProgramUniform1i(ShaderUniform1i su2, int value) {
        su2.setValue(value);
    }

    private static void setProgramUniform2i(ShaderUniform2i su2, int i0, int i1) {
        su2.setValue(i0, i1);
    }

    private static void setProgramUniform1f(ShaderUniform1f su2, float value) {
        su2.setValue(value);
    }

    private static void setProgramUniform3f(ShaderUniform3f su2, float f0, float f1, float f2) {
        su2.setValue(f0, f1, f2);
    }

    private static void setProgramUniformMatrix4ARB(ShaderUniformM4 su2, boolean transpose, FloatBuffer matrix) {
        su2.setValue(transpose, matrix);
    }

    public static int getBufferIndex(String name) {
        int colortexIndex = ShaderParser.getIndex((String)name, (String)"colortex", (int)0, (int)15);
        if (colortexIndex >= 0) {
            return colortexIndex;
        }
        int colorimgIndex = ShaderParser.getIndex((String)name, (String)"colorimg", (int)0, (int)15);
        if (colorimgIndex >= 0) {
            return colorimgIndex;
        }
        if (name.equals("gcolor")) {
            return 0;
        }
        if (name.equals("gdepth")) {
            return 1;
        }
        if (name.equals("gnormal")) {
            return 2;
        }
        if (name.equals("composite")) {
            return 3;
        }
        if (name.equals("gaux1")) {
            return 4;
        }
        if (name.equals("gaux2")) {
            return 5;
        }
        if (name.equals("gaux3")) {
            return 6;
        }
        if (name.equals("gaux4")) {
            return 7;
        }
        return -1;
    }

    private static int getTextureFormatFromString(String par) {
        par = par.trim();
        for (int i2 = 0; i2 < formatNames.length; ++i2) {
            String name = formatNames[i2];
            if (!par.equals(name)) continue;
            return formatIds[i2];
        }
        return 0;
    }

    public static int getImageFormat(int textureFormat) {
        switch (textureFormat) {
            case 8194: {
                return 33321;
            }
            case 33319: {
                return 33323;
            }
            case 6407: {
                return 32849;
            }
            case 6408: {
                return 32856;
            }
            case 10768: {
                return 32849;
            }
            case 32855: {
                return 32856;
            }
            case 35901: {
                return 32852;
            }
        }
        return textureFormat;
    }

    private static void setupNoiseTexture() {
        if (noiseTexture == null && noiseTexturePath != null) {
            noiseTexture = Shaders.loadCustomTexture((int)15, (String)noiseTexturePath);
        }
        if (noiseTexture == null) {
            noiseTexture = new HFNoiseTexture(noiseTextureResolution, noiseTextureResolution);
        }
    }

    private static void loadEntityDataMap() {
        mapBlockToEntityData = new IdentityHashMap(300);
        if (mapBlockToEntityData.isEmpty()) {
            for (acq key : jb.f.e()) {
                cpn block = (cpn)jb.f.a(key);
                int id = jb.f.a((Object)block);
                mapBlockToEntityData.put(block, id);
            }
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(shaderPack.getResourceAsStream("/mc_Entity_x.txt")));
        }
        catch (Exception key) {
            // empty catch block
        }
        if (reader != null) {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher m2 = patternLoadEntityDataMap.matcher(line);
                    if (m2.matches()) {
                        String name = m2.group(1);
                        String value = m2.group(2);
                        int id = Integer.parseInt(value);
                        acq loc = new acq(name);
                        if (jb.f.c(loc)) {
                            cpn block = (cpn)jb.f.a(loc);
                            mapBlockToEntityData.put(block, id);
                            continue;
                        }
                        SMCLog.warning((String)"Unknown block name %s", (Object[])new Object[]{name});
                        continue;
                    }
                    SMCLog.warning((String)"unmatched %s\n", (Object[])new Object[]{line});
                }
            }
            catch (Exception e2) {
                SMCLog.warning((String)"Error parsing mc_Entity_x.txt");
            }
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static IntBuffer fillIntBufferZero(IntBuffer buf) {
        int limit = buf.limit();
        for (int i2 = buf.position(); i2 < limit; ++i2) {
            buf.put(i2, 0);
        }
        return buf;
    }

    private static DrawBuffers fillIntBufferZero(DrawBuffers buf) {
        int limit = buf.limit();
        for (int i2 = buf.position(); i2 < limit; ++i2) {
            buf.put(i2, 0);
        }
        return buf;
    }

    public static void uninit() {
        if (isShaderPackInitialized) {
            int i2;
            Shaders.checkGLError((String)"Shaders.uninit pre");
            for (i2 = 0; i2 < ProgramsAll.length; ++i2) {
                Program pi = ProgramsAll[i2];
                if (pi.getRef() != 0) {
                    GL43.glDeleteProgram((int)pi.getRef());
                    Shaders.checkGLError((String)"del programRef");
                }
                pi.setRef(0);
                pi.setId(0);
                pi.setDrawBufSettings(null);
                pi.setDrawBuffers(null);
                pi.setCompositeMipmapSetting(0);
                ComputeProgram[] cps = pi.getComputePrograms();
                for (int c2 = 0; c2 < cps.length; ++c2) {
                    ComputeProgram cp = cps[c2];
                    if (cp.getRef() != 0) {
                        GL43.glDeleteProgram((int)cp.getRef());
                        Shaders.checkGLError((String)"del programRef");
                    }
                    cp.setRef(0);
                    cp.setId(0);
                }
                pi.setComputePrograms(new ComputeProgram[0]);
            }
            hasDeferredPrograms = false;
            hasShadowcompPrograms = false;
            hasPreparePrograms = false;
            if (dfb != null) {
                dfb.delete();
                dfb = null;
                Shaders.checkGLError((String)"del dfb");
            }
            if (sfb != null) {
                sfb.delete();
                sfb = null;
                Shaders.checkGLError((String)"del sfb");
            }
            if (dfbDrawBuffers != null) {
                Shaders.fillIntBufferZero((DrawBuffers)dfbDrawBuffers);
            }
            if (sfbDrawBuffers != null) {
                Shaders.fillIntBufferZero((DrawBuffers)sfbDrawBuffers);
            }
            if (noiseTexture != null) {
                noiseTexture.deleteTexture();
                noiseTexture = null;
            }
            for (i2 = 0; i2 < colorImageUnit.length; ++i2) {
                GlStateManager.bindImageTexture((int)colorImageUnit[i2], (int)0, (int)0, (boolean)false, (int)0, (int)35000, (int)32856);
            }
            SMCLog.info((String)"Uninit");
            hasShadowMap = false;
            shouldSkipDefaultShadow = false;
            isShaderPackInitialized = false;
            Shaders.checkGLError((String)"Shaders.uninit");
        }
    }

    public static void scheduleResize() {
        renderDisplayHeight = 0;
    }

    public static void scheduleResizeShadow() {
        needResizeShadow = true;
    }

    private static void resize() {
        renderDisplayWidth = mc.aM().k();
        renderDisplayHeight = mc.aM().l();
        renderWidth = Math.round((float)renderDisplayWidth * configRenderResMul);
        renderHeight = Math.round((float)renderDisplayHeight * configRenderResMul);
        Shaders.setupFrameBuffer();
    }

    private static void resizeShadow() {
        needResizeShadow = false;
        shadowMapWidth = Math.round((float)spShadowMapWidth * configShadowResMul);
        shadowMapHeight = Math.round((float)spShadowMapHeight * configShadowResMul);
        Shaders.setupShadowFrameBuffer();
    }

    private static void setupFrameBuffer() {
        if (dfb != null) {
            dfb.delete();
        }
        boolean[] depthFilterNearest = ArrayUtils.newBoolean((int)usedDepthBuffers, (boolean)true);
        boolean[] depthFilterHardware = new boolean[usedDepthBuffers];
        boolean[] colorFilterNearest = new boolean[usedColorBuffers];
        int[] colorImageUnits = (int[])(bindImageTextures ? colorImageUnit : null);
        dfb = new ShadersFramebuffer("dfb", renderWidth, renderHeight, usedColorBuffers, usedDepthBuffers, 8, depthFilterNearest, depthFilterHardware, colorFilterNearest, colorBufferSizes, gbuffersFormat, colorTextureImageUnit, depthTextureImageUnit, colorImageUnits, dfbDrawBuffers);
        dfb.setup();
    }

    public static int getPixelFormat(int internalFormat) {
        switch (internalFormat) {
            case 33329: 
            case 33335: 
            case 36238: 
            case 36239: {
                return 36251;
            }
            case 33330: 
            case 33336: 
            case 36220: 
            case 36221: {
                return 36251;
            }
            case 33331: 
            case 33337: 
            case 36232: 
            case 36233: {
                return 36251;
            }
            case 33332: 
            case 33338: 
            case 36214: 
            case 36215: {
                return 36251;
            }
            case 33333: 
            case 33339: 
            case 36226: 
            case 36227: {
                return 36251;
            }
            case 33334: 
            case 33340: 
            case 36208: 
            case 36209: {
                return 36251;
            }
        }
        return 32993;
    }

    private static void setupShadowFrameBuffer() {
        if (!hasShadowMap) {
            return;
        }
        isShadowPass = true;
        if (sfb != null) {
            sfb.delete();
        }
        DynamicDimension[] shadowColorBufferSizes = new DynamicDimension[2];
        int[] shadowColorImageUnits = (int[])(bindImageTextures ? shadowColorImageUnit : null);
        sfb = new ShadersFramebuffer("sfb", shadowMapWidth, shadowMapHeight, usedShadowColorBuffers, usedShadowDepthBuffers, 8, shadowFilterNearest, shadowHardwareFilteringEnabled, shadowColorFilterNearest, shadowColorBufferSizes, shadowBuffersFormat, shadowColorTextureImageUnit, shadowDepthTextureImageUnit, shadowColorImageUnits, sfbDrawBuffers);
        sfb.setup();
        isShadowPass = false;
    }

    public static void beginRender(enn minecraft, emz activeRenderInfo, float partialTicks, long finishTimeNano) {
        block14: {
            Shaders.checkGLError((String)"pre beginRender");
            Shaders.checkWorldChanged((few)Shaders.mc.s);
            mc = minecraft;
            mc.aG().a("init");
            entityRenderer = Shaders.mc.j;
            if (!isShaderPackInitialized) {
                try {
                    Shaders.init();
                }
                catch (IllegalStateException e2) {
                    if (!Config.normalize((String)e2.getMessage()).equals("Function is not supported")) break block14;
                    Shaders.printChatAndLogError((String)("[Shaders] Error: " + e2.getMessage()));
                    e2.printStackTrace();
                    Shaders.setShaderPack((String)"OFF");
                    return;
                }
            }
        }
        if (mc.aM().k() != renderDisplayWidth || mc.aM().l() != renderDisplayHeight) {
            Shaders.resize();
        }
        if (needResizeShadow) {
            Shaders.resizeShadow();
        }
        if (++frameCounter >= 720720) {
            frameCounter = 0;
        }
        systemTime = System.currentTimeMillis();
        if (lastSystemTime == 0L) {
            lastSystemTime = systemTime;
        }
        diffSystemTime = systemTime - lastSystemTime;
        lastSystemTime = systemTime;
        frameTime = (float)diffSystemTime / 1000.0f;
        frameTimeCounter += frameTime;
        frameTimeCounter %= 3600.0f;
        pointOfViewChanged = pointOfView != Shaders.mc.m.au();
        pointOfView = Shaders.mc.m.au();
        ShadersRender.updateActiveRenderInfo((emz)activeRenderInfo, (enn)minecraft, (float)partialTicks);
        few world = Shaders.mc.s;
        if (world != null) {
            worldTime = world.W();
            diffWorldTime = (worldTime - lastWorldTime) % 24000L;
            if (diffWorldTime < 0L) {
                diffWorldTime += 24000L;
            }
            lastWorldTime = worldTime;
            moonPhase = world.ao();
            rainStrength = world.d(partialTicks);
            float fadeScalarRain = (float)diffSystemTime * 0.01f;
            float tempRain = (float)Math.exp(Math.log(0.5) * (double)fadeScalarRain / (double)(wetness < rainStrength ? drynessHalfLife : wetnessHalfLife));
            wetness = wetness * tempRain + rainStrength * (1.0f - tempRain);
            bossBattle = Shaders.getBossBattle();
            bfj renderViewEntity = activeRenderInfo.g();
            if (renderViewEntity != null) {
                isSleeping = renderViewEntity instanceof bfz && ((bfz)renderViewEntity).fy();
                eyePosY = (float)activeRenderInfo.b().b();
                eyeBrightness = mc.an().a(renderViewEntity, partialTicks);
                float fadeScalarBrightness = (float)diffSystemTime * 0.01f;
                float tempBrightness = (float)Math.exp(Math.log(0.5) * (double)fadeScalarBrightness / (double)eyeBrightnessHalflife);
                eyeBrightnessFadeX = eyeBrightnessFadeX * tempBrightness + (float)(eyeBrightness & 0xFFFF) * (1.0f - tempBrightness);
                eyeBrightnessFadeY = eyeBrightnessFadeY * tempBrightness + (float)(eyeBrightness >> 16) * (1.0f - tempBrightness);
                dxg cameraFogType = activeRenderInfo.k();
                isEyeInWater = cameraFogType == dxg.b ? 1 : (cameraFogType == dxg.a ? 2 : (cameraFogType == dxg.c ? 3 : 0));
                if (renderViewEntity instanceof bfz) {
                    bfz player = (bfz)renderViewEntity;
                    nightVision = 0.0f;
                    if (player.a(bfc.p)) {
                        nightVision = fjq.a((bfz)player, (float)partialTicks);
                    }
                    blindness = 0.0f;
                    if (player.a(bfc.o)) {
                        int blindnessTicks = player.b(bfc.o).d();
                        blindness = Config.limit((float)((float)blindnessTicks / 20.0f), (float)0.0f, (float)1.0f);
                    }
                }
                eei skyColorV = world.a(activeRenderInfo.b(), partialTicks);
                skyColorV = CustomColors.getWorldSkyColor((eei)skyColorV, (cmm)world, (bfj)renderViewEntity, (float)partialTicks);
                skyColorR = (float)skyColorV.c;
                skyColorG = (float)skyColorV.d;
                skyColorB = (float)skyColorV.e;
            }
        }
        isRenderingWorld = true;
        isCompositeRendered = false;
        isShadowPass = false;
        isHandRenderedMain = false;
        isHandRenderedOff = false;
        skipRenderHandMain = false;
        skipRenderHandOff = false;
        dfb.setColorBuffersFiltering(9729, 9729);
        Shaders.bindGbuffersTextures();
        dfb.bindColorImages(true);
        if (sfb != null) {
            sfb.bindColorImages(true);
        }
        previousCameraPositionX = cameraPositionX;
        previousCameraPositionY = cameraPositionY;
        previousCameraPositionZ = cameraPositionZ;
        previousProjection.position(0);
        projection.position(0);
        previousProjection.put(projection);
        previousProjection.position(0);
        projection.position(0);
        previousModelView.position(0);
        modelView.position(0);
        previousModelView.put(modelView);
        previousModelView.position(0);
        modelView.position(0);
        lastModelView.identity();
        lastProjection.identity();
        Shaders.checkGLError((String)"beginRender");
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        Shaders.setDefaultAttribColor();
        Shaders.setDefaultAttribLightmap();
        Shaders.setDefaultAttribNormal();
        ShadersRender.renderShadowMap((fjq)entityRenderer, (emz)activeRenderInfo, (int)0, (float)partialTicks, (long)finishTimeNano);
        mc.aG().c();
        dfb.setColorTextures(true);
        Shaders.setRenderStage((RenderStage)RenderStage.NONE);
        Shaders.checkGLError((String)"end beginRender");
    }

    private static void bindGbuffersTextures() {
        Shaders.bindTextures((int)4, (ICustomTexture[])customTexturesGbuffers);
    }

    private static void bindTextures(int startColorBuffer, ICustomTexture[] customTextures) {
        if (sfb != null) {
            sfb.bindColorTextures(0);
            sfb.bindDepthTextures(shadowDepthTextureImageUnit);
        }
        dfb.bindColorTextures(startColorBuffer);
        dfb.bindDepthTextures(depthTextureImageUnit);
        if (noiseTextureEnabled) {
            GlStateManager._activeTexture((int)(33984 + noiseTexture.getTextureUnit()));
            GlStateManager._bindTexture((int)noiseTexture.getTextureId());
            GlStateManager._activeTexture((int)33984);
        }
        Shaders.bindCustomTextures((ICustomTexture[])customTextures);
    }

    public static void checkWorldChanged(few world) {
        if (currentWorld == world) {
            return;
        }
        few oldWorld = currentWorld;
        currentWorld = world;
        if (currentWorld == null) {
            cameraPositionX = 0.0;
            cameraPositionY = 0.0;
            cameraPositionZ = 0.0;
            previousCameraPositionX = 0.0;
            previousCameraPositionY = 0.0;
            previousCameraPositionZ = 0.0;
        }
        Shaders.setCameraOffset((bfj)mc.al());
        int dimIdOld = WorldUtils.getDimensionId((cmm)oldWorld);
        int dimIdNew = WorldUtils.getDimensionId((cmm)world);
        if (dimIdNew != dimIdOld) {
            boolean dimShadersOld = shaderPackDimensions.contains(dimIdOld);
            boolean dimShadersNew = shaderPackDimensions.contains(dimIdNew);
            if (dimShadersOld || dimShadersNew) {
                Shaders.uninit();
            }
        }
        Smoother.resetValues();
    }

    public static void beginRenderPass(float partialTicks, long finishTimeNano) {
        if (isShadowPass) {
            return;
        }
        dfb.bindFramebuffer();
        GL11.glViewport((int)0, (int)0, (int)renderWidth, (int)renderHeight);
        GlState.setDrawBuffers(null);
        ShadersTex.bindNSTextures((MultiTexID)defaultTexture.getMultiTexID());
        Shaders.useProgram((Program)ProgramTextured);
        Shaders.checkGLError((String)"end beginRenderPass");
    }

    public static void setViewport(int vx, int vy, int vw2, int vh) {
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (isShadowPass) {
            GL11.glViewport((int)0, (int)0, (int)shadowMapWidth, (int)shadowMapHeight);
        } else {
            GL11.glViewport((int)0, (int)0, (int)renderWidth, (int)renderHeight);
            dfb.bindFramebuffer();
            isRenderingDfb = true;
            GlStateManager._enableCull();
            GlStateManager._enableDepthTest();
            GlState.setDrawBuffers((DrawBuffers)drawBuffersNone);
            Shaders.useProgram((Program)ProgramTextured);
            Shaders.checkGLError((String)"beginRenderPass");
        }
    }

    public static void setFogMode(int value) {
        fogMode = value;
        if (fogEnabled && fogAllowed) {
            Shaders.setProgramUniform1i((ShaderUniform1i)uniform_fogMode, (int)value);
        }
    }

    public static void setFogShape(int value) {
        fogShape = value;
        if (fogEnabled && fogAllowed) {
            Shaders.setProgramUniform1i((ShaderUniform1i)uniform_fogShape, (int)value);
        }
    }

    public static void setFogColor(float r2, float g2, float b2) {
        fogColorR = r2;
        fogColorG = g2;
        fogColorB = b2;
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_fogColor, (float)fogColorR, (float)fogColorG, (float)fogColorB);
    }

    public static void setClearColor(float red, float green, float blue, float alpha) {
        clearColor.set(red, green, blue, 1.0f);
    }

    public static void clearRenderBuffer() {
        if (isShadowPass) {
            Shaders.checkGLError((String)"shadow clear pre");
            sfb.clearDepthBuffer(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
            Shaders.checkGLError((String)"shadow clear");
            return;
        }
        Shaders.checkGLError((String)"clear pre");
        Vector4f[] clearColors = new Vector4f[usedColorBuffers];
        for (int i2 = 0; i2 < clearColors.length; ++i2) {
            clearColors[i2] = Shaders.getBufferClearColor((int)i2);
        }
        dfb.clearColorBuffers(gbuffersClear, clearColors);
        dfb.setDrawBuffers();
        Shaders.checkFramebufferStatus((String)"clear");
        Shaders.checkGLError((String)"clear");
    }

    public static void renderPrepare() {
        if (hasPreparePrograms) {
            Shaders.renderPrepareComposites();
            Shaders.bindGbuffersTextures();
            dfb.setDrawBuffers();
            dfb.setColorTextures(true);
        }
    }

    private static Vector4f getBufferClearColor(int buffer) {
        Vector4f col = gbuffersClearColor[buffer];
        if (col != null) {
            return col;
        }
        if (buffer == 0) {
            return clearColor;
        }
        if (buffer == 1) {
            return CLEAR_COLOR_1;
        }
        return CLEAR_COLOR_0;
    }

    public static void setCamera(eij matrixStackIn, emz activeRenderInfo, float partialTicks) {
        bfj viewEntity = activeRenderInfo.g();
        eei cameraPos = activeRenderInfo.b();
        double x2 = cameraPos.c;
        double y2 = cameraPos.d;
        double z2 = cameraPos.e;
        Shaders.updateCameraOffset((bfj)viewEntity);
        cameraPositionX = x2 - (double)cameraOffsetX;
        cameraPositionY = y2;
        cameraPositionZ = z2 - (double)cameraOffsetZ;
        Shaders.updateProjectionMatrix();
        Shaders.setModelView((Matrix4f)matrixStackIn.c().a());
        Shaders.checkGLError((String)"setCamera");
    }

    public static void updateProjectionMatrix() {
        Shaders.setProjection((Matrix4f)RenderSystem.getProjectionMatrix());
    }

    private static void updateShadowProjectionMatrix() {
        MathUtils.write((Matrix4f)RenderSystem.getProjectionMatrix(), (FloatBuffer)shadowProjection);
        SMath.invertMat4FBFA((FloatBuffer)shadowProjectionInverse.position(0), (FloatBuffer)shadowProjection.position(0), (float[])faShadowProjectionInverse, (float[])faShadowProjection);
        shadowProjection.position(0);
        shadowProjectionInverse.position(0);
    }

    private static void updateCameraOffset(bfj viewEntity) {
        double adx = Math.abs(cameraPositionX - previousCameraPositionX);
        double adz = Math.abs(cameraPositionZ - previousCameraPositionZ);
        double apx = Math.abs(cameraPositionX);
        double apz2 = Math.abs(cameraPositionZ);
        if (adx > 1000.0 || adz > 1000.0 || apx > 1000000.0 || apz2 > 1000000.0) {
            Shaders.setCameraOffset((bfj)viewEntity);
        }
    }

    private static void setCameraOffset(bfj viewEntity) {
        if (viewEntity == null) {
            cameraOffsetX = 0;
            cameraOffsetZ = 0;
            return;
        }
        cameraOffsetX = (int)viewEntity.dn() / 1000 * 1000;
        cameraOffsetZ = (int)viewEntity.dt() / 1000 * 1000;
    }

    public static void setCameraShadow(eij matrixStack, emz activeRenderInfo, float partialTicks) {
        float angleInterval;
        bfj viewEntity = activeRenderInfo.g();
        eei cameraPos = activeRenderInfo.b();
        double x2 = cameraPos.c;
        double y2 = cameraPos.d;
        double z2 = cameraPos.e;
        Shaders.updateCameraOffset((bfj)viewEntity);
        cameraPositionX = x2 - (double)cameraOffsetX;
        cameraPositionY = y2;
        cameraPositionZ = z2 - (double)cameraOffsetZ;
        GlStateManager._viewport((int)0, (int)0, (int)shadowMapWidth, (int)shadowMapHeight);
        if (shadowMapIsOrtho) {
            Matrix4f projectionMatrix = MathUtils.makeOrtho4f((float)(-shadowMapHalfPlane), (float)shadowMapHalfPlane, (float)shadowMapHalfPlane, (float)(-shadowMapHalfPlane), (float)0.05f, (float)256.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (eir)eir.b);
        } else {
            Matrix4f projectionMatrix = new Matrix4f().perspective(shadowMapFOV, (float)shadowMapWidth / (float)shadowMapHeight, 0.05f, 256.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (eir)eir.a);
        }
        matrixStack.a(0.0f, 0.0f, -100.0f);
        matrixStack.a(a.b.rotationDegrees(90.0f));
        celestialAngle = Shaders.mc.s.f(partialTicks);
        sunAngle = celestialAngle < 0.75f ? celestialAngle + 0.25f : celestialAngle - 0.75f;
        float angle = celestialAngle * -360.0f;
        float f2 = angleInterval = shadowAngleInterval > 0.0f ? angle % shadowAngleInterval - shadowAngleInterval * 0.5f : 0.0f;
        if ((double)sunAngle <= 0.5) {
            matrixStack.a(a.f.rotationDegrees(angle - angleInterval));
            matrixStack.a(a.b.rotationDegrees(sunPathRotation));
            shadowAngle = sunAngle;
        } else {
            matrixStack.a(a.f.rotationDegrees(angle + 180.0f - angleInterval));
            matrixStack.a(a.b.rotationDegrees(sunPathRotation));
            shadowAngle = sunAngle - 0.5f;
        }
        if (shadowMapIsOrtho) {
            float trans = shadowIntervalSize;
            float trans2 = trans / 2.0f;
            matrixStack.a((float)x2 % trans - trans2, (float)y2 % trans - trans2, (float)z2 % trans - trans2);
        }
        float raSun = sunAngle * ((float)Math.PI * 2);
        float x1 = (float)Math.cos(raSun);
        float y1 = (float)Math.sin(raSun);
        float raTilt = sunPathRotation * ((float)Math.PI * 2);
        float x22 = x1;
        float y22 = y1 * (float)Math.cos(raTilt);
        float z22 = y1 * (float)Math.sin(raTilt);
        if ((double)sunAngle > 0.5) {
            x22 = -x22;
            y22 = -y22;
            z22 = -z22;
        }
        Shaders.shadowLightPositionVector[0] = x22;
        Shaders.shadowLightPositionVector[1] = y22;
        Shaders.shadowLightPositionVector[2] = z22;
        Shaders.shadowLightPositionVector[3] = 0.0f;
        Shaders.updateShadowProjectionMatrix();
        Matrix4f shadowModelViewMat4 = matrixStack.c().a();
        MathUtils.write((Matrix4f)shadowModelViewMat4, (FloatBuffer)shadowModelView.position(0));
        SMath.invertMat4FBFA((FloatBuffer)shadowModelViewInverse.position(0), (FloatBuffer)shadowModelView.position(0), (float[])faShadowModelViewInverse, (float[])faShadowModelView);
        shadowModelView.position(0);
        shadowModelViewInverse.position(0);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferProjection, (boolean)false, (FloatBuffer)projection);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferProjectionInverse, (boolean)false, (FloatBuffer)projectionInverse);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferPreviousProjection, (boolean)false, (FloatBuffer)previousProjection);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferModelView, (boolean)false, (FloatBuffer)modelView);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferModelViewInverse, (boolean)false, (FloatBuffer)modelViewInverse);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferPreviousModelView, (boolean)false, (FloatBuffer)previousModelView);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_shadowProjection, (boolean)false, (FloatBuffer)shadowProjection);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_shadowProjectionInverse, (boolean)false, (FloatBuffer)shadowProjectionInverse);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_shadowModelView, (boolean)false, (FloatBuffer)shadowModelView);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_shadowModelViewInverse, (boolean)false, (FloatBuffer)shadowModelViewInverse);
        Shaders.checkGLError((String)"setCamera");
    }

    public static void preCelestialRotate(eij matrixStackIn) {
        matrixStackIn.a(a.f.rotationDegrees(sunPathRotation * 1.0f));
        Shaders.checkGLError((String)"preCelestialRotate");
    }

    public static void postCelestialRotate(eij matrixStackIn) {
        Matrix4f modelViewMat4 = matrixStackIn.c().a();
        Matrix4f modelViewMat4T = new Matrix4f((Matrix4fc)modelViewMat4);
        modelViewMat4T.transpose();
        MathUtils.write((Matrix4f)modelViewMat4T, (float[])tempMat);
        SMath.multiplyMat4xVec4((float[])sunPosition, (float[])tempMat, (float[])sunPosModelView);
        SMath.multiplyMat4xVec4((float[])moonPosition, (float[])tempMat, (float[])moonPosModelView);
        System.arraycopy(shadowAngle == sunAngle ? sunPosition : moonPosition, 0, shadowLightPosition, 0, 3);
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_sunPosition, (float)sunPosition[0], (float)sunPosition[1], (float)sunPosition[2]);
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_moonPosition, (float)moonPosition[0], (float)moonPosition[1], (float)moonPosition[2]);
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_shadowLightPosition, (float)shadowLightPosition[0], (float)shadowLightPosition[1], (float)shadowLightPosition[2]);
        if (customUniforms != null) {
            customUniforms.update();
        }
        Shaders.checkGLError((String)"postCelestialRotate");
    }

    public static void setUpPosition(eij matrixStackIn) {
        Matrix4f modelViewMat4 = matrixStackIn.c().a();
        Matrix4f modelViewMat4T = new Matrix4f((Matrix4fc)modelViewMat4);
        modelViewMat4T.transpose();
        MathUtils.write((Matrix4f)modelViewMat4T, (float[])tempMat);
        SMath.multiplyMat4xVec4((float[])upPosition, (float[])tempMat, (float[])upPosModelView);
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_upPosition, (float)upPosition[0], (float)upPosition[1], (float)upPosition[2]);
        if (customUniforms != null) {
            customUniforms.update();
        }
    }

    public static void drawComposite() {
        Matrix4f mv = MATRIX_IDENTITY;
        Matrix4f mp = MathUtils.makeOrtho4f((float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix4f mt = MATRIX_IDENTITY;
        Shaders.setModelViewMatrix((Matrix4f)mv);
        Shaders.setProjectionMatrix((Matrix4f)mp);
        Shaders.setTextureMatrix((Matrix4f)mt);
        Shaders.drawCompositeQuad();
        int countInstances = activeProgram.getCountInstances();
        if (countInstances > 1) {
            for (int i2 = 1; i2 < countInstances; ++i2) {
                uniform_instanceId.setValue(i2);
                Shaders.drawCompositeQuad();
            }
            uniform_instanceId.setValue(0);
        }
    }

    private static void drawCompositeQuad() {
        eil tesselator = RenderSystem.renderThreadTesselator();
        eie bufferbuilder = tesselator.c();
        bufferbuilder.a(eio.b.h, eih.q);
        bufferbuilder.a(0.0, 0.0, 0.0).a(0.0f, 0.0f).e();
        bufferbuilder.a(1.0, 0.0, 0.0).a(1.0f, 0.0f).e();
        bufferbuilder.a(1.0, 1.0, 0.0).a(1.0f, 1.0f).e();
        bufferbuilder.a(0.0, 1.0, 0.0).a(0.0f, 1.0f).e();
        eif.b((eie.b)bufferbuilder.d());
    }

    public static void renderDeferred() {
        if (isShadowPass) {
            return;
        }
        boolean buffersChanged = Shaders.checkBufferFlip((ShadersFramebuffer)dfb, (Program)ProgramDeferredPre);
        if (hasDeferredPrograms) {
            Shaders.checkGLError((String)"pre-render Deferred");
            Shaders.renderDeferredComposites();
            buffersChanged = true;
        }
        if (buffersChanged) {
            Shaders.bindGbuffersTextures();
            dfb.setColorTextures(true);
            DrawBuffers drawBuffersWater = ProgramWater.getDrawBuffers() != null ? ProgramWater.getDrawBuffers() : dfb.getDrawBuffers();
            GlState.setDrawBuffers((DrawBuffers)drawBuffersWater);
            GlStateManager._activeTexture((int)33984);
            mc.X().a(fuu.e);
        }
    }

    public static void renderCompositeFinal() {
        if (isShadowPass) {
            return;
        }
        Shaders.checkBufferFlip((ShadersFramebuffer)dfb, (Program)ProgramCompositePre);
        Shaders.checkGLError((String)"pre-render CompositeFinal");
        Shaders.renderComposites();
    }

    private static boolean checkBufferFlip(ShadersFramebuffer framebuffer, Program program) {
        boolean flipped = false;
        Boolean[] buffersFlip = program.getBuffersFlip();
        for (int i2 = 0; i2 < usedColorBuffers; ++i2) {
            if (!Config.isTrue((Boolean)buffersFlip[i2])) continue;
            framebuffer.flipColorTexture(i2);
            flipped = true;
        }
        return flipped;
    }

    private static void renderComposites() {
        if (isShadowPass) {
            return;
        }
        Shaders.renderComposites((Program[])ProgramsComposite, (boolean)true, (ICustomTexture[])customTexturesComposite);
    }

    private static void renderDeferredComposites() {
        if (isShadowPass) {
            return;
        }
        Shaders.renderComposites((Program[])ProgramsDeferred, (boolean)false, (ICustomTexture[])customTexturesDeferred);
    }

    public static void renderPrepareComposites() {
        Shaders.renderComposites((Program[])ProgramsPrepare, (boolean)false, (ICustomTexture[])customTexturesPrepare);
    }

    private static void renderComposites(Program[] ps, boolean renderFinal, ICustomTexture[] customTextures) {
        Shaders.renderComposites((ShadersFramebuffer)dfb, (Program[])ps, (boolean)renderFinal, (ICustomTexture[])customTextures);
    }

    public static void renderShadowComposites() {
        Shaders.renderComposites((ShadersFramebuffer)sfb, (Program[])ProgramsShadowcomp, (boolean)false, (ICustomTexture[])customTexturesShadowcomp);
    }

    private static void renderComposites(ShadersFramebuffer framebuffer, Program[] ps, boolean renderFinal, ICustomTexture[] customTextures) {
        GlStateManager.enableTexture();
        GlStateManager.disableAlphaTest();
        GlStateManager._disableBlend();
        GlStateManager._enableDepthTest();
        GlStateManager._depthFunc((int)519);
        GlStateManager._depthMask((boolean)false);
        Shaders.bindTextures((int)0, (ICustomTexture[])customTextures);
        framebuffer.bindColorImages(true);
        framebuffer.setColorTextures(false);
        framebuffer.setDepthTexture();
        framebuffer.setDrawBuffers();
        Shaders.checkGLError((String)"pre-composite");
        for (int i2 = 0; i2 < ps.length; ++i2) {
            Program program = ps[i2];
            Shaders.dispatchComputes((ShadersFramebuffer)framebuffer, (ComputeProgram[])program.getComputePrograms());
            if (program.getId() == 0) continue;
            Shaders.useProgram((Program)program);
            Shaders.checkGLError((String)program.getName());
            if (program.hasCompositeMipmaps()) {
                framebuffer.genCompositeMipmap(program.getCompositeMipmapSetting());
            }
            Shaders.preDrawComposite((ShadersFramebuffer)framebuffer, (Program)program);
            Shaders.drawComposite();
            Shaders.postDrawComposite((ShadersFramebuffer)framebuffer, (Program)program);
            framebuffer.flipColorTextures(program.getToggleColorTextures());
        }
        Shaders.checkGLError((String)"composite");
        if (renderFinal) {
            Shaders.renderFinal();
            isCompositeRendered = true;
        }
        GlStateManager.enableTexture();
        GlStateManager.enableAlphaTest();
        GlStateManager._enableBlend();
        GlStateManager._depthFunc((int)515);
        GlStateManager._depthMask((boolean)true);
        Shaders.useProgram((Program)ProgramNone);
    }

    private static void preDrawComposite(ShadersFramebuffer framebuffer, Program program) {
        RenderScale rs;
        int drawWidth = framebuffer.getWidth();
        int drawHeight = framebuffer.getHeight();
        if (program.getDrawSize() != null) {
            Dimension dim2 = program.getDrawSize().getDimension(drawWidth, drawHeight);
            drawWidth = dim2.width;
            drawHeight = dim2.height;
            FixedFramebuffer ff = framebuffer.getFixedFramebuffer(drawWidth, drawHeight, program.getDrawBuffers(), false);
            ff.bindFramebuffer();
            GL43.glViewport((int)0, (int)0, (int)drawWidth, (int)drawHeight);
        }
        if ((rs = program.getRenderScale()) != null) {
            int x2 = (int)((float)drawWidth * rs.getOffsetX());
            int y2 = (int)((float)drawHeight * rs.getOffsetY());
            int w = (int)((float)drawWidth * rs.getScale());
            int h2 = (int)((float)drawHeight * rs.getScale());
            GL43.glViewport((int)x2, (int)y2, (int)w, (int)h2);
        }
    }

    private static void postDrawComposite(ShadersFramebuffer framebuffer, Program program) {
        RenderScale rs;
        if (program.getDrawSize() != null) {
            framebuffer.bindFramebuffer();
            GL43.glViewport((int)0, (int)0, (int)framebuffer.getWidth(), (int)framebuffer.getHeight());
        }
        if ((rs = activeProgram.getRenderScale()) != null) {
            GL43.glViewport((int)0, (int)0, (int)framebuffer.getWidth(), (int)framebuffer.getHeight());
        }
    }

    public static void dispatchComputes(ShadersFramebuffer framebuffer, ComputeProgram[] cps) {
        for (int i2 = 0; i2 < cps.length; ++i2) {
            ComputeProgram cp = cps[i2];
            Shaders.dispatchCompute((ComputeProgram)cp);
            if (!cp.hasCompositeMipmaps()) continue;
            framebuffer.genCompositeMipmap(cp.getCompositeMipmapSetting());
        }
    }

    public static void useComputeProgram(ComputeProgram cp) {
        GlStateManager._glUseProgram((int)cp.getId());
        if (Shaders.checkGLError((String)"useComputeProgram") != 0) {
            cp.setId(0);
            return;
        }
        shaderUniforms.setProgram(cp.getId());
        if (customUniforms != null) {
            customUniforms.setProgram(cp.getId());
        }
        Shaders.setProgramUniforms((ProgramStage)cp.getProgramStage());
        Shaders.setImageUniforms();
        if (dfb == null) {
            return;
        }
        dfb.bindColorImages(true);
    }

    public static void dispatchCompute(ComputeProgram cp) {
        if (dfb == null) {
            return;
        }
        Shaders.useComputeProgram((ComputeProgram)cp);
        hz workGroups = cp.getWorkGroups();
        if (workGroups == null) {
            eeh workGroupsRender = cp.getWorkGroupsRender();
            if (workGroupsRender == null) {
                workGroupsRender = new eeh(1.0f, 1.0f);
            }
            int computeWidth = (int)Math.ceil((float)renderWidth * workGroupsRender.i);
            int computeHeight = (int)Math.ceil((float)renderHeight * workGroupsRender.j);
            hz localSize = cp.getLocalSize();
            int groupsX = (int)Math.ceil(1.0 * (double)computeWidth / (double)localSize.u());
            int groupsY = (int)Math.ceil(1.0 * (double)computeHeight / (double)localSize.v());
            workGroups = new hz(groupsX, groupsY, 1);
        }
        GL43.glMemoryBarrier((int)40);
        GL43.glDispatchCompute((int)workGroups.u(), (int)workGroups.v(), (int)workGroups.w());
        GL43.glMemoryBarrier((int)40);
        Shaders.checkGLError((String)"compute");
    }

    private static void renderFinal() {
        Shaders.dispatchComputes((ShadersFramebuffer)dfb, (ComputeProgram[])ProgramFinal.getComputePrograms());
        isRenderingDfb = false;
        mc.f().a(true);
        GlStateManager._glFramebufferTexture2D((int)GLConst.GL_FRAMEBUFFER, (int)GLConst.GL_COLOR_ATTACHMENT0, (int)3553, (int)mc.f().f(), (int)0);
        GL43.glViewport((int)0, (int)0, (int)mc.aM().k(), (int)mc.aM().l());
        GlStateManager._depthMask((boolean)true);
        GL43.glClearColor((float)clearColor.x(), (float)clearColor.y(), (float)clearColor.z(), (float)1.0f);
        GL43.glClear((int)16640);
        GlStateManager.enableTexture();
        GlStateManager.disableAlphaTest();
        GlStateManager._disableBlend();
        GlStateManager._enableDepthTest();
        GlStateManager._depthFunc((int)519);
        GlStateManager._depthMask((boolean)false);
        Shaders.checkGLError((String)"pre-final");
        Shaders.useProgram((Program)ProgramFinal);
        Shaders.checkGLError((String)"final");
        if (ProgramFinal.hasCompositeMipmaps()) {
            dfb.genCompositeMipmap(ProgramFinal.getCompositeMipmapSetting());
        }
        Shaders.drawComposite();
        Shaders.checkGLError((String)"renderCompositeFinal");
    }

    public static void endRender() {
        if (isShadowPass) {
            Shaders.checkGLError((String)"shadow endRender");
            return;
        }
        if (!isCompositeRendered) {
            Shaders.renderCompositeFinal();
        }
        isRenderingWorld = false;
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        Shaders.useProgram((Program)ProgramNone);
        Shaders.setRenderStage((RenderStage)RenderStage.NONE);
        Shaders.checkGLError((String)"endRender end");
    }

    public static void beginSky() {
        isRenderingSky = true;
        fogEnabled = true;
        Shaders.useProgram((Program)ProgramSkyTextured);
        Shaders.pushEntity((int)-2, (int)0);
        Shaders.setRenderStage((RenderStage)RenderStage.SKY);
    }

    public static void setSkyColor(eei v3color) {
        skyColorR = (float)v3color.c;
        skyColorG = (float)v3color.d;
        skyColorB = (float)v3color.e;
        Shaders.setProgramUniform3f((ShaderUniform3f)uniform_skyColor, (float)skyColorR, (float)skyColorG, (float)skyColorB);
    }

    public static void drawHorizon(eij matrixStackIn) {
        eie tess = eil.a().c();
        double top = 16.0;
        double bot = -cameraPositionY + currentWorld.k().a((cmo)currentWorld) + 12.0 - 16.0;
        if (cameraPositionY < currentWorld.k().a((cmo)currentWorld)) {
            bot = -4.0;
        }
        Matrix4f matrix = matrixStackIn.c().a();
        tess.a(eio.b.h, eih.m);
        int dist = 512;
        for (int i2 = 0; i2 < 8; ++i2) {
            double x2 = (float)dist * apa.b((float)((float)i2 * 0.7853982f));
            double z2 = (float)dist * apa.a((float)((float)i2 * 0.7853982f));
            int iN = i2 + 1;
            double xN = (float)dist * apa.b((float)((float)iN * 0.7853982f));
            double zN = (float)dist * apa.a((float)((float)iN * 0.7853982f));
            Shaders.addVertex((eie)tess, (Matrix4f)matrix, (double)x2, (double)bot, (double)z2);
            Shaders.addVertex((eie)tess, (Matrix4f)matrix, (double)xN, (double)bot, (double)zN);
            Shaders.addVertex((eie)tess, (Matrix4f)matrix, (double)xN, (double)top, (double)zN);
            Shaders.addVertex((eie)tess, (Matrix4f)matrix, (double)x2, (double)top, (double)z2);
            Shaders.addVertex((eie)tess, (Matrix4f)matrix, (double)0.0, (double)bot, (double)0.0);
            Shaders.addVertex((eie)tess, (Matrix4f)matrix, (double)0.0, (double)bot, (double)0.0);
            Shaders.addVertex((eie)tess, (Matrix4f)matrix, (double)xN, (double)bot, (double)zN);
            Shaders.addVertex((eie)tess, (Matrix4f)matrix, (double)x2, (double)bot, (double)z2);
        }
        eil.a().b();
    }

    private static void addVertex(eie buffer, Matrix4f matrix, double x2, double y2, double z2) {
        float xt = MathUtils.getTransformX((Matrix4f)matrix, (float)((float)x2), (float)((float)y2), (float)((float)z2));
        float yt = MathUtils.getTransformY((Matrix4f)matrix, (float)((float)x2), (float)((float)y2), (float)((float)z2));
        float zt = MathUtils.getTransformZ((Matrix4f)matrix, (float)((float)x2), (float)((float)y2), (float)((float)z2));
        buffer.a((double)xt, (double)yt, (double)zt).e();
    }

    public static void preSkyList(eij matrixStackIn) {
        Shaders.setUpPosition((eij)matrixStackIn);
        RenderSystem.setShaderColor((float)fogColorR, (float)fogColorG, (float)fogColorB, (float)1.0f);
        Shaders.drawHorizon((eij)matrixStackIn);
        RenderSystem.setShaderColor((float)skyColorR, (float)skyColorG, (float)skyColorB, (float)1.0f);
    }

    public static void endSky() {
        isRenderingSky = false;
        Shaders.useProgram((Program)(lightmapEnabled ? ProgramTexturedLit : ProgramTextured));
        Shaders.popEntity();
        Shaders.setRenderStage((RenderStage)RenderStage.NONE);
    }

    public static void beginUpdateChunks() {
        Shaders.checkGLError((String)"beginUpdateChunks1");
        Shaders.checkFramebufferStatus((String)"beginUpdateChunks1");
        if (!isShadowPass) {
            Shaders.useProgram((Program)ProgramTerrain);
        }
        Shaders.checkGLError((String)"beginUpdateChunks2");
        Shaders.checkFramebufferStatus((String)"beginUpdateChunks2");
    }

    public static void endUpdateChunks() {
        Shaders.checkGLError((String)"endUpdateChunks1");
        Shaders.checkFramebufferStatus((String)"endUpdateChunks1");
        if (!isShadowPass) {
            Shaders.useProgram((Program)ProgramTerrain);
        }
        Shaders.checkGLError((String)"endUpdateChunks2");
        Shaders.checkFramebufferStatus((String)"endUpdateChunks2");
    }

    public static boolean shouldRenderClouds(enr gs) {
        if (!shaderPackLoaded) {
            return true;
        }
        Shaders.checkGLError((String)"shouldRenderClouds");
        return isShadowPass ? configCloudShadow : gs.as() != enc.a;
    }

    public static void beginClouds() {
        fogEnabled = true;
        Shaders.pushEntity((int)-3, (int)0);
        Shaders.useProgram((Program)ProgramClouds);
        Shaders.setRenderStage((RenderStage)RenderStage.CLOUDS);
    }

    public static void endClouds() {
        Shaders.disableFog();
        Shaders.popEntity();
        Shaders.useProgram((Program)(lightmapEnabled ? ProgramTexturedLit : ProgramTextured));
        Shaders.setRenderStage((RenderStage)RenderStage.NONE);
    }

    public static void beginEntities() {
        if (isRenderingWorld) {
            Shaders.useProgram((Program)ProgramEntities);
            Shaders.setRenderStage((RenderStage)RenderStage.ENTITIES);
        }
    }

    public static void nextEntity(bfj entity) {
        if (isRenderingWorld) {
            if (mc.b(entity)) {
                Shaders.useProgram((Program)ProgramEntitiesGlowing);
            } else {
                Shaders.useProgram((Program)ProgramEntities);
            }
            Shaders.setEntityId((bfj)entity);
        }
    }

    public static void setEntityId(bfj entity) {
        if (uniform_entityId.isDefined()) {
            int id = EntityUtils.getEntityIdByClass((bfj)entity);
            int idAlias = EntityAliases.getEntityAliasId((int)id);
            uniform_entityId.setValue(idAlias);
        }
    }

    public static void beginSpiderEyes() {
        if (isRenderingWorld && ProgramSpiderEyes.getId() != ProgramNone.getId()) {
            Shaders.useProgram((Program)ProgramSpiderEyes);
            GlStateManager._blendFunc((int)770, (int)771);
        }
    }

    public static void endSpiderEyes() {
        if (isRenderingWorld && ProgramSpiderEyes.getId() != ProgramNone.getId()) {
            Shaders.useProgram((Program)ProgramEntities);
        }
    }

    public static void endEntities() {
        if (isRenderingWorld) {
            Shaders.setEntityId(null);
            Shaders.useProgram((Program)(lightmapEnabled ? ProgramTexturedLit : ProgramTextured));
        }
    }

    public static void setEntityColor(float r2, float g2, float b2, float a2) {
        if (isRenderingWorld && !isShadowPass) {
            uniform_entityColor.setValue(r2, g2, b2, a2);
        }
    }

    public static void beginLivingDamage() {
        if (isRenderingWorld) {
            ShadersTex.bindTexture((fug)defaultTexture);
            if (!isShadowPass) {
                GlState.setDrawBuffers((DrawBuffers)drawBuffersColorAtt[0]);
            }
        }
    }

    public static void endLivingDamage() {
        if (isRenderingWorld && !isShadowPass) {
            GlState.setDrawBuffers((DrawBuffers)ProgramEntities.getDrawBuffers());
        }
    }

    public static void beginBlockEntities() {
        if (isRenderingWorld) {
            Shaders.checkGLError((String)"beginBlockEntities");
            Shaders.useProgram((Program)ProgramBlock);
            Shaders.setRenderStage((RenderStage)RenderStage.BLOCK_ENTITIES);
        }
    }

    public static void nextBlockEntity(czn tileEntity) {
        if (isRenderingWorld) {
            Shaders.checkGLError((String)"nextBlockEntity");
            Shaders.useProgram((Program)ProgramBlock);
            Shaders.setBlockEntityId((czn)tileEntity);
        }
    }

    public static void setBlockEntityId(czn tileEntity) {
        if (uniform_blockEntityId.isDefined()) {
            int blockId = Shaders.getBlockEntityId((czn)tileEntity);
            uniform_blockEntityId.setValue(blockId);
        }
    }

    private static int getBlockEntityId(czn tileEntity) {
        if (tileEntity == null) {
            return -1;
        }
        dcb blockState = tileEntity.q();
        if (blockState == null) {
            return -1;
        }
        int blockId = BlockAliases.getAliasBlockId((dcb)blockState);
        return blockId;
    }

    public static void endBlockEntities() {
        if (isRenderingWorld) {
            Shaders.checkGLError((String)"endBlockEntities");
            Shaders.setBlockEntityId(null);
            Shaders.useProgram((Program)(lightmapEnabled ? ProgramTexturedLit : ProgramTextured));
            ShadersTex.bindNSTextures((MultiTexID)defaultTexture.getMultiTexID());
        }
    }

    public static void beginLitParticles() {
        Shaders.useProgram((Program)ProgramTexturedLit);
    }

    public static void beginParticles() {
        Shaders.useProgram((Program)ProgramTextured);
        Shaders.setRenderStage((RenderStage)RenderStage.PARTICLES);
    }

    public static void endParticles() {
        Shaders.useProgram((Program)ProgramTexturedLit);
        Shaders.setRenderStage((RenderStage)RenderStage.NONE);
    }

    public static void readCenterDepth() {
        if (!isShadowPass && centerDepthSmoothEnabled) {
            tempDirectFloatBuffer.clear();
            GL43.glReadPixels((int)(renderWidth / 2), (int)(renderHeight / 2), (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)tempDirectFloatBuffer);
            centerDepth = tempDirectFloatBuffer.get(0);
            float fadeScalar = (float)diffSystemTime * 0.01f;
            float fadeFactor = (float)Math.exp(Math.log(0.5) * (double)fadeScalar / (double)centerDepthSmoothHalflife);
            centerDepthSmooth = centerDepthSmooth * fadeFactor + centerDepth * (1.0f - fadeFactor);
        }
    }

    public static void beginWeather() {
        if (!isShadowPass) {
            GlStateManager._enableDepthTest();
            GlStateManager._enableBlend();
            GlStateManager._blendFunc((int)770, (int)771);
            GlStateManager.enableAlphaTest();
            Shaders.useProgram((Program)ProgramWeather);
            Shaders.setRenderStage((RenderStage)RenderStage.RAIN_SNOW);
        }
    }

    public static void endWeather() {
        GlStateManager._disableBlend();
        Shaders.useProgram((Program)ProgramTexturedLit);
        Shaders.setRenderStage((RenderStage)RenderStage.NONE);
    }

    public static void preRenderHand() {
        if (!isShadowPass && usedDepthBuffers >= 3) {
            GlStateManager._activeTexture((int)33996);
            GL43.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)renderWidth, (int)renderHeight);
            GlStateManager._activeTexture((int)33984);
        }
    }

    public static void preWater() {
        if (usedDepthBuffers >= 2) {
            GlStateManager._activeTexture((int)33995);
            Shaders.checkGLError((String)"pre copy depth");
            GL43.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)renderWidth, (int)renderHeight);
            Shaders.checkGLError((String)"copy depth");
            GlStateManager._activeTexture((int)33984);
        }
        ShadersTex.bindNSTextures((MultiTexID)defaultTexture.getMultiTexID());
    }

    public static void beginWater() {
        if (isRenderingWorld) {
            if (!isShadowPass) {
                Shaders.renderDeferred();
                Shaders.useProgram((Program)ProgramWater);
                GlStateManager._enableBlend();
                GlStateManager._depthMask((boolean)true);
            } else {
                GlStateManager._depthMask((boolean)true);
            }
        }
    }

    public static void endWater() {
        if (isRenderingWorld) {
            if (isShadowPass) {
                // empty if block
            }
            Shaders.useProgram((Program)(lightmapEnabled ? ProgramTexturedLit : ProgramTextured));
        }
    }

    public static void applyHandDepth(eij matrixStackIn) {
        if ((double)configHandDepthMul != 1.0) {
            matrixStackIn.b(1.0f, 1.0f, configHandDepthMul);
        }
    }

    public static void beginHand(eij matrixStackIn, boolean translucent) {
        matrixStackIn.a();
        if (translucent) {
            Shaders.useProgram((Program)ProgramHandWater);
        } else {
            Shaders.useProgram((Program)ProgramHand);
        }
        Shaders.checkGLError((String)"beginHand");
        Shaders.checkFramebufferStatus((String)"beginHand");
    }

    public static void endHand(eij matrixStackIn) {
        Shaders.checkGLError((String)"pre endHand");
        Shaders.checkFramebufferStatus((String)"pre endHand");
        matrixStackIn.b();
        GlStateManager._blendFunc((int)770, (int)771);
        Shaders.checkGLError((String)"endHand");
    }

    public static void beginFPOverlay() {
        GlStateManager._disableBlend();
    }

    public static void endFPOverlay() {
    }

    public static void glEnableWrapper(int cap) {
        GL43.glEnable((int)cap);
        if (cap == 3553) {
            Shaders.enableTexture2D();
        } else if (cap == 2912) {
            Shaders.enableFog();
        }
    }

    public static void glDisableWrapper(int cap) {
        GL43.glDisable((int)cap);
        if (cap == 3553) {
            Shaders.disableTexture2D();
        } else if (cap == 2912) {
            Shaders.disableFog();
        }
    }

    public static void sglEnableT2D(int cap) {
        GL43.glEnable((int)cap);
        Shaders.enableTexture2D();
    }

    public static void sglDisableT2D(int cap) {
        GL43.glDisable((int)cap);
        Shaders.disableTexture2D();
    }

    public static void sglEnableFog(int cap) {
        GL43.glEnable((int)cap);
        Shaders.enableFog();
    }

    public static void sglDisableFog(int cap) {
        GL43.glDisable((int)cap);
        Shaders.disableFog();
    }

    public static void enableTexture2D() {
        if (isRenderingSky) {
            Shaders.useProgram((Program)ProgramSkyTextured);
        } else if (activeProgram == ProgramBasic) {
            Shaders.useProgram((Program)(lightmapEnabled ? ProgramTexturedLit : ProgramTextured));
        }
    }

    public static void disableTexture2D() {
        if (isRenderingSky) {
            Shaders.useProgram((Program)ProgramSkyBasic);
        } else if (activeProgram == ProgramTextured || activeProgram == ProgramTexturedLit) {
            Shaders.useProgram((Program)ProgramBasic);
        }
    }

    public static void pushProgram() {
        programStack.push(activeProgram);
    }

    public static void pushUseProgram(Program program) {
        Shaders.pushProgram();
        Shaders.useProgram((Program)program);
    }

    public static void popProgram() {
        Program program = programStack.pop();
        Shaders.useProgram((Program)program);
    }

    public static void beginLeash() {
        Shaders.pushProgram();
        Shaders.useProgram((Program)ProgramBasic);
    }

    public static void endLeash() {
        Shaders.popProgram();
    }

    public static void beginLines() {
        Shaders.pushProgram();
        Shaders.useProgram((Program)ProgramLine);
        Shaders.setRenderStage((RenderStage)RenderStage.OUTLINE);
    }

    public static void endLines() {
        Shaders.popProgram();
        Shaders.setRenderStage((RenderStage)RenderStage.NONE);
    }

    public static void beginWaterMask() {
        GlStateManager.disableAlphaTest();
    }

    public static void endWaterMask() {
        GlStateManager.enableAlphaTest();
    }

    public static void enableFog() {
        fogEnabled = true;
        if (fogAllowed) {
            Shaders.setProgramUniform1i((ShaderUniform1i)uniform_fogMode, (int)fogMode);
            Shaders.setProgramUniform1i((ShaderUniform1i)uniform_fogShape, (int)fogShape);
            Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogDensity, (float)fogDensity);
            Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogStart, (float)fogStart);
            Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogEnd, (float)fogEnd);
            Shaders.setProgramUniform3f((ShaderUniform3f)uniform_fogColor, (float)fogColorR, (float)fogColorG, (float)fogColorB);
        } else {
            Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogDensity, (float)0.0f);
            Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogStart, (float)1.7014117E38f);
            Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogEnd, (float)Float.MAX_VALUE);
        }
    }

    public static void disableFog() {
        fogEnabled = false;
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_fogMode, (int)0);
        Shaders.setProgramUniform1i((ShaderUniform1i)uniform_fogShape, (int)0);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogDensity, (float)0.0f);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogStart, (float)1.7014117E38f);
        Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogEnd, (float)Float.MAX_VALUE);
    }

    public static void setFogDensity(float value) {
        fogDensity = value;
        if (fogEnabled && fogAllowed) {
            Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogDensity, (float)value);
        }
    }

    public static void setFogStart(float value) {
        fogStart = value;
        if (fogEnabled && fogAllowed) {
            Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogStart, (float)value);
        }
    }

    public static void setFogEnd(float value) {
        fogEnd = value;
        if (fogEnabled && fogAllowed) {
            Shaders.setProgramUniform1f((ShaderUniform1f)uniform_fogEnd, (float)value);
        }
    }

    public static void sglFogi(int pname, int param) {
        GL11.glFogi((int)pname, (int)param);
        if (pname == 2917) {
            fogMode = param;
            if (fogEnabled && fogAllowed) {
                Shaders.setProgramUniform1i((ShaderUniform1i)uniform_fogMode, (int)fogMode);
            }
        }
    }

    public static void enableLightmap() {
        lightmapEnabled = true;
        if (activeProgram == ProgramTextured) {
            Shaders.useProgram((Program)ProgramTexturedLit);
        }
    }

    public static void disableLightmap() {
        lightmapEnabled = false;
        if (activeProgram == ProgramTexturedLit) {
            Shaders.useProgram((Program)ProgramTextured);
        }
    }

    public static int getEntityData() {
        return entityData[entityDataIndex * 2];
    }

    public static int getEntityData2() {
        return entityData[entityDataIndex * 2 + 1];
    }

    public static int setEntityData1(int data1) {
        Shaders.entityData[Shaders.entityDataIndex * 2] = entityData[entityDataIndex * 2] & 0xFFFF | data1 << 16;
        return data1;
    }

    public static int setEntityData2(int data2) {
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = entityData[entityDataIndex * 2 + 1] & 0xFFFF0000 | data2 & 0xFFFF;
        return data2;
    }

    public static void pushEntity(int data0, int data1) {
        Shaders.entityData[++Shaders.entityDataIndex * 2] = data0 & 0xFFFF | data1 << 16;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
    }

    public static void pushEntity(int data0) {
        Shaders.entityData[++Shaders.entityDataIndex * 2] = data0 & 0xFFFF;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
    }

    public static void pushEntity(cpn block) {
        int blockRenderType = block.b_(block.n()).ordinal();
        Shaders.entityData[++Shaders.entityDataIndex * 2] = jb.f.a((Object)block) & 0xFFFF | blockRenderType << 16;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
    }

    public static void popEntity() {
        Shaders.entityData[Shaders.entityDataIndex * 2] = 0;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
        --entityDataIndex;
    }

    public static void mcProfilerEndSection() {
        mc.aG().c();
    }

    public static String getShaderPackName() {
        if (shaderPack == null) {
            return null;
        }
        if (shaderPack instanceof ShaderPackNone) {
            return null;
        }
        return shaderPack.getName();
    }

    public static InputStream getShaderPackResourceStream(String path) {
        if (shaderPack == null) {
            return null;
        }
        return shaderPack.getResourceAsStream(path);
    }

    public static void nextAntialiasingLevel(boolean forward) {
        if (forward) {
            if ((configAntialiasingLevel += 2) > 4) {
                configAntialiasingLevel = 0;
            }
        } else if ((configAntialiasingLevel -= 2) < 0) {
            configAntialiasingLevel = 4;
        }
        configAntialiasingLevel = configAntialiasingLevel / 2 * 2;
        configAntialiasingLevel = Config.limit((int)configAntialiasingLevel, (int)0, (int)4);
    }

    public static void checkShadersModInstalled() {
        try {
            Class<?> clazz = Class.forName("shadersmod.transform.SMCClassTransformer");
        }
        catch (Throwable e2) {
            return;
        }
        throw new RuntimeException("Shaders Mod detected. Please remove it, OptiFine has built-in support for shaders.");
    }

    public static void resourcesReloaded() {
        Shaders.loadShaderPackResources();
        Shaders.reloadCustomTexturesLocation((ICustomTexture[])customTexturesGbuffers);
        Shaders.reloadCustomTexturesLocation((ICustomTexture[])customTexturesComposite);
        Shaders.reloadCustomTexturesLocation((ICustomTexture[])customTexturesDeferred);
        Shaders.reloadCustomTexturesLocation((ICustomTexture[])customTexturesShadowcomp);
        Shaders.reloadCustomTexturesLocation((ICustomTexture[])customTexturesPrepare);
        if (shaderPackLoaded) {
            BlockAliases.resourcesReloaded();
            ItemAliases.resourcesReloaded();
            EntityAliases.resourcesReloaded();
        }
    }

    private static void loadShaderPackResources() {
        shaderPackResources = new HashMap();
        if (!shaderPackLoaded) {
            return;
        }
        ArrayList<CallSite> listFiles = new ArrayList<CallSite>();
        String PREFIX = "/shaders/lang/";
        String EN_US = "en_us";
        String SUFFIX = ".lang";
        listFiles.add((CallSite)((Object)(PREFIX + EN_US + SUFFIX)));
        listFiles.add((CallSite)((Object)(PREFIX + Shaders.getLocaleUppercase((String)EN_US) + SUFFIX)));
        if (!Config.getGameSettings().ag.equals(EN_US)) {
            String language = Config.getGameSettings().ag;
            listFiles.add((CallSite)((Object)(PREFIX + language + SUFFIX)));
            listFiles.add((CallSite)((Object)(PREFIX + Shaders.getLocaleUppercase((String)language) + SUFFIX)));
        }
        try {
            for (String string : listFiles) {
                InputStream in2 = shaderPack.getResourceAsStream(string);
                if (in2 == null) continue;
                PropertiesOrdered props = new PropertiesOrdered();
                Lang.loadLocaleData((InputStream)in2, (Map)props);
                in2.close();
                Set<Object> keys = props.keySet();
                for (String string2 : keys) {
                    String value = props.getProperty(string2);
                    shaderPackResources.put(string2, value);
                }
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static String getLocaleUppercase(String name) {
        int pos = name.indexOf(95);
        if (pos < 0) {
            return name;
        }
        String nameUp = name.substring(0, pos) + name.substring(pos).toUpperCase(Locale.ROOT);
        return nameUp;
    }

    public static String translate(String key, String def) {
        String str = (String)shaderPackResources.get(key);
        if (str == null) {
            return def;
        }
        return str;
    }

    public static boolean isProgramPath(String path) {
        Program p2;
        if (path == null) {
            return false;
        }
        if (path.length() <= 0) {
            return false;
        }
        int pos = path.lastIndexOf("/");
        if (pos >= 0) {
            path = path.substring(pos + 1);
        }
        return (p2 = Shaders.getProgram((String)path)) != null;
    }

    public static Program getProgram(String name) {
        return programs.getProgram(name);
    }

    public static void setItemToRenderMain(cfz itemToRenderMain) {
        itemToRenderMainTranslucent = Shaders.isTranslucentBlock((cfz)itemToRenderMain);
    }

    public static void setItemToRenderOff(cfz itemToRenderOff) {
        itemToRenderOffTranslucent = Shaders.isTranslucentBlock((cfz)itemToRenderOff);
    }

    public static boolean isItemToRenderMainTranslucent() {
        return itemToRenderMainTranslucent;
    }

    public static boolean isItemToRenderOffTranslucent() {
        return itemToRenderOffTranslucent;
    }

    public static boolean isBothHandsRendered() {
        return isHandRenderedMain && isHandRenderedOff;
    }

    private static boolean isTranslucentBlock(cfz stack) {
        if (stack == null) {
            return false;
        }
        cfu item = stack.d();
        if (item == null) {
            return false;
        }
        if (!(item instanceof cds)) {
            return false;
        }
        cds itemBlock = (cds)item;
        cpn block = itemBlock.e();
        if (block == null) {
            return false;
        }
        fkf blockRenderLayer = fjs.a((dcb)block.n());
        return blockRenderLayer == RenderTypes.TRANSLUCENT;
    }

    public static boolean isSkipRenderHand(bdw hand) {
        if (hand == bdw.a && skipRenderHandMain) {
            return true;
        }
        return hand == bdw.b && skipRenderHandOff;
    }

    public static boolean isRenderBothHands() {
        return !skipRenderHandMain && !skipRenderHandOff;
    }

    public static void setSkipRenderHands(boolean skipMain, boolean skipOff) {
        skipRenderHandMain = skipMain;
        skipRenderHandOff = skipOff;
    }

    public static void setHandsRendered(boolean handMain, boolean handOff) {
        isHandRenderedMain = handMain;
        isHandRenderedOff = handOff;
    }

    public static boolean isHandRenderedMain() {
        return isHandRenderedMain;
    }

    public static boolean isHandRenderedOff() {
        return isHandRenderedOff;
    }

    public static float getShadowRenderDistance() {
        if (shadowDistanceRenderMul < 0.0f) {
            return -1.0f;
        }
        return shadowMapHalfPlane * shadowDistanceRenderMul;
    }

    public static void beginRenderFirstPersonHand(boolean translucent) {
        isRenderingFirstPersonHand = true;
        if (translucent) {
            Shaders.setRenderStage((RenderStage)RenderStage.HAND_TRANSLUCENT);
        } else {
            Shaders.setRenderStage((RenderStage)RenderStage.HAND_SOLID);
        }
    }

    public static void endRenderFirstPersonHand() {
        isRenderingFirstPersonHand = false;
        Shaders.setRenderStage((RenderStage)RenderStage.NONE);
    }

    public static boolean isRenderingFirstPersonHand() {
        return isRenderingFirstPersonHand;
    }

    public static void beginBeacon() {
        if (isRenderingWorld) {
            Shaders.useProgram((Program)ProgramBeaconBeam);
        }
    }

    public static void endBeacon() {
        if (isRenderingWorld) {
            Shaders.useProgram((Program)ProgramBlock);
        }
    }

    public static few getCurrentWorld() {
        return currentWorld;
    }

    public static gu getWorldCameraPosition() {
        return gu.a((double)(cameraPositionX + (double)cameraOffsetX), (double)cameraPositionY, (double)(cameraPositionZ + (double)cameraOffsetZ));
    }

    public static boolean isCustomUniforms() {
        return customUniforms != null;
    }

    public static boolean canRenderQuads() {
        if (hasGeometryShaders) {
            return Shaders.capabilities.GL_NV_geometry_shader4;
        }
        return true;
    }

    public static boolean isOverlayDisabled() {
        return shaderPackLoaded;
    }

    public static boolean isRemapLightmap() {
        return shaderPackLoaded;
    }

    public static boolean isEffectsModelView() {
        return shaderPackLoaded;
    }

    public static void flushRenderBuffers() {
        RenderUtils.flushRenderBuffers();
    }

    public static void setRenderStage(RenderStage stage) {
        if (!shaderPackLoaded) {
            return;
        }
        renderStage = stage;
        uniform_renderStage.setValue(stage.ordinal());
    }

    public static void setModelView(Matrix4f matrixIn) {
        if (matrixIn.equals((Object)lastModelView)) {
            return;
        }
        lastModelView.set((Matrix4fc)matrixIn);
        MathUtils.write((Matrix4f)matrixIn, (FloatBuffer)modelView);
        SMath.invertMat4FBFA((FloatBuffer)modelViewInverse.position(0), (FloatBuffer)modelView.position(0), (float[])faModelViewInverse, (float[])faModelView);
        modelView.position(0);
        modelViewInverse.position(0);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferModelView, (boolean)false, (FloatBuffer)modelView);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferModelViewInverse, (boolean)false, (FloatBuffer)modelViewInverse);
    }

    public static void setProjection(Matrix4f matrixIn) {
        if (matrixIn.equals((Object)lastProjection)) {
            return;
        }
        lastProjection.set((Matrix4fc)matrixIn);
        MathUtils.write((Matrix4f)matrixIn, (FloatBuffer)projection);
        SMath.invertMat4FBFA((FloatBuffer)projectionInverse.position(0), (FloatBuffer)projection.position(0), (float[])faProjectionInverse, (float[])faProjection);
        projection.position(0);
        projectionInverse.position(0);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferProjection, (boolean)false, (FloatBuffer)projection);
        Shaders.setProgramUniformMatrix4ARB((ShaderUniformM4)uniform_gbufferProjectionInverse, (boolean)false, (FloatBuffer)projectionInverse);
    }

    public static void setModelViewMatrix(Matrix4f matrixIn) {
        uniform_modelViewMatrix.setValue(matrixIn);
        if (uniform_modelViewMatrixInverse.isDefined()) {
            Matrix4f matInv = new Matrix4f((Matrix4fc)matrixIn);
            matInv.invert();
            uniform_modelViewMatrixInverse.setValue(matInv);
        }
        if (uniform_normalMatrix.isDefined()) {
            Matrix3f normalMat3 = new Matrix3f((Matrix4fc)matrixIn);
            normalMat3.invert();
            normalMat3.transpose();
            uniform_normalMatrix.setValue(normalMat3);
        }
    }

    public static void setProjectionMatrix(Matrix4f matrixIn) {
        uniform_projectionMatrix.setValue(matrixIn);
        if (uniform_projectionMatrixInverse.isDefined()) {
            Matrix4f matInv = new Matrix4f((Matrix4fc)matrixIn);
            matInv.invert();
            uniform_projectionMatrixInverse.setValue(matInv);
        }
    }

    public static void setTextureMatrix(Matrix4f matrixIn) {
        uniform_textureMatrix.setValue(matrixIn);
    }

    public static void setColorModulator(float[] cols) {
        if (cols == null || cols.length < 4) {
            return;
        }
        uniform_colorModulator.setValue(cols[0], cols[1], cols[2], cols[3]);
    }

    public static void setFogAllowed(boolean fogAllowed) {
        Shaders.fogAllowed = fogAllowed;
    }

    public static void setDefaultAttribColor() {
        Shaders.setDefaultAttribColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void setDefaultAttribLightmap() {
        Shaders.setDefaultAttribLightmap((short)240, (short)240);
    }

    private static void setDefaultAttribNormal() {
        Shaders.setDefaultAttribNormal((float)0.0f, (float)1.0f, (float)0.0f);
    }

    public static void setDefaultAttribColor(float r2, float g2, float b2, float a2) {
        GL30.glVertexAttrib4f((int)eih.b.getAttributeIndex(), (float)r2, (float)g2, (float)b2, (float)a2);
    }

    private static void setDefaultAttribLightmap(short su2, short sv2) {
        GL30.glVertexAttrib2s((int)eih.e.getAttributeIndex(), (short)su2, (short)sv2);
    }

    private static void setDefaultAttribNormal(float x2, float y2, float z2) {
        GL30.glVertexAttrib3f((int)eih.f.getAttributeIndex(), (float)x2, (float)y2, (float)z2);
    }

    private static int getBossBattle() {
        String bossName = Shaders.mc.l.j().getBossName();
        if (bossName == null) {
            return 0;
        }
        if (bossName.equals("entity.minecraft.ender_dragon")) {
            return 2;
        }
        if (bossName.equals("entity.minecraft.wither")) {
            return 3;
        }
        if (bossName.equals("event.minecraft.raid")) {
            return 4;
        }
        return 1;
    }

    public static void setDarknessFactor(float darknessFactor) {
        Shaders.darknessFactor = darknessFactor;
    }

    public static void setDarknessLightFactor(float darknessLightFactor) {
        Shaders.darknessLightFactor = darknessLightFactor;
    }

    static {
        isInitializedOnce = false;
        isShaderPackInitialized = false;
        hasGlGenMipmap = false;
        countResetDisplayLists = 0;
        renderDisplayWidth = 0;
        renderDisplayHeight = 0;
        renderWidth = 0;
        renderHeight = 0;
        isRenderingWorld = false;
        isRenderingSky = false;
        isCompositeRendered = false;
        isRenderingDfb = false;
        isShadowPass = false;
        renderItemKeepDepthMask = false;
        itemToRenderMainTranslucent = false;
        itemToRenderOffTranslucent = false;
        sunPosition = new float[4];
        moonPosition = new float[4];
        shadowLightPosition = new float[4];
        upPosition = new float[4];
        shadowLightPositionVector = new float[4];
        upPosModelView = new float[]{0.0f, 100.0f, 0.0f, 0.0f};
        sunPosModelView = new float[]{0.0f, 100.0f, 0.0f, 0.0f};
        moonPosModelView = new float[]{0.0f, -100.0f, 0.0f, 0.0f};
        tempMat = new float[16];
        clearColor = new Vector4f();
        worldTime = 0L;
        lastWorldTime = 0L;
        diffWorldTime = 0L;
        celestialAngle = 0.0f;
        sunAngle = 0.0f;
        shadowAngle = 0.0f;
        moonPhase = 0;
        systemTime = 0L;
        lastSystemTime = 0L;
        diffSystemTime = 0L;
        frameCounter = 0;
        frameTime = 0.0f;
        frameTimeCounter = 0.0f;
        systemTimeInt32 = 0;
        pointOfView = ena.a;
        pointOfViewChanged = false;
        rainStrength = 0.0f;
        wetness = 0.0f;
        wetnessHalfLife = 600.0f;
        drynessHalfLife = 200.0f;
        eyeBrightnessHalflife = 10.0f;
        usewetness = false;
        isEyeInWater = 0;
        eyeBrightness = 0;
        eyeBrightnessFadeX = 0.0f;
        eyeBrightnessFadeY = 0.0f;
        eyePosY = 0.0f;
        centerDepth = 0.0f;
        centerDepthSmooth = 0.0f;
        centerDepthSmoothHalflife = 1.0f;
        centerDepthSmoothEnabled = false;
        superSamplingLevel = 1;
        nightVision = 0.0f;
        blindness = 0.0f;
        lightmapEnabled = false;
        fogEnabled = true;
        fogAllowed = true;
        renderStage = RenderStage.NONE;
        bossBattle = 0;
        darknessFactor = 0.0f;
        darknessLightFactor = 0.0f;
        baseAttribId = 11;
        entityAttrib = baseAttribId + 0;
        midTexCoordAttrib = baseAttribId + 1;
        tangentAttrib = baseAttribId + 2;
        velocityAttrib = baseAttribId + 3;
        midBlockAttrib = baseAttribId + 4;
        useEntityAttrib = false;
        useMidTexCoordAttrib = false;
        useTangentAttrib = false;
        useVelocityAttrib = false;
        useMidBlockAttrib = false;
        progUseEntityAttrib = false;
        progUseMidTexCoordAttrib = false;
        progUseTangentAttrib = false;
        progUseVelocityAttrib = false;
        progUseMidBlockAttrib = false;
        progArbGeometryShader4 = false;
        progExtGeometryShader4 = false;
        progMaxVerticesOut = 3;
        hasGeometryShaders = false;
        hasShadowGeometryShaders = false;
        hasShadowInstancing = false;
        atlasSizeX = 0;
        atlasSizeY = 0;
        shaderUniforms = new ShaderUniforms();
        uniform_entityColor = shaderUniforms.make4f("entityColor");
        uniform_entityId = shaderUniforms.make1i("entityId");
        uniform_blockEntityId = shaderUniforms.make1i("blockEntityId");
        uniform_gtexture = shaderUniforms.make1i("gtexture");
        uniform_lightmap = shaderUniforms.make1i("lightmap");
        uniform_normals = shaderUniforms.make1i("normals");
        uniform_specular = shaderUniforms.make1i("specular");
        uniform_shadow = shaderUniforms.make1i("shadow");
        uniform_watershadow = shaderUniforms.make1i("watershadow");
        uniform_shadowtex0 = shaderUniforms.make1i("shadowtex0");
        uniform_shadowtex1 = shaderUniforms.make1i("shadowtex1");
        uniform_depthtex0 = shaderUniforms.make1i("depthtex0");
        uniform_depthtex1 = shaderUniforms.make1i("depthtex1");
        uniform_shadowcolor = shaderUniforms.make1i("shadowcolor");
        uniform_shadowcolor0 = shaderUniforms.make1i("shadowcolor0");
        uniform_shadowcolor1 = shaderUniforms.make1i("shadowcolor1");
        uniform_noisetex = shaderUniforms.make1i("noisetex");
        uniform_gcolor = shaderUniforms.make1i("gcolor");
        uniform_gdepth = shaderUniforms.make1i("gdepth");
        uniform_gnormal = shaderUniforms.make1i("gnormal");
        uniform_composite = shaderUniforms.make1i("composite");
        uniform_gaux1 = shaderUniforms.make1i("gaux1");
        uniform_gaux2 = shaderUniforms.make1i("gaux2");
        uniform_gaux3 = shaderUniforms.make1i("gaux3");
        uniform_gaux4 = shaderUniforms.make1i("gaux4");
        uniform_colortex0 = shaderUniforms.make1i("colortex0");
        uniform_colortex1 = shaderUniforms.make1i("colortex1");
        uniform_colortex2 = shaderUniforms.make1i("colortex2");
        uniform_colortex3 = shaderUniforms.make1i("colortex3");
        uniform_colortex4 = shaderUniforms.make1i("colortex4");
        uniform_colortex5 = shaderUniforms.make1i("colortex5");
        uniform_colortex6 = shaderUniforms.make1i("colortex6");
        uniform_colortex7 = shaderUniforms.make1i("colortex7");
        uniform_gdepthtex = shaderUniforms.make1i("gdepthtex");
        uniform_depthtex2 = shaderUniforms.make1i("depthtex2");
        uniform_colortex8 = shaderUniforms.make1i("colortex8");
        uniform_colortex9 = shaderUniforms.make1i("colortex9");
        uniform_colortex10 = shaderUniforms.make1i("colortex10");
        uniform_colortex11 = shaderUniforms.make1i("colortex11");
        uniform_colortex12 = shaderUniforms.make1i("colortex12");
        uniform_colortex13 = shaderUniforms.make1i("colortex13");
        uniform_colortex14 = shaderUniforms.make1i("colortex14");
        uniform_colortex15 = shaderUniforms.make1i("colortex15");
        uniform_colorimg0 = shaderUniforms.make1i("colorimg0");
        uniform_colorimg1 = shaderUniforms.make1i("colorimg1");
        uniform_colorimg2 = shaderUniforms.make1i("colorimg2");
        uniform_colorimg3 = shaderUniforms.make1i("colorimg3");
        uniform_colorimg4 = shaderUniforms.make1i("colorimg4");
        uniform_colorimg5 = shaderUniforms.make1i("colorimg5");
        uniform_shadowcolorimg0 = shaderUniforms.make1i("shadowcolorimg0");
        uniform_shadowcolorimg1 = shaderUniforms.make1i("shadowcolorimg1");
        uniform_tex = shaderUniforms.make1i("tex");
        uniform_heldItemId = shaderUniforms.make1i("heldItemId");
        uniform_heldBlockLightValue = shaderUniforms.make1i("heldBlockLightValue");
        uniform_heldItemId2 = shaderUniforms.make1i("heldItemId2");
        uniform_heldBlockLightValue2 = shaderUniforms.make1i("heldBlockLightValue2");
        uniform_fogMode = shaderUniforms.make1i("fogMode");
        uniform_fogDensity = shaderUniforms.make1f("fogDensity");
        uniform_fogStart = shaderUniforms.make1f("fogStart");
        uniform_fogEnd = shaderUniforms.make1f("fogEnd");
        uniform_fogShape = shaderUniforms.make1i("fogShape");
        uniform_fogColor = shaderUniforms.make3f("fogColor");
        uniform_skyColor = shaderUniforms.make3f("skyColor");
        uniform_worldTime = shaderUniforms.make1i("worldTime");
        uniform_worldDay = shaderUniforms.make1i("worldDay");
        uniform_moonPhase = shaderUniforms.make1i("moonPhase");
        uniform_frameCounter = shaderUniforms.make1i("frameCounter");
        uniform_frameTime = shaderUniforms.make1f("frameTime");
        uniform_frameTimeCounter = shaderUniforms.make1f("frameTimeCounter");
        uniform_sunAngle = shaderUniforms.make1f("sunAngle");
        uniform_shadowAngle = shaderUniforms.make1f("shadowAngle");
        uniform_rainStrength = shaderUniforms.make1f("rainStrength");
        uniform_aspectRatio = shaderUniforms.make1f("aspectRatio");
        uniform_viewWidth = shaderUniforms.make1f("viewWidth");
        uniform_viewHeight = shaderUniforms.make1f("viewHeight");
        uniform_near = shaderUniforms.make1f("near");
        uniform_far = shaderUniforms.make1f("far");
        uniform_sunPosition = shaderUniforms.make3f("sunPosition");
        uniform_moonPosition = shaderUniforms.make3f("moonPosition");
        uniform_shadowLightPosition = shaderUniforms.make3f("shadowLightPosition");
        uniform_upPosition = shaderUniforms.make3f("upPosition");
        uniform_previousCameraPosition = shaderUniforms.make3f("previousCameraPosition");
        uniform_cameraPosition = shaderUniforms.make3f("cameraPosition");
        uniform_gbufferModelView = shaderUniforms.makeM4("gbufferModelView");
        uniform_gbufferModelViewInverse = shaderUniforms.makeM4("gbufferModelViewInverse");
        uniform_gbufferPreviousProjection = shaderUniforms.makeM4("gbufferPreviousProjection");
        uniform_gbufferProjection = shaderUniforms.makeM4("gbufferProjection");
        uniform_gbufferProjectionInverse = shaderUniforms.makeM4("gbufferProjectionInverse");
        uniform_gbufferPreviousModelView = shaderUniforms.makeM4("gbufferPreviousModelView");
        uniform_shadowProjection = shaderUniforms.makeM4("shadowProjection");
        uniform_shadowProjectionInverse = shaderUniforms.makeM4("shadowProjectionInverse");
        uniform_shadowModelView = shaderUniforms.makeM4("shadowModelView");
        uniform_shadowModelViewInverse = shaderUniforms.makeM4("shadowModelViewInverse");
        uniform_wetness = shaderUniforms.make1f("wetness");
        uniform_eyeAltitude = shaderUniforms.make1f("eyeAltitude");
        uniform_eyeBrightness = shaderUniforms.make2i("eyeBrightness");
        uniform_eyeBrightnessSmooth = shaderUniforms.make2i("eyeBrightnessSmooth");
        uniform_terrainTextureSize = shaderUniforms.make2i("terrainTextureSize");
        uniform_terrainIconSize = shaderUniforms.make1i("terrainIconSize");
        uniform_isEyeInWater = shaderUniforms.make1i("isEyeInWater");
        uniform_nightVision = shaderUniforms.make1f("nightVision");
        uniform_blindness = shaderUniforms.make1f("blindness");
        uniform_screenBrightness = shaderUniforms.make1f("screenBrightness");
        uniform_hideGUI = shaderUniforms.make1i("hideGUI");
        uniform_centerDepthSmooth = shaderUniforms.make1f("centerDepthSmooth");
        uniform_atlasSize = shaderUniforms.make2i("atlasSize");
        uniform_spriteBounds = shaderUniforms.make4f("spriteBounds");
        uniform_blendFunc = shaderUniforms.make4i("blendFunc");
        uniform_instanceId = shaderUniforms.make1i("instanceId");
        uniform_playerMood = shaderUniforms.make1f("playerMood");
        uniform_renderStage = shaderUniforms.make1i("renderStage");
        uniform_bossBattle = shaderUniforms.make1i("bossBattle");
        uniform_modelViewMatrix = shaderUniforms.makeM4("modelViewMatrix");
        uniform_modelViewMatrixInverse = shaderUniforms.makeM4("modelViewMatrixInverse");
        uniform_projectionMatrix = shaderUniforms.makeM4("projectionMatrix");
        uniform_projectionMatrixInverse = shaderUniforms.makeM4("projectionMatrixInverse");
        uniform_textureMatrix = shaderUniforms.makeM4("textureMatrix");
        uniform_normalMatrix = shaderUniforms.makeM3("normalMatrix");
        uniform_chunkOffset = shaderUniforms.make3f("chunkOffset");
        uniform_colorModulator = shaderUniforms.make4f("colorModulator");
        uniform_alphaTestRef = shaderUniforms.make1f("alphaTestRef");
        uniform_darknessFactor = shaderUniforms.make1f("darknessFactor");
        uniform_darknessLightFactor = shaderUniforms.make1f("darknessLightFactor");
        hasShadowMap = false;
        needResizeShadow = false;
        shadowMapWidth = 1024;
        shadowMapHeight = 1024;
        spShadowMapWidth = 1024;
        spShadowMapHeight = 1024;
        shadowMapFOV = 90.0f;
        shadowMapHalfPlane = 160.0f;
        shadowMapIsOrtho = true;
        shadowDistanceRenderMul = -1.0f;
        shouldSkipDefaultShadow = false;
        waterShadowEnabled = false;
        usedColorBuffers = 0;
        usedDepthBuffers = 0;
        usedShadowColorBuffers = 0;
        usedShadowDepthBuffers = 0;
        usedColorAttachs = 0;
        usedDrawBuffers = 0;
        bindImageTextures = false;
        gbuffersFormat = new int[16];
        gbuffersClear = new boolean[16];
        gbuffersClearColor = new Vector4f[16];
        CLEAR_COLOR_0 = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        CLEAR_COLOR_1 = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        shadowBuffersFormat = new int[2];
        shadowBuffersClear = new boolean[2];
        shadowBuffersClearColor = new Vector4f[2];
        programs = new Programs();
        ProgramNone = programs.getProgramNone();
        ProgramShadow = programs.makeShadow("shadow", ProgramNone);
        ProgramShadowSolid = programs.makeShadow("shadow_solid", ProgramShadow);
        ProgramShadowCutout = programs.makeShadow("shadow_cutout", ProgramShadow);
        ProgramsShadowcomp = programs.makeShadowcomps("shadowcomp", 100);
        ProgramsPrepare = programs.makePrepares("prepare", 100);
        ProgramBasic = programs.makeGbuffers("gbuffers_basic", ProgramNone);
        ProgramLine = programs.makeGbuffers("gbuffers_line", ProgramBasic);
        ProgramTextured = programs.makeGbuffers("gbuffers_textured", ProgramBasic);
        ProgramTexturedLit = programs.makeGbuffers("gbuffers_textured_lit", ProgramTextured);
        ProgramSkyBasic = programs.makeGbuffers("gbuffers_skybasic", ProgramBasic);
        ProgramSkyTextured = programs.makeGbuffers("gbuffers_skytextured", ProgramTextured);
        ProgramClouds = programs.makeGbuffers("gbuffers_clouds", ProgramTextured);
        ProgramTerrain = programs.makeGbuffers("gbuffers_terrain", ProgramTexturedLit);
        ProgramTerrainSolid = programs.makeGbuffers("gbuffers_terrain_solid", ProgramTerrain);
        ProgramTerrainCutoutMip = programs.makeGbuffers("gbuffers_terrain_cutout_mip", ProgramTerrain);
        ProgramTerrainCutout = programs.makeGbuffers("gbuffers_terrain_cutout", ProgramTerrain);
        ProgramDamagedBlock = programs.makeGbuffers("gbuffers_damagedblock", ProgramTerrain);
        ProgramBlock = programs.makeGbuffers("gbuffers_block", ProgramTerrain);
        ProgramBeaconBeam = programs.makeGbuffers("gbuffers_beaconbeam", ProgramTextured);
        ProgramItem = programs.makeGbuffers("gbuffers_item", ProgramTexturedLit);
        ProgramEntities = programs.makeGbuffers("gbuffers_entities", ProgramTexturedLit);
        ProgramEntitiesGlowing = programs.makeGbuffers("gbuffers_entities_glowing", ProgramEntities);
        ProgramArmorGlint = programs.makeGbuffers("gbuffers_armor_glint", ProgramTextured);
        ProgramSpiderEyes = programs.makeGbuffers("gbuffers_spidereyes", ProgramTextured);
        ProgramHand = programs.makeGbuffers("gbuffers_hand", ProgramTexturedLit);
        ProgramWeather = programs.makeGbuffers("gbuffers_weather", ProgramTexturedLit);
        ProgramDeferredPre = programs.makeVirtual("deferred_pre");
        ProgramsDeferred = programs.makeDeferreds("deferred", 100);
        ProgramDeferred = ProgramsDeferred[0];
        ProgramWater = programs.makeGbuffers("gbuffers_water", ProgramTerrain);
        ProgramHandWater = programs.makeGbuffers("gbuffers_hand_water", ProgramHand);
        ProgramCompositePre = programs.makeVirtual("composite_pre");
        ProgramsComposite = programs.makeComposites("composite", 100);
        ProgramComposite = ProgramsComposite[0];
        ProgramFinal = programs.makeComposite("final");
        ProgramCount = programs.getCount();
        ProgramsAll = programs.getPrograms();
        activeProgram = ProgramNone;
        activeProgramID = 0;
        programStack = new ProgramStack();
        hasDeferredPrograms = false;
        hasShadowcompPrograms = false;
        hasPreparePrograms = false;
        loadedShaders = null;
        shadersConfig = null;
        defaultTexture = null;
        shadowHardwareFilteringEnabled = new boolean[2];
        shadowMipmapEnabled = new boolean[2];
        shadowFilterNearest = new boolean[2];
        shadowColorMipmapEnabled = new boolean[2];
        shadowColorFilterNearest = new boolean[2];
        configTweakBlockDamage = false;
        configCloudShadow = false;
        configHandDepthMul = 0.125f;
        configRenderResMul = 1.0f;
        configShadowResMul = 1.0f;
        configTexMinFilB = 0;
        configTexMinFilN = 0;
        configTexMinFilS = 0;
        configTexMagFilB = 0;
        configTexMagFilN = 0;
        configTexMagFilS = 0;
        configShadowClipFrustrum = true;
        configNormalMap = true;
        configSpecularMap = true;
        configOldLighting = new PropertyDefaultTrueFalse("oldLighting", "Classic Lighting", 0);
        configOldHandLight = new PropertyDefaultTrueFalse("oldHandLight", "Old Hand Light", 0);
        configAntialiasingLevel = 0;
        texMinFilDesc = new String[]{"Nearest", "Nearest-Nearest", "Nearest-Linear"};
        texMagFilDesc = new String[]{"Nearest", "Linear"};
        texMinFilValue = new int[]{9728, 9984, 9986};
        texMagFilValue = new int[]{9728, 9729};
        shaderPack = null;
        shaderPackLoaded = false;
        shaderPacksDir = new File(enn.N().p, "shaderpacks");
        configFile = new File(enn.N().p, "optionsshaders.txt");
        shaderPackOptions = null;
        shaderPackOptionSliders = null;
        shaderPackProfiles = null;
        shaderPackGuiScreens = null;
        shaderPackProgramConditions = new HashMap();
        shaderPackClouds = new PropertyDefaultFastFancyOff("clouds", "Clouds", 0);
        shaderPackOldLighting = new PropertyDefaultTrueFalse("oldLighting", "Classic Lighting", 0);
        shaderPackOldHandLight = new PropertyDefaultTrueFalse("oldHandLight", "Old Hand Light", 0);
        shaderPackDynamicHandLight = new PropertyDefaultTrueFalse("dynamicHandLight", "Dynamic Hand Light", 0);
        shaderPackShadowTerrain = new PropertyDefaultTrueFalse("shadowTerrain", "Shadow Terrain", 0);
        shaderPackShadowTranslucent = new PropertyDefaultTrueFalse("shadowTranslucent", "Shadow Translucent", 0);
        shaderPackShadowEntities = new PropertyDefaultTrueFalse("shadowEntities", "Shadow Entities", 0);
        shaderPackShadowBlockEntities = new PropertyDefaultTrueFalse("shadowBlockEntities", "Shadow Block Entities", 0);
        shaderPackUnderwaterOverlay = new PropertyDefaultTrueFalse("underwaterOverlay", "Underwater Overlay", 0);
        shaderPackSun = new PropertyDefaultTrueFalse("sun", "Sun", 0);
        shaderPackMoon = new PropertyDefaultTrueFalse("moon", "Moon", 0);
        shaderPackVignette = new PropertyDefaultTrueFalse("vignette", "Vignette", 0);
        shaderPackBackFaceSolid = new PropertyDefaultTrueFalse("backFace.solid", "Back-face Solid", 0);
        shaderPackBackFaceCutout = new PropertyDefaultTrueFalse("backFace.cutout", "Back-face Cutout", 0);
        shaderPackBackFaceCutoutMipped = new PropertyDefaultTrueFalse("backFace.cutoutMipped", "Back-face Cutout Mipped", 0);
        shaderPackBackFaceTranslucent = new PropertyDefaultTrueFalse("backFace.translucent", "Back-face Translucent", 0);
        shaderPackRainDepth = new PropertyDefaultTrueFalse("rain.depth", "Rain Depth", 0);
        shaderPackBeaconBeamDepth = new PropertyDefaultTrueFalse("beacon.beam.depth", "Rain Depth", 0);
        shaderPackSeparateAo = new PropertyDefaultTrueFalse("separateAo", "Separate AO", 0);
        shaderPackFrustumCulling = new PropertyDefaultTrueFalse("frustum.culling", "Frustum Culling", 0);
        shaderPackShadowCulling = new PropertyDefaultTrueFalse("shadow.culling", "Shadow Culling", 0);
        shaderPackParticlesBeforeDeferred = new PropertyDefaultTrueFalse("particles.before.deferred", "Particles before deferred", 0);
        shaderPackResources = new HashMap();
        currentWorld = null;
        shaderPackDimensions = new ArrayList();
        customTexturesGbuffers = null;
        customTexturesComposite = null;
        customTexturesDeferred = null;
        customTexturesShadowcomp = null;
        customTexturesPrepare = null;
        noiseTexturePath = null;
        colorBufferSizes = new DynamicDimension[16];
        customUniforms = null;
        saveFinalShaders = System.getProperty("shaders.debug.save", "false").equals("true");
        blockLightLevel05 = 0.5f;
        blockLightLevel06 = 0.6f;
        blockLightLevel08 = 0.8f;
        aoLevel = -1.0f;
        sunPathRotation = 0.0f;
        shadowAngleInterval = 0.0f;
        fogMode = 0;
        fogShape = 0;
        fogDensity = 0.0f;
        fogStart = 0.0f;
        fogEnd = 0.0f;
        shadowIntervalSize = 2.0f;
        terrainIconSize = 16;
        terrainTextureSize = new int[2];
        noiseTextureEnabled = false;
        noiseTextureResolution = 256;
        colorTextureImageUnit = new int[]{0, 1, 2, 3, 7, 8, 9, 10, 16, 17, 18, 19, 20, 21, 22, 23};
        depthTextureImageUnit = new int[]{6, 11, 12};
        shadowColorTextureImageUnit = new int[]{13, 14};
        shadowDepthTextureImageUnit = new int[]{4, 5};
        colorImageUnit = new int[]{0, 1, 2, 3, 4, 5};
        shadowColorImageUnit = new int[]{6, 7};
        bigBufferSize = (295 + 8 * ProgramCount) * 4;
        bigBuffer = BufferUtils.createByteBuffer((int)bigBufferSize).limit(0);
        faProjection = new float[16];
        faProjectionInverse = new float[16];
        faModelView = new float[16];
        faModelViewInverse = new float[16];
        faShadowProjection = new float[16];
        faShadowProjectionInverse = new float[16];
        faShadowModelView = new float[16];
        faShadowModelViewInverse = new float[16];
        projection = Shaders.nextFloatBuffer((int)16);
        projectionInverse = Shaders.nextFloatBuffer((int)16);
        modelView = Shaders.nextFloatBuffer((int)16);
        modelViewInverse = Shaders.nextFloatBuffer((int)16);
        shadowProjection = Shaders.nextFloatBuffer((int)16);
        shadowProjectionInverse = Shaders.nextFloatBuffer((int)16);
        shadowModelView = Shaders.nextFloatBuffer((int)16);
        shadowModelViewInverse = Shaders.nextFloatBuffer((int)16);
        lastModelView = new Matrix4f();
        lastProjection = new Matrix4f();
        previousProjection = Shaders.nextFloatBuffer((int)16);
        previousModelView = Shaders.nextFloatBuffer((int)16);
        tempMatrixDirectBuffer = Shaders.nextFloatBuffer((int)16);
        tempDirectFloatBuffer = Shaders.nextFloatBuffer((int)16);
        dfbDrawBuffers = new DrawBuffers("dfbDrawBuffers", 16, 8);
        sfbDrawBuffers = new DrawBuffers("sfbDrawBuffers", 16, 8);
        drawBuffersNone = new DrawBuffers("drawBuffersNone", 16, 8).limit(0);
        drawBuffersColorAtt = Shaders.makeDrawBuffersColorSingle((int)16);
        MATRIX_IDENTITY = MathUtils.makeMatrixIdentity();
        formatNames = new String[]{"R8", "RG8", "RGB8", "RGBA8", "R8_SNORM", "RG8_SNORM", "RGB8_SNORM", "RGBA8_SNORM", "R8I", "RG8I", "RGB8I", "RGBA8I", "R8UI", "RG8UI", "RGB8UI", "RGBA8UI", "R16", "RG16", "RGB16", "RGBA16", "R16_SNORM", "RG16_SNORM", "RGB16_SNORM", "RGBA16_SNORM", "R16F", "RG16F", "RGB16F", "RGBA16F", "R16I", "RG16I", "RGB16I", "RGBA16I", "R16UI", "RG16UI", "RGB16UI", "RGBA16UI", "R32F", "RG32F", "RGB32F", "RGBA32F", "R32I", "RG32I", "RGB32I", "RGBA32I", "R32UI", "RG32UI", "RGB32UI", "RGBA32UI", "R3_G3_B2", "RGB5_A1", "RGB10_A2", "R11F_G11F_B10F", "RGB9_E5"};
        formatIds = new int[]{33321, 33323, 32849, 32856, 36756, 36757, 36758, 36759, 33329, 33335, 36239, 36238, 33330, 33336, 36221, 36220, 33322, 33324, 32852, 32859, 36760, 36761, 36762, 36763, 33325, 33327, 34843, 34842, 33331, 33337, 36233, 36232, 33332, 33338, 36215, 36214, 33326, 33328, 34837, 34836, 33333, 33339, 36227, 36226, 33334, 33340, 36209, 36208, 10768, 32855, 32857, 35898, 35901};
        patternLoadEntityDataMap = Pattern.compile("\\s*([\\w:]+)\\s*=\\s*([-]?\\d+)\\s*");
        entityData = new int[32];
        entityDataIndex = 0;
    }
}

