/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.optifine.BlockPosM;

public class IteratorAxis
implements Iterator<gu> {
    private double yDelta;
    private double zDelta;
    private int xStart;
    private int xEnd;
    private double yStart;
    private double yEnd;
    private double zStart;
    private double zEnd;
    private int xNext;
    private double yNext;
    private double zNext;
    private BlockPosM pos = new BlockPosM(0, 0, 0);
    private boolean hasNext = false;

    public IteratorAxis(gu posStart, gu posEnd, double yDelta, double zDelta) {
        this.yDelta = yDelta;
        this.zDelta = zDelta;
        this.xStart = posStart.u();
        this.xEnd = posEnd.u();
        this.yStart = posStart.v();
        this.yEnd = (double)posEnd.v() - 0.5;
        this.zStart = posStart.w();
        this.zEnd = (double)posEnd.w() - 0.5;
        this.xNext = this.xStart;
        this.yNext = this.yStart;
        this.zNext = this.zStart;
        this.hasNext = this.xNext < this.xEnd && this.yNext < this.yEnd && this.zNext < this.zEnd;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public gu next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        this.pos.setXyz((double)this.xNext, this.yNext, this.zNext);
        this.nextPos();
        this.hasNext = this.xNext < this.xEnd && this.yNext < this.yEnd && this.zNext < this.zEnd;
        return this.pos;
    }

    private void nextPos() {
        this.zNext += 1.0;
        if (this.zNext < this.zEnd) {
            return;
        }
        this.zNext = this.zStart;
        this.yNext += 1.0;
        if (this.yNext < this.yEnd) {
            return;
        }
        this.yNext = this.yStart;
        this.yStart += this.yDelta;
        this.yEnd += this.yDelta;
        this.yNext = this.yStart;
        this.zStart += this.zDelta;
        this.zEnd += this.zDelta;
        this.zNext = this.zStart;
        ++this.xNext;
        if (this.xNext < this.xEnd) {
            return;
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    public static void main(String[] args) throws Exception {
        gu posStart = new gu(-2, 10, 20);
        gu posEnd = new gu(2, 12, 22);
        double yDelta = -0.5;
        double zDelta = 0.5;
        IteratorAxis it2 = new IteratorAxis(posStart, posEnd, yDelta, zDelta);
        System.out.println("Start: " + posStart + ", end: " + posEnd + ", yDelta: " + yDelta + ", zDelta: " + zDelta);
        while (it2.hasNext()) {
            gu blockPos = it2.next();
            System.out.println("" + blockPos);
        }
    }
}

