/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.Random;
import net.optifine.util.MathUtils;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMath {
    static Random random = new Random(1L);

    public static void main(String[] args) {
        int count = 1;
        TestMath.dbg((String)("Test math: " + count));
        for (int i2 = 0; i2 < count; ++i2) {
            TestMath.testMatrix4f_mulTranslate();
            TestMath.testMatrix4f_mulScale();
            TestMath.testMatrix4f_mulQuaternion();
            TestMath.testMatrix3f_mulQuaternion();
            TestMath.testVector4f_transform();
            TestMath.testVector3f_transform();
        }
        TestMath.dbg((String)"Done");
    }

    private static void testMatrix4f_mulTranslate() {
        Matrix4f m2 = new Matrix4f();
        MathUtils.setRandom((Matrix4f)m2, (Random)random);
        Matrix4f m22 = MathUtils.copy((Matrix4f)m2);
        float x2 = random.nextFloat();
        float y2 = random.nextFloat();
        float z2 = random.nextFloat();
        m2.mul((Matrix4fc)MathUtils.makeTranslate4f((float)x2, (float)y2, (float)z2));
        MathUtils.mulTranslate((Matrix4f)m22, (float)x2, (float)y2, (float)z2);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg((String)"*** DIFFERENT ***");
            TestMath.dbg((String)m2.toString());
            TestMath.dbg((String)m22.toString());
        }
    }

    private static void testMatrix4f_mulScale() {
        Matrix4f m2 = new Matrix4f();
        MathUtils.setRandom((Matrix4f)m2, (Random)random);
        Matrix4f m22 = MathUtils.copy((Matrix4f)m2);
        float x2 = random.nextFloat();
        float y2 = random.nextFloat();
        float z2 = random.nextFloat();
        m2.mul((Matrix4fc)MathUtils.makeScale4f((float)x2, (float)y2, (float)z2));
        MathUtils.mulScale((Matrix4f)m22, (float)x2, (float)y2, (float)z2);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg((String)"*** DIFFERENT ***");
            TestMath.dbg((String)m2.toString());
            TestMath.dbg((String)m22.toString());
        }
    }

    private static void testMatrix4f_mulQuaternion() {
        Matrix4f m2 = new Matrix4f();
        MathUtils.setRandom((Matrix4f)m2, (Random)random);
        Matrix4f m22 = MathUtils.copy((Matrix4f)m2);
        Quaternionf q2 = new Quaternionf(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        m2.mul((Matrix4fc)MathUtils.makeMatrix4f((Quaternionf)q2));
        MathUtils.mul((Matrix4f)m22, (Quaternionf)q2);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg((String)"*** DIFFERENT ***");
            TestMath.dbg((String)m2.toString());
            TestMath.dbg((String)m22.toString());
        }
    }

    private static void testMatrix3f_mulQuaternion() {
        Matrix3f m2 = new Matrix3f();
        MathUtils.setRandom((Matrix3f)m2, (Random)random);
        Matrix3f m22 = MathUtils.copy((Matrix3f)m2);
        Quaternionf q2 = new Quaternionf(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        m2.mul((Matrix3fc)MathUtils.makeMatrix3f((Quaternionf)q2));
        MathUtils.mul((Matrix3f)m22, (Quaternionf)q2);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg((String)"*** DIFFERENT ***");
            TestMath.dbg((String)m2.toString());
            TestMath.dbg((String)m22.toString());
        }
    }

    private static void testVector3f_transform() {
        Vector3f v2 = new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat());
        Vector3f v22 = MathUtils.copy((Vector3f)v2);
        Matrix3f m2 = new Matrix3f();
        MathUtils.setRandom((Matrix3f)m2, (Random)random);
        MathUtils.transform((Vector3f)v2, (Matrix3f)m2);
        float x2 = MathUtils.getTransformX((Matrix3f)m2, (float)v22.x(), (float)v22.y(), (float)v22.z());
        float y2 = MathUtils.getTransformY((Matrix3f)m2, (float)v22.x(), (float)v22.y(), (float)v22.z());
        float z2 = MathUtils.getTransformZ((Matrix3f)m2, (float)v22.x(), (float)v22.y(), (float)v22.z());
        v22 = new Vector3f(x2, y2, z2);
        if (!v22.equals((Object)v2)) {
            TestMath.dbg((String)"*** DIFFERENT ***");
            TestMath.dbg((String)v2.toString());
            TestMath.dbg((String)v22.toString());
        }
    }

    private static void testVector4f_transform() {
        Vector4f v2 = new Vector4f(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        Vector4f v22 = MathUtils.copy((Vector4f)v2);
        Matrix4f m2 = new Matrix4f();
        MathUtils.setRandom((Matrix4f)m2, (Random)random);
        MathUtils.transform((Vector4f)v2, (Matrix4f)m2);
        float x2 = MathUtils.getTransformX((Matrix4f)m2, (float)v22.x(), (float)v22.y(), (float)v22.z(), (float)v22.w());
        float y2 = MathUtils.getTransformY((Matrix4f)m2, (float)v22.x(), (float)v22.y(), (float)v22.z(), (float)v22.w());
        float z2 = MathUtils.getTransformZ((Matrix4f)m2, (float)v22.x(), (float)v22.y(), (float)v22.z(), (float)v22.w());
        float w = MathUtils.getTransformW((Matrix4f)m2, (float)v22.x(), (float)v22.y(), (float)v22.z(), (float)v22.w());
        v22 = new Vector4f(x2, y2, z2, w);
        if (!v22.equals((Object)v2)) {
            TestMath.dbg((String)"*** DIFFERENT ***");
            TestMath.dbg((String)v2.toString());
            TestMath.dbg((String)v22.toString());
        }
    }

    private static void dbg(String str) {
        System.out.println(str);
    }
}

