/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;

public class ChunkLayerMap<T> {
    private T[] values = new Object[fkf.CHUNK_RENDER_TYPES.length];
    private Supplier<T> defaultValue;

    public ChunkLayerMap(Function<fkf, T> initialValue) {
        int i2;
        fkf[] renderTypes = fkf.CHUNK_RENDER_TYPES;
        this.values = new Object[renderTypes.length];
        for (i2 = 0; i2 < renderTypes.length; ++i2) {
            fkf renderType = renderTypes[i2];
            T t = initialValue.apply(renderType);
            this.values[renderType.ordinal()] = t;
        }
        for (i2 = 0; i2 < this.values.length; ++i2) {
            if (this.values[i2] != null) continue;
            throw new RuntimeException("Missing value at index: " + i2);
        }
    }

    public T get(fkf layer) {
        return (T)this.values[layer.ordinal()];
    }

    public Collection<T> values() {
        return Arrays.asList(this.values);
    }
}

