/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.override;

import java.util.Arrays;
import net.optifine.BlockPosM;
import net.optifine.render.RenderEnv;
import net.optifine.util.ArrayCache;

public class ChunkCacheOF
implements clp {
    private final fmr chunkCache;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int sizeXZ;
    private int[] combinedLights;
    private dcb[] blockStates;
    private cnk[] biomes;
    private final int arraySize;
    private RenderEnv renderEnv;
    private static final ArrayCache cacheCombinedLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache cacheBlockStates = new ArrayCache(dcb.class, 16);
    private static final ArrayCache cacheBiomes = new ArrayCache(cnk.class, 16);

    public ChunkCacheOF(fmr chunkCache, gu posFromIn, gu posToIn, int subIn) {
        this.chunkCache = chunkCache;
        int minChunkX = posFromIn.u() - subIn >> 4;
        int minChunkY = posFromIn.v() - subIn >> 4;
        int minChunkZ = posFromIn.w() - subIn >> 4;
        int maxChunkX = posToIn.u() + subIn >> 4;
        int maxChunkY = posToIn.v() + subIn >> 4;
        int maxChunkZ = posToIn.w() + subIn >> 4;
        this.sizeX = maxChunkX - minChunkX + 1 << 4;
        this.sizeY = maxChunkY - minChunkY + 1 << 4;
        this.sizeZ = maxChunkZ - minChunkZ + 1 << 4;
        this.sizeXZ = this.sizeX * this.sizeZ;
        this.arraySize = this.sizeX * this.sizeY * this.sizeZ;
        this.posX = minChunkX << 4;
        this.posY = minChunkY << 4;
        this.posZ = minChunkZ << 4;
    }

    public int getPositionIndex(gu pos) {
        int dx = pos.u() - this.posX;
        if (dx < 0 || dx >= this.sizeX) {
            return -1;
        }
        int dy = pos.v() - this.posY;
        if (dy < 0 || dy >= this.sizeY) {
            return -1;
        }
        int dz = pos.w() - this.posZ;
        if (dz < 0 || dz >= this.sizeZ) {
            return -1;
        }
        return dy * this.sizeXZ + dz * this.sizeX + dx;
    }

    public int a(cmv type, gu pos) {
        return this.chunkCache.a(type, pos);
    }

    public dcb a_(gu pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.blockStates == null) {
            return this.chunkCache.a_(pos);
        }
        dcb iblockstate = this.blockStates[index];
        if (iblockstate == null) {
            this.blockStates[index] = iblockstate = this.chunkCache.a_(pos);
        }
        return iblockstate;
    }

    public void renderStart() {
        if (this.combinedLights == null) {
            this.combinedLights = (int[])cacheCombinedLights.allocate(this.arraySize);
        }
        if (this.blockStates == null) {
            this.blockStates = (dcb[])cacheBlockStates.allocate(this.arraySize);
        }
        if (this.biomes == null) {
            this.biomes = (cnk[])cacheBiomes.allocate(this.arraySize);
        }
        Arrays.fill(this.combinedLights, -1);
        Arrays.fill(this.blockStates, null);
        Arrays.fill(this.biomes, null);
        this.loadBlockStates();
    }

    private void loadBlockStates() {
        if (this.sizeX != 48 || this.sizeY != 48 || this.sizeZ != 48) {
            return;
        }
        dei chunk = this.chunkCache.getChunk(1, 1);
        BlockPosM pos = new BlockPosM();
        for (int y2 = 16; y2 < 32; ++y2) {
            int dy = y2 * this.sizeXZ;
            for (int z2 = 16; z2 < 32; ++z2) {
                int dz = z2 * this.sizeX;
                for (int x2 = 16; x2 < 32; ++x2) {
                    dcb bs;
                    pos.setXyz(this.posX + x2, this.posY + y2, this.posZ + z2);
                    int index = dy + dz + x2;
                    this.blockStates[index] = bs = chunk.a_((gu)pos);
                }
            }
        }
    }

    public void renderFinish() {
        cacheCombinedLights.free((Object)this.combinedLights);
        this.combinedLights = null;
        cacheBlockStates.free((Object)this.blockStates);
        this.blockStates = null;
        cacheBiomes.free((Object)this.biomes);
        this.biomes = null;
        this.chunkCache.finish();
    }

    public int[] getCombinedLights() {
        return this.combinedLights;
    }

    public cnk getBiome(gu pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.biomes == null) {
            return this.chunkCache.getBiome(pos);
        }
        cnk biome = this.biomes[index];
        if (biome == null) {
            this.biomes[index] = biome = this.chunkCache.getBiome(pos);
        }
        return biome;
    }

    public czn c_(gu pos) {
        return this.chunkCache.c_(pos);
    }

    public boolean g(gu pos) {
        return this.chunkCache.g(pos);
    }

    public dxe b_(gu pos) {
        return this.a_(pos).u();
    }

    public int a(gu blockPosIn, clx colorResolverIn) {
        return this.chunkCache.a(blockPosIn, colorResolverIn);
    }

    public dwt s_() {
        return this.chunkCache.s_();
    }

    public RenderEnv getRenderEnv() {
        return this.renderEnv;
    }

    public void setRenderEnv(RenderEnv renderEnv) {
        this.renderEnv = renderEnv;
    }

    public float a(ha directionIn, boolean shadeIn) {
        return this.chunkCache.a(directionIn, shadeIn);
    }

    public int D_() {
        return this.chunkCache.D_();
    }

    public int C_() {
        return this.chunkCache.C_();
    }
}

