/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.http;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import net.optifine.Config;
import net.optifine.http.HttpPipelineConnection;
import net.optifine.http.HttpPipelineRequest;
import net.optifine.http.HttpResponse;

public class HttpPipelineReceiver
extends Thread {
    private HttpPipelineConnection httpPipelineConnection = null;
    private static final Charset ASCII = Charset.forName("ASCII");
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final char CR = '\r';
    private static final char LF = '\n';

    public HttpPipelineReceiver(HttpPipelineConnection httpPipelineConnection) {
        super("HttpPipelineReceiver");
        this.httpPipelineConnection = httpPipelineConnection;
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            HttpPipelineRequest currentRequest = null;
            try {
                currentRequest = this.httpPipelineConnection.getNextRequestReceive();
                InputStream in2 = this.httpPipelineConnection.getInputStream();
                HttpResponse resp = this.readResponse(in2);
                this.httpPipelineConnection.onResponseReceived(currentRequest, resp);
            }
            catch (InterruptedException e2) {
                return;
            }
            catch (Exception e3) {
                this.httpPipelineConnection.onExceptionReceive(currentRequest, e3);
            }
        }
    }

    private HttpResponse readResponse(InputStream in2) throws IOException {
        String line;
        String statusLine = this.readLine(in2);
        String[] parts = Config.tokenize((String)statusLine, (String)" ");
        if (parts.length < 3) {
            throw new IOException("Invalid status line: " + statusLine);
        }
        String http = parts[0];
        int status = Config.parseInt((String)parts[1], (int)0);
        String message = parts[2];
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        while ((line = this.readLine(in2)).length() > 0) {
            int pos = line.indexOf(":");
            if (pos <= 0) continue;
            String key = line.substring(0, pos).trim();
            String val = line.substring(pos + 1).trim();
            headers.put(key, val);
        }
        byte[] body = null;
        String lenStr = (String)headers.get(HEADER_CONTENT_LENGTH);
        if (lenStr != null) {
            int len = Config.parseInt((String)lenStr, (int)-1);
            if (len > 0) {
                body = new byte[len];
                this.readFull(body, in2);
            }
        } else {
            String enc2 = (String)headers.get("Transfer-Encoding");
            if (Config.equals((Object)enc2, (Object)"chunked")) {
                body = this.readContentChunked(in2);
            }
        }
        return new HttpResponse(status, statusLine, headers, body);
    }

    private byte[] readContentChunked(InputStream in2) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            String line = this.readLine(in2);
            String[] parts = Config.tokenize((String)line, (String)"; ");
            len = Integer.parseInt(parts[0], 16);
            byte[] buf = new byte[len];
            this.readFull(buf, in2);
            baos.write(buf);
            this.readLine(in2);
        } while (len != 0);
        return baos.toByteArray();
    }

    private void readFull(byte[] buf, InputStream in2) throws IOException {
        int len;
        for (int pos = 0; pos < buf.length; pos += len) {
            len = in2.read(buf, pos, buf.length - pos);
            if (len >= 0) continue;
            throw new EOFException();
        }
    }

    private String readLine(InputStream in2) throws IOException {
        int i2;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int prev = -1;
        boolean hasCRLF = false;
        while ((i2 = in2.read()) >= 0) {
            baos.write(i2);
            if (prev == 13 && i2 == 10) {
                hasCRLF = true;
                break;
            }
            prev = i2;
        }
        byte[] bytes = baos.toByteArray();
        String str = new String(bytes, ASCII);
        if (hasCRLF) {
            str = str.substring(0, str.length() - 2);
        }
        return str;
    }
}

