/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.optifine.Config;
import net.optifine.DynamicLight;
import net.optifine.DynamicLightsMap;
import net.optifine.config.ConnectedParser;
import net.optifine.config.EntityTypeNameLocator;
import net.optifine.config.IObjectLocator;
import net.optifine.config.ItemLocator;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.util.PropertiesOrdered;

/*
 * Exception performing whole class analysis ignored.
 */
public class DynamicLights {
    private static DynamicLightsMap mapDynamicLights = new DynamicLightsMap();
    private static Map<String, Integer> mapEntityLightLevels = new HashMap();
    private static Map<cfu, Integer> mapItemLightLevels = new HashMap();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;
    private static final int LIGHT_LEVEL_GLOW_SQUID = 11;
    private static final int LIGHT_LEVEL_GLOW_INK_SAC = 8;
    private static final int LIGHT_LEVEL_GLOW_LICHEN = 6;
    private static final int LIGHT_LEVEL_GLOW_BERRIES = 12;
    private static final int LIGHT_LEVEL_GLOW_ITEM_FRAME = 8;
    private static final aby<cfz> PARAMETER_ITEM_STACK = (aby)Reflector.EntityItem_ITEM.getValue();
    private static boolean initialized;

    public static void entityAdded(bfj entityIn, fjv renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(bfj entityIn, fjv renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLight dynamicLight = mapDynamicLights.remove(entityIn.af());
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(fjv renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        if (!initialized) {
            DynamicLights.initialize();
        }
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLights.updateMapDynamicLights((fjv)renderGlobal);
            if (mapDynamicLights.size() <= 0) {
                return;
            }
            List dynamicLights = mapDynamicLights.valueList();
            for (int i2 = 0; i2 < dynamicLights.size(); ++i2) {
                DynamicLight dynamicLight = (DynamicLight)dynamicLights.get(i2);
                dynamicLight.update(renderGlobal);
            }
        }
    }

    private static void initialize() {
        initialized = true;
        mapEntityLightLevels.clear();
        mapItemLightLevels.clear();
        String[] modIds = ReflectorForge.getForgeModIds();
        for (int i2 = 0; i2 < modIds.length; ++i2) {
            String modId = modIds[i2];
            try {
                acq loc = new acq(modId, "optifine/dynamic_lights.properties");
                InputStream in2 = Config.getResourceStream((acq)loc);
                DynamicLights.loadModConfiguration((InputStream)in2, (String)loc.toString(), (String)modId);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (mapEntityLightLevels.size() > 0) {
            Config.dbg((String)("DynamicLights entities: " + mapEntityLightLevels.size()));
        }
        if (mapItemLightLevels.size() > 0) {
            Config.dbg((String)("DynamicLights items: " + mapItemLightLevels.size()));
        }
    }

    private static void loadModConfiguration(InputStream in2, String path, String modId) {
        if (in2 == null) {
            return;
        }
        try {
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in2);
            in2.close();
            Config.dbg((String)("DynamicLights: Parsing " + path));
            ConnectedParser cp = new ConnectedParser("DynamicLights");
            DynamicLights.loadModLightLevels((String)props.getProperty("entities"), (Map)mapEntityLightLevels, (IObjectLocator)new EntityTypeNameLocator(), (ConnectedParser)cp, (String)path, (String)modId);
            DynamicLights.loadModLightLevels((String)props.getProperty("items"), (Map)mapItemLightLevels, (IObjectLocator)new ItemLocator(), (ConnectedParser)cp, (String)path, (String)modId);
        }
        catch (IOException e2) {
            Config.warn((String)("DynamicLights: Error reading " + path));
        }
    }

    private static <T> void loadModLightLevels(String prop, Map<T, Integer> mapLightLevels, IObjectLocator<T> ol, ConnectedParser cp, String path, String modId) {
        if (prop == null) {
            return;
        }
        String[] parts = Config.tokenize((String)prop, (String)" ");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            String[] tokens = Config.tokenize((String)part, (String)":");
            if (tokens.length != 2) {
                cp.warn("Invalid entry: " + part + ", in:" + path);
                continue;
            }
            String name = tokens[0];
            String light = tokens[1];
            String nameFull = modId + ":" + name;
            acq loc = new acq(nameFull);
            Object obj = ol.getObject(loc);
            if (obj == null) {
                cp.warn("Object not found: " + nameFull);
                continue;
            }
            int lightLevel = cp.parseInt(light, -1);
            if (lightLevel < 0 || lightLevel > 15) {
                cp.warn("Invalid light level: " + part);
                continue;
            }
            mapLightLevels.put(obj, new Integer(lightLevel));
        }
    }

    private static void updateMapDynamicLights(fjv renderGlobal) {
        few world = renderGlobal.getWorld();
        if (world == null) {
            return;
        }
        Iterable entities = world.e();
        for (bfj entity : entities) {
            DynamicLight dynamicLight;
            int key;
            int lightLevel = DynamicLights.getLightLevel((bfj)entity);
            if (lightLevel > 0) {
                key = entity.af();
                dynamicLight = mapDynamicLights.get(key);
                if (dynamicLight != null) continue;
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, dynamicLight);
                continue;
            }
            key = entity.af();
            dynamicLight = mapDynamicLights.remove(key);
            if (dynamicLight == null) continue;
            dynamicLight.updateLitChunks(renderGlobal);
        }
    }

    public static int getCombinedLight(gu pos, int combinedLight) {
        double lightPos = DynamicLights.getLightLevel((gu)pos);
        combinedLight = DynamicLights.getCombinedLight((double)lightPos, (int)combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(bfj entity, int combinedLight) {
        double lightPos = DynamicLights.getLightLevel((gu)entity.di());
        if (entity == Config.getMinecraft().t) {
            double lightOwn = DynamicLights.getLightLevel((bfj)entity);
            lightPos = Math.max(lightPos, lightOwn);
        }
        combinedLight = DynamicLights.getCombinedLight((double)lightPos, (int)combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(gu pos) {
        double lightLevelMax = 0.0;
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List dynamicLights = mapDynamicLights.valueList();
            int dynamicLightsSize = dynamicLights.size();
            for (int i2 = 0; i2 < dynamicLightsSize; ++i2) {
                double dist;
                double light;
                double lightLevel;
                double dz;
                double dy;
                DynamicLight dynamicLight = (DynamicLight)dynamicLights.get(i2);
                int dynamicLightLevel = dynamicLight.getLastLightLevel();
                if (dynamicLightLevel <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)pos.u() - px;
                double distSq = dx * dx + (dy = (double)pos.v() - py) * dy + (dz = (double)pos.w() - pz) * dz;
                if (distSq > 56.25 || !((lightLevel = (light = 1.0 - (dist = Math.sqrt(distSq)) / 7.5) * (double)dynamicLightLevel) > lightLevelMax)) continue;
                lightLevelMax = lightLevel;
            }
        }
        double lightPlayer = Config.limit((double)lightLevelMax, (double)0.0, (double)15.0);
        return lightPlayer;
    }

    public static int getLightLevel(cfz itemStack) {
        Integer level;
        cds itemBlock;
        cpn block;
        if (itemStack == null) {
            return 0;
        }
        cfu item = itemStack.d();
        if (item instanceof cds && (block = (itemBlock = (cds)item).e()) != null) {
            if (block == cpo.hX) {
                return 0;
            }
            if (block == cpo.fg) {
                return 6;
            }
            if (block == cpo.ru) {
                return 12;
            }
            return block.n().h();
        }
        if (item == cgc.pM) {
            return cpo.H.n().h();
        }
        if (item == cgc.rr || item == cgc.rz) {
            return 10;
        }
        if (item == cgc.qk) {
            return 8;
        }
        if (item == cgc.tF) {
            return 8;
        }
        if (item == cgc.rA) {
            return 8;
        }
        if (item == cgc.ty) {
            return cpo.fO.n().h() / 2;
        }
        if (item == cgc.qs) {
            return 8;
        }
        if (item == cgc.tj) {
            return 8;
        }
        if (!mapItemLightLevels.isEmpty() && (level = (Integer)mapItemLightLevels.get(item)) != null) {
            return level;
        }
        return 0;
    }

    public static int getLightLevel(bfj entity) {
        bvo entityCreeper;
        String typeName;
        Integer level;
        byo player;
        if (entity == Config.getMinecraft().al() && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity instanceof byo && (player = (byo)entity).G_()) {
            return 0;
        }
        if (entity.bL()) {
            return 15;
        }
        if (!mapEntityLightLevels.isEmpty() && (level = (Integer)mapEntityLightLevels.get(typeName = EntityTypeNameLocator.getEntityTypeName((bfj)entity))) != null) {
            return level;
        }
        if (entity instanceof byv) {
            return 15;
        }
        if (entity instanceof bvi) {
            return 15;
        }
        if (entity instanceof bvm) {
            bvm entityBlaze = (bvm)entity;
            if (entityBlaze.bL()) {
                return 15;
            }
            return 10;
        }
        if (entity instanceof bwb) {
            bwb emc = (bwb)entity;
            if ((double)emc.e > 0.6) {
                return 13;
            }
            return 8;
        }
        if (entity instanceof bvo && (double)(entityCreeper = (bvo)entity).D(0.0f) > 0.001) {
            return 15;
        }
        if (entity instanceof bfr) {
            bfr glowSquid = (bfr)entity;
            int squidLight = (int)apa.b((float)0.0f, (float)11.0f, (float)(1.0f - (float)glowSquid.w() / 10.0f));
            return squidLight;
        }
        if (entity instanceof buy) {
            return 8;
        }
        if (entity instanceof bfz) {
            player = (bfz)entity;
            cfz stackMain = player.eO();
            int levelMain = DynamicLights.getLightLevel((cfz)stackMain);
            cfz stackOff = player.eP();
            int levelOff = DynamicLights.getLightLevel((cfz)stackOff);
            cfz stackHead = player.c(bfo.f);
            int levelHead = DynamicLights.getLightLevel((cfz)stackHead);
            int levelHandMax = Math.max(levelMain, levelOff);
            return Math.max(levelHandMax, levelHead);
        }
        if (entity instanceof bvh) {
            bvh entityItem = (bvh)entity;
            cfz itemStack = DynamicLights.getItemStack((bvh)entityItem);
            return DynamicLights.getLightLevel((cfz)itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(fjv renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List dynamicLights = mapDynamicLights.valueList();
            for (int i2 = 0; i2 < dynamicLights.size(); ++i2) {
                DynamicLight dynamicLight = (DynamicLight)dynamicLights.get(i2);
                dynamicLight.updateLitChunks(renderGlobal);
            }
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            return mapDynamicLights.size();
        }
    }

    public static cfz getItemStack(bvh entityItem) {
        cfz itemstack = (cfz)entityItem.aj().b(PARAMETER_ITEM_STACK);
        return itemstack;
    }
}

