/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.util.BitStorage;
import net.minecraft.util.SimpleBitStorage;
import net.optifine.util.ArrayCaches;
import org.apache.commons.lang3.Validate;

public class SimpleBitStorage
implements BitStorage {
    private static final int[] f_184706_ = new int[]{-1, -1, 0, Integer.MIN_VALUE, 0, 0, 0x55555555, 0x55555555, 0, Integer.MIN_VALUE, 0, 1, 0x33333333, 0x33333333, 0, 0x2AAAAAAA, 0x2AAAAAAA, 0, 0x24924924, 0x24924924, 0, Integer.MIN_VALUE, 0, 2, 0x1C71C71C, 0x1C71C71C, 0, 0x19999999, 0x19999999, 0, 390451572, 390451572, 0, 0x15555555, 0x15555555, 0, 0x13B13B13, 0x13B13B13, 0, 306783378, 306783378, 0, 0x11111111, 0x11111111, 0, Integer.MIN_VALUE, 0, 3, 0xF0F0F0F, 0xF0F0F0F, 0, 0xE38E38E, 0xE38E38E, 0, 226050910, 226050910, 0, 0xCCCCCCC, 0xCCCCCCC, 0, 0xC30C30C, 0xC30C30C, 0, 195225786, 195225786, 0, 186737708, 186737708, 0, 0xAAAAAAA, 0xAAAAAAA, 0, 171798691, 171798691, 0, 0x9D89D89, 0x9D89D89, 0, 159072862, 159072862, 0, 0x9249249, 0x9249249, 0, 148102320, 148102320, 0, 0x8888888, 0x8888888, 0, 138547332, 138547332, 0, Integer.MIN_VALUE, 0, 4, 130150524, 130150524, 0, 0x7878787, 0x7878787, 0, 0x7507507, 0x7507507, 0, 0x71C71C7, 0x71C71C7, 0, 116080197, 116080197, 0, 113025455, 113025455, 0, 0x6906906, 0x6906906, 0, 0x6666666, 0x6666666, 0, 104755299, 104755299, 0, 0x6186186, 0x6186186, 0, 99882960, 99882960, 0, 97612893, 97612893, 0, 0x5B05B05, 0x5B05B05, 0, 93368854, 93368854, 0, 91382282, 91382282, 0, 0x5555555, 0x5555555, 0, 87652393, 87652393, 0, 85899345, 85899345, 0, 0x5050505, 0x5050505, 0, 0x4EC4EC4, 0x4EC4EC4, 0, 81037118, 81037118, 0, 79536431, 79536431, 0, 78090314, 78090314, 0, 0x4924924, 0x4924924, 0, 75350303, 75350303, 0, 74051160, 74051160, 0, 72796055, 72796055, 0, 0x4444444, 0x4444444, 0, 70409299, 70409299, 0, 69273666, 69273666, 0, 0x4104104, 0x4104104, 0, Integer.MIN_VALUE, 0, 5};
    private long[] f_184707_;
    private final int f_184708_;
    private final long f_184709_;
    private final int f_184710_;
    private final int f_184711_;
    private final int f_184712_;
    private final int f_184713_;
    private final int f_184714_;
    private boolean dataFromCache = false;
    private static ArrayCaches dataCaches = new ArrayCaches(new int[]{256, 342, 410, 456}, Long.TYPE, 256);

    public SimpleBitStorage(int p_i198163_1_, int p_i198163_2_, int[] p_i198163_3_) {
        this(p_i198163_1_, p_i198163_2_);
        int i2;
        int j2 = 0;
        for (i2 = 0; i2 <= p_i198163_2_ - this.f_184711_; i2 += this.f_184711_) {
            long k2 = 0L;
            for (int i1 = this.f_184711_ - 1; i1 >= 0; --i1) {
                k2 <<= p_i198163_1_;
                k2 |= (long)p_i198163_3_[i2 + i1] & this.f_184709_;
            }
            this.f_184707_[j2++] = k2;
        }
        int k1 = p_i198163_2_ - i2;
        if (k1 > 0) {
            long l2 = 0L;
            for (int j1 = k1 - 1; j1 >= 0; --j1) {
                l2 <<= p_i198163_1_;
                l2 |= (long)p_i198163_3_[i2 + j1] & this.f_184709_;
            }
            this.f_184707_[j2] = l2;
        }
    }

    public SimpleBitStorage(int p_i184716_1_, int p_i184716_2_) {
        this(p_i184716_1_, p_i184716_2_, (long[])null);
    }

    public SimpleBitStorage(int p_i184723_1_, int p_i184723_2_, @Nullable long[] p_i184723_3_) {
        Validate.inclusiveBetween((long)1L, (long)32L, (long)p_i184723_1_);
        this.f_184710_ = p_i184723_2_;
        this.f_184708_ = p_i184723_1_;
        this.f_184709_ = (1L << p_i184723_1_) - 1L;
        this.f_184711_ = (char)(64 / p_i184723_1_);
        int i2 = 3 * (this.f_184711_ - 1);
        this.f_184712_ = f_184706_[i2 + 0];
        this.f_184713_ = f_184706_[i2 + 1];
        this.f_184714_ = f_184706_[i2 + 2];
        int j2 = (p_i184723_2_ + this.f_184711_ - 1) / this.f_184711_;
        if (p_i184723_3_ != null) {
            if (p_i184723_3_.length != j2) {
                throw new InitializationException("Invalid length given for storage, got: " + p_i184723_3_.length + " but expected: " + j2);
            }
            this.f_184707_ = p_i184723_3_;
        } else {
            this.f_184707_ = new long[j2];
        }
    }

    private int m_184739_(int p_184739_1_) {
        long i2 = Integer.toUnsignedLong(this.f_184712_);
        long j2 = Integer.toUnsignedLong(this.f_184713_);
        return (int)((long)p_184739_1_ * i2 + j2 >> 32 >> this.f_184714_);
    }

    public int m_13516_(int index, int value) {
        Validate.inclusiveBetween((long)0L, (long)(this.f_184710_ - 1), (long)index);
        Validate.inclusiveBetween((long)0L, (long)this.f_184709_, (long)value);
        int i2 = this.m_184739_(index);
        long j2 = this.f_184707_[i2];
        int k2 = (index - i2 * this.f_184711_) * this.f_184708_;
        int l2 = (int)(j2 >> k2 & this.f_184709_);
        this.f_184707_[i2] = j2 & (this.f_184709_ << k2 ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.f_184709_) << k2;
        return l2;
    }

    public void m_13524_(int index, int value) {
        Validate.inclusiveBetween((long)0L, (long)(this.f_184710_ - 1), (long)index);
        Validate.inclusiveBetween((long)0L, (long)this.f_184709_, (long)value);
        int i2 = this.m_184739_(index);
        long j2 = this.f_184707_[i2];
        int k2 = (index - i2 * this.f_184711_) * this.f_184708_;
        this.f_184707_[i2] = j2 & (this.f_184709_ << k2 ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.f_184709_) << k2;
    }

    public int m_13514_(int index) {
        Validate.inclusiveBetween((long)0L, (long)(this.f_184710_ - 1), (long)index);
        int i2 = this.m_184739_(index);
        long j2 = this.f_184707_[i2];
        int k2 = (index - i2 * this.f_184711_) * this.f_184708_;
        return (int)(j2 >> k2 & this.f_184709_);
    }

    public long[] m_13513_() {
        return this.f_184707_;
    }

    public int m_13521_() {
        return this.f_184710_;
    }

    public int m_144604_() {
        return this.f_184708_;
    }

    public void m_13519_(IntConsumer consumer) {
        int i2 = 0;
        for (long j2 : this.f_184707_) {
            for (int k2 = 0; k2 < this.f_184711_; ++k2) {
                consumer.accept((int)(j2 & this.f_184709_));
                j2 >>= this.f_184708_;
                if (++i2 < this.f_184710_) continue;
                return;
            }
        }
    }

    public void m_197970_(int[] p_197970_1_) {
        int i2 = this.f_184707_.length;
        int j2 = 0;
        for (int k2 = 0; k2 < i2 - 1; ++k2) {
            long l2 = this.f_184707_[k2];
            for (int i1 = 0; i1 < this.f_184711_; ++i1) {
                p_197970_1_[j2 + i1] = (int)(l2 & this.f_184709_);
                l2 >>= this.f_184708_;
            }
            j2 += this.f_184711_;
        }
        int j1 = this.f_184710_ - j2;
        if (j1 > 0) {
            long k1 = this.f_184707_[i2 - 1];
            for (int l1 = 0; l1 < j1; ++l1) {
                p_197970_1_[j2 + l1] = (int)(k1 & this.f_184709_);
                k1 >>= this.f_184708_;
            }
        }
    }

    public BitStorage m_199833_() {
        long[] dataCopy = (long[])dataCaches.allocate(this.f_184707_.length);
        System.arraycopy(this.f_184707_, 0, dataCopy, 0, this.f_184707_.length);
        SimpleBitStorage sbs = new SimpleBitStorage(this.f_184708_, this.f_184710_, dataCopy);
        sbs.dataFromCache = true;
        return sbs;
    }

    public void finish() {
        if (this.dataFromCache) {
            dataCaches.free((Object)this.f_184707_);
            this.f_184707_ = null;
            this.dataFromCache = false;
        }
    }
}

