/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.optifine.reflect.ReflectorForge;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class VanillaPackResources
implements PackResources {
    private static final Logger f_10315_ = LogUtils.getLogger();
    private final BuiltInMetadata f_243789_;
    private final Set<String> f_10314_;
    private final List<Path> f_244169_;
    private final Map<PackType, List<Path>> f_244459_;

    VanillaPackResources(BuiltInMetadata metadataIn, Set<String> namespacesIn, List<Path> rootPathsIn, Map<PackType, List<Path>> typePathsIn) {
        this.f_243789_ = metadataIn;
        this.f_10314_ = namespacesIn;
        this.f_244169_ = rootPathsIn;
        this.f_244459_ = typePathsIn;
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... pathIn) {
        FileUtil.m_245411_((String[])pathIn);
        List<String> list = List.of(pathIn);
        for (Path path : this.f_244169_) {
            Path path1 = FileUtil.m_245247_((Path)path, list);
            if (!Files.exists(path1, new LinkOption[0]) || !PathPackResources.m_246877_((Path)path1)) continue;
            return IoSupplier.m_246697_((Path)path1);
        }
        return null;
    }

    public void m_245163_(PackType packTypeIn, ResourceLocation locationIn, Consumer<Path> consumerPathIn) {
        FileUtil.m_245538_((String)locationIn.m_135815_()).get().ifLeft(p_244894_4_ -> {
            String s = locationIn.m_135827_();
            for (Path path : (List)this.f_244459_.get(packTypeIn)) {
                Path path1 = path.resolve(s);
                consumerPathIn.accept(FileUtil.m_245247_((Path)path1, (List)p_244894_4_));
            }
        }).ifRight(p_244892_1_ -> f_10315_.error("Invalid path {}: {}", (Object)locationIn, (Object)p_244892_1_.message()));
    }

    public void m_8031_(PackType typeIn, String namespaceIn, String pathIn, PackResources.ResourceOutput outputIn) {
        PackResources.ResourceOutput outputOF = (locIn, suppIn) -> {
            IoSupplier suppOF;
            if (locIn.m_135815_().startsWith("models/block/template_glass_pane") && (suppOF = this.getResourceOF(typeIn, locIn)) != null) {
                suppIn = suppOF;
            }
            outputIn.accept(locIn, suppIn);
        };
        FileUtil.m_245538_((String)pathIn).get().ifLeft(partsIn -> {
            List list = (List)this.f_244459_.get(typeIn);
            int i2 = list.size();
            if (i2 == 1) {
                VanillaPackResources.m_246310_((PackResources.ResourceOutput)outputOF, (String)namespaceIn, (Path)((Path)list.get(0)), (List)partsIn);
            } else if (i2 > 1) {
                HashMap map = new HashMap();
                for (int j2 = 0; j2 < i2 - 1; ++j2) {
                    VanillaPackResources.m_246310_(map::putIfAbsent, (String)namespaceIn, (Path)((Path)list.get(j2)), (List)partsIn);
                }
                Path path = (Path)list.get(i2 - 1);
                if (map.isEmpty()) {
                    VanillaPackResources.m_246310_((PackResources.ResourceOutput)outputOF, (String)namespaceIn, (Path)path, (List)partsIn);
                } else {
                    VanillaPackResources.m_246310_(map::putIfAbsent, (String)namespaceIn, (Path)path, (List)partsIn);
                    map.forEach(outputOF);
                }
            }
        }).ifRight(p_244893_1_ -> f_10315_.error("Invalid path {}: {}", (Object)pathIn, (Object)p_244893_1_.message()));
    }

    private static void m_246310_(PackResources.ResourceOutput outputIn, String namespaceIn, Path pathIn, List<String> partsIn) {
        Path path = pathIn.resolve(namespaceIn);
        PathPackResources.m_246914_((String)namespaceIn, (Path)path, partsIn, (PackResources.ResourceOutput)outputIn);
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation namespaceIn) {
        IoSupplier res = this.getResourcesImpl(type, namespaceIn);
        if (res != null) {
            return res;
        }
        return this.getResourceOF(type, namespaceIn);
    }

    @Nullable
    public IoSupplier<InputStream> getResourcesImpl(PackType type, ResourceLocation namespaceIn) {
        return (IoSupplier)FileUtil.m_245538_((String)namespaceIn.m_135815_()).get().map(p_244889_3_ -> {
            String s = namespaceIn.m_135827_();
            for (Path path : (List)this.f_244459_.get(type)) {
                Path path1 = FileUtil.m_245247_((Path)path.resolve(s), (List)p_244889_3_);
                if (!Files.exists(path1, new LinkOption[0]) || !PathPackResources.m_246877_((Path)path1)) continue;
                return IoSupplier.m_246697_((Path)path1);
            }
            return null;
        }, p_244891_1_ -> {
            f_10315_.error("Invalid path {}: {}", (Object)namespaceIn, (Object)p_244891_1_.message());
            return null;
        });
    }

    public Set<String> m_5698_(PackType type) {
        return this.f_10314_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) {
        IoSupplier iosupplier = this.m_8017_(new String[]{"pack.mcmeta"});
        if (iosupplier == null) return (T)this.f_243789_.m_245920_(deserializer);
        try (InputStream inputstream = (InputStream)iosupplier.m_247737_();){
            Object t = AbstractPackResources.m_10214_(deserializer, (InputStream)inputstream);
            if (t == null) return (T)this.f_243789_.m_245920_(deserializer);
            Object object = t;
            return (T)object;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (T)this.f_243789_.m_245920_(deserializer);
    }

    public String m_5542_() {
        return "vanilla";
    }

    public boolean m_246538_() {
        return true;
    }

    public void close() {
    }

    public ResourceProvider m_215363_() {
        return p_244895_1_ -> Optional.ofNullable(this.m_214146_(PackType.CLIENT_RESOURCES, p_244895_1_)).map(p_244888_1_ -> new Resource((PackResources)this, p_244888_1_));
    }

    public IoSupplier<InputStream> getResourceOF(PackType type, ResourceLocation locationIn) {
        String pathStr = "/" + type.m_10305_() + "/" + locationIn.m_135827_() + "/" + locationIn.m_135815_();
        InputStream is = ReflectorForge.getOptiFineResourceStream((String)pathStr);
        if (is != null) {
            return () -> is;
        }
        URL url = VanillaPackResources.class.getResource(pathStr);
        if (url != null) {
            return () -> url.openStream();
        }
        return null;
    }
}

