/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class PathPackResources
extends AbstractPackResources {
    private static final Logger f_244043_ = LogUtils.getLogger();
    private static final Joiner f_244478_ = Joiner.on((String)"/");
    public final Path f_243919_;

    public PathPackResources(String p_i255246_1_, Path p_i255246_2_, boolean p_i255246_3_) {
        super(p_i255246_1_, p_i255246_3_);
        this.f_243919_ = p_i255246_2_;
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... pathIn) {
        FileUtil.m_245411_((String[])pathIn);
        Path path = FileUtil.m_245247_((Path)this.f_243919_, List.of(pathIn));
        return Files.exists(path, new LinkOption[0]) ? IoSupplier.m_246697_((Path)path) : null;
    }

    public static boolean m_246877_(Path p_246877_0_) {
        return true;
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation namespaceIn) {
        Path path = this.f_243919_.resolve(type.m_10305_()).resolve(namespaceIn.m_135827_());
        return PathPackResources.m_247113_((ResourceLocation)namespaceIn, (Path)path);
    }

    public static IoSupplier<InputStream> m_247113_(ResourceLocation p_247113_0_, Path p_247113_1_) {
        return (IoSupplier)FileUtil.m_245538_((String)p_247113_0_.m_135815_()).get().map(p_245898_1_ -> {
            Path path = FileUtil.m_245247_((Path)p_247113_1_, (List)p_245898_1_);
            return PathPackResources.m_246992_((Path)path);
        }, p_246537_1_ -> {
            f_244043_.error("Invalid path {}: {}", (Object)p_247113_0_, (Object)p_246537_1_.message());
            return null;
        });
    }

    @Nullable
    private static IoSupplier<InputStream> m_246992_(Path p_246992_0_) {
        return Files.exists(p_246992_0_, new LinkOption[0]) && PathPackResources.m_246877_((Path)p_246992_0_) ? IoSupplier.m_246697_((Path)p_246992_0_) : null;
    }

    public void m_8031_(PackType typeIn, String namespaceIn, String pathIn, PackResources.ResourceOutput outputIn) {
        FileUtil.m_245538_((String)pathIn).get().ifLeft(p_245378_4_ -> {
            Path path = this.f_243919_.resolve(typeIn.m_10305_()).resolve(namespaceIn);
            PathPackResources.m_246914_((String)namespaceIn, (Path)path, (List)p_245378_4_, (PackResources.ResourceOutput)outputIn);
        }).ifRight(p_246950_1_ -> f_244043_.error("Invalid path {}: {}", (Object)pathIn, (Object)p_246950_1_.message()));
    }

    public static void m_246914_(String p_246914_0_, Path p_246914_1_, List<String> p_246914_2_, PackResources.ResourceOutput p_246914_3_) {
        Path path = FileUtil.m_245247_((Path)p_246914_1_, p_246914_2_);
        try (Stream<Path> stream2 = Files.find(path, Integer.MAX_VALUE, (p_247260_0_, p_247260_1_) -> p_247260_1_.isRegularFile(), new FileVisitOption[0]);){
            stream2.forEach(p_247327_3_ -> {
                String s = f_244478_.join((Iterable)p_246914_1_.relativize((Path)p_247327_3_));
                ResourceLocation resourcelocation = ResourceLocation.m_214293_((String)p_246914_0_, (String)s);
                if (resourcelocation == null) {
                    Util.m_143785_((String)String.format(Locale.ROOT, "Invalid path in pack: %s:%s, ignoring", p_246914_0_, s));
                } else {
                    p_246914_3_.accept((Object)resourcelocation, (Object)IoSupplier.m_246697_((Path)p_247327_3_));
                }
            });
        }
        catch (NoSuchFileException stream2) {
        }
        catch (IOException ioexception) {
            f_244043_.error("Failed to list path {}", (Object)path, (Object)ioexception);
        }
    }

    public Set<String> m_5698_(PackType type) {
        HashSet set = Sets.newHashSet();
        Path path = this.f_243919_.resolve(type.m_10305_());
        try (DirectoryStream<Path> directorystream2 = Files.newDirectoryStream(path);){
            for (Path path1 : directorystream2) {
                String s = path1.getFileName().toString();
                if (s.equals(s.toLowerCase(Locale.ROOT))) {
                    set.add(s);
                    continue;
                }
                f_244043_.warn("Ignored non-lowercase namespace: {} in {}", (Object)s, (Object)this.f_243919_);
            }
        }
        catch (NoSuchFileException directorystream2) {
        }
        catch (IOException ioexception) {
            f_244043_.error("Failed to list path {}", (Object)path, (Object)ioexception);
        }
        return set;
    }

    public void close() {
    }
}

