/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class FilePackResources
extends AbstractPackResources {
    private static final Logger f_215322_ = LogUtils.getLogger();
    public static final Splitter f_10232_ = Splitter.on((char)'/').omitEmptyStrings().limit(3);
    public final File f_243750_;
    @Nullable
    private ZipFile f_10233_;
    private boolean f_243662_;

    public FilePackResources(String nameIn, File fileIn, boolean builtIn) {
        super(nameIn, builtIn);
        this.f_243750_ = fileIn;
    }

    @Nullable
    private ZipFile m_10247_() {
        if (this.f_243662_) {
            return null;
        }
        if (this.f_10233_ == null) {
            try {
                this.f_10233_ = new ZipFile(this.f_243750_);
            }
            catch (IOException ioexception) {
                f_215322_.error("Failed to open pack {}", (Object)this.f_243750_, (Object)ioexception);
                this.f_243662_ = true;
                return null;
            }
        }
        return this.f_10233_;
    }

    private static String m_245721_(PackType typeIn, ResourceLocation locIn) {
        return String.format(Locale.ROOT, "%s/%s/%s", typeIn.m_10305_(), locIn.m_135827_(), locIn.m_135815_());
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... pathIn) {
        return this.m_247280_(String.join((CharSequence)"/", pathIn));
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation namespaceIn) {
        return this.m_247280_(FilePackResources.m_245721_((PackType)type, (ResourceLocation)namespaceIn));
    }

    @Nullable
    private IoSupplier<InputStream> m_247280_(String p_247280_1_) {
        ZipFile zipfile = this.m_10247_();
        if (zipfile == null) {
            return null;
        }
        ZipEntry zipentry = zipfile.getEntry(p_247280_1_);
        return zipentry == null ? null : IoSupplier.m_247178_((ZipFile)zipfile, (ZipEntry)zipentry);
    }

    public Set<String> m_5698_(PackType type) {
        ZipFile zipfile = this.m_10247_();
        if (zipfile == null) {
            return Set.of();
        }
        Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
        HashSet set = Sets.newHashSet();
        while (enumeration.hasMoreElements()) {
            ArrayList list;
            ZipEntry zipentry = enumeration.nextElement();
            String s = zipentry.getName();
            if (!s.startsWith(type.m_10305_() + "/") || (list = Lists.newArrayList((Iterable)f_10232_.split((CharSequence)s))).size() <= 1) continue;
            String s1 = (String)list.get(1);
            if (s1.equals(s1.toLowerCase(Locale.ROOT))) {
                set.add(s1);
                continue;
            }
            f_215322_.warn("Ignored non-lowercase namespace: {} in {}", (Object)s1, (Object)this.f_243750_);
        }
        return set;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        if (this.f_10233_ != null) {
            IOUtils.closeQuietly((Closeable)this.f_10233_);
            this.f_10233_ = null;
        }
    }

    public void m_8031_(PackType typeIn, String namespaceIn, String pathIn, PackResources.ResourceOutput outputIn) {
        ZipFile zipfile = this.m_10247_();
        if (zipfile != null) {
            Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
            String s = typeIn.m_10305_() + "/" + namespaceIn + "/";
            String s1 = s + pathIn + "/";
            while (enumeration.hasMoreElements()) {
                String s2;
                ZipEntry zipentry = enumeration.nextElement();
                if (zipentry.isDirectory() || !(s2 = zipentry.getName()).startsWith(s1)) continue;
                String s3 = s2.substring(s.length());
                ResourceLocation resourcelocation = ResourceLocation.m_214293_((String)namespaceIn, (String)s3);
                if (resourcelocation != null) {
                    outputIn.accept((Object)resourcelocation, (Object)IoSupplier.m_247178_((ZipFile)zipfile, (ZipEntry)zipentry));
                    continue;
                }
                f_215322_.warn("Invalid path in datapack: {}:{}, ignoring", (Object)namespaceIn, (Object)s3);
            }
        }
    }
}

