/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.world.level.ChunkPos;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.reflect.ReflectorMethod;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class DistanceManager {
    static final Logger f_140758_ = LogUtils.getLogger();
    static final int f_140759_ = ChunkLevel.m_287154_((FullChunkStatus)FullChunkStatus.ENTITY_TICKING);
    private static final int f_143206_ = 4;
    final Long2ObjectMap<ObjectSet<ServerPlayer>> f_140760_ = new Long2ObjectOpenHashMap();
    final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> f_140761_ = new Long2ObjectOpenHashMap();
    private final ChunkTicketTracker f_140762_ = new ChunkTicketTracker(this);
    private final FixedPlayerDistanceChunkTracker f_140763_ = new FixedPlayerDistanceChunkTracker(this, 8);
    private final TickingTracker f_183901_ = new TickingTracker();
    private final PlayerTicketTracker f_140764_ = new PlayerTicketTracker(this, 64);
    final Set<ChunkHolder> f_140765_ = Sets.newHashSet();
    final ChunkTaskPriorityQueueSorter f_140766_;
    final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> f_140767_;
    final ProcessorHandle<ChunkTaskPriorityQueueSorter.Release> f_140768_;
    final LongSet f_140769_ = new LongOpenHashSet();
    final Executor f_140770_;
    private long f_140771_;
    private int f_183902_ = 10;
    private final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> forcedTickets = new Long2ObjectOpenHashMap();

    protected DistanceManager(Executor p_i140773_1_, Executor p_i140773_2_) {
        ChunkTaskPriorityQueueSorter chunktaskpriorityqueuesorter;
        ProcessorHandle processorhandle = ProcessorHandle.m_18714_((String)"player ticket throttler", p_i140773_2_::execute);
        this.f_140766_ = chunktaskpriorityqueuesorter = new ChunkTaskPriorityQueueSorter((List)ImmutableList.of((Object)processorhandle), p_i140773_1_, 4);
        this.f_140767_ = chunktaskpriorityqueuesorter.m_140604_(processorhandle, true);
        this.f_140768_ = chunktaskpriorityqueuesorter.m_140567_(processorhandle);
        this.f_140770_ = p_i140773_2_;
    }

    protected void m_140776_() {
        ++this.f_140771_;
        ObjectIterator objectiterator = this.f_140761_.long2ObjectEntrySet().fastIterator();
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            Iterator iterator = ((SortedArraySet)entry.getValue()).iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                if (!ticket.m_9434_(this.f_140771_)) continue;
                iterator.remove();
                flag = true;
                this.f_183901_.m_184165_(entry.getLongKey(), ticket);
            }
            if (flag) {
                this.f_140762_.m_140715_(entry.getLongKey(), DistanceManager.m_140797_((SortedArraySet)((SortedArraySet)entry.getValue())), false);
            }
            if (!((SortedArraySet)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
    }

    private static int m_140797_(SortedArraySet<Ticket<?>> p_140797_0_) {
        return !p_140797_0_.isEmpty() ? ((Ticket)p_140797_0_.m_14262_()).m_9433_() : ChunkLevel.f_286967_ + 1;
    }

    protected abstract boolean m_7009_(long var1);

    @Nullable
    protected abstract ChunkHolder m_7316_(long var1);

    @Nullable
    protected abstract ChunkHolder m_7288_(long var1, int var3, @Nullable ChunkHolder var4, int var5);

    public boolean m_140805_(ChunkMap chunkManagerIn) {
        boolean flag;
        this.f_140763_.m_6410_();
        this.f_183901_.m_184145_();
        this.f_140764_.m_6410_();
        int i2 = Integer.MAX_VALUE - this.f_140762_.m_140877_(Integer.MAX_VALUE);
        boolean bl = flag = i2 != 0;
        if (flag) {
            // empty if block
        }
        if (!this.f_140765_.isEmpty()) {
            this.f_140765_.forEach(p_183906_2_ -> p_183906_2_.m_143003_(chunkManagerIn, this.f_140770_));
            this.f_140765_.clear();
            return true;
        }
        if (!this.f_140769_.isEmpty()) {
            LongIterator longiterator = this.f_140769_.iterator();
            while (longiterator.hasNext()) {
                long j2 = longiterator.nextLong();
                if (!this.m_140857_(j2).stream().anyMatch(p_183909_0_ -> p_183909_0_.m_9428_() == TicketType.f_9444_)) continue;
                ChunkHolder chunkholder = chunkManagerIn.m_140174_(j2);
                if (chunkholder == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture completablefuture = chunkholder.m_140073_();
                completablefuture.thenAccept(p_183903_3_ -> this.f_140770_.execute(() -> this.f_140768_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140628_(() -> {}, (long)j2, (boolean)false))));
            }
            this.f_140769_.clear();
        }
        return flag;
    }

    void m_140784_(long chunkPosIn, Ticket<?> ticketIn) {
        SortedArraySet sortedarrayset = this.m_140857_(chunkPosIn);
        int i2 = DistanceManager.m_140797_((SortedArraySet)sortedarrayset);
        Ticket ticket = (Ticket)sortedarrayset.m_14253_(ticketIn);
        ticket.m_9429_(this.f_140771_);
        if (ticketIn.m_9433_() < i2) {
            this.f_140762_.m_140715_(chunkPosIn, ticketIn.m_9433_(), true);
        }
        if (Reflector.callBoolean(ticketIn, (ReflectorMethod)Reflector.ForgeTicket_isForceTicks, (Object[])new Object[0])) {
            SortedArraySet tickets = (SortedArraySet)this.forcedTickets.computeIfAbsent(chunkPosIn, e2 -> SortedArraySet.m_14246_((int)4));
            tickets.m_14253_((Object)ticket);
        }
    }

    void m_140818_(long chunkPosIn, Ticket<?> ticketIn) {
        SortedArraySet tickets;
        SortedArraySet sortedarrayset = this.m_140857_(chunkPosIn);
        if (sortedarrayset.remove(ticketIn)) {
            // empty if block
        }
        if (sortedarrayset.isEmpty()) {
            this.f_140761_.remove(chunkPosIn);
        }
        this.f_140762_.m_140715_(chunkPosIn, DistanceManager.m_140797_((SortedArraySet)sortedarrayset), false);
        if (Reflector.callBoolean(ticketIn, (ReflectorMethod)Reflector.ForgeTicket_isForceTicks, (Object[])new Object[0]) && (tickets = (SortedArraySet)this.forcedTickets.get(chunkPosIn)) != null) {
            tickets.remove(ticketIn);
        }
    }

    public <T> void m_140792_(TicketType<T> type, ChunkPos pos, int level, T value) {
        this.m_140784_(pos.m_45588_(), new Ticket(type, level, value));
    }

    public <T> void m_140823_(TicketType<T> type, ChunkPos pos, int level, T value) {
        Ticket ticket = new Ticket(type, level, value);
        this.m_140818_(pos.m_45588_(), ticket);
    }

    public <T> void m_140840_(TicketType<T> type, ChunkPos pos, int distance, T value) {
        this.addRegionTicket(type, pos, distance, value, false);
    }

    public <T> void addRegionTicket(TicketType<T> type, ChunkPos pos, int distance, T value, boolean forceTicks) {
        Ticket ticket = new Ticket(type, ChunkLevel.m_287154_((FullChunkStatus)FullChunkStatus.FULL) - distance, value);
        Reflector.setFieldValue((Object)ticket, (ReflectorField)Reflector.ForgeTicket_forceTicks, (Object)forceTicks);
        long i2 = pos.m_45588_();
        this.m_140784_(i2, ticket);
        this.f_183901_.m_184151_(i2, ticket);
    }

    public <T> void m_140849_(TicketType<T> type, ChunkPos pos, int distance, T value) {
        this.removeRegionTicket(type, pos, distance, value, false);
    }

    public <T> void removeRegionTicket(TicketType<T> type, ChunkPos pos, int distance, T value, boolean forceTicks) {
        Ticket ticket = new Ticket(type, ChunkLevel.m_287154_((FullChunkStatus)FullChunkStatus.FULL) - distance, value);
        Reflector.setFieldValue((Object)ticket, (ReflectorField)Reflector.ForgeTicket_forceTicks, (Object)forceTicks);
        long i2 = pos.m_45588_();
        this.m_140818_(i2, ticket);
        this.f_183901_.m_184165_(i2, ticket);
    }

    private SortedArraySet<Ticket<?>> m_140857_(long p_140857_1_) {
        return (SortedArraySet)this.f_140761_.computeIfAbsent(p_140857_1_, p_183922_0_ -> SortedArraySet.m_14246_((int)4));
    }

    protected void m_140799_(ChunkPos pos, boolean add) {
        Ticket ticket = new Ticket(TicketType.f_9445_, ChunkMap.f_143033_, (Object)pos);
        long i2 = pos.m_45588_();
        if (add) {
            this.m_140784_(i2, ticket);
            this.f_183901_.m_184151_(i2, ticket);
        } else {
            this.m_140818_(i2, ticket);
            this.f_183901_.m_184165_(i2, ticket);
        }
    }

    public void m_140802_(SectionPos sectionPosIn, ServerPlayer player) {
        ChunkPos chunkpos = sectionPosIn.m_123251_();
        long i2 = chunkpos.m_45588_();
        ((ObjectSet)this.f_140760_.computeIfAbsent(i2, p_183920_0_ -> new ObjectOpenHashSet())).add((Object)player);
        this.f_140763_.m_140715_(i2, 0, true);
        this.f_140764_.m_140715_(i2, 0, true);
        this.f_183901_.m_184154_(TicketType.f_9444_, chunkpos, this.m_183918_(), (Object)chunkpos);
    }

    public void m_140828_(SectionPos sectionPosIn, ServerPlayer player) {
        ChunkPos chunkpos = sectionPosIn.m_123251_();
        long i2 = chunkpos.m_45588_();
        ObjectSet objectset = (ObjectSet)this.f_140760_.get(i2);
        objectset.remove((Object)player);
        if (objectset.isEmpty()) {
            this.f_140760_.remove(i2);
            this.f_140763_.m_140715_(i2, Integer.MAX_VALUE, false);
            this.f_140764_.m_140715_(i2, Integer.MAX_VALUE, false);
            this.f_183901_.m_184168_(TicketType.f_9444_, chunkpos, this.m_183918_(), (Object)chunkpos);
        }
    }

    private int m_183918_() {
        return Math.max(0, ChunkLevel.m_287154_((FullChunkStatus)FullChunkStatus.ENTITY_TICKING) - this.f_183902_);
    }

    public boolean m_183913_(long posLongIn) {
        return ChunkLevel.m_287155_((int)this.f_183901_.m_6172_(posLongIn));
    }

    public boolean m_183916_(long posLongIn) {
        return ChunkLevel.m_287283_((int)this.f_183901_.m_6172_(posLongIn));
    }

    protected String m_140838_(long posLongIn) {
        SortedArraySet sortedarrayset = (SortedArraySet)this.f_140761_.get(posLongIn);
        return sortedarrayset != null && !sortedarrayset.isEmpty() ? ((Ticket)sortedarrayset.m_14262_()).toString() : "no_ticket";
    }

    protected void m_140777_(int viewDistance) {
        this.f_140764_.m_140912_(viewDistance);
    }

    public void m_183911_(int distanceIn) {
        if (distanceIn != this.f_183902_) {
            this.f_183902_ = distanceIn;
            this.f_183901_.m_184146_(this.m_183918_());
        }
    }

    public int m_140816_() {
        this.f_140763_.m_6410_();
        return this.f_140763_.f_140886_.size();
    }

    public boolean m_140847_(long chunkPosIn) {
        this.f_140763_.m_6410_();
        return this.f_140763_.f_140886_.containsKey(chunkPosIn);
    }

    public String m_140837_() {
        return this.f_140766_.m_140558_();
    }

    private void m_143207_(String fileNameIn) {
        try (FileOutputStream fileoutputstream = new FileOutputStream(new File(fileNameIn));){
            for (Long2ObjectMap.Entry entry : this.f_140761_.long2ObjectEntrySet()) {
                ChunkPos chunkpos = new ChunkPos(entry.getLongKey());
                for (Ticket ticket : (SortedArraySet)entry.getValue()) {
                    fileoutputstream.write((chunkpos.f_45578_ + "\t" + chunkpos.f_45579_ + "\t" + ticket.m_9428_() + "\t" + ticket.m_9433_() + "\t\n").getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        catch (IOException ioexception) {
            f_140758_.error("Failed to dump tickets to {}", (Object)fileNameIn, (Object)ioexception);
        }
    }

    @VisibleForTesting
    TickingTracker m_183915_() {
        return this.f_183901_;
    }

    public void m_201910_() {
        ImmutableSet immutableset = ImmutableSet.of((Object)TicketType.f_9449_, (Object)TicketType.f_9448_, (Object)TicketType.f_9446_);
        ObjectIterator objectiterator = this.f_140761_.long2ObjectEntrySet().fastIterator();
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            Iterator iterator = ((SortedArraySet)entry.getValue()).iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                if (immutableset.contains((Object)ticket.m_9428_())) continue;
                iterator.remove();
                flag = true;
                this.f_183901_.m_184165_(entry.getLongKey(), ticket);
            }
            if (flag) {
                this.f_140762_.m_140715_(entry.getLongKey(), DistanceManager.m_140797_((SortedArraySet)((SortedArraySet)entry.getValue())), false);
            }
            if (!((SortedArraySet)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
    }

    public boolean m_201911_() {
        return !this.f_140761_.isEmpty();
    }

    public boolean shouldForceTicks(long chunkPos) {
        SortedArraySet tickets = (SortedArraySet)this.forcedTickets.get(chunkPos);
        return tickets != null && !tickets.isEmpty();
    }
}

