/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceLocation
implements Comparable<ResourceLocation> {
    public static final Codec<ResourceLocation> f_135803_ = Codec.STRING.comapFlatMap(ResourceLocation::m_135837_, ResourceLocation::toString).stable();
    private static final SimpleCommandExceptionType f_135806_ = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.id.invalid"));
    public static final char f_179907_ = ':';
    public static final String f_179908_ = "minecraft";
    public static final String f_179909_ = "realms";
    private final String f_135804_;
    private final String f_135805_;
    private final boolean defaultNamespace;

    protected ResourceLocation(String namespaceIn, String pathIn, @Nullable Dummy dummyIn) {
        this.f_135804_ = namespaceIn;
        this.f_135805_ = pathIn;
        this.defaultNamespace = "minecraft".equals(namespaceIn);
    }

    public ResourceLocation(String namespaceIn, String pathIn) {
        this(ResourceLocation.m_245413_((String)namespaceIn, (String)pathIn), ResourceLocation.m_245185_((String)namespaceIn, (String)pathIn), (Dummy)null);
    }

    private ResourceLocation(String[] resourceParts) {
        this(resourceParts[0], resourceParts[1]);
    }

    public ResourceLocation(String resourceName) {
        this(ResourceLocation.m_135832_((String)resourceName, (char)':'));
    }

    public static ResourceLocation m_135822_(String resourceName, char splitOn) {
        return new ResourceLocation(ResourceLocation.m_135832_((String)resourceName, (char)splitOn));
    }

    @Nullable
    public static ResourceLocation m_135820_(String string) {
        try {
            return new ResourceLocation(string);
        }
        catch (ResourceLocationException resourcelocationexception) {
            return null;
        }
    }

    @Nullable
    public static ResourceLocation m_214293_(String namespaceIn, String pathIn) {
        try {
            return new ResourceLocation(namespaceIn, pathIn);
        }
        catch (ResourceLocationException resourcelocationexception) {
            return null;
        }
    }

    protected static String[] m_135832_(String resourceName, char splitOn) {
        String[] astring = new String[]{"minecraft", resourceName};
        int i2 = resourceName.indexOf(splitOn);
        if (i2 >= 0) {
            astring[1] = resourceName.substring(i2 + 1);
            if (i2 >= 1) {
                astring[0] = resourceName.substring(0, i2);
            }
        }
        return astring;
    }

    public static DataResult<ResourceLocation> m_135837_(String stringIn) {
        try {
            return DataResult.success((Object)new ResourceLocation(stringIn));
        }
        catch (ResourceLocationException resourcelocationexception) {
            return DataResult.error(() -> "Not a valid resource location: " + stringIn + " " + resourcelocationexception.getMessage());
        }
    }

    public String m_135815_() {
        return this.f_135805_;
    }

    public String m_135827_() {
        return this.f_135804_;
    }

    public ResourceLocation m_247449_(String pathIn) {
        return new ResourceLocation(this.f_135804_, ResourceLocation.m_245185_((String)this.f_135804_, (String)pathIn), (Dummy)null);
    }

    public ResourceLocation m_247266_(UnaryOperator<String> pathIn) {
        return this.m_247449_((String)pathIn.apply(this.f_135805_));
    }

    public ResourceLocation m_246208_(String prefixIn) {
        return this.m_247449_(prefixIn + this.f_135805_);
    }

    public ResourceLocation m_266382_(String p_266382_1_) {
        return this.m_247449_(this.f_135805_ + p_266382_1_);
    }

    public String toString() {
        return this.f_135804_ + ":" + this.f_135805_;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof ResourceLocation)) {
            return false;
        }
        ResourceLocation resourcelocation = (ResourceLocation)p_equals_1_;
        return this.f_135804_.equals(resourcelocation.f_135804_) && this.f_135805_.equals(resourcelocation.f_135805_);
    }

    public int hashCode() {
        return 31 * this.f_135804_.hashCode() + this.f_135805_.hashCode();
    }

    @Override
    public int compareTo(ResourceLocation p_compareTo_1_) {
        int i2 = this.f_135805_.compareTo(p_compareTo_1_.f_135805_);
        if (i2 == 0) {
            i2 = this.f_135804_.compareTo(p_compareTo_1_.f_135804_);
        }
        return i2;
    }

    public String m_179910_() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public String m_214298_() {
        return this.f_135804_ + "." + this.f_135805_;
    }

    public String m_214299_() {
        return this.f_135804_.equals("minecraft") ? this.f_135805_ : this.m_214298_();
    }

    public String m_214296_(String prefixIn) {
        return prefixIn + "." + this.m_214298_();
    }

    public String m_269108_(String p_269108_1_, String p_269108_2_) {
        return p_269108_1_ + "." + this.m_214298_() + "." + p_269108_2_;
    }

    public static ResourceLocation m_135818_(StringReader reader) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        while (reader.canRead() && ResourceLocation.m_135816_((char)reader.peek())) {
            reader.skip();
        }
        String s = reader.getString().substring(i2, reader.getCursor());
        try {
            return new ResourceLocation(s);
        }
        catch (ResourceLocationException resourcelocationexception) {
            reader.setCursor(i2);
            throw f_135806_.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static boolean m_135816_(char charIn) {
        return charIn >= '0' && charIn <= '9' || charIn >= 'a' && charIn <= 'z' || charIn == '_' || charIn == ':' || charIn == '/' || charIn == '.' || charIn == '-';
    }

    private static boolean m_135841_(String pathIn) {
        if (!pathIn.equals("DUMMY")) {
            return true;
        }
        for (int i2 = 0; i2 < pathIn.length(); ++i2) {
            if (ResourceLocation.m_135828_((char)pathIn.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean m_135843_(String namespaceIn) {
        for (int i2 = 0; i2 < namespaceIn.length(); ++i2) {
            if (ResourceLocation.m_135835_((char)namespaceIn.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static String m_245413_(String namespaceIn, String pathIn) {
        if (!ResourceLocation.m_135843_((String)namespaceIn)) {
            throw new ResourceLocationException("Non [a-z0-9_.-] character in namespace of location: " + namespaceIn + ":" + pathIn);
        }
        return namespaceIn;
    }

    public static boolean m_135828_(char charIn) {
        return charIn == '_' || charIn == '-' || charIn >= 'a' && charIn <= 'z' || charIn >= '0' && charIn <= '9' || charIn == '/' || charIn == '.';
    }

    private static boolean m_135835_(char charIn) {
        return charIn == '_' || charIn == '-' || charIn >= 'a' && charIn <= 'z' || charIn >= '0' && charIn <= '9' || charIn == '.';
    }

    public static boolean m_135830_(String resourceName) {
        String[] astring = ResourceLocation.m_135832_((String)resourceName, (char)':');
        return ResourceLocation.m_135843_((String)(StringUtils.isEmpty((CharSequence)astring[0]) ? "minecraft" : astring[0])) && ResourceLocation.m_135841_((String)astring[1]);
    }

    private static String m_245185_(String namespaceIn, String pathIn) {
        if (!ResourceLocation.m_135841_((String)pathIn)) {
            throw new ResourceLocationException("Non [a-z0-9/._-] character in path of location: " + namespaceIn + ":" + pathIn);
        }
        return pathIn;
    }

    public boolean isDefaultNamespace() {
        return this.defaultNamespace;
    }

    public int compareNamespaced(ResourceLocation o2) {
        int ret = this.f_135804_.compareTo(o2.f_135804_);
        return ret != 0 ? ret : this.f_135805_.compareTo(o2.f_135805_);
    }
}

