/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.optifine.util.BiomeUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class SynchedEntityData {
    private static final Logger f_135342_ = LogUtils.getLogger();
    private static final Object2IntMap<Class<? extends Entity>> f_135343_ = new Object2IntOpenHashMap();
    private static final int f_179843_ = 254;
    private final Entity f_135344_;
    private final Int2ObjectMap<DataItem<?>> f_135345_ = new Int2ObjectOpenHashMap();
    private final ReadWriteLock f_135346_ = new ReentrantReadWriteLock();
    private boolean f_135348_;
    public Biome spawnBiome = BiomeUtils.PLAINS;
    public BlockPos spawnPosition = BlockPos.f_121853_;
    public BlockState blockStateOn = Blocks.f_50016_.m_49966_();
    public long blockStateOnUpdateMs = 0L;
    public Map<String, Object> modelVariables;
    public CompoundTag nbtTag;
    public long nbtTagUpdateMs = 0L;

    public SynchedEntityData(Entity entityIn) {
        this.f_135344_ = entityIn;
    }

    public static <T> EntityDataAccessor<T> m_135353_(Class<? extends Entity> clazz, EntityDataSerializer<T> serializer) {
        int j2;
        if (f_135342_.isDebugEnabled()) {
            try {
                Class<?> oclass = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!oclass.equals(clazz)) {
                    f_135342_.debug("defineId called for: {} from {}", new Object[]{clazz, oclass, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException oclass) {
                // empty catch block
            }
        }
        if (f_135343_.containsKey(clazz)) {
            j2 = f_135343_.getInt(clazz) + 1;
        } else {
            int i2 = 0;
            Class<? extends Entity> oclass1 = clazz;
            while (oclass1 != Entity.class) {
                if (!f_135343_.containsKey(oclass1 = oclass1.getSuperclass())) continue;
                i2 = f_135343_.getInt(oclass1) + 1;
                break;
            }
            j2 = i2;
        }
        if (j2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + j2 + "! (Max is 254)");
        }
        f_135343_.put(clazz, j2);
        return serializer.m_135021_(j2);
    }

    public <T> void m_135372_(EntityDataAccessor<T> key, T value) {
        int i2 = key.m_135015_();
        if (i2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is 254)");
        }
        if (this.f_135345_.containsKey(i2)) {
            throw new IllegalArgumentException("Duplicate id value for " + i2 + "!");
        }
        if (EntityDataSerializers.m_135052_((EntityDataSerializer)key.m_135016_()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + key.m_135016_() + " for " + i2 + "!");
        }
        this.m_135385_(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void m_135385_(EntityDataAccessor<T> key, T value) {
        DataItem dataitem = new DataItem(key, value);
        ReadWriteLock readWriteLock = this.f_135346_;
        synchronized (readWriteLock) {
            this.f_135345_.put(key.m_135015_(), (Object)dataitem);
        }
    }

    public <T> boolean m_285897_(EntityDataAccessor<T> dataAccessorIn) {
        return this.f_135345_.containsKey(dataAccessorIn.m_135015_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> DataItem<T> m_135379_(EntityDataAccessor<T> key) {
        DataItem dataitem;
        ReadWriteLock readWriteLock = this.f_135346_;
        synchronized (readWriteLock) {
            try {
                dataitem = (DataItem)this.f_135345_.get(key.m_135015_());
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Getting synched entity data");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Synched entity data");
                crashreportcategory.m_128159_("Data ID", key);
                throw new ReportedException(crashreport);
            }
        }
        return dataitem;
    }

    public <T> T m_135370_(EntityDataAccessor<T> key) {
        return (T)this.m_135379_(key).m_135403_();
    }

    public <T> void m_135381_(EntityDataAccessor<T> key, T value) {
        this.m_276349_(key, value, false);
    }

    public <T> void m_276349_(EntityDataAccessor<T> p_276349_1_, T p_276349_2_, boolean p_276349_3_) {
        DataItem dataitem = this.m_135379_(p_276349_1_);
        if (p_276349_3_ || ObjectUtils.notEqual(p_276349_2_, (Object)dataitem.m_135403_())) {
            dataitem.m_135397_(p_276349_2_);
            this.f_135344_.m_7350_(p_276349_1_);
            dataitem.m_135401_(true);
            this.f_135348_ = true;
            this.nbtTag = null;
        }
    }

    public boolean m_135352_() {
        return this.f_135348_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<DataValue<?>> m_135378_() {
        ArrayList<DataValue> list = null;
        if (this.f_135348_) {
            ReadWriteLock readWriteLock = this.f_135346_;
            synchronized (readWriteLock) {
                for (DataItem dataitem : this.f_135345_.values()) {
                    if (!dataitem.m_135406_()) continue;
                    dataitem.m_135401_(false);
                    if (list == null) {
                        list = new ArrayList<DataValue>();
                    }
                    list.add(dataitem.m_253123_());
                }
            }
        }
        this.f_135348_ = false;
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<DataValue<?>> m_252804_() {
        ArrayList<DataValue> list = null;
        ReadWriteLock readWriteLock = this.f_135346_;
        synchronized (readWriteLock) {
            for (DataItem dataitem : this.f_135345_.values()) {
                if (dataitem.m_252838_()) continue;
                if (list == null) {
                    list = new ArrayList<DataValue>();
                }
                list.add(dataitem.m_253123_());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_135356_(List<DataValue<?>> entriesIn) {
        ReadWriteLock readWriteLock = this.f_135346_;
        synchronized (readWriteLock) {
            for (DataValue<?> datavalue : entriesIn) {
                DataItem dataitem = (DataItem)this.f_135345_.get(datavalue.f_252469_);
                if (dataitem == null) continue;
                this.m_135375_(dataitem, datavalue);
                this.f_135344_.m_7350_(dataitem.m_135396_());
                this.nbtTag = null;
            }
        }
        this.f_135344_.m_269505_(entriesIn);
    }

    private <T> void m_135375_(DataItem<T> target, DataValue<?> source) {
        if (!Objects.equals(source.f_252511_(), target.f_135390_.m_135016_())) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", target.f_135390_.m_135015_(), this.f_135344_, target.f_135391_, target.f_135391_.getClass(), source.f_252525_, source.f_252525_.getClass()));
        }
        target.m_135397_(source.f_252525_);
    }

    public boolean m_135388_() {
        return this.f_135345_.isEmpty();
    }
}

