/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModelBakery {
    public static final Material f_119219_ = new Material(TextureAtlas.f_118259_, new ResourceLocation("block/fire_0"));
    public static final Material f_119220_ = new Material(TextureAtlas.f_118259_, new ResourceLocation("block/fire_1"));
    public static final Material f_119221_ = new Material(TextureAtlas.f_118259_, new ResourceLocation("block/lava_flow"));
    public static final Material f_119222_ = new Material(TextureAtlas.f_118259_, new ResourceLocation("block/water_flow"));
    public static final Material f_119223_ = new Material(TextureAtlas.f_118259_, new ResourceLocation("block/water_overlay"));
    public static final Material f_119224_ = new Material(Sheets.f_110737_, new ResourceLocation("entity/banner_base"));
    public static final Material f_119225_ = new Material(Sheets.f_110738_, new ResourceLocation("entity/shield_base"));
    public static final Material f_119226_ = new Material(Sheets.f_110738_, new ResourceLocation("entity/shield_base_nopattern"));
    public static final int f_174875_ = 10;
    public static final List<ResourceLocation> f_119227_ = IntStream.range(0, 10).mapToObj(indexIn -> new ResourceLocation("block/destroy_stage_" + indexIn)).collect(Collectors.toList());
    public static final List<ResourceLocation> f_119228_ = f_119227_.stream().map(locationIn -> new ResourceLocation("textures/" + locationIn.m_135815_() + ".png")).collect(Collectors.toList());
    public static final List<RenderType> f_119229_ = f_119228_.stream().map(RenderType::m_110494_).collect(Collectors.toList());
    static final int f_174876_ = -1;
    private static final int f_174877_ = 0;
    private static final Logger f_119235_ = LogUtils.getLogger();
    private static final String f_174878_ = "builtin/";
    private static final String f_174879_ = "builtin/generated";
    private static final String f_174880_ = "builtin/entity";
    private static final String f_174881_ = "missing";
    public static final ModelResourceLocation f_119230_ = ModelResourceLocation.m_245263_((String)"builtin/missing", (String)"missing");
    public static final FileToIdConverter f_244202_ = FileToIdConverter.m_246568_((String)"blockstates");
    public static final FileToIdConverter f_244378_ = FileToIdConverter.m_246568_((String)"models");
    @VisibleForTesting
    public static final String f_119231_ = ("{    'textures': {       'particle': '" + MissingTextureAtlasSprite.m_118071_().m_135815_() + "',       'missingno': '" + MissingTextureAtlasSprite.m_118071_().m_135815_() + "'    },    'elements': [         {  'from': [ 0, 0, 0 ],            'to': [ 16, 16, 16 ],            'faces': {                'down':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'down',  'texture': '#missingno' },                'up':    { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'up',    'texture': '#missingno' },                'north': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'north', 'texture': '#missingno' },                'south': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'south', 'texture': '#missingno' },                'west':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'west',  'texture': '#missingno' },                'east':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'east',  'texture': '#missingno' }            }        }    ]}").replace('\'', '\"');
    private static final Map<String, String> f_119237_ = Maps.newHashMap((Map)ImmutableMap.of((Object)"missing", (Object)f_119231_));
    private static final Splitter f_119238_ = Splitter.on((char)',');
    private static final Splitter f_119239_ = Splitter.on((char)'=').limit(2);
    public static final BlockModel f_119232_ = (BlockModel)Util.m_137469_((Object)BlockModel.m_111463_((String)"{\"gui_light\": \"front\"}"), modelIn -> {
        modelIn.f_111416_ = "generation marker";
    });
    public static final BlockModel f_119233_ = (BlockModel)Util.m_137469_((Object)BlockModel.m_111463_((String)"{\"gui_light\": \"side\"}"), modelIn -> {
        modelIn.f_111416_ = "block entity marker";
    });
    private static final StateDefinition<Block, BlockState> f_119240_ = new StateDefinition.Builder((Object)Blocks.f_50016_).m_61104_(new Property[]{BooleanProperty.m_61465_((String)"map")}).m_61101_(Block::m_49966_, BlockState::new);
    static final ItemModelGenerator f_119241_ = new ItemModelGenerator();
    private static final Map<ResourceLocation, StateDefinition<Block, BlockState>> f_119242_ = ImmutableMap.of((Object)new ResourceLocation("item_frame"), (Object)f_119240_, (Object)new ResourceLocation("glow_item_frame"), (Object)f_119240_);
    private final BlockColors f_119209_;
    private final Map<ResourceLocation, BlockModel> f_244132_;
    private final Map<ResourceLocation, List<LoadedJson>> f_243866_;
    private final Set<ResourceLocation> f_119210_ = Sets.newHashSet();
    private final BlockModelDefinition.Context f_119211_ = new BlockModelDefinition.Context();
    private final Map<ResourceLocation, UnbakedModel> f_119212_ = Maps.newHashMap();
    final Map<BakedCacheKey, BakedModel> f_119213_ = Maps.newHashMap();
    private final Map<ResourceLocation, UnbakedModel> f_119214_ = Maps.newHashMap();
    private final Map<ResourceLocation, BakedModel> f_119215_ = Maps.newHashMap();
    private int f_119217_ = 1;
    private final Object2IntMap<BlockState> f_119218_ = (Object2IntMap)Util.m_137469_((Object)new Object2IntOpenHashMap(), mapIn -> mapIn.defaultReturnValue(-1));
    public Map<ResourceLocation, UnbakedModel> mapUnbakedModels;

    public ModelBakery(BlockColors blockColorsIn, ProfilerFiller profilerIn, Map<ResourceLocation, BlockModel> modelResourcesIn, Map<ResourceLocation, List<LoadedJson>> blockStateResourcesIn) {
        this.f_119209_ = blockColorsIn;
        this.f_244132_ = new HashMap<ResourceLocation, BlockModel>(modelResourcesIn);
        this.f_243866_ = blockStateResourcesIn;
        profilerIn.m_6180_("missing_model");
        try {
            this.f_119212_.put(f_119230_, this.m_119364_((ResourceLocation)f_119230_));
            this.m_119306_(f_119230_);
        }
        catch (IOException ioexception) {
            f_119235_.error("Error loading missing model, should never happen :(", (Throwable)ioexception);
            throw new RuntimeException(ioexception);
        }
        profilerIn.m_6182_("static_definitions");
        f_119242_.forEach((locationIn, definitionIn) -> definitionIn.m_61056_().forEach(stateIn -> this.m_119306_(BlockModelShaper.m_110889_((ResourceLocation)locationIn, (BlockState)stateIn))));
        profilerIn.m_6182_("blocks");
        for (Block block : BuiltInRegistries.f_256975_) {
            block.m_49965_().m_61056_().forEach(stateIn -> this.m_119306_(BlockModelShaper.m_110895_((BlockState)stateIn)));
        }
        profilerIn.m_6182_("items");
        for (ResourceLocation resourcelocation : BuiltInRegistries.f_257033_.m_6566_()) {
            this.m_119306_(new ModelResourceLocation(resourcelocation, "inventory"));
        }
        profilerIn.m_6182_("special");
        this.m_119306_(ItemRenderer.f_244055_);
        this.m_119306_(ItemRenderer.f_243706_);
        HashSet additionalModels = Sets.newHashSet();
        Reflector.ForgeHooksClient_onRegisterAdditionalModels.call((Object)additionalModels);
        for (ResourceLocation rl : additionalModels) {
            UnbakedModel unbakedmodel = this.m_119341_(rl);
            this.f_119212_.put(rl, unbakedmodel);
            this.f_119214_.put(rl, unbakedmodel);
        }
        this.mapUnbakedModels = this.f_119212_;
        TextureUtils.registerCustomModels((ModelBakery)this);
        this.f_119214_.values().forEach(modelIn -> modelIn.m_5500_(arg_0 -> this.m_119341_(arg_0)));
        profilerIn.m_7238_();
    }

    public void m_245909_(BiFunction<ResourceLocation, Material, TextureAtlasSprite> funcIn) {
        this.f_119214_.keySet().forEach(locIn -> {
            BakedModel bakedmodel = null;
            try {
                bakedmodel = new ModelBakerImpl(this, funcIn, locIn).m_245240_(locIn, (ModelState)BlockModelRotation.X0_Y0);
            }
            catch (Exception exception) {
                f_119235_.warn("Unable to bake model: '{}': {}", locIn, (Object)exception);
            }
            if (bakedmodel != null) {
                this.f_119215_.put(locIn, bakedmodel);
            }
        });
    }

    private static Predicate<BlockState> m_119273_(StateDefinition<Block, BlockState> containerIn, String variantIn) {
        HashMap map = Maps.newHashMap();
        for (String s : f_119238_.split((CharSequence)variantIn)) {
            Iterator iterator = f_119239_.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String s1 = (String)iterator.next();
            Property property = containerIn.m_61081_(s1);
            if (property != null && iterator.hasNext()) {
                String s2 = (String)iterator.next();
                Comparable comparable = ModelBakery.m_119276_((Property)property, (String)s2);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + s2 + "' for blockstate property: '" + s1 + "' " + property.m_6908_());
                }
                map.put(property, comparable);
                continue;
            }
            if (s1.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + s1 + "'");
        }
        Block block = (Block)containerIn.m_61091_();
        return stateIn -> {
            if (stateIn != null && stateIn.m_60713_(block)) {
                for (Map.Entry entry : map.entrySet()) {
                    if (Objects.equals(stateIn.m_61143_((Property)entry.getKey()), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    @Nullable
    static <T extends Comparable<T>> T m_119276_(Property<T> property, String value) {
        return (T)property.m_6215_(value).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnbakedModel m_119341_(ResourceLocation modelLocation) {
        if (this.f_119212_.containsKey(modelLocation)) {
            return (UnbakedModel)this.f_119212_.get(modelLocation);
        }
        if (this.f_119210_.contains(modelLocation)) {
            throw new IllegalStateException("Circular reference while loading " + modelLocation);
        }
        this.f_119210_.add(modelLocation);
        UnbakedModel unbakedmodel = (UnbakedModel)this.f_119212_.get(f_119230_);
        while (!this.f_119210_.isEmpty()) {
            ResourceLocation resourcelocation = (ResourceLocation)this.f_119210_.iterator().next();
            try {
                if (this.f_119212_.containsKey(resourcelocation)) continue;
                this.m_119362_(resourcelocation);
            }
            catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                f_119235_.warn(modelbakery$blockstatedefinitionexception.getMessage());
                this.f_119212_.put(resourcelocation, unbakedmodel);
            }
            catch (Exception exception) {
                f_119235_.warn("Unable to load model: '{}' referenced from: {}", (Object)resourcelocation, (Object)modelLocation);
                f_119235_.warn(exception.getClass().getName() + ": " + exception.getMessage());
                this.f_119212_.put(resourcelocation, unbakedmodel);
            }
            finally {
                this.f_119210_.remove(resourcelocation);
            }
        }
        return this.f_119212_.getOrDefault(modelLocation, unbakedmodel);
    }

    private void m_119362_(ResourceLocation blockstateLocation) throws Exception {
        if (!(blockstateLocation instanceof ModelResourceLocation)) {
            this.m_119352_(blockstateLocation, (UnbakedModel)this.m_119364_(blockstateLocation));
        } else {
            ModelResourceLocation modelresourcelocation = (ModelResourceLocation)blockstateLocation;
            if (Objects.equals(modelresourcelocation.m_119448_(), "inventory")) {
                ResourceLocation resourcelocation = blockstateLocation.m_246208_("item/");
                String path = blockstateLocation.m_135815_();
                if (path.startsWith("optifine/") || path.startsWith("item/")) {
                    resourcelocation = blockstateLocation.m_246208_("");
                }
                BlockModel blockmodel = this.m_119364_(resourcelocation);
                this.m_119352_((ResourceLocation)modelresourcelocation, (UnbakedModel)blockmodel);
                this.f_119212_.put(resourcelocation, blockmodel);
            } else {
                ResourceLocation resourcelocation2 = new ResourceLocation(blockstateLocation.m_135827_(), blockstateLocation.m_135815_());
                StateDefinition statedefinition = Optional.ofNullable((StateDefinition)f_119242_.get(resourcelocation2)).orElseGet(() -> ((Block)BuiltInRegistries.f_256975_.m_7745_(resourcelocation2)).m_49965_());
                this.f_119211_.m_111552_(statedefinition);
                ImmutableList list = ImmutableList.copyOf((Collection)this.f_119209_.m_92575_((Block)statedefinition.m_61091_()));
                ImmutableList immutablelist = statedefinition.m_61056_();
                HashMap map = Maps.newHashMap();
                immutablelist.forEach(stateIn -> map.put(BlockModelShaper.m_110889_((ResourceLocation)resourcelocation2, (BlockState)stateIn), stateIn));
                HashMap map1 = Maps.newHashMap();
                ResourceLocation resourcelocation1 = f_244202_.m_245698_(blockstateLocation);
                UnbakedModel unbakedmodel = (UnbakedModel)this.f_119212_.get(f_119230_);
                ModelGroupKey modelbakery$modelgroupkey = new ModelGroupKey((List)ImmutableList.of((Object)unbakedmodel), (List)ImmutableList.of());
                Pair pair = Pair.of((Object)unbakedmodel, () -> modelbakery$modelgroupkey);
                try {
                    for (Pair pair1 : this.f_243866_.getOrDefault(resourcelocation1, List.of()).stream().map(jsonIn -> {
                        try {
                            return Pair.of((Object)jsonIn.f_243774_, (Object)BlockModelDefinition.m_247114_((BlockModelDefinition.Context)this.f_119211_, (JsonElement)jsonIn.f_244212_));
                        }
                        catch (Exception exception1) {
                            throw new BlockStateDefinitionException(String.format(Locale.ROOT, "Exception loading blockstate definition: '%s' in resourcepack: '%s': %s", resourcelocation1, jsonIn.f_243774_, exception1.getMessage()));
                        }
                    }).toList()) {
                        MultiPart multipart;
                        BlockModelDefinition blockmodeldefinition = (BlockModelDefinition)pair1.getSecond();
                        IdentityHashMap map2 = Maps.newIdentityHashMap();
                        if (blockmodeldefinition.m_111543_()) {
                            multipart = blockmodeldefinition.m_111544_();
                            immutablelist.forEach(arg_0 -> ModelBakery.lambda$loadBlockstate$16(map2, multipart, (List)list, arg_0));
                        } else {
                            multipart = null;
                        }
                        blockmodeldefinition.m_111539_().forEach((arg_0, arg_1) -> ModelBakery.lambda$loadBlockstate$20(immutablelist, statedefinition, map2, (List)list, multipart, pair, blockmodeldefinition, resourcelocation1, pair1, arg_0, arg_1));
                        map1.putAll(map2);
                    }
                }
                catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                    throw modelbakery$blockstatedefinitionexception;
                }
                catch (Exception exception) {
                    throw new BlockStateDefinitionException(String.format(Locale.ROOT, "Exception loading blockstate definition: '%s': %s", resourcelocation1, exception));
                }
                finally {
                    HashMap map3 = Maps.newHashMap();
                    map.forEach((locationIn, stateIn) -> {
                        Pair pair2 = (Pair)map1.get(stateIn);
                        if (pair2 == null) {
                            f_119235_.warn("Exception loading blockstate definition: '{}' missing model for variant: '{}'", (Object)resourcelocation1, locationIn);
                            pair2 = pair;
                        }
                        this.m_119352_((ResourceLocation)locationIn, (UnbakedModel)pair2.getFirst());
                        try {
                            ModelGroupKey modelbakery$modelgroupkey1 = (ModelGroupKey)((Supplier)pair2.getSecond()).get();
                            map3.computeIfAbsent(modelbakery$modelgroupkey1, keyIn -> Sets.newIdentityHashSet()).add(stateIn);
                        }
                        catch (Exception exception1) {
                            f_119235_.warn("Exception evaluating model definition: '{}'", locationIn, (Object)exception1);
                        }
                    });
                    map3.forEach((keyIn, setIn) -> {
                        Iterator iterator = setIn.iterator();
                        while (iterator.hasNext()) {
                            BlockState blockstate = (BlockState)iterator.next();
                            if (blockstate.m_60799_() == RenderShape.MODEL) continue;
                            iterator.remove();
                            this.f_119218_.put((Object)blockstate, 0);
                        }
                        if (setIn.size() > 1) {
                            this.m_119310_((Iterable)setIn);
                        }
                    });
                }
            }
        }
    }

    private void m_119352_(ResourceLocation locationIn, UnbakedModel modelIn) {
        this.f_119212_.put(locationIn, modelIn);
        this.f_119210_.addAll(modelIn.m_7970_());
    }

    public void m_119306_(ModelResourceLocation locationIn) {
        UnbakedModel unbakedmodel = this.m_119341_((ResourceLocation)locationIn);
        this.f_119212_.put(locationIn, unbakedmodel);
        this.f_119214_.put(locationIn, unbakedmodel);
    }

    private void m_119310_(Iterable<BlockState> blockStatesIn) {
        int i2 = this.f_119217_++;
        blockStatesIn.forEach(stateIn -> this.f_119218_.put(stateIn, i2));
    }

    private BlockModel m_119364_(ResourceLocation location) throws IOException {
        String s = location.m_135815_();
        if ("builtin/generated".equals(s)) {
            return f_119232_;
        }
        if ("builtin/entity".equals(s)) {
            return f_119233_;
        }
        if (s.startsWith("builtin/")) {
            String s1 = s.substring("builtin/".length());
            String s2 = (String)f_119237_.get(s1);
            if (s2 == null) {
                throw new FileNotFoundException(location.toString());
            }
            StringReader reader = new StringReader(s2);
            BlockModel blockmodel1 = BlockModel.m_111461_((Reader)reader);
            blockmodel1.f_111416_ = location.toString();
            return blockmodel1;
        }
        ResourceLocation resourcelocation = this.getModelLocation(location);
        BlockModel blockmodel = (BlockModel)this.f_244132_.get(resourcelocation);
        if (blockmodel == null && (blockmodel = this.loadBlockModel(resourcelocation)) != null) {
            this.f_244132_.put(resourcelocation, blockmodel);
        }
        if (blockmodel == null) {
            throw new FileNotFoundException(resourcelocation.toString());
        }
        blockmodel.f_111416_ = location.toString();
        String basePath = TextureUtils.getBasePath((String)resourcelocation.m_135815_());
        ModelBakery.fixModelLocations((BlockModel)blockmodel, (String)basePath);
        return blockmodel;
    }

    public Map<ResourceLocation, BakedModel> m_119251_() {
        return this.f_119215_;
    }

    public Object2IntMap<BlockState> m_119355_() {
        return this.f_119218_;
    }

    private ResourceLocation getModelLocation(ResourceLocation location) {
        String path = location.m_135815_();
        if (path.startsWith("optifine/")) {
            if (!path.endsWith(".json")) {
                location = new ResourceLocation(location.m_135827_(), path + ".json");
            }
            return location;
        }
        return f_244378_.m_245698_(location);
    }

    public static void fixModelLocations(BlockModel modelBlock, String basePath) {
        ResourceLocation parentLocFixed = ModelBakery.fixModelLocation((ResourceLocation)FaceBakery.getParentLocation((BlockModel)modelBlock), (String)basePath);
        if (parentLocFixed != FaceBakery.getParentLocation((BlockModel)modelBlock)) {
            FaceBakery.setParentLocation((BlockModel)modelBlock, (ResourceLocation)parentLocFixed);
        }
        if (FaceBakery.getTextures((BlockModel)modelBlock) != null) {
            for (Map.Entry entry : FaceBakery.getTextures((BlockModel)modelBlock).entrySet()) {
                Material material;
                ResourceLocation textureLocation;
                String path;
                String pathFixed;
                Either value = (Either)entry.getValue();
                Optional optionalMaterial = value.left();
                if (!optionalMaterial.isPresent() || (pathFixed = ModelBakery.fixResourcePath((String)(path = (textureLocation = (material = (Material)optionalMaterial.get()).m_119203_()).m_135815_()), (String)basePath)).equals(path)) continue;
                ResourceLocation textureLocationFixed = new ResourceLocation(textureLocation.m_135827_(), pathFixed);
                Material materialFixed = new Material(material.m_119193_(), textureLocationFixed);
                Either valueFixed = Either.left((Object)materialFixed);
                entry.setValue(valueFixed);
            }
        }
    }

    public static ResourceLocation fixModelLocation(ResourceLocation loc, String basePath) {
        if (loc == null || basePath == null) {
            return loc;
        }
        if (!loc.m_135827_().equals("minecraft")) {
            return loc;
        }
        String path = loc.m_135815_();
        String pathFixed = ModelBakery.fixResourcePath((String)path, (String)basePath);
        if (pathFixed != path) {
            loc = new ResourceLocation(loc.m_135827_(), pathFixed);
        }
        return loc;
    }

    private static String fixResourcePath(String path, String basePath) {
        path = TextureUtils.fixResourcePath((String)path, (String)basePath);
        path = StrUtils.removeSuffix((String)path, (String)".json");
        path = StrUtils.removeSuffix((String)path, (String)".png");
        return path;
    }

    public BlockModel loadBlockModel(ResourceLocation locJson) {
        try {
            Resource res = Config.getResource((ResourceLocation)locJson);
            BufferedReader reader = res.m_215508_();
            BlockModel bm = BlockModel.m_111461_((Reader)reader);
            return bm;
        }
        catch (Exception e2) {
            Config.warn((String)("Error loading model: " + locJson));
            Config.warn((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
    }

    private static /* synthetic */ void lambda$loadBlockstate$20(ImmutableList immutablelist, StateDefinition statedefinition, Map map2, List list, MultiPart multipart, Pair pair, BlockModelDefinition blockmodeldefinition, ResourceLocation resourcelocation1, Pair pair1, String keyIn, MultiVariant variantIn) {
        try {
            immutablelist.stream().filter(ModelBakery.m_119273_((StateDefinition)statedefinition, (String)keyIn)).forEach(stateIn -> {
                Pair pair2 = map2.put(stateIn, Pair.of((Object)variantIn, () -> ModelGroupKey.m_119383_((BlockState)stateIn, (UnbakedModel)variantIn, (Collection)list)));
                if (pair2 != null && pair2.getFirst() != multipart) {
                    map2.put(stateIn, pair);
                    throw new RuntimeException("Overlapping definition with: " + (String)blockmodeldefinition.m_111539_().entrySet().stream().filter(entityIn -> entityIn.getValue() == pair2.getFirst()).findFirst().get().getKey());
                }
            });
        }
        catch (Exception exception1) {
            f_119235_.warn("Exception loading blockstate definition: '{}' in resourcepack: '{}' for variant: '{}': {}", new Object[]{resourcelocation1, pair1.getFirst(), keyIn, exception1.getMessage()});
        }
    }

    private static /* synthetic */ void lambda$loadBlockstate$16(Map map2, MultiPart multipart, List list, BlockState stateIn) {
        map2.put(stateIn, Pair.of((Object)multipart, () -> ModelGroupKey.m_119379_((BlockState)stateIn, (MultiPart)multipart, (Collection)list)));
    }
}

