/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.optifine.shaders.ShadersTextureType;
import net.optifine.texture.SpriteSourceCollector;
import net.optifine.util.StrUtils;
import org.slf4j.Logger;

public class SpriteResourceLoader {
    private static final Logger f_260482_ = LogUtils.getLogger();
    private static final FileToIdConverter f_260445_ = new FileToIdConverter("atlases", ".json");
    private final List<SpriteSource> f_260697_;

    private SpriteResourceLoader(List<SpriteSource> sourcesIn) {
        this.f_260697_ = sourcesIn;
    }

    public List<Supplier<SpriteContents>> m_260886_(ResourceManager resourceManagerIn) {
        HashMap map = new HashMap();
        1 spritesource$output = new /* Unavailable Anonymous Inner Class!! */;
        this.f_260697_.forEach(arg_0 -> SpriteResourceLoader.lambda$list$0(resourceManagerIn, (SpriteSource.Output)spritesource$output, arg_0));
        this.filterSpriteNames(map.keySet());
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(MissingTextureAtlasSprite::m_246104_);
        builder.addAll(map.values());
        return builder.build();
    }

    public static SpriteResourceLoader m_261166_(ResourceManager resourceManagerIn, ResourceLocation locationIn) {
        ResourceLocation resourcelocation = f_260445_.m_245698_(locationIn);
        ArrayList list = new ArrayList();
        for (Resource resource : resourceManagerIn.m_213829_(resourcelocation)) {
            try {
                BufferedReader bufferedreader = resource.m_215508_();
                try {
                    Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)bufferedreader));
                    list.addAll((Collection)SpriteSources.f_260551_.parse(dynamic).getOrThrow(false, arg_0 -> ((Logger)f_260482_).error(arg_0)));
                }
                finally {
                    if (bufferedreader == null) continue;
                    bufferedreader.close();
                }
            }
            catch (Exception exception) {
                f_260482_.warn("Failed to parse atlas definition {} in pack {}", new Object[]{resourcelocation, resource.m_215506_(), exception});
            }
        }
        return new SpriteResourceLoader(list);
    }

    public void addSpriteSources(Collection<ResourceLocation> spriteNames) {
        for (ResourceLocation spriteName : spriteNames) {
            this.f_260697_.add(new SingleFile(spriteName, Optional.empty()));
        }
    }

    public List<SpriteSource> getSpriteSources() {
        return this.f_260697_;
    }

    public Set<ResourceLocation> getSpriteNames(ResourceManager resourceManager) {
        LinkedHashSet<ResourceLocation> spriteNames = new LinkedHashSet<ResourceLocation>();
        for (SpriteSource source : this.f_260697_) {
            SpriteSourceCollector out = new SpriteSourceCollector(spriteNames);
            source.m_260891_(resourceManager, (SpriteSource.Output)out);
        }
        return spriteNames;
    }

    public void filterSpriteNames(Set<ResourceLocation> spriteNames) {
        String suffixNormal = ShadersTextureType.NORMAL.getSuffix();
        String suffixSpecular = ShadersTextureType.SPECULAR.getSuffix();
        String[] suffixesShaders = new String[]{suffixNormal, suffixSpecular};
        Iterator<ResourceLocation> it = spriteNames.iterator();
        while (it.hasNext()) {
            ResourceLocation loc = it.next();
            String path = loc.m_135815_();
            if (!path.endsWith(suffixNormal) && !path.endsWith(suffixSpecular)) continue;
            String pathBase = StrUtils.removeSuffix((String)path, (String[])suffixesShaders);
            ResourceLocation locBase = new ResourceLocation(loc.m_135827_(), pathBase);
            if (!spriteNames.contains(locBase)) continue;
            it.remove();
        }
    }

    private static /* synthetic */ void lambda$list$0(ResourceManager resourceManagerIn, SpriteSource.Output spritesource$output, SpriteSource sourceIn) {
        sourceIn.m_260891_(resourceManagerIn, spritesource$output);
    }
}

