/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.RealmsMainScreen;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.Dumpable;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.PreloadedTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.optifine.Config;
import net.optifine.EmissiveTextures;
import net.optifine.RandomEntities;
import net.optifine.shaders.ShadersTex;
import org.slf4j.Logger;

public class TextureManager
implements PreparableReloadListener,
Tickable,
AutoCloseable {
    private static final Logger f_118467_ = LogUtils.getLogger();
    public static final ResourceLocation f_118466_ = new ResourceLocation("");
    private final Map<ResourceLocation, AbstractTexture> f_118468_ = Maps.newHashMap();
    private final Set<Tickable> f_118469_ = Sets.newHashSet();
    private final Map<String, Integer> f_118470_ = Maps.newHashMap();
    private final ResourceManager f_118471_;
    private Int2ObjectMap<AbstractTexture> mapTexturesById = new Int2ObjectOpenHashMap();

    public TextureManager(ResourceManager resourceManager) {
        this.f_118471_ = resourceManager;
    }

    public void m_174784_(ResourceLocation resource) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.m_118519_(resource));
        } else {
            this.m_118519_(resource);
        }
    }

    private void m_118519_(ResourceLocation resource) {
        AbstractTexture abstracttexture = (AbstractTexture)this.f_118468_.get(resource);
        if (abstracttexture == null) {
            abstracttexture = new SimpleTexture(resource);
            this.m_118495_(resource, abstracttexture);
        }
        if (Config.isShaders()) {
            ShadersTex.bindTexture((AbstractTexture)abstracttexture);
        } else {
            abstracttexture.m_117966_();
        }
    }

    public void m_118495_(ResourceLocation textureLocation, AbstractTexture textureObj) {
        int textureId;
        AbstractTexture abstracttexture = this.f_118468_.put(textureLocation, textureObj = this.m_118515_(textureLocation, textureObj));
        if (abstracttexture != textureObj) {
            if (abstracttexture != null && abstracttexture != MissingTextureAtlasSprite.m_118080_()) {
                this.m_118508_(textureLocation, abstracttexture);
            }
            if (textureObj instanceof Tickable) {
                this.f_118469_.add((Tickable)textureObj);
            }
        }
        if ((textureId = textureObj.m_117963_()) > 0) {
            this.mapTexturesById.put(textureId, (Object)textureObj);
        }
    }

    private void m_118508_(ResourceLocation locationIn, AbstractTexture textureIn) {
        if (textureIn != MissingTextureAtlasSprite.m_118080_()) {
            this.f_118469_.remove(textureIn);
            try {
                textureIn.close();
            }
            catch (Exception exception) {
                f_118467_.warn("Failed to close texture {}", (Object)locationIn, (Object)exception);
            }
        }
        textureIn.m_117964_();
    }

    private AbstractTexture m_118515_(ResourceLocation locationIn, AbstractTexture textureIn) {
        try {
            textureIn.m_6704_(this.f_118471_);
            return textureIn;
        }
        catch (IOException ioexception) {
            if (locationIn != f_118466_) {
                f_118467_.warn("Failed to load texture: {}", (Object)locationIn);
                f_118467_.warn(ioexception.getClass().getName() + ": " + ioexception.getMessage());
            }
            return MissingTextureAtlasSprite.m_118080_();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Registering texture");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Resource location being registered");
            crashreportcategory.m_128159_("Resource location", (Object)locationIn);
            crashreportcategory.m_128165_("Texture object class", () -> textureIn.getClass().getName());
            throw new ReportedException(crashreport);
        }
    }

    public AbstractTexture m_118506_(ResourceLocation textureLocation) {
        AbstractTexture abstracttexture = (AbstractTexture)this.f_118468_.get(textureLocation);
        if (abstracttexture == null) {
            abstracttexture = new SimpleTexture(textureLocation);
            this.m_118495_(textureLocation, abstracttexture);
        }
        return abstracttexture;
    }

    public AbstractTexture m_174786_(ResourceLocation textureLocation, AbstractTexture textureDefault) {
        return this.f_118468_.getOrDefault(textureLocation, textureDefault);
    }

    public ResourceLocation m_118490_(String name, DynamicTexture texture) {
        Integer integer = (Integer)this.f_118470_.get(name);
        integer = integer == null ? Integer.valueOf(1) : Integer.valueOf(integer + 1);
        this.f_118470_.put(name, integer);
        ResourceLocation resourcelocation = new ResourceLocation(String.format(Locale.ROOT, "dynamic/%s_%d", name, integer));
        this.m_118495_(resourcelocation, (AbstractTexture)texture);
        return resourcelocation;
    }

    public CompletableFuture<Void> m_118501_(ResourceLocation textureLocation, Executor executor) {
        if (!this.f_118468_.containsKey(textureLocation)) {
            PreloadedTexture preloadedtexture = new PreloadedTexture(this.f_118471_, textureLocation, executor);
            this.f_118468_.put(textureLocation, preloadedtexture);
            return preloadedtexture.m_118105_().thenRunAsync(() -> this.m_118495_(textureLocation, (AbstractTexture)preloadedtexture), TextureManager::m_118488_);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static void m_118488_(Runnable runnableIn) {
        Minecraft.m_91087_().execute(() -> RenderSystem.recordRenderCall(runnableIn::run));
    }

    public void m_7673_() {
        for (Tickable tickable : this.f_118469_) {
            tickable.m_7673_();
        }
    }

    public void m_118513_(ResourceLocation textureLocation) {
        AbstractTexture abstracttexture = (AbstractTexture)this.f_118468_.remove(textureLocation);
        if (abstracttexture != null) {
            this.f_118468_.remove(textureLocation);
            this.m_118508_(textureLocation, abstracttexture);
        }
    }

    @Override
    public void close() {
        this.f_118468_.forEach((arg_0, arg_1) -> this.m_118508_(arg_0, arg_1));
        this.f_118468_.clear();
        this.f_118469_.clear();
        this.f_118470_.clear();
        this.mapTexturesById.clear();
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        Config.dbg((String)"*** Reloading textures ***");
        Config.log((String)("Resource packs: " + Config.getResourcePackNames()));
        Iterator it = this.f_118468_.keySet().iterator();
        while (it.hasNext()) {
            ResourceLocation loc = (ResourceLocation)it.next();
            String path = loc.m_135815_();
            if (!path.startsWith("optifine/") && !EmissiveTextures.isEmissive((ResourceLocation)loc)) continue;
            AbstractTexture tex = (AbstractTexture)this.f_118468_.get(loc);
            if (tex instanceof AbstractTexture) {
                AbstractTexture at = tex;
                at.m_117964_();
            }
            it.remove();
        }
        RandomEntities.update();
        EmissiveTextures.update();
        CompletableFuture<Void> completablefuture = new CompletableFuture<Void>();
        ((CompletableFuture)CompletableFuture.allOf(TitleScreen.m_96754_((TextureManager)this, (Executor)backgroundExecutor), this.m_118501_(AbstractWidget.f_93617_, backgroundExecutor)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(p_244739_4_ -> {
            MissingTextureAtlasSprite.m_118080_();
            RealmsMainScreen.m_86406_((ResourceManager)this.f_118471_);
            HashSet entries = new HashSet(this.f_118468_.entrySet());
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
                AbstractTexture abstracttexture = (AbstractTexture)entry.getValue();
                if (abstracttexture == MissingTextureAtlasSprite.m_118080_() && !resourcelocation.equals((Object)MissingTextureAtlasSprite.m_118071_())) {
                    iterator.remove();
                    continue;
                }
                abstracttexture.m_6479_(this, resourceManager, resourcelocation, gameExecutor);
            }
            Minecraft.m_91087_().m_6937_(() -> completablefuture.complete(null));
        }, runnableIn -> RenderSystem.recordRenderCall(runnableIn::run));
        return completablefuture;
    }

    public void m_276085_(Path pathIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.m_276083_(pathIn));
        } else {
            this.m_276083_(pathIn);
        }
    }

    private void m_276083_(Path pathIn) {
        try {
            Files.createDirectories(pathIn, new FileAttribute[0]);
        }
        catch (IOException ioexception) {
            f_118467_.error("Failed to create directory {}", (Object)pathIn, (Object)ioexception);
            return;
        }
        this.f_118468_.forEach((p_276077_1_, p_276077_2_) -> {
            if (p_276077_2_ instanceof Dumpable) {
                Dumpable dumpable = (Dumpable)p_276077_2_;
                try {
                    dumpable.m_276079_(p_276077_1_, pathIn);
                }
                catch (IOException ioexception1) {
                    f_118467_.error("Failed to dump texture {}", p_276077_1_, (Object)ioexception1);
                }
            }
        });
    }

    public AbstractTexture getTextureById(int id) {
        AbstractTexture tex = (AbstractTexture)this.mapTexturesById.get(id);
        if (tex != null && tex.m_117963_() != id) {
            this.mapTexturesById.remove(id);
            this.mapTexturesById.put(tex.m_117963_(), (Object)tex);
            tex = null;
        }
        return tex;
    }

    public Collection<AbstractTexture> getTextures() {
        return this.f_118468_.values();
    }

    public Collection<ResourceLocation> getTextureLocations() {
        return this.f_118468_.keySet();
    }
}

