/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.StitcherException;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.util.TextureUtils;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpriteLoader {
    private static final Logger f_244357_ = LogUtils.getLogger();
    private final ResourceLocation f_244500_;
    private final int f_243676_;
    private final int f_276071_;
    private final int f_276068_;
    private TextureAtlas atlas;

    public SpriteLoader(ResourceLocation locIn, int maxSizeIn, int minWidthIn, int minHeightIn) {
        this.f_244500_ = locIn;
        this.f_243676_ = maxSizeIn;
        this.f_276071_ = minWidthIn;
        this.f_276068_ = minHeightIn;
    }

    public static SpriteLoader m_245483_(TextureAtlas atlasIn) {
        SpriteLoader loader = new SpriteLoader(atlasIn.m_118330_(), atlasIn.m_245285_(), atlasIn.m_276092_(), atlasIn.m_276095_());
        loader.atlas = atlasIn;
        return loader;
    }

    public Preparations m_261295_(List<SpriteContents> spritesIn, int mipmapLevelIn, Executor executorIn) {
        int l1;
        int mipmapLevels = this.atlas.mipmapLevel;
        int minSpriteSize = this.atlas.getIconGridSize();
        int i2 = this.f_243676_;
        Stitcher stitcher = new Stitcher(i2, i2, mipmapLevelIn);
        int j2 = Integer.MAX_VALUE;
        int k2 = 1 << mipmapLevelIn;
        for (SpriteContents spritecontents : spritesIn) {
            int ws = spritecontents.getSpriteWidth();
            int hs = spritecontents.getSpriteHeight();
            if (ws < 1 || hs < 1) {
                Config.warn((String)("Invalid sprite size: " + spritecontents.getSpriteLocation()));
                continue;
            }
            if (ws < minSpriteSize || mipmapLevels > 0) {
                int ws2;
                int n2 = ws2 = mipmapLevels > 0 ? TextureUtils.scaleToGrid((int)ws, (int)minSpriteSize) : TextureUtils.scaleToMin((int)ws, (int)minSpriteSize);
                if (ws2 != ws) {
                    if (!TextureUtils.isPowerOfTwo((int)ws)) {
                        Config.log((String)("Scaled non power of 2: " + spritecontents.getSpriteLocation() + ", " + ws + " -> " + ws2));
                    } else {
                        Config.log((String)("Scaled too small texture: " + spritecontents.getSpriteLocation() + ", " + ws + " -> " + ws2));
                    }
                    int hs2 = hs * ws2 / ws;
                    double scaleFactor = (double)ws2 * 1.0 / (double)ws;
                    spritecontents.setSpriteWidth(ws2);
                    spritecontents.setSpriteHeight(hs2);
                    spritecontents.setScaleFactor(scaleFactor);
                    spritecontents.rescale();
                }
            }
            j2 = Math.min(j2, Math.min(spritecontents.m_246492_(), spritecontents.m_245330_()));
            int l2 = Math.min(Integer.lowestOneBit(spritecontents.m_246492_()), Integer.lowestOneBit(spritecontents.m_245330_()));
            if (l2 < k2) {
                f_244357_.warn("Texture {} with size {}x{} limits mip level from {} to {}", new Object[]{spritecontents.m_246162_(), spritecontents.m_246492_(), spritecontents.m_245330_(), Mth.m_14173_((int)k2), Mth.m_14173_((int)l2)});
                k2 = l2;
            }
            stitcher.m_246099_((Stitcher.Entry)spritecontents);
        }
        int j1 = Math.min(j2, k2);
        int k1 = Mth.m_14173_((int)j1);
        if (k1 < 0) {
            k1 = 0;
        }
        if (k1 < mipmapLevelIn) {
            f_244357_.warn("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", new Object[]{this.f_244500_, mipmapLevelIn, k1, j1});
            l1 = k1;
        } else {
            l1 = mipmapLevelIn;
        }
        try {
            stitcher.m_118193_();
        }
        catch (StitcherException stitcherexception) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)stitcherexception, (String)"Stitching");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Stitcher");
            crashreportcategory.m_128159_("Sprites", (Object)stitcherexception.m_118258_().stream().map(entryIn -> String.format(Locale.ROOT, "%s[%dx%d]", entryIn.m_246162_(), entryIn.m_246492_(), entryIn.m_245330_())).collect(Collectors.joining(",")));
            crashreportcategory.m_128159_("Max Texture Size", (Object)i2);
            throw new ReportedException(crashreport);
        }
        int i1 = Math.max(stitcher.m_118174_(), this.f_276071_);
        int i22 = Math.max(stitcher.m_118187_(), this.f_276068_);
        Map map = this.m_276091_(stitcher, i1, i22);
        TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)map.get(MissingTextureAtlasSprite.m_118071_());
        CompletableFuture<Void> completablefuture = l1 > 0 ? CompletableFuture.runAsync(() -> map.values().forEach(spriteIn -> {
            spriteIn.setTextureAtlas(this.atlas);
            spriteIn.increaseMipLevel(l1);
        }), executorIn) : CompletableFuture.completedFuture(null);
        return new Preparations(i1, i22, l1, textureatlassprite, map, completablefuture);
    }

    public static CompletableFuture<List<SpriteContents>> m_260809_(List<Supplier<SpriteContents>> spritesIn, Executor executorIn) {
        List<CompletableFuture> list = spritesIn.stream().map(supplierIn -> CompletableFuture.supplyAsync(supplierIn, executorIn)).toList();
        return Util.m_137567_(list).thenApply(listSpritesIn -> listSpritesIn.stream().filter(Objects::nonNull).toList());
    }

    public CompletableFuture<Preparations> m_260881_(ResourceManager resourceManagerIn, ResourceLocation locationIn, int mipmapLevelIn, Executor executorIn) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            SpriteResourceLoader srl = SpriteResourceLoader.m_261166_((ResourceManager)resourceManagerIn, (ResourceLocation)locationIn);
            Set spriteNames = srl.getSpriteNames(resourceManagerIn);
            srl.filterSpriteNames(spriteNames);
            LinkedHashSet spriteNamesNew = new LinkedHashSet(spriteNames);
            this.atlas.preStitch(spriteNamesNew, resourceManagerIn, mipmapLevelIn);
            spriteNamesNew.removeAll(spriteNames);
            srl.addSpriteSources(spriteNamesNew);
            return srl.m_260886_(resourceManagerIn);
        }, executorIn).thenCompose(contentsIn -> SpriteLoader.m_260809_((List)contentsIn, (Executor)executorIn))).thenApply(contentsIn -> this.m_261295_(contentsIn, mipmapLevelIn, executorIn));
    }

    @Nullable
    public static SpriteContents m_245083_(ResourceLocation locationIn, Resource resourceIn) {
        NativeImage nativeimage;
        AnimationMetadataSection animationmetadatasection;
        try {
            animationmetadatasection = resourceIn.m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).orElse(AnimationMetadataSection.f_119012_);
        }
        catch (Exception exception) {
            f_244357_.error("Unable to parse metadata from {}", (Object)locationIn, (Object)exception);
            return null;
        }
        try (InputStream inputstream = resourceIn.m_215507_();){
            nativeimage = NativeImage.m_85058_((InputStream)inputstream);
        }
        catch (IOException ioexception) {
            f_244357_.error("Using missing texture, unable to load {}", (Object)locationIn, (Object)ioexception);
            return null;
        }
        FrameSize framesize = animationmetadatasection.m_245821_(nativeimage.m_84982_(), nativeimage.m_85084_());
        if (Mth.m_264612_((int)nativeimage.m_84982_(), (int)framesize.f_244129_()) && Mth.m_264612_((int)nativeimage.m_85084_(), (int)framesize.f_244503_())) {
            SpriteContents contents;
            if (Reflector.ForgeHooksClient_loadSpriteContents.exists() && (contents = (SpriteContents)Reflector.ForgeHooksClient_loadSpriteContents.call(new Object[]{locationIn, resourceIn, framesize, nativeimage, animationmetadatasection})) != null) {
                return contents;
            }
            return new SpriteContents(locationIn, framesize, nativeimage, animationmetadatasection);
        }
        f_244357_.error("Image {} size {},{} is not multiple of frame size {},{}", new Object[]{locationIn, nativeimage.m_84982_(), nativeimage.m_85084_(), framesize.f_244129_(), framesize.f_244503_()});
        nativeimage.close();
        return null;
    }

    private Map<ResourceLocation, TextureAtlasSprite> m_276091_(Stitcher<SpriteContents> stitcherIn, int widthIn, int heightIn) {
        HashMap<ResourceLocation, TextureAtlasSprite> map = new HashMap<ResourceLocation, TextureAtlasSprite>();
        stitcherIn.m_118180_((contentsIn, xIn, yIn) -> {
            TextureAtlasSprite sprite;
            if (Reflector.ForgeHooksClient_loadTextureAtlasSprite.exists() && (sprite = (TextureAtlasSprite)Reflector.ForgeHooksClient_loadTextureAtlasSprite.call(new Object[]{this.f_244500_, contentsIn, widthIn, heightIn, xIn, yIn, contentsIn.f_243731_.length - 1})) != null) {
                map.put(contentsIn.m_246162_(), sprite);
                return;
            }
            sprite = this.atlas.getRegisteredSprite(contentsIn.m_246162_());
            if (sprite != null) {
                sprite.init(this.f_244500_, contentsIn, widthIn, heightIn, xIn, yIn);
            } else {
                sprite = new TextureAtlasSprite(this.f_244500_, contentsIn, widthIn, heightIn, xIn, yIn, this.atlas, null);
            }
            sprite.update(Config.getResourceManager());
            map.put(contentsIn.m_246162_(), sprite);
        });
        return map;
    }
}

