/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.texture.MipmapGenerator;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteTicker;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.textures.ForgeTextureMetadata;
import net.optifine.texture.ColorBlenderKeepAlpha;
import net.optifine.texture.IColorBlender;
import net.optifine.util.TextureUtils;
import org.slf4j.Logger;

public class SpriteContents
implements Stitcher.Entry,
AutoCloseable {
    private static final Logger f_243663_ = LogUtils.getLogger();
    private final ResourceLocation f_243877_;
    int f_244302_;
    int f_244600_;
    private NativeImage f_243904_;
    NativeImage[] f_243731_;
    @Nullable
    private final AnimatedTexture f_244575_;
    private double scaleFactor = 1.0;
    private TextureAtlasSprite sprite;
    private AnimationMetadataSection metadata;
    public final ForgeTextureMetadata forgeMeta;

    public SpriteContents(ResourceLocation nameIn, FrameSize sizeIn, NativeImage imageIn, AnimationMetadataSection metadataIn) {
        this(nameIn, sizeIn, imageIn, metadataIn, null);
    }

    public SpriteContents(ResourceLocation nameIn, FrameSize sizeIn, NativeImage imageIn, AnimationMetadataSection metadataIn, ForgeTextureMetadata forgeMeta) {
        this.f_243877_ = nameIn;
        this.f_244302_ = sizeIn.f_244129_();
        this.f_244600_ = sizeIn.f_244503_();
        this.f_244575_ = this.m_247391_(sizeIn, imageIn.m_84982_(), imageIn.m_85084_(), metadataIn);
        this.f_243904_ = imageIn;
        this.f_243731_ = new NativeImage[]{this.f_243904_};
        this.metadata = metadataIn;
        this.forgeMeta = forgeMeta;
    }

    public void m_246368_(int mipmapLevelIn) {
        IColorBlender colorBlender = null;
        if (this.sprite != null) {
            colorBlender = this.sprite.getTextureAtlas().getShadersColorBlender(this.sprite.spriteShadersType);
            if (this.sprite.spriteShadersType == null) {
                if (!this.f_243877_.m_135815_().endsWith("_leaves")) {
                    TextureAtlasSprite.fixTransparentColor((NativeImage)this.f_243904_);
                    this.f_243731_[0] = this.f_243904_;
                }
                if (colorBlender == null && this.f_243877_.m_135815_().endsWith("glass_pane_top")) {
                    colorBlender = new ColorBlenderKeepAlpha();
                }
            }
        }
        try {
            this.f_243731_ = MipmapGenerator.generateMipLevels((NativeImage[])this.f_243731_, (int)mipmapLevelIn, colorBlender);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Generating mipmaps for frame");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Sprite being mipmapped");
            crashreportcategory.m_128165_("First frame", () -> {
                StringBuilder stringbuilder = new StringBuilder();
                if (stringbuilder.length() > 0) {
                    stringbuilder.append(", ");
                }
                stringbuilder.append(this.f_243904_.m_84982_()).append("x").append(this.f_243904_.m_85084_());
                return stringbuilder.toString();
            });
            CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Frame being iterated");
            crashreportcategory1.m_128159_("Sprite name", (Object)this.f_243877_);
            crashreportcategory1.m_128165_("Sprite size", () -> this.f_244302_ + " x " + this.f_244600_);
            crashreportcategory1.m_128165_("Sprite frames", () -> this.m_245088_() + " frames");
            crashreportcategory1.m_128159_("Mipmap levels", (Object)mipmapLevelIn);
            throw new ReportedException(crashreport);
        }
    }

    private int m_245088_() {
        return this.f_244575_ != null ? this.f_244575_.f_243714_.size() : 1;
    }

    @Nullable
    private AnimatedTexture m_247391_(FrameSize frameSizeIn, int widthIn, int heightIn, AnimationMetadataSection metadataIn) {
        int i2 = widthIn / frameSizeIn.f_244129_();
        int j2 = heightIn / frameSizeIn.f_244503_();
        int k2 = i2 * j2;
        ArrayList<FrameInfo> list = new ArrayList<FrameInfo>();
        metadataIn.m_174861_((indexIn, timeIn) -> list.add(new FrameInfo(indexIn, timeIn)));
        if (list.isEmpty()) {
            for (int l2 = 0; l2 < k2; ++l2) {
                list.add(new FrameInfo(l2, metadataIn.m_119030_()));
            }
        } else {
            int i1 = 0;
            IntOpenHashSet intset = new IntOpenHashSet();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FrameInfo spritecontents$frameinfo = (FrameInfo)iterator.next();
                boolean flag = true;
                if (spritecontents$frameinfo.f_244553_ <= 0) {
                    f_243663_.warn("Invalid frame duration on sprite {} frame {}: {}", new Object[]{this.f_243877_, i1, spritecontents$frameinfo.f_244553_});
                    flag = false;
                }
                if (spritecontents$frameinfo.f_243751_ < 0 || spritecontents$frameinfo.f_243751_ >= k2) {
                    f_243663_.warn("Invalid frame index on sprite {} frame {}: {}", new Object[]{this.f_243877_, i1, spritecontents$frameinfo.f_243751_});
                    flag = false;
                }
                if (flag) {
                    intset.add(spritecontents$frameinfo.f_243751_);
                } else {
                    iterator.remove();
                }
                ++i1;
            }
            int[] aint = IntStream.range(0, k2).filter(arg_0 -> SpriteContents.lambda$createAnimatedTexture$4((IntSet)intset, arg_0)).toArray();
            if (aint.length > 0) {
                f_243663_.warn("Unused frames in sprite {}: {}", (Object)this.f_243877_, (Object)Arrays.toString(aint));
            }
        }
        return list.size() <= 1 ? null : new AnimatedTexture(this, (List)ImmutableList.copyOf(list), i2, metadataIn.m_119036_());
    }

    void m_247381_(int xIn, int yIn, int xOffsetIn, int yOffsetIn, NativeImage[] framesIn) {
        for (int i2 = 0; i2 < this.f_243731_.length && this.f_244302_ >> i2 > 0 && this.f_244600_ >> i2 > 0; ++i2) {
            framesIn[i2].m_85003_(i2, xIn >> i2, yIn >> i2, xOffsetIn >> i2, yOffsetIn >> i2, this.f_244302_ >> i2, this.f_244600_ >> i2, this.f_243731_.length > 1, false);
        }
    }

    public int m_246492_() {
        return this.f_244302_;
    }

    public int m_245330_() {
        return this.f_244600_;
    }

    public ResourceLocation m_246162_() {
        return this.f_243877_;
    }

    public IntStream m_245638_() {
        return this.f_244575_ != null ? this.f_244575_.m_246130_() : IntStream.of(1);
    }

    @Nullable
    public SpriteTicker m_246786_() {
        return this.f_244575_ != null ? this.f_244575_.m_246690_() : null;
    }

    @Override
    public void close() {
        for (NativeImage nativeimage : this.f_243731_) {
            nativeimage.close();
        }
    }

    public String toString() {
        return "SpriteContents{name=" + this.f_243877_ + ", frameCount=" + this.m_245088_() + ", height=" + this.f_244600_ + ", width=" + this.f_244302_ + "}";
    }

    public boolean m_245970_(int frameIndexIn, int xIn, int yIn) {
        int i2 = xIn;
        int j2 = yIn;
        if (this.f_244575_ != null) {
            i2 = xIn + this.f_244575_.m_245080_(frameIndexIn) * this.f_244302_;
            j2 = yIn + this.f_244575_.m_246436_(frameIndexIn) * this.f_244600_;
        }
        return (this.f_243904_.m_84985_(i2, j2) >> 24 & 0xFF) == 0;
    }

    public void m_246850_(int xIn, int yIn) {
        if (this.f_244575_ != null) {
            this.f_244575_.m_247129_(xIn, yIn);
        } else {
            this.m_247381_(xIn, yIn, 0, 0, this.f_243731_);
        }
    }

    public int getSpriteWidth() {
        return this.f_244302_;
    }

    public int getSpriteHeight() {
        return this.f_244600_;
    }

    public ResourceLocation getSpriteLocation() {
        return this.f_243877_;
    }

    public void setSpriteWidth(int spriteWidth) {
        this.f_244302_ = spriteWidth;
    }

    public void setSpriteHeight(int spriteHeight) {
        this.f_244600_ = spriteHeight;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public void rescale() {
        int widthScaled;
        NativeImage imageScaled;
        if (this.scaleFactor > 1.0 && (imageScaled = TextureUtils.scaleImage((NativeImage)this.f_243904_, (int)(widthScaled = (int)Math.round((double)this.f_243904_.m_84982_() * this.scaleFactor)))) != this.f_243904_) {
            this.f_243904_.close();
            this.f_243731_[0] = this.f_243904_ = imageScaled;
        }
    }

    public AnimatedTexture getAnimatedTexture() {
        return this.f_244575_;
    }

    public NativeImage getOriginalImage() {
        return this.f_243904_;
    }

    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public AnimationMetadataSection getMetadata() {
        return this.metadata;
    }

    private static /* synthetic */ boolean lambda$createAnimatedTexture$4(IntSet intset, int indexIn) {
        return !intset.contains(indexIn);
    }
}

