/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.optifine.Config;
import net.optifine.http.HttpPipeline;
import net.optifine.http.HttpRequest;
import net.optifine.http.HttpResponse;
import net.optifine.player.CapeImageBuffer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpTexture
extends SimpleTexture {
    private static final Logger f_117993_ = LogUtils.getLogger();
    private static final int f_181889_ = 64;
    private static final int f_181890_ = 64;
    private static final int f_181891_ = 32;
    @Nullable
    private final File f_117994_;
    private final String f_117995_;
    private final boolean f_117996_;
    @Nullable
    private final Runnable f_117997_;
    @Nullable
    private CompletableFuture<?> f_117998_;
    private boolean f_117999_;
    public Boolean imageFound = null;
    public boolean pipeline = false;
    private boolean uploadPending = false;

    public HttpTexture(@Nullable File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation, boolean legacySkinIn, @Nullable Runnable processTaskIn) {
        super(textureResourceLocation);
        this.f_117994_ = cacheFileIn;
        this.f_117995_ = imageUrlIn;
        this.f_117996_ = legacySkinIn;
        this.f_117997_ = processTaskIn;
    }

    private void m_118010_(NativeImage nativeImageIn) {
        if (this.f_117997_ instanceof CapeImageBuffer) {
            CapeImageBuffer cib = (CapeImageBuffer)this.f_117997_;
            nativeImageIn = cib.parseUserSkin(nativeImageIn);
            cib.skinAvailable();
        }
        this.setImageImpl(nativeImageIn);
    }

    private void setImageImpl(NativeImage nativeImageIn) {
        if (this.f_117997_ != null) {
            this.f_117997_.run();
        }
        Minecraft.m_91087_().execute(() -> {
            this.f_117999_ = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.m_118020_(nativeImageIn));
            } else {
                this.m_118020_(nativeImageIn);
            }
        });
    }

    private void m_118020_(NativeImage imageIn) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)imageIn.m_84982_(), (int)imageIn.m_85084_());
        imageIn.m_85040_(0, 0, 0, true);
        this.imageFound = imageIn != null;
        this.size = imageIn.getSize();
    }

    public void m_6704_(ResourceManager manager) throws IOException {
        Minecraft.m_91087_().execute(() -> {
            if (!this.f_117999_) {
                try {
                    super.m_6704_(manager);
                }
                catch (IOException ioexception) {
                    f_117993_.warn("Failed to load texture: {}", (Object)this.f_118129_, (Object)ioexception);
                }
                this.f_117999_ = true;
            }
        });
        if (this.f_117998_ == null) {
            NativeImage nativeimage;
            if (this.f_117994_ != null && this.f_117994_.isFile()) {
                f_117993_.debug("Loading http texture from local cache ({})", (Object)this.f_117994_);
                FileInputStream fileinputstream = new FileInputStream(this.f_117994_);
                nativeimage = this.m_118018_((InputStream)fileinputstream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.m_118010_(nativeimage);
                this.loadingFinished();
            } else {
                this.f_117998_ = CompletableFuture.runAsync(() -> {
                    HttpURLConnection httpurlconnection = null;
                    f_117993_.debug("Downloading http texture from {} to {}", (Object)this.f_117995_, (Object)this.f_117994_);
                    if (this.shouldPipeline()) {
                        this.loadPipelined();
                        return;
                    }
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(this.f_117995_).openConnection(Minecraft.m_91087_().m_91096_());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() / 100 == 2) {
                            InputStream inputstream;
                            if (this.f_117994_ != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)this.f_117994_);
                                inputstream = new FileInputStream(this.f_117994_);
                            } else {
                                inputstream = httpurlconnection.getInputStream();
                            }
                            Minecraft.m_91087_().execute(() -> {
                                NativeImage nativeimage1 = this.m_118018_(inputstream);
                                if (nativeimage1 != null) {
                                    this.m_118010_(nativeimage1);
                                    this.loadingFinished();
                                }
                            });
                            this.uploadPending = true;
                            return;
                        }
                        if (httpurlconnection.getErrorStream() != null) {
                            Config.readAll((InputStream)httpurlconnection.getErrorStream());
                        }
                    }
                    catch (Exception exception) {
                        f_117993_.error("Couldn't download http texture", (Throwable)exception);
                        return;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                        this.loadingFinished();
                    }
                }, this.getExecutor());
            }
        }
    }

    @Nullable
    private NativeImage m_118018_(InputStream inputStreamIn) {
        NativeImage nativeimage = null;
        try {
            nativeimage = NativeImage.m_85058_((InputStream)inputStreamIn);
            if (this.f_117996_) {
                nativeimage = this.m_118032_(nativeimage);
            }
        }
        catch (Exception exception) {
            f_117993_.warn("Error while loading the skin texture", (Throwable)exception);
        }
        return nativeimage;
    }

    private boolean shouldPipeline() {
        if (!this.pipeline) {
            return false;
        }
        Proxy proxy = Minecraft.m_91087_().m_91096_();
        if (proxy.type() != Proxy.Type.DIRECT && proxy.type() != Proxy.Type.SOCKS) {
            return false;
        }
        return this.f_117995_.startsWith("http://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPipelined() {
        try {
            HttpRequest req = HttpPipeline.makeRequest((String)this.f_117995_, (Proxy)Minecraft.m_91087_().m_91096_());
            HttpResponse resp = HttpPipeline.executeRequest((HttpRequest)req);
            if (resp.getStatus() / 100 == 2) {
                NativeImage ni;
                byte[] body = resp.getBody();
                ByteArrayInputStream bais = new ByteArrayInputStream(body);
                if (this.f_117994_ != null) {
                    FileUtils.copyInputStreamToFile((InputStream)bais, (File)this.f_117994_);
                    ni = NativeImage.m_85058_((InputStream)new FileInputStream(this.f_117994_));
                } else {
                    ni = NativeImage.m_85058_((InputStream)bais);
                }
                this.m_118010_(ni);
                this.uploadPending = true;
                return;
            }
        }
        catch (Exception var6) {
            f_117993_.error("Couldn't download http texture: " + var6.getClass().getName() + ": " + var6.getMessage());
            return;
        }
        finally {
            this.loadingFinished();
        }
    }

    private void loadingFinished() {
        if (this.uploadPending) {
            return;
        }
        if (this.f_117997_ instanceof CapeImageBuffer) {
            CapeImageBuffer cib = (CapeImageBuffer)this.f_117997_;
            cib.cleanup();
        }
    }

    public Runnable getProcessTask() {
        return this.f_117997_;
    }

    private Executor getExecutor() {
        if (this.f_117995_.startsWith("http://s.optifine.net")) {
            return Util.getCapeExecutor();
        }
        return Util.m_183991_();
    }

    @Nullable
    private NativeImage m_118032_(NativeImage p_118032_1_) {
        int i2 = p_118032_1_.m_85084_();
        int j2 = p_118032_1_.m_84982_();
        if (j2 == 64 && (i2 == 32 || i2 == 64)) {
            boolean flag;
            boolean bl = flag = i2 == 32;
            if (flag) {
                NativeImage nativeimage = new NativeImage(64, 64, true);
                nativeimage.m_85054_(p_118032_1_);
                p_118032_1_.close();
                p_118032_1_ = nativeimage;
                nativeimage.m_84997_(0, 32, 64, 32, 0);
                nativeimage.m_85025_(4, 16, 16, 32, 4, 4, true, false);
                nativeimage.m_85025_(8, 16, 16, 32, 4, 4, true, false);
                nativeimage.m_85025_(0, 20, 24, 32, 4, 12, true, false);
                nativeimage.m_85025_(4, 20, 16, 32, 4, 12, true, false);
                nativeimage.m_85025_(8, 20, 8, 32, 4, 12, true, false);
                nativeimage.m_85025_(12, 20, 16, 32, 4, 12, true, false);
                nativeimage.m_85025_(44, 16, -8, 32, 4, 4, true, false);
                nativeimage.m_85025_(48, 16, -8, 32, 4, 4, true, false);
                nativeimage.m_85025_(40, 20, 0, 32, 4, 12, true, false);
                nativeimage.m_85025_(44, 20, -8, 32, 4, 12, true, false);
                nativeimage.m_85025_(48, 20, -16, 32, 4, 12, true, false);
                nativeimage.m_85025_(52, 20, -8, 32, 4, 12, true, false);
            }
            HttpTexture.m_118022_((NativeImage)p_118032_1_, (int)0, (int)0, (int)32, (int)16);
            if (flag) {
                HttpTexture.m_118012_((NativeImage)p_118032_1_, (int)32, (int)0, (int)64, (int)32);
            }
            HttpTexture.m_118022_((NativeImage)p_118032_1_, (int)0, (int)16, (int)64, (int)32);
            HttpTexture.m_118022_((NativeImage)p_118032_1_, (int)16, (int)48, (int)48, (int)64);
            return p_118032_1_;
        }
        p_118032_1_.close();
        f_117993_.warn("Discarding incorrectly sized ({}x{}) skin texture from {}", new Object[]{j2, i2, this.f_117995_});
        return null;
    }

    private static void m_118012_(NativeImage image, int x, int y, int width, int height) {
        for (int i2 = x; i2 < width; ++i2) {
            for (int j2 = y; j2 < height; ++j2) {
                int k2 = image.m_84985_(i2, j2);
                if ((k2 >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int l2 = x; l2 < width; ++l2) {
            for (int i1 = y; i1 < height; ++i1) {
                image.m_84988_(l2, i1, image.m_84985_(l2, i1) & 0xFFFFFF);
            }
        }
    }

    private static void m_118022_(NativeImage image, int x, int y, int width, int height) {
        for (int i2 = x; i2 < width; ++i2) {
            for (int j2 = y; j2 < height; ++j2) {
                image.m_84988_(i2, j2, image.m_84985_(i2, j2) | 0xFF000000);
            }
        }
    }
}

